/***************************************************************************/
/*	    PROGRAMM  ix/Mbox						   */
/*             DATEI  admin.c						   */
/*        FUNKTIONEN  user_aendern(), user_anzeigen(), user_loeschen(),    */
/*		      setup_get(), wait_until_keypressed(), admin(),       */
/*		      setup()					           */
/*             AUTOR  vs (Volker Schuermann/MINIX-Version)		   */
/*  LETZTE AENDERUNG  18.03.1992					   */
/***************************************************************************/

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdio.h>
#include <fcntl.h>

#include "mbox.h"


void wait_until_keypressed();



/***************************************************************************/
/*      FUNKTION  user_aendern						   */
/*  BESCHREIBUNG  Aendern ALLER Teilnehmerparameter (von ADMIN aus)        */
/*     PARAMETER  keine	                                                   */
/*     RUECKGABE  keine	                                                   */
/***************************************************************************/

void user_aendern()
{
  int fd;
  struct userdaten DUMMY, LOOSER;
  char s[STRING];
  char t[STRING];
  long ll = -1L;
  size_t dummy = sizeof(DUMMY);
  char c;
  int i;
  int uid = -1;

  headline( ADM01_MSG );

  printf("%s ", ADM02_MSG);
  strcpy(s, (char *) getline(30, 11, '.', ""));
  if ((s[0] > 47) && (s[0] < 58)) uid = atoi(s);

  maybe_locked(UDBASE, "r"); mblock(UDBASE);
  fd = open(UDBASE, O_RDONLY);
  if(fd == -1){
	nerror("admin.c", 324, "aendern", "Datei-Lesefehler", UDBASE);
  }
  while(read(fd, &DUMMY, dummy) == dummy){
	if(uid == DUMMY.id){
		ll = lseek(fd, 0L, SEEK_CUR) - dummy;
	}
	else{
		if((strcomp(s, DUMMY.name) == 0) ||
		   (strcomp(s, DUMMY.nick) == 0) ||
		   (strcomp(s, DUMMY.sh_name) == 0)){
			ll = lseek(fd, 0L, SEEK_CUR) - dummy;
		}
	}
  }
  lseek(fd, ll, SEEK_SET);
  read(fd, &LOOSER, sizeof(LOOSER));
  close(fd);
  mbunlock(UDBASE);

  if(ll == -1L) return;

  printf("%c%s %d                                               ", CR, ADM03_MSG, LOOSER.id);

  printf("\n%s ", ADM04_MSG);
  strcpy(s, (char *) getline(30, 1011, '.', LOOSER.name));
  if (s[0] > 32) sprintf(LOOSER.name, s);
  if (s[0] == 32) LOOSER.name[0] = '\0';

  printf("\n%s ", ADM05_MSG);
  strcpy(s, (char *) getline(10, 1011, '.', LOOSER.passwort));
  if (s[0] > 32) sprintf(LOOSER.passwort, s);
  if (s[0] == 32) LOOSER.passwort[0] = '\0';

  printf("\n%s ", ADM06_MSG);
  strcpy(s, (char *) getline(14, 1011, '.', LOOSER.sh_name));
  if (s[0] > 32) sprintf(LOOSER.sh_name, s);
  if (s[0] == 32) LOOSER.sh_name[0] = '\0';

  printf("\n%s ", ADM07_MSG);
  strcpy(s, (char *) getline(30, 1011, '.', LOOSER.nick));
  if (s[0] > 32) sprintf(LOOSER.nick, s);
  if (s[0] == 32) LOOSER.nick[0] = '\0';

  printf("\n%s ", ADM08_MSG);
  strcpy(s, (char *) getline(30, 1011, '.', LOOSER.wohnort));
  if (s[0] > 31) sprintf(LOOSER.wohnort, s);

  printf("\n%s ", ADM09_MSG);
  strcpy(s, (char *) getline(30, 1011, '.', LOOSER.strasse));
  if (s[0] > 31) sprintf(LOOSER.strasse, s);

  printf("\n%s ", ADM10_MSG);
  strcpy(s, (char *) getline(20, 1011, '.', LOOSER.telefon1));
  if (s[0] > 31) sprintf(LOOSER.telefon1, s);

  printf("\n%s ", ADM11_MSG);
  strcpy(s, (char *) getline(20, 1011, '.', LOOSER.telefon2));
  if (s[0] > 31) sprintf(LOOSER.telefon2, s);

  printf("\n%s ", ADM12_MSG);
  strcpy(s, (char *) getline(10, 1114, '?', LOOSER.geburtsdatum));
  if (s[0] > 31) sprintf(LOOSER.geburtsdatum, s);

  printf("\n%s ", ADM13_MSG);
  sprintf(t, "%d", LOOSER.terminal);
  strcpy(s, (char *) getline(5, 1111, '.', t));
  if (s[0] > 31) LOOSER.terminal = atoi(s);
  if ((LOOSER.terminal < 1) || (LOOSER.terminal > 4)) LOOSER.terminal = 1;

  printf("\n%s ", ADM14_MSG);
  sprintf(t, "%d", LOOSER.editor);
  strcpy(s, (char *) getline(5, 1111, '.', t));
  if (s[0] > 31) LOOSER.editor = atoi(s);
  if ((LOOSER.editor < 1) || (LOOSER.editor > 3)) LOOSER.editor = 1;

  printf("\n%s ", ADM15_MSG);
  sprintf(t, "%d", LOOSER.level);
  strcpy(s, (char *) getline(5, 1111, '.', t));
  if (s[0] > 31) LOOSER.level = atoi(s);

  printf("\n%s ", ADM16_MSG);
  sprintf(t, "%d", LOOSER.more);
  strcpy(s, (char *) getline(5, 1111, '.', t));
  if (s[0] > 31) LOOSER.more = atoi(s);
  if ((LOOSER.more < 0) || (LOOSER.more > 3)) LOOSER.more = 1;

  printf("\n%s ", ADM17_MSG);
  sprintf(t, "%d", LOOSER.bell);
  strcpy(s, (char *) getline(5, 1111, '.', t));
  if (s[0] > 31) LOOSER.bell = atoi(s);
  if ((LOOSER.bell < -1) || (LOOSER.bell > 1)) LOOSER.bell = 0;

  printf("\n%s ", ADM18_MSG);
  sprintf(t, "%d", LOOSER.prompt);
  strcpy(s, (char *) getline(5, 1111, '.', t));
  if (s[0] > 31) LOOSER.prompt = atoi(s);
  if ((LOOSER.prompt < 1) || (LOOSER.prompt > 3)) LOOSER.prompt = 2;

  printf("\n%s ", ADM19_MSG);
  LOOSER.tlines += 2;
  sprintf(t, "%d", LOOSER.tlines);
  strcpy(s, (char *) getline(5, 1111, '.', t));
  if (s[0] > 31) LOOSER.tlines = atoi(s);
  LOOSER.tlines -= 2;
  if ((LOOSER.tlines < 22) || (LOOSER.tlines > 23)) LOOSER.tlines = DEF_MAX_SCR_LINES;
  
  printf("\n%s ", ADM20_MSG);
  strcpy(s, (char *) getline(10, 1114, '?', LOOSER.lastlog));
  if (s[0] > 31) sprintf(LOOSER.lastlog, s);

  printf("\n%s ", ADM21_MSG);
  strcpy(t, (char *) timereconv((long) LOOSER.lasttime));
  t[5] = '\0';
  strcpy(s, (char *) getline(5, 1113, '?', t));
  LOOSER.lasttime = timeconv(s);

  printf("\n%s ", ADM21aMSG);
  strcpy(s, (char *) ttyname(0));
  if(strcomp(PMS_TTY, s) == 0){
	strcpy(s, (char *) getline(17, 1011, '.', LOOSER.account));
	if (s[0] > 31) sprintf(LOOSER.account, s);
  }
  else{
	printf("%s", LOOSER.account);
  }

  printf("\n%s ", ADM22_MSG);
  strcpy(s, (char *) getline(58, 1011, '.', LOOSER.newsgrps));
  if (s[0] > 31) sprintf(LOOSER.newsgrps, s);

  printf("\n%s ", ADM23_MSG);
  sprintf(t, "%d", LOOSER.seq);
  strcpy(s, (char *) getline(10, 1111, '.', t));
  if (s[0] > 31) LOOSER.seq = atoi(s);

  wait_until_keypressed();

  maybe_locked(UDBASE, "r"); mblock(UDBASE);
  fd = open(UDBASE, O_WRONLY);
  if (fd == -1) {
	nerror("admin.c", 428, "aendern", "Datei-Schreibfehler", UDBASE);
  }
  if (lseek(fd, ll, SEEK_SET) == -1) {
	nerror("admin.c", 431, "aendern", "Positionierungsfehler", UDBASE);
  }
  write(fd, &LOOSER, sizeof(LOOSER));
  close(fd);
  mbunlock(UDBASE);

  if (LOOSER.id == USER.id) {	/* Ich bin's !!! */

	maybe_locked(UDBASE, "r");
	mblock(UDBASE);
	fd = open(UDBASE, O_RDONLY);
	if (fd == -1) {
		nerror("admin.c", 324, "aendern", "Datei-Lesefehler", UDBASE);
	}
	lseek(fd, ll, SEEK_SET);
	read(fd, &USER, sizeof(USER));
	close(fd);
	mbunlock(UDBASE);
  }
}



/***************************************************************************/
/*      FUNKTION  user_anzeigen()					   */
/*  BESCHREIBUNG  ALLE Teilnehmerdaten anzeigen (von ADMIN aus)		   */
/*     PARAMETER  keine	                                                   */
/*     RUECKGABE  keine	                                                   */
/***************************************************************************/

void user_anzeigen()
{
  int fd;
  struct userdaten DUMMY, LOOSER;
  char s[STRING];
  char t[STRING];
  long ll = -1L;
  size_t dummy = sizeof(DUMMY);
  char c;
  int i;
  int uid = -1;


  headline( ADM01_MSG );

  printf("%s ", ADM02_MSG);
  strcpy(s, (char *) getline(30, 11, '.', ""));
  if ((s[0] > 47) && (s[0] < 58)) uid = atoi(s);

  maybe_locked(UDBASE, "r"); mblock(UDBASE);
  fd = open(UDBASE, O_RDONLY);
  if (fd == -1) {
	nerror("admin.c", 324, "aendern", "Datei-Lesefehler", UDBASE);
  }
  while (read(fd, &DUMMY, dummy) == dummy) {
	if (uid == DUMMY.id) {
		ll = lseek(fd, 0L, SEEK_CUR) - dummy;
	} 
	else{
		if ((strcomp(s, DUMMY.name) == 0) ||
		    (strcomp(s, DUMMY.nick) == 0) ||
		    (strcomp(s, DUMMY.sh_name) == 0)) {
			ll = lseek(fd, 0L, SEEK_CUR) - dummy;
		}
	}
  }
  lseek(fd, ll, SEEK_SET);
  read(fd, &LOOSER, sizeof(LOOSER));
  close(fd);
  mbunlock(UDBASE);

  if (ll == -1L) return;

  printf("%c  %s %d                                               ", CR, ADM03_MSG, LOOSER.id);
  printf("\n  %s %s",   ADM04_MSG, LOOSER.name);
  printf("\n  %s %s",   ADM05_MSG, LOOSER.passwort);
  printf("\n  %s %s",   ADM06_MSG, LOOSER.sh_name);
  printf("\n  %s %s",   ADM07_MSG, LOOSER.nick);
  printf("\n  %s %s",   ADM08_MSG, LOOSER.wohnort);
  printf("\n  %s %s",   ADM09_MSG, LOOSER.strasse);
  printf("\n  %s %s",   ADM10_MSG, LOOSER.telefon1);
  printf("\n  %s %s",   ADM11_MSG, LOOSER.telefon2);
  printf("\n  %s %s",   ADM12_MSG, LOOSER.geburtsdatum);
  printf("\n  %s %d",   ADM13_MSG, LOOSER.terminal);
  printf("\n  %s %d",   ADM14_MSG, LOOSER.editor);
  printf("\n  %s %d",   ADM15_MSG, LOOSER.level);
  printf("\n  %s %d",   ADM16_MSG, LOOSER.more);
  printf("\n  %s %d",   ADM17_MSG, LOOSER.bell);
  printf("\n  %s %d",   ADM18_MSG, LOOSER.prompt);
  printf("\n  %s %d",   ADM19_MSG, LOOSER.tlines += 2);
  printf("\n  %s %s",   ADM20_MSG, LOOSER.lastlog);
  printf("\n  %s %.5s", ADM21_MSG, (char *) timereconv((long) LOOSER.lasttime));
  printf("\n  %s %s",   ADM21aMSG, LOOSER.account);
  printf("\n  %s %s",   ADM22_MSG, LOOSER.newsgrps);
  printf("\n  %s %d",   ADM23_MSG, LOOSER.seq);

  wait_until_keypressed();
}



/***************************************************************************/
/*      FUNKTION  user_loeschen()					   */
/*  BESCHREIBUNG  Einen Teilnehmer einsch. persoenlicher Post etc. aus	   */
/*		  dem System entfernen.                                    */
/*     PARAMETER  keine	                                                   */
/*     RUECKGABE  keine	                                                   */
/***************************************************************************/

void user_loeschen()
{
  int fd;
  int gd;
  struct userdaten DUMMY, LOOSER;
  char s[STRING];
  char t[STRING];
  long ll = -1L;
  size_t dummy = sizeof(DUMMY);
  char c;
  int i;
  int uid = -1;


  headline( ADM25_MSG );
	
  printf("\n%s ", ADM02_MSG);
  strcpy(s, (char *) getline(30, 11, '.', ""));
  if ((s[0] > 47) && (s[0] < 58)) uid = atoi(s);

  maybe_locked(UDBASE, "r"); mblock(UDBASE);
  fd = open(UDBASE, O_RDONLY);
  if (fd == -1) {
	nerror("admin.c", 459, "loeschen", "Datei-Lesefehler", UDBASE);
  }
  while (read(fd, &DUMMY, dummy) == dummy) {
	if (uid == DUMMY.id) {
		ll = lseek(fd, 0L, SEEK_CUR) - dummy;
	}
	else{
		if ((strcomp(s, DUMMY.name) == 0) ||
		    (strcomp(s, DUMMY.nick) == 0) ||
		    (strcomp(s, DUMMY.sh_name) == 0)) {
			ll = lseek(fd, 0L, SEEK_CUR) - dummy;
		}
	}
  }
  lseek(fd, ll, SEEK_SET);
  read(fd, &LOOSER, sizeof(LOOSER));
  close(fd);
  mbunlock(UDBASE);

  if (ll == -1L) return;

  printf("%c%s (%d)                                     ", CR, ADM26_MSG, LOOSER.id);
  printf("\n%s (%s) ", ADM27_MSG, LOOSER.name);

  ansi("md");
  printf("\n\n%s [%c, %c] ? > ", ADM28_MSG, GBL06_MSG, GBL07_MSG);
  ansi("me");

  c = yesno();

  if (c != GBL06_MSG) return;

  maybe_locked(UDBASE, "r"); mblock(UDBASE);
  fd = open(UDBASE, O_RDONLY);
  if (fd == -1) {
	nerror("admin.c", 490, "loeschen", "Datei-Lesefehler", UDBASE);
  }
  sprintf(s, "%s/%dbase", TMP, getpid());

  gd = open(s, O_WRONLY | O_CREAT);
  if (gd == -1) {
	nerror("admin.c", 497, "loeschen", "Datei-Erstellungsfehler", s);
  }
  while (read(fd, &DUMMY, dummy) == dummy) {
	if (DUMMY.id != LOOSER.id) {
		write(gd, &DUMMY, dummy);
	}
  }
  close(gd);
  close(fd);
  mbunlock(UDBASE);

  sprintf(t, "cp %s %s", s, UDBASE);
  system(t);

  unlink(s);

  sprintf(s, "rm -r %s/usr/%d", HOME, LOOSER.id);
  system(s);
}




/***************************************************************************/
/*      FUNKTION  setup_get()						   */
/*  BESCHREIBUNG  Die Ziffern 1-max einlesen und zurueckgeben.		   */
/*     PARAMETER  max  =  groesste, zulaessige Ziffer		           */
/*     RUECKGABE  erfasste Ziffer (CHAR !!!)				   */
/***************************************************************************/

int setup_get(max)
char max;
{
  char c;

  ansi("md");
  printf("\n[1-%c] %s > ", max, ADM29_MSG);
  ansi("me");

  do {
	c = getint();
	if ((c < '0') || (c > max)) c = 0;
  } while (c == 0);
  printf("%c", c);

  return c;
}




/***************************************************************************/
/*      FUNKTION  wait_until_keypressed					   */
/*  BESCHREIBUNG  siehe FUNKTION					   */
/*     PARAMETER  keine	                                                   */
/*     RUECKGABE  keine	                                                   */
/***************************************************************************/

void wait_until_keypressed()
{
  char c;

  ansi("md");
  printf("\n\n%s > ", ADM30_MSG);
  ansi("me");
 
  c = getint();
}




/***************************************************************************/
/*      FUNKTION  admin()						   */
/*  BESCHREIBUNG  Teilnehmerverwaltung fuer den Administrator/Sysop.       */
/*     PARAMETER  keine	                                                   */
/*     RUECKGABE  keine	                                                   */
/***************************************************************************/

void admin()
{
  char c;

AGAIN:

  headline( ADM31_MSG );

  printf(  "\n  1 - %s", ADM32_MSG);
  printf("\n\n  2 - %s", ADM33_MSG);
  printf("\n\n  3 - %s", ADM34_MSG);
  printf("\n\n  4 - %s", ADM35_MSG);
  printf("\n\n  5 - %s", ADM36_MSG);

  printf("\n");
  printf("\n\n  8 - %s", ADM37_MSG);

  MEDIUM: printf("\n");

  c = setup_get('8');

  switch (c) {
      case '1':	
		postfach("*");
		logout();
		intro();
		break;

      case '2':	
		user_aendern();
		break;

      case '3':	
		user_loeschen();
		break;

      case '4':	
		user_anzeigen();
		break;

      case '5':
		userliste("");
		wait_until_keypressed();
		break;

       default:
		printf("\n");
		return;
  }
  goto AGAIN;

}




/***************************************************************************/
/*      FUNKTION  setup()						   */
/*  BESCHREIBUNG  Teilnehmerdaten/Parameter aendern (fuer die User)        */
/*     PARAMETER  keine	                                                   */
/*     RUECKGABE  keine	                                                   */
/***************************************************************************/

void setup()
{
  FILE *fp;
  int fd;
  char s[STRING];
  char t[STRING];
  char c;
  int i;
  int ok = 0;
  long ll;
  struct userdaten DUMMY;
  int dummy = sizeof(DUMMY);
  char *BLANKS = "                                               ";


  AGAIN:

  headline( ADM38_MSG );
  printf("\n");

  printf("  1 - %s\n\n", ADM39_MSG);
  printf("  2 - %s\n\n", ADM40_MSG);
  printf("  3 - %s\n\n", ADM41_MSG);
  printf("  4 - %s\n\n", ADM42_MSG);
  printf("  5 - %s\n\n", ADM43_MSG);
  printf("  6 - %s\n\n", ADM44_MSG);
  printf("  7 - %s\n\n", ADM45_MSG);
  printf("  8 - %s\n\n", ADM46_MSG);
  printf("\n");
  printf("  9 - %s\n\n", ADM47_MSG);

  c = setup_get('9');

  switch (c) {
      case '1':
		headline( ADM48_MSG );
		printf("\n");
		if (USER.terminal == 1)
			printf("*");
		else
			printf(" ");
		printf(" 1 - ANSI (X3.64 ... PC-BBS-ANSI)\n\n");
		if (USER.terminal == 2)
			printf("*");
		else
			printf(" ");
		printf(" 2 - VT100\n\n");
		if (USER.terminal == 3)
			printf("*");
		else
			printf(" ");
		printf(" 3 - VT52\n\n");
		if (USER.terminal == 4)
			printf("*");
		else
			printf(" ");
		printf(" 4 - Dump (%s)\n\n", ADM49_MSG);
		USER.terminal = setup_get('4') - 48;
		break;

      case '2':
		headline( ADM50_MSG );
		printf("\n");
		fp = fopen(EDITORS, "r");
		if (fp == NULL) {
			nerror("admin.c", 563, "setup", "Datei-Lesefehler", EDITORS);
		}
		i = 0;
		while((fgets(s, 80, fp) != NULL) && (s[0] == '/'));
		while (fscanf(fp, "%s %s", s, t) > 0) {
			i++;
			if (USER.editor == i)
				printf("*");
			else
				printf(" ");
			printf(" %d - %s\n\n", i, s);
		}
		fclose(fp);
		USER.editor = setup_get((i + 48)) - 48;
	
		if (USER.level < WRITE_INTERNAT) USER.editor = 1;
		break;

      case '3':
		headline( ADM51_MSG );
		printf("\n");
		strcpy(s, (char *) mytime(0));
		if ((USER.prompt == 1) && (USER.bell == 1))
			printf("*");
		else
			printf(" ");
		printf(" 1 - %s->     \"[%s] %s > \"\n\n", ADM52_MSG, s, LOP06_MSG);
		if ((USER.prompt == 1) && (USER.bell == 0))
			printf("*");             
		else
			printf(" ");
		printf(" 2 - %s->     \"[%s] %s > \"\n\n", ADM53_MSG, s, LOP06_MSG);
		if ((USER.prompt == 2) && (USER.bell == 1))
			printf("*");
		else
			printf(" ");
		printf(" 3 - %s->     \"[%s] %s > \"\n\n", ADM54_MSG, NG, LOP06_MSG);
		if ((USER.prompt == 2) && (USER.bell == 0))
			printf("*");
		else
			printf(" ");
		printf(" 4 - %s->     \"[%s] %s > \"\n\n", ADM55_MSG, NG, LOP06_MSG);
		if ((USER.prompt == 3) && (USER.bell == 1))
			printf("*");
		else
			printf(" ");
		printf(" 5 - %s->     \"[(Sec.) NZ, RZ, WZ] %s > \"\n\n", ADM56_MSG, LOP06_MSG);
		if ((USER.prompt == 3) && (USER.bell == 0))
			printf("*");
		else
			printf(" ");
		printf(" 6 - %s->     \"[(Sec.) NZ, RZ, WZ] %s > \"\n\n", ADM57_MSG, LOP06_MSG);
	
		c = setup_get('6');
		switch (c) {
			    case '1':
					USER.prompt = 1;
					USER.bell = 1;
					break;
			    case '2':
					USER.prompt = 1;
					USER.bell = 0;
					break;
			    case '3':
					USER.prompt = 2;
					USER.bell = 1;
					break;
			    case '4':
					USER.prompt = 2;
					USER.bell = 0;
					break;
			    case '5':
					USER.prompt = 3;
					USER.bell = 1;
					break;
			    case '6':
					USER.prompt = 3;
					USER.bell = 0;
					break;
		}
		break;

      case '4':
		headline( ADM58_MSG );
		printf("\n");
		if (USER.more == 0)
			printf("*");
		else
			printf(" ");
		printf(" 1 - %s\n\n", ADM59_MSG);
		if (USER.more == 1)
			printf("*");
		else
			printf(" ");
		printf(" 2 - %s\n\n", ADM60_MSG);
		if (USER.more == 3)
			printf("*");
		else
			printf(" ");
		printf(" 3 - %s\n\n", ADM61_MSG);
		printf("\n");
		printf("  4 - %s\n\n", ADM62_MSG);
		printf("  5 - %s\n\n", ADM63_MSG);
		printf("  6 - %s\n\n", ADM64_MSG);		
		printf("  7 - %s\n\n", ADM64aMSG);

		i = setup_get('7') - 49;

		if (i < 3) {
			USER.more = i;
			if (USER.more == 2) USER.more++;
		}
		else {
			headline( ADM58_MSG );
			printf("\n");
			
			if (i == 3) {
				if (USER.leserichtung == 1)
					printf("*");
				else
					printf(" ");
				printf(" 1 - %s\n\n", ADM65_MSG);
				if (USER.leserichtung == 2)
					printf("*");
				else
					printf(" ");
				printf(" 2 - %s\n\n", ADM66_MSG);
		
				USER.leserichtung = setup_get('2') - 48;
			}
			if (i == 4) {
				if (USER.tlines != 23)
					printf("*");
				else
					printf(" ");
				printf(" 1 - %s\n\n", ADM67_MSG);
				if (USER.tlines == 23)
					printf("*");
				else
					printf(" ");
				printf(" 2 - %s\n\n", ADM68_MSG);
		
				USER.tlines = setup_get('2') - 48 + 21;
			}
			if (i == 5) {
				if (USER.schluessel[0] != 32)
					printf("*");
				else
					printf(" ");
				printf(" 1 - %s\n\n", ADM69_MSG);
				if (USER.schluessel[0] == 32)
					printf("*");
				else
					printf(" ");
				printf(" 2 - %s\n\n", ADM70_MSG);
		
				i = setup_get('2') - 48;
				if (i == 2){
					USER.schluessel[0] = 32;
				}				
				else{
					USER.schluessel[0] = 1;
				}
			}
			if (i == 6) {
				if (USER.schluessel[1] == 2)
					printf("*");
				else
					printf(" ");
				printf(" 1 - %s\n\n", ADM70aMSG);
				if (USER.schluessel[1] == 3)
					printf("*");
				else
					printf(" ");
				printf(" 2 - %s\n\n", ADM70bMSG);
		
				if (USER.schluessel[1] == 4)
					printf("*");
				else
					printf(" ");
				printf(" 3 - %s\n\n", ADM70cMSG);
	
				i = setup_get('3') - 48;
				USER.schluessel[1] = i + 1;
			}
		}
		break;

	case '5':
		if (strcomp(GUEST, USER.name) == 0) break;

		headline( ADM71_MSG );
		printf("\n");

		ansi("md");
		printf("%s\n", ADM72_MSG);
		printf("%s\n", ADM73_MSG);
		printf("%s\n", ADM74_MSG);
		printf("\n");
		printf("%s\n", ADM75_MSG);
		printf("%s\n", ADM76_MSG);
		ansi("me");

		maybe_locked(UDBASE, "r"); 
	        fd = open(UDBASE, O_RDONLY);
		if (fd == -1) {
			nerror("admin.c", 747, "setup", "Datei-Lesefehler", UDBASE);
		}	

		printf("\n%s ", ADM04_MSG);
		strcpy(s, (char *) getline(30, 1015, '.', USER.name));
		if(strcomp(GUEST, s) != 0){
			if (s[0] > 31){
				ok = 0;
				lseek(fd, 0L, SEEK_SET);
				while ((read(fd, &DUMMY, sizeof(DUMMY)) == sizeof(DUMMY)) && (ok == 0)) {
					if (strcomp(s, DUMMY.name)    == 0) ok = 1;
					if (strcomp(s, DUMMY.nick)    == 0) ok = 1;
					if (strcomp(s, DUMMY.sh_name) == 0) ok = 1;
				}
				if(USER.level < ADMIN_LEV){
					if ((strcomp("SYSOP", s) == 0) ||
					    (strcomp("POST",  s) == 0) ||
					    (strcomp("GAST",  s) == 0) ||
					    (strcomp("ADMIN", s) == 0) ||
					    (strcomp("COSYS", s) == 0)) ok++;
				}

				if(ok == 0) sprintf(USER.name, s);
			}
		}

		printf("\n%s ", ADM07_MSG);
		strcpy(s, (char *) getline(30, 1015, '.', USER.nick));
		if (s[0] > 31){	
			ok = 0;
			lseek(fd, 0L, SEEK_SET);
			while ((read(fd, &DUMMY, sizeof(DUMMY)) == sizeof(DUMMY)) && (ok == 0)) {
				if (strcomp(s, DUMMY.name)    == 0) ok = 1;
				if (strcomp(s, DUMMY.nick)    == 0) ok = 1;
				if (strcomp(s, DUMMY.sh_name) == 0) ok = 1;
			}
			if (USER.level < ADMIN_LEV){
				if ((strcomp("SYSOP", s) == 0) ||
				    (strcomp("POST",  s) == 0) ||
				    (strcomp("GAST",  s) == 0) ||
				    (strcomp("ADMIN", s) == 0) ||
				    (strcomp("COSYS", s) == 0)) ok++;
			}

			if(ok == 0) sprintf(USER.nick, s);
		}

		close(fd);
		mbunlock(UDBASE);

		printf("\n%s ", ADM08_MSG);
		strcpy(s, (char *) getline(30, 1011, '.', USER.wohnort));
		if (s[0] > 31) sprintf(USER.wohnort, s);

		printf("\n%s ", ADM09_MSG);
		strcpy(s, (char *) getline(30, 1011, '.', USER.strasse));
		if (s[0] > 31) sprintf(USER.strasse, s);

		printf("\n%s ", ADM10_MSG);
		strcpy(s, (char *) getline(20, 1011, '.', USER.telefon1));
		if (s[0] > 31) sprintf(USER.telefon1, s);

		printf("\n%s ", ADM11_MSG);
		strcpy(s, (char *) getline(20, 1011, '.', USER.telefon2));
		if (s[0] > 31) sprintf(USER.telefon2, s);

		printf("\n%s ", ADM12_MSG);
		strcpy(s, (char *) getline(10, 1114, '?', USER.geburtsdatum));
		if (s[0] > 31) sprintf(USER.geburtsdatum, s);

		break;


      case '6':
		if (strcomp(GUEST, USER.name) == 0) break;

		headline( ADM77_MSG );
		
		NIX: printf("\n%s ", ADM78_MSG);
	
		strcpy(s, (char *) getline(10, 12, '.', ""));
		if (s[0] != '\0') {
			strcpy(USER.passwort, (char *) crypted(s));
			printf(" (%s)", USER.passwort);
		}
		if (length(USER.passwort) < 5) {
			ansi("md");
			printf("\n\n%s\n", ADM79_MSG);
			ansi("me");
			goto NIX;
		}
		printf("\n\n%s ", ADM80_MSG);
		strcpy(s, (char *) getline(10, 12, '.', ""));
		strcpy(t, (char *) crypted(s));
		printf(" (%s)", t);
		if ((strcomp(t, USER.passwort) != 0) || (strcomp(USER.passwort, t) != 0)) {
			ansi("md");
			printf(" %s         \n", ADM81_MSG);
			ansi("me");
			goto NIX;
		}
		break;

	case '7':
		headline( ADM82_MSG );
		printf("\n");
		strcpy(s, (char *) mytime(0));
		if (USER.intro == 1)
			printf("*");
		else
			printf(" ");
		printf(" 1 - %s\n\n", ADM83_MSG);
		if (USER.intro == 2)
			printf("*");
		else
			printf(" ");
		printf(" 2 - %s\n\n", ADM84_MSG);
		if (USER.intro == 3)
			printf("*");
		else
			printf(" ");
		printf(" 3 - %s\n\n", ADM85_MSG);
		if (USER.intro == 4)
			printf("*");
		else
			printf(" ");
		printf(" 4 - %s\n\n", ADM86_MSG);

		USER.intro = setup_get('4') - 48;
		break;

      case '8':
		headline( ADM87_MSG );
		printf("\n");
		if (USER.lastmode == 1)
			printf("*");
		else
			printf(" ");
		printf(" 1 - %s\n\n", ADM88_MSG);
		if (USER.lastmode == 2)
			printf("*");
		else
			printf(" ");
		printf(" 2 - %s\n\n", ADM89_MSG);
		printf("\n");
		printf("  3 - %s\n\n", ADM90_MSG);
	
		i = setup_get('3') - 48;

		switch (i) {
		    case 1:
				USER.lastmode = 1;
				LASTTIME = USER.lasttime;
				break;
		    case 2:
				USER.lastmode = 2;
				LASTTIME = (int) 0;
				break;
		    case 3:
				headline( ADM87_MSG );
				ansi("md");
				printf("\n%s\n", ADM91_MSG);
				printf("%s\n", ADM92_MSG);
				printf("%s\n", ADM93_MSG);
				printf("%s\n", ADM94_MSG);
				ansi("me");

				printf("\n%s ", ADM95_MSG);
				strcpy(t, (char *) datereconv(LASTLOG));
				strcpy(s, (char *) getline(10, 1114, '?', t));
				LASTLOG = (long) dateconv(s);

				printf("\n%s ", ADM96_MSG);
				strcpy(t, (char *) timereconv(LASTTIME));
				strcpy(s, (char *) getline(8, 1113, '?', t));
				LASTTIME = timeconv(s);

				break;
		}
		break;

      case '9':	
		goto ENDE;
		break;
  }
  printf("\n\n");
  init_user( ADM97_MSG );
  goto AGAIN;

  ENDE:

  printf("\n");
  return;
}
