/*
 *	%Z% %M%	%I% %D% %Q%
 *
 *	Copyright (C) 1990 by Christian Schlichtherle
 *			      (chriss@attron.ruhr.sub.org)
 *
 *	%M% - C module for getch(S).
 *
 *	"getch" is a DOS and curses(S) like function which reads
 *	a character and returns immediately without waiting for
 *	newline.
 */

#if	!defined(lint) && !defined(library)
static char	sccsid[] = "%Z% %M% %I% %D% %Q%";
#endif /* not lint and not library */

#include <stdio.h>    
#include <sys/ioctl.h>
#include <termio.h>
#include <errno.h>

/*
 * getch - Gets a character.
 * This function gets one character and immediately returns
 * without waiting for newline. The character is not echoed.
 * This function can be used best when you want to input only one
 * character within canonical input or if you need this function
 * only very rarely.
 * EOF is returned on errors or if an ignored signal occured.
 */
int	getch()
{
	static struct termio	told, tnew;
	static int	set = 0;
	int	rstat;
	char	c;

	if (!set) {
			/* Get old terminal mode. */
		if (ioctl(0, TCGETA, &told) == -1)
			return (EOF);

		/*
		 * Set new terminal mode. Switch off
		 * canonical input and echoing.
		 */
		tnew = told;
		tnew.c_cc[VMIN] = 1;
		tnew.c_cc[VTIME] = 0;
		tnew.c_lflag &= ~(ICANON | ECHO);

			/* Don't execute this part anymore. */
		set = 1;
	}

		/* Set new terminal mode. */
	if (ioctl(0, TCSETA, &tnew) == -1)
		return (EOF);

		/* Read one character. */
	rstat = read(0, &c, 1);

		/* Reset old terminal mode.
		   Don't get disturbed by ignored signals.
		   unnet!volker: Quite right, but you'll get
		   Timing-Problems using this Function on
	           ESIX-Systems.	
		
	while (ioctl(0, TCSETA, &told) == -1)
		if (errno != EINTR)
			return (EOF);  */

        ioctl(0, TCSETA, &told);

	if (rstat != 1)
		return (EOF);

	return ((int)c);
}

