/*
 * bbscfile.c 
 *
 */

/* #define DEBUG 1 */

#include "packdef.h"
#include <string.h>
char            bufs[99];


hdrwrt()
{				/* write the header from memory variables *//* h
				 * eader is a 1 record file */
	int             fd;
	int             fd1;
	char            buf128[MSGSECT];

	strcpy(bufs, m_pathname);
	strcat(bufs, NEWHEADER);
	if ((fd = open(bufs, WRITE, 0666)) < 0) {	/* open i/o */
		printf("Can't open header-file, will create it!");
		printf(CRLF);
		if ((fd = creat(bufs, 0666)) < 0) {
			printf("Can't create header-file, aborting!");
			printf(CRLF);
			return (ERROR);
		}
	}
	strcpy(bufs, m_pathname);
	strcat(bufs, NEWXREF);
	if ((fd1 = open(bufs, WRITE, 0666)) < 0) {
		printf("Can't open xref file, will create it!");
		printf(CRLF);
		if ((fd1 = creat(bufs, 0666)) < 0) {
			printf(" XREF creation error! -- abort!");
			printf(CRLF);
			return (ERROR);
		}
	}
	itoa(h_next_msg, h_next);	/* convert int to char */
	itoa(h_act_msg, h_act);
	strfill(buf128, 26, MSGSECT);	/* init buf128 to all hex 1a */
	sprintf(buf128, "%s~%s~%s~",	/* build record */
		h_next_msg,
		h_act_msg,
		h_date);
	write(fd, buf128, MSGSECT);	/* write it */
	close(fd);		/* no need to leave it open */
	write(fd1, ytable, 4000);
	close(fd1);
	return (OK);
}

hdrreadr()
{				/* read the header file into memory */
	int             fd, i, cnt1, cnt;
	char            buf128[MSGSECT];
	strcpy(bufs, m_pathname);
	strcat(bufs, HEADER);
	if ((fd = open(bufs, READ, 0666)) < 0) {
		printf("Can't open header-file, using inital values!");
		printf(CRLF);
		h_next = 1;
		h_next_msg[0] = '1';
		h_next_msg[1] = 0;
		h_act = 1;
		h_act_msg[0] = '1';
		h_act_msg[1] = 0;
		h_date[0] = '0';
		h_date[1] = 0;
		goto next;
	}
	if ((cnt = read(fd, buf128, MSGSECT)) != MSGSECT) {
		printf(CRLF);
		printf("<<< header read error >>>");
		printf(CRLF);
		return (ERROR);
	}
	cnt = sscanf(buf128, "%[^~]~%[^~]~%[^~]~",
		     h_next_msg,
		     h_act_msg,
		     h_date);
next:
	close(fd);
	strcpy(bufs, m_pathname);
	strcat(bufs, CROSSREF);
	if ((fd = open(bufs, READ, 0666)) < 0) {
		printf("Can't open xref file --- setting values!");
		printf(CRLF);
		xtable[0] = 1L;
		for (i = 1; i <= 999; i++)
			xtable[i] = 0L;
		return;
	}
	if ((cnt1 = read(fd, xtable, 4000)) != 4000) {
		printf(CRLF);
		printf("<<< xref read error >>>");
		printf(CRLF);
		return (ERROR);
	}
	close(fd);
	/* 
	 * if (cnt != 2) { return(ERROR) ; } */
	h_next = atoi(h_next_msg);
	h_act = atoi(h_act_msg);
	return (OK);
}

hdrreadw()
{				/* read the header file into memory */
	int             fd, i, cnt1, cnt;
	char            buf128[MSGSECT];

	strcpy(bufs, m_pathname);
	strcat(bufs, NEWHEADER);
	if ((fd = open(bufs, READ, 0666)) < 0) {	/* open input */
		printf("Can't open header-file, using inital values!");
		printf(CRLF);
		h_next = 1;
		h_next_msg[0] = '1';
		h_next_msg[1] = 0;
		h_act = 1;
		h_act_msg[0] = '1';
		h_act_msg[1] = 0;
		h_date[0] = '0';
		h_date[1] = 0;
		hdrwrt();
		goto next;
	}
	if ((cnt = read(fd, buf128, MSGSECT)) != MSGSECT) {
		printf(CRLF);
		printf("<<< header read error >>>");
		printf(CRLF);
		return (ERROR);
	}
	cnt = sscanf(buf128, "%[^~]~%[^~]~%[^~]~",
		     h_next_msg,
		     h_act_msg,
		     h_date);
next:
	close(fd);		/* no need to leave it open */
	strcpy(bufs, m_pathname);
	strcat(bufs, NEWXREF);
	if ((fd = open(bufs, READ, 0666)) < 0) {
		printf("Can't open xref file --- setting values!");
		printf(CRLF);
		ytable[0] = 1L;
		for (i = 1; i <= 999; i++)
			ytable[i] = 0L;
		return;
	}
	if ((cnt1 = read(fd, ytable, 4000)) != 4000) {
		printf(CRLF);
		printf("<<< xref read error >>>");
		printf(CRLF);
		return (ERROR);
	}
	close(fd);
	/* 
	 * if (cnt != 2) { return(ERROR) ; } */
	h_next = atoi(h_next_msg);
	h_act = atoi(h_act_msg);
	return (OK);
}

msgopenr(how)
	int             how;	/* how to open 0=input, 1=output, 2=i/o */
{
	int             fd;

	strcpy(bufs, m_pathname);
	strcat(bufs, MESSAGES);
	if ((fd = open(bufs, how, 0666)) < 0) {	/* open i/o */
		printf("can't open message-file, will create it!");
		printf(CRLF);
		if ((fd = creat(bufs, 0666)) < 0) {
			printf("can't create message-file, aborting!");
			printf(CRLF);
			return (ERROR);
		}
	}
	return (fd);
}

msgopenw(how)
	int             how;	/* how to open 0=input, 1=output, 2=i/o */
{
	int             fd;
	strcpy(bufs, m_pathname);
	strcat(bufs, NEWMSG);

	if ((fd = open(bufs, how, 0666)) < 0) {	/* open i/o */
		printf("can't open message-file, will create it!");
		printf(CRLF);
		if ((fd = creat(bufs, 0666)) < 0) {
			printf("can't create message-file, aborting!");
			printf(CRLF);
			return (ERROR);
		}
	}
	return (fd);
}

msgclose(fd)
	int             fd;
{
	return (close(fd));
}

msgwrt(fd)			/* write the message file from memory
				 * variables */
	int             fd;	/* writes a message starting with the h_next
				 * msg # */
{
	int             rc,	/* return code */
	                cnt1, cnt2, len;
	char            bufmsg0[MSG1MAX + 1], buf128[MSGSECT + 1], this1[10], next1[10];

	rc = cnt1 = len = cnt2 = 0;
	itoa(this1, h_next);	/* convert int to char */
	ytable[h_act - 1] = h_next;
	h_act++;
	rc = seek(fd, h_next - 1, 0);	/* seek next available sector */
	h_next++;
	itoa(next1, h_next);
	strfill(buf128, 0, MSGSECT);	/* init buf128 to all hex 00 */
	/*
	 * build first piece of msg record 
	 */
	sprintf(buf128, "%-10s~%-10s~%-2s~%-9s~%-15s~%-21s~%-21s~%-11s~%-21s~",
		this1,		/* this rcd # */
		next1,		/* points next rcd # */
		msg_delete,	/* delete byte */
		msg_date,
		msg_time,
		msg_to,
		msg_from,
		msg_pass,
		msg_subject);
	rc = write(fd, buf128, MSGSECT);	/* write the first 128 byte
						 * record */
	/* for a message record */
	/*
	 * build the n+1 piece of msg record 
	 */

	len = (strlen(msg_text) / MSG1MAX) + 1;	/* calc how many more 128 */
	/* byte records to write */
	cnt2 = 1;		/* init for substr */
	while (len--) {
		itoa(this1, h_next);	/* calc/convert record #'s */
		h_next++;
		if (len == 0) {
			strcpy(next1, "0");	/* marks last 128 byte piece */
		}
		 /* of a msg */ 
		else {
			itoa(next1, h_next);
		}
		strfill(bufmsg0, 0, MSG1MAX);
		substr(msg_text, bufmsg0, cnt2, MSG1MAX);	/* mv MSG1MAX to buff */
		cnt2 += MSG1MAX;/* up cnt2 by MSG1MAX */
		strfill(buf128, 0, MSGSECT);	/* init buf128 to all hex 00 */
		sprintf(buf128, "%-10s~%-10s~%-2s~%-102s~",
			this1,	/* this rcd # */
			next1,	/* point to next rcd # */
			msg_delete,	/* delete byte */
			bufmsg0);	/* piece of msg */
		rc = write(fd, buf128, MSGSECT);	/* write n+1 128 byte
							 * record */
	}

	strfill(buf128, 26, MSGSECT);	/* fill with all hex 1a */
	rc = write(fd, buf128, MSGSECT);	/* write all hex 1a 128 byte
						 * record */
	return (OK);
}


msgread(fd, msgno)		/* read message number requested */
	int             fd,	/* returns ERROR if msg past eof */
	                msgno;	/* returns 0 if msg is not 1st piece */
/* of a message */
/* returns 0 if msg is deleted */
/* returns msg # if successful */
{
	int             rc,	/* return code */
	                msgac, cnt1, cnt2, len, next, ret_this, file_size;
	char            bufmsg0[MSG1MAX + 1], buf128[MSGSECT + 256], buftmp[MSGSECT + 256], this1[10], act[10], next1[10];

	msgac = xtable[msgno - 1];
	if (msgac > h_next) {	/* don't try to seek past end of file */
		return (ERROR);
	}
	if (msgac == 0) {
		return (ERROR);
	}
	if ((rc = seek(fd, msgac - 1, 0)) == ERROR) {
		printf(CRLF);
		printf("Can't seek on message-file!");
		printf(CRLF);
		return (ERROR);	/* when cant find it */
	}
	if (read(fd, buf128, MSGSECT) != MSGSECT) {	/* read 128 byte sector */
		printf(CRLF);
		printf("Can't read in message-file!");
		printf(CRLF);
		return (ERROR);
	}
	/*
	 * get first piece of msg record 
	 */
	/* do trial read, since if not first record, fields might overflow */
	rc = sscanf(buf128, "%[^~]~%[^~]~%[^~]~%[^~]~%[^~]~%[^~]~%[^~]~%[^~]~%[^~]~",
		    buftmp, buftmp, buftmp, buftmp, buftmp, buftmp, buftmp, buftmp, buftmp);
	if (rc != 9) {		/* makes sure we read the 1st piece *//* of a
				 * message and not in the middle */
		return (0);	/* 0 when is not the msg header */
	}
	/* now do the real read since looks like is a good record */
	rc = sscanf(buf128, "%[^~]~%[^~]~%[^~]~%[^~]~%[^~]~%[^~]~%[^~]~%[^~]~%[^~]~",
		    this1,	/* this rcd # */
		    next1,	/* points to next rcd # */
		    msg_delete,	/* delete byte */
		    msg_date,
		    msg_time,
		    msg_to,
		    msg_from,
		    msg_pass,
		    msg_subject);
	if (rc != 9) {		/* makes sure we read the 1st piece *//* of a
				 * message and not in the middle */
		return (0);	/* 0 when is not the msg header */
	}
	if (msg_delete[0] == '9') {	/* check for deleted messages *//* if
					 * so, return as if not found */
		return (0);
	}
	ret_this = atoi(this1);	/* return this msg no. */
	next = atoi(next1);
	itoa(act, msgno);
	strcpy(msg_no, act);
	msg_text[0] = '\0';
	while (next) {		/* read until no more pieces for *//* this
				 * message */
		if (read(fd, buf128, MSGSECT) != MSGSECT) {	/* read next sector */
			printf(CRLF);
			printf("Can't read in message-file(2)!");
			printf(CRLF);
			return (ERROR);
		}
		strfill(bufmsg0, 0, MSG1MAX);	/* init bufmsg0 to all hex 00 */
		rc = sscanf(buf128, "%[^~]~%[^~]~%[^~]~%[^~]~",
			    this1,	/* this rcd # */
			    next1,	/* point to next rcd # */
			    msg_delete,	/* delete byte */
			    bufmsg0);	/* piece of msg */
		next = atoi(next1);
		strcat(msg_text, bufmsg0);	/* tag piece of msg to */
		/* whole msg array */
	}
	return (ret_this);	/* if all ok, return the msg no. found */
}

/* end of program  	 */
