/*
 *  This program allows the "sysop" to communicate with the bbs user(s) that
 *  is/are on the system. Only one chat can be performed at a time. While the
 *  chat is in progress, any other user that is on the system who requests a
 *  chat will automatically be notified that the sysop is presently chatting
 *  or has "turned off" the chat. To turn off the chat, just generate a null
 *  length file called /tmp/ttydev and the bbs software will do the rest.
 * 
 *  Usage of the program is as follows:   chatbbs device_name
 *
 *  Please note that the device_name DOES NOT include the path ( /dev/ ). An
 *  example of the usage is as follows:  chatbbs tty1A
 *
 *  To TERMINATE the chat, just depress the ESCAPE key ( esc --- '\033' ) and
 *  the chat will terminate.
 *
 *  The sequence that the bbs software uses is as follows:
 *
 *  SIGPIPE ------ Go into chat
 *  SIGUSR1 ------ Exit chat
 *
 *  Please note that SIGUSR1 is also used to toggle the local monitoring of the
 *  bbs user. The bbs software will determine what to do when it intercepts
 *  SIGUSR1.
 *
 *
 *  FOR SysV.4, compile the code using a -DES54 ( cc -DES54 chatbbs.c -o chatbbs
 *
 *
 *  Sanford J. Zelkovitz    XBBS  714-821-9671
 *
 */
#include <stdio.h>
#include <string.h>
#include <signal.h>
#include "chat.h"
int             kill();
int             atoi();
main(argc, argv) 
	int		argc;
	char           *argv[];
{
	FILE           *indev;
	FILE           *outdev;
	char            buffer[30];
	char           *tty, *buffer_ptr, *ttyname();
	char            temp[50], char_pid[30];
	int             ch;
	int             handle, i, pid;
	int             ret_kill;
#ifdef ESIX54
	char		tmpbuffer[100];
	FILE		*ttz;
	char		x1[20], x2[20], x3[20], x4[20], x5[20], x6[20];
	int		major, minor;
#endif
	setbuf(stdin, NULL);
	setbuf(stdout, NULL);
	if (argc != 2) {
		printf("\nError in usage, should be: chatbbs device.\n");
		exit(1);
	}
	strcpy(buffer, "/dev/");
	strcat(buffer, argv[1]);
	printf("\nDevice driver = %s\n", buffer);
	tty = ttyname(1);
#ifdef ESIX54
	unlink("/dev/bbschatter");
	sprintf(tmpbuffer, "ls -l %s > /tmp/chatinfo", tty);
	system(tmpbuffer);
	ttz = fopen("/tmp/chatinfo", "r");
	(void) fscanf(ttz, "%s%s%s%s%s%s", x1, x2, x3, x4, x5, x6);
	fclose(ttz);
	major = atoi(x5);
	minor = atoi(x6);
	printf( "major = %d    minor = %d\n", major, minor);
	sprintf(tmpbuffer, "/etc/mknod /dev/bbschatter c %d %d", major, minor);
	system(tmpbuffer);
	system("chmod 666 /dev/bbschatter");
	system("chown bbs /dev/bbschatter");
#endif
	if ((indev = fopen("/tmp/ttydev", "w")) == NULL) {
		printf("\nError opening /tmp/ttydev!\n");
		exit(1);
	}
#ifdef ESIX54
	(void) fprintf(indev, "%s\n", "/dev/bbschatter");
#else
	(void) fprintf(indev, "%s\n", tty);
#endif
	fclose(indev);
	if ((outdev = fopen(buffer, "r+")) == NULL) {
		unlink("/tmp/ttydev");
		unlink("/dev/bbschatter");
		printf("\nError opening BBS user's device driver!\n");
		exit(1);
	}
	setbuf(outdev, NULL);
	strcpy(temp, "/tmp/pid");
	i = strlen(buffer);
	buffer_ptr = buffer;
	buffer_ptr = buffer_ptr + i - 2;
	strcat(temp, buffer_ptr);
	if ((indev = fopen(temp, "r")) == NULL) {
		unlink("/tmp/ttydev");
		unlink("/dev/bbschatter");
		printf("\nError opening pid file!\n");
		exit(1);
	}
	(void) fscanf(indev, "%s", char_pid);
	fclose(indev);
	pid = atoi(char_pid);
	ret_kill = kill(pid, SIGPIPE);
	if (ret_kill == -1) {
		printf("\nIllegal pid????\n");
		unlink("/tmp/ttydev");
		unlink("/dev/bbschatter");
		exit(1);
	}
	sleep(2);
	setraw();
	while (1) {
		ch = getc(stdin);
		ch &= '\377';
		if (ch == '\033')
			break;
		putchar(ch);
		putc(ch, outdev);
		if (ch == '\n') {
			ch = '\r';
			putchar(ch);
			putc(ch, outdev);
		}
		if (ch == '\r') {
			ch = '\n';
			putchar(ch);
			putc(ch, outdev);
		}
		if (ch == '\b') {
			ch = ' ';
			putchar(ch);
			putc(ch, outdev);
			ch = '\b';
			putchar(ch);
			putc(ch, outdev);
		}
	}
	ch = '\r';
	putchar(ch);
	putc(ch, outdev);
	ch = '\n';
	for (i = 0; i <= 5; i++) {
		putchar(ch);
		putc(ch, outdev);
	}
	fclose(outdev);
	restore();
	unlink("/tmp/ttydev");
	unlink("/dev/bbschatter");
	ret_kill = kill(pid, SIGUSR1);
	if (ret_kill == -1) {
		printf("\nIllegal pid????\n");
		exit(1);
	}
}
