
/*
	If the computer is BIG ENDIAN, remove the comment from the next
        line.
#define BIGEND
*/

typedef unsigned char byte;	/* code assumes UNSIGNED bytes */
typedef long longint;
typedef unsigned short word;
typedef char boolean;

#define STRSIZ 256
#define BSIZE 512

#include <stdio.h>
#include <ctype.h>

#ifdef __STDC__

#include <stdlib.h>

#else

char *malloc();

#endif

#define min(a,b) ((a) < (b) ? (a) : (b))

/*
 * Zipfile layout declarations
 *
 */

#define LONGIP(l) ((longint *) &((l)[0]))
#define LONGI(l) (*(LONGIP(l)))

typedef longint signature_type;


#define LOCAL_FILE_HEADER_SIGNATURE  0x04034b50L


typedef struct local_file_header {
	word version_needed_to_extract;
        word general_purpose_bit_flag;
	word compression_method;
	word last_mod_file_time;
	word last_mod_file_date;
	byte crc32[4];
	byte compressed_size[4];
        byte uncompressed_size[4];
	word filename_length;
	word extra_field_length;
} local_file_header;


#define CENTRAL_FILE_HEADER_SIGNATURE  0x02014b50L


typedef struct central_directory_file_header {
	word version_made_by;
	word version_needed_to_extract;
	word general_purpose_bit_flag;
	word compression_method;
	word last_mod_file_time;
	word last_mod_file_date;
	byte crc32[4];
	byte compressed_size[4];
	byte uncompressed_size[4];
	word filename_length;
	word extra_field_length;
	word file_comment_length;
	word disk_number_start;
	word internal_file_attributes;
	byte external_file_attributes[4];
	byte relative_offset_local_header[4];
} central_directory_file_header;


#define END_CENTRAL_DIR_SIGNATURE  0x06054b50L


typedef struct end_central_dir_record {
	word number_this_disk;
	word number_disk_with_start_central_directory;
	word total_entries_central_dir_on_this_disk;
	word total_entries_central_dir;
	byte size_central_directory[4];
	byte offset_start_central_directory[4];
	word zipfile_comment_length;
} end_central_dir_record;


char *fnames[2] = {	/* default filenames vector */
	"*",
	NULL
};
char **fnv = &fnames[0];

int vflag;		/* -v: view directory */

int members;
longint csize;
longint ucsize;
longint tot_csize;
longint tot_ucsize;


/*
 * input file variables
 *
 */

#define INBUFSIZ BUFSIZ		/* same as stdio uses */
byte *inbufchr;			/* input file buffer - any size is legal */
byte *inptr;

int incnt;
word bitbuf;
int bits_left;
boolean zipeof;

int zipfd;
char zipfn[STRSIZ];
local_file_header lrec;


/*
 * output stream variables
 *
 */

#define OUTBUFSIZ 0x2000        /* unImplode needs power of 2, >= 0x2000 */
byte *outbufchr;                   /* buffer for rle look-back */
byte *outptr;

longint outpos;			/* absolute position in outfile */
int outcnt;			/* current position in outbufchr */

int outfd;
char filename[STRSIZ];
char extra[STRSIZ];

#define DLE 144


/* ----------------------------------------------------------- */
/*
 * shrink/reduce working storage
 *
 */

int factor;

#define max_bits 13
#define init_bits 9
#define hsize 8192
#define first_ent 257
#define clear 256


int codesize;
int maxcode;
int free_ent;
int maxcodemax;
int offset;
int sizex;



/* ============================================================= */
/*
 * Host operating system details
 *
 */

/* On some systems the contents of sys/param.h duplicates the
   contents of sys/types.h, so you don't need (and can't use)
   sys/types.h. */

#include <sys/types.h>
#include <sys/param.h>
#include <time.h>
struct tm *gmtime(), *localtime();
#define ZSUFX ".zip"


char *strchr(), *strrchr();

long lseek();

#define SEEK_SET  0
#define SEEK_CUR  1
#define SEEK_END  2

FILE *zipFILE;

#include <fcntl.h>

void set_file_time()
 /*
  * set the output file date/time stamp according to information from the
  * zipfile directory record for this file 
  */

{
    time_t times[2];
    struct tm *tmbuf;
    long m_time;
    int yr, mo, dy, hh, mm, ss, leap, days = 0;


    yr = (((lrec.last_mod_file_date >> 9) & 0x7f) + 10);  /* dissect date */
    mo = ((lrec.last_mod_file_date >> 5) & 0x0f);
    dy = ((lrec.last_mod_file_date & 0x1f) - 1);

    hh = ((lrec.last_mod_file_time >> 11) & 0x1f);        /* dissect time */
    mm = ((lrec.last_mod_file_time >> 5) & 0x3f);
    ss = ((lrec.last_mod_file_time & 0x1f) * 2);

    /* leap = # of leap years from 1970 up to but not including
       the current year */

    leap = ((yr+1969)/4);              /* Leap year base factor */

    /* How many days from 1970 to this year? */
    days = (yr * 365) + (leap - 492);

    switch(mo)			       /* calculate expired days this year */
    {
    case 12:
        days += 30;
    case 11:
        days += 31;
    case 10:
        days += 30;
    case 9:
        days += 31;
    case 8:
        days += 31;
    case 7:
        days += 30;
    case 6:
        days += 31;
    case 5:
        days += 30;
    case 4:
        days += 31;
    case 3:
        days += 28;                    /* account for leap years */
        if (((yr+1970) % 4 == 0) && (yr+1970) != 2000)
            ++days;
    case 2:
        days += 31;
    }

    /* convert date & time to seconds relative to 00:00:00, 01/01/1970 */
    m_time = ((days + dy) * 86400) + (hh * 3600) + (mm * 60) + ss;

    tmbuf = localtime(&m_time);
    hh = tmbuf->tm_hour;
    tmbuf = gmtime(&m_time);
    hh = tmbuf->tm_hour - hh;
    if (hh < 0)
	hh += 24;
    m_time += (hh * 3600);             /* account for timezone differences */

    times[0] = m_time;             /* set the stamp on the file */
    times[1] = m_time;
    utime(filename, times);
}


int open_input_file()
 /* return non-0 if open failed */
{
	/*
	 * open the zipfile for reading and in BINARY mode to prevent cr/lf
	 * translation, which would corrupt the bitstreams 
	 */

	zipfd = open(zipfn, O_RDONLY);
	return 0;
}


#ifdef BIGEND

void swap_bytes(wordp)
word *wordp;
 /* convert intel style 'short int' variable to host format */
{
	char *charp = (char *) wordp;
	char temp;

	temp = charp[0];
	charp[0] = charp[1];
	charp[1] = temp;
}

void swap_lbytes(longp)
longint *longp;
 /* convert intel style 'long' variable to host format */
{
	char *charp = (char *) longp;
	char temp[4];

	temp[3] = charp[0];
	temp[2] = charp[1];
	temp[1] = charp[2];
	temp[0] = charp[3];

	charp[0] = temp[0];
	charp[1] = temp[1];
	charp[2] = temp[2];
	charp[3] = temp[3];
}

#endif



/* ============================================================= */

int readbuf(fd, buf, size)
int fd;
char *buf;
register unsigned size;
{
	register int count;
	int n;

	n = size;
	while (size)  {
		if (incnt == 0)  {
			if ((incnt = read(fd, inbufchr, INBUFSIZ)) <= 0)
				return(incnt);
			inptr = inbufchr;
		}
		count = min(size, incnt);
		memcpy(buf, inptr, count);
		buf += count;
		inptr += count;
		incnt -= count;
		size -= count;
	}
	return(n);
}

int ReadByte(x)
word *x;
 /* read a byte; return 8 if byte available, 0 if not */
{
	if (csize-- <= 0)
		return 0;
	if (incnt == 0)  {
		if ((incnt = read(zipfd, inbufchr, INBUFSIZ)) <= 0)
			return 0;
		inptr = inbufchr;
	}
	*x = *inptr++;
	--incnt;
	return 8;
}


/* ------------------------------------------------------------- */
static word mask_bits[] =
        {0,     0x0001, 0x0003, 0x0007, 0x000f,
                0x001f, 0x003f, 0x007f, 0x00ff,
                0x01ff, 0x03ff, 0x07ff, 0x0fff,
                0x1fff, 0x3fff, 0x7fff, 0xffff
        };


int FillBitBuffer(bits)
register int bits;
{
	/* get the bits that are left and read the next word */
        register int result = bitbuf;
	word temp;
	int sbits = bits_left;
	bits -= bits_left;

	/* read next word of input */
	bits_left = ReadByte(&bitbuf);
	bits_left += ReadByte(&temp);
	bitbuf |= (temp << 8);
	if (bits_left == 0)
		zipeof = 1;

	/* get the remaining bits */
        result = result | (int) ((bitbuf & mask_bits[bits]) << sbits);
        bitbuf >>= bits;
        bits_left -= bits;
        return result;
}

#define READBIT(nbits,zdest) { if (nbits <= bits_left) { zdest = (int)(bitbuf & mask_bits[nbits]); bitbuf >>= nbits; bits_left -= nbits; } else zdest = FillBitBuffer(nbits);}


/* ------------------------------------------------------------- */

unsigned long crc32val;

void UpdateCRC();



/* ----------------------------------------------------------- */
/*
 * The Reducing algorithm is actually a combination of two
 * distinct algorithms.  The first algorithm compresses repeated
 * byte sequences, and the second algorithm takes the compressed
 * stream from the first algorithm and applies a probabilistic
 * compression method.
 */

int L_table[] = {0, 0x7f, 0x3f, 0x1f, 0x0f};

int D_shift[] = {0, 0x07, 0x06, 0x05, 0x04};
int D_mask[]  = {0, 0x01, 0x03, 0x07, 0x0f};

int B_table[] = {8, 1, 1, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 5,
		 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6,
		 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
		 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7,
		 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
		 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
		 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
		 7, 7, 7, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
		 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
		 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
		 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
		 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
		 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
		 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
		 8, 8, 8, 8};

/* ----------------------------------------------------------- */


/*
 Length  Method   Size  Ratio   Date    Time   CRC-32    Name
 ------  ------   ----- -----   ----    ----   ------    ----
  44004  Implode  13041  71%  11-02-89  19:34  88420727  DIFF3.C
 */

void dir_member()
{
	char *method;
	int ratio;
	int yr, mo, dy, hh, mm;

	yr = (((lrec.last_mod_file_date >> 9) & 0x7f) + 80);
	mo = ((lrec.last_mod_file_date >> 5) & 0x0f);
	dy = (lrec.last_mod_file_date & 0x1f);

	hh = ((lrec.last_mod_file_time >> 11) & 0x1f);
	mm = ((lrec.last_mod_file_time >> 5) & 0x3f);

	switch (lrec.compression_method)  {
	case 0:
		method = "Stored";
		break;
	case 1:
		method = "Shrunk";
		break;
	case 2:
		method = "Reduce1";
		break;
	case 3:
		method = "Reduce2";
		break;
	case 4:
		method = "Reduce3";
		break;
	case 5:
		method = "Reduce4";
		break;
	case 6:
		method = "Implode";
		break;
	case 7:
		method = "Token";
		break;
	case 8:
		method = "Deflate";
		break;
	default:
		method = "Unknown";
		break;
	}

	if (ucsize != 0)  {
		ratio = (int) ((1000L * (ucsize	- csize)) / ucsize);
		if ((ratio % 10) >= 5)
			ratio += 10;
	}
	else
		ratio = 0;	/* can .zip contain 0-size file? */

	fprintf(zipFILE, "%7ld  %-7s%7ld %3d%%  %02d-%02d-%02d  %02d:%02d  \
%08lx  %s\n", ucsize, method, csize,
		ratio / 10, mo, dy, yr, hh, mm,
		LONGI(lrec.crc32), filename);
	tot_ucsize += ucsize;
	tot_csize += csize;
	++members;
}

/* ---------------------------------------------------------- */

void skip_member()
{
	register long pos;
	long endbuf;
	int offset;

	endbuf = lseek(zipfd, 0L, SEEK_CUR);	/* 1st byte beyond inbufchr */
	pos = endbuf - incnt;			/* 1st compressed byte */
	pos += csize;		/* next header signature */
	if (pos < endbuf)  {
		incnt -= csize;
		inptr += csize;
	}
	else  {
		offset = pos % BSIZE;		/* offset within block */
		pos = (pos / BSIZE) * BSIZE;	/* block start */
	        lseek(zipfd, pos, SEEK_SET);
		incnt = read(zipfd, inbufchr, INBUFSIZ);
		incnt -= offset;
		inptr = inbufchr + offset;
	}
}

/* ---------------------------------------------------------- */

void get_string(len, s)
int len;
char *s;
{
	readbuf(zipfd, s, len);
	s[len] = 0;
}


/* ---------------------------------------------------------- */

void process_local_file_header(fnamev)
char **fnamev;
{
	int extracted;

	readbuf(zipfd, &lrec, sizeof(lrec));

#ifdef BIGEND
	swap_bytes(&lrec.filename_length);
	swap_bytes(&lrec.extra_field_length);
	swap_lbytes(LONGIP(lrec.compressed_size));
	swap_lbytes(LONGIP(lrec.uncompressed_size));
	swap_bytes(&lrec.compression_method);
	swap_bytes(&lrec.version_needed_to_extract);
        swap_bytes(&lrec.general_purpose_bit_flag);
	swap_bytes(&lrec.last_mod_file_time);
	swap_bytes(&lrec.last_mod_file_date);
        swap_lbytes(LONGIP(lrec.crc32));
#endif
	csize = LONGI(lrec.compressed_size);
	ucsize = LONGI(lrec.uncompressed_size);

	get_string(lrec.filename_length, filename);
	get_string(lrec.extra_field_length, extra);

	extracted = 0;
	for (--fnamev; *++fnamev; )  {
		if (match(filename, *fnamev))  {
				dir_member();
			break;
		}
	}
		skip_member();
}


/* ---------------------------------------------------------- */

void process_central_file_header()
{
	central_directory_file_header rec;
	char filename[STRSIZ];
	char extra[STRSIZ];
	char comment[STRSIZ];

	readbuf(zipfd, &rec, sizeof(rec));

#ifdef BIGEND
	swap_bytes(&rec.filename_length);
	swap_bytes(&rec.extra_field_length);
	swap_bytes(&rec.file_comment_length);
#endif

        get_string(rec.filename_length, filename);
	get_string(rec.extra_field_length, extra);
	get_string(rec.file_comment_length, comment);
}


/* ---------------------------------------------------------- */

void process_end_central_dir()
{
	end_central_dir_record rec;
	char comment[STRSIZ];

	readbuf(zipfd, &rec, sizeof(rec));

#ifdef BIGEND
	swap_bytes(&rec.zipfile_comment_length);
#endif

	/* There seems to be no limit to the zipfile
	   comment length.  Some zipfiles have comments
	   longer than 256 bytes.  Currently no use is
	   made of the comment anyway.
	 */
#if 0
	get_string(rec.zipfile_comment_length, comment);
#endif
}


/* ---------------------------------------------------------- */

void process_headers()
{
	int ratio;
	longint sig;

	if (vflag)  {
		members = 0;
		tot_ucsize = tot_csize = 0;
		fprintf(zipFILE,"\n Length  Method   Size  Ratio   Date    Time   \
CRC-32    Name\n ------  ------   ----- -----   ----    ----   ------    \
----\n");
	}

	while (1) {
		if (readbuf(zipfd, &sig, sizeof(sig)) != sizeof(sig))
			return;

#ifdef BIGEND
		swap_lbytes(&sig);
#endif

                if (sig == LOCAL_FILE_HEADER_SIGNATURE)
			process_local_file_header(fnv);
                else if (sig == CENTRAL_FILE_HEADER_SIGNATURE)
			process_central_file_header();
                else if (sig == END_CENTRAL_DIR_SIGNATURE) {
			process_end_central_dir();
			break;
		}
                else {
			fprintf(stderr, "Invalid Zipfile Header\n");
			return;
		}
	}
	if (vflag)  {
		if (tot_ucsize != 0)  {
			ratio = (int) ((1000L * (tot_ucsize-tot_csize))
					/ tot_ucsize);
			if ((ratio % 10) >= 5)
				ratio += 10;
		}
		else
			ratio = 0;
		fprintf(zipFILE, " ------          ------  \
---                             -------\n\
%7ld         %7ld %3d%%                             %7d\n",
		tot_ucsize, tot_csize, ratio / 10, members);
	}
}


/* ---------------------------------------------------------- */

void process_zipfile()
{
	/*
	 * open the zipfile for reading and in BINARY mode to prevent cr/lf
	 * translation, which would corrupt the bitstreams 
	 */

	if (open_input_file())
		exit(1);

	process_headers();

	close(zipfd);
}

/* ---------------------------------------------------------- */
void listzip (fn, port_id)
char *fn;
char *port_id;
{
	char *s;
	int c;
	char buu[32];

	++vflag;

	strcpy(zipfn, fn);
        /* allocate i/o buffers */
	inbufchr = (byte *) (malloc(INBUFSIZ));
	outbufchr = (byte *) (malloc(OUTBUFSIZ));
	if ((inbufchr == NULL) || (outbufchr == NULL)) {
		fprintf(stderr, "Can't allocate buffers!\n");
		exit(1);
	}

        /* do the job... */
	sprintf( buu, "/tmp/ziplst.%s", port_id);
	zipFILE = fopen( buu, "w" );
        process_zipfile();
	free(inbufchr);
	free(outbufchr);
	fclose(zipFILE);
}

#include <sys/dir.h>
#include <ctype.h>

#define ASTERISK '*'		/* The '*' metacharacter */
#define QUESTION '?'		/* The '?' metacharacter */
#define BACK_SLASH '\\'         /* The '\' metacharacter */
#define LEFT_BRACKET '['	/* The '[' metacharacter */
#define RIGHT_BRACKET ']'	/* The ']' metacharacter */

#define IS_OCTAL(ch) (ch >= '0' && ch <= '7')

typedef short INT;
typedef short BOOLEAN;
#define TRUE 1
#define FALSE 0
#define EOS '\000'

static BOOLEAN do_list();
static char nextch();
static void list_parse();

int match(string, pattern)
char *string;
char *pattern;
{
    register int ismatch;

    ismatch = FALSE;
    switch (*pattern)
    {
    case ASTERISK:
        pattern++;
        do
        {
            ismatch = match (string, pattern);
        }
        while (!ismatch && *string++ != EOS);
        break;
    case QUESTION:
        if (*string != EOS)
            ismatch = match (++string, ++pattern);
        break;
    case EOS:
        if (*string == EOS)
            ismatch = TRUE;
        break;
    case LEFT_BRACKET:
        if (*string != EOS)
            ismatch = do_list (string, pattern);
        break;
    case BACK_SLASH:
        pattern++;
    default:
	if (toupper(*string) == toupper(*pattern))
        {
            string++;
            pattern++;
            ismatch = match (string, pattern);
        }
        else
            ismatch = FALSE;
        break;
    }
    return(ismatch);
}

static BOOLEAN do_list (string, pattern)
register char *string;
char *pattern;
{
    register BOOLEAN ismatch;
    register BOOLEAN if_found;
    register BOOLEAN if_not_found;
    auto char lower;
    auto char upper;

    pattern++;
    if (*pattern == '!')
    {
        if_found = FALSE;
        if_not_found = TRUE;
        pattern++;
    }
    else
    {
        if_found = TRUE;
        if_not_found = FALSE;
    }
    ismatch = if_not_found;
    while (*pattern != ']' && *pattern != EOS)
    {
        list_parse(&pattern, &lower, &upper);
        if (*string >= lower && *string <= upper)
        {
            ismatch = if_found;
            while (*pattern != ']' && *pattern != EOS) pattern++;
        }
    }

    if (*pattern++ != ']')
    {
        fprintf(stderr, "Character class error\n");
	return;
    }
    else
        if (ismatch)
            ismatch = match (++string, pattern);

    return(ismatch);
}

static void list_parse (patp, lowp, highp)
char **patp;
char *lowp;
char *highp;
{
    *lowp = nextch (patp);
    if (**patp == '-')
    {
        (*patp)++;
        *highp = nextch(patp);
    }
    else
        *highp = *lowp;
}

static char nextch (patp)
char **patp;
{
    register char ch;
    register char chsum;
    register INT count;

    ch = *(*patp)++;
    if (ch == '\\')
    {
        ch = *(*patp)++;
        if (IS_OCTAL (ch))
        {
            chsum = 0;
            for (count = 0; count < 3 && IS_OCTAL (ch); count++)
            {
                chsum *= 8;
                chsum += ch - '0';
                ch = *(*patp)++;
            }
            (*patp)--;
            ch = chsum;
        }
    }
    return(ch);
}

long crc_32_tab[] = {
      0x00000000L, 0x77073096L, 0xee0e612cL, 0x990951baL, 0x076dc419L,
      0x706af48fL, 0xe963a535L, 0x9e6495a3L, 0x0edb8832L, 0x79dcb8a4L,
      0xe0d5e91eL, 0x97d2d988L, 0x09b64c2bL, 0x7eb17cbdL, 0xe7b82d07L,
      0x90bf1d91L, 0x1db71064L, 0x6ab020f2L, 0xf3b97148L, 0x84be41deL,
      0x1adad47dL, 0x6ddde4ebL, 0xf4d4b551L, 0x83d385c7L, 0x136c9856L,
      0x646ba8c0L, 0xfd62f97aL, 0x8a65c9ecL, 0x14015c4fL, 0x63066cd9L,
      0xfa0f3d63L, 0x8d080df5L, 0x3b6e20c8L, 0x4c69105eL, 0xd56041e4L,
      0xa2677172L, 0x3c03e4d1L, 0x4b04d447L, 0xd20d85fdL, 0xa50ab56bL,
      0x35b5a8faL, 0x42b2986cL, 0xdbbbc9d6L, 0xacbcf940L, 0x32d86ce3L,
      0x45df5c75L, 0xdcd60dcfL, 0xabd13d59L, 0x26d930acL, 0x51de003aL,
      0xc8d75180L, 0xbfd06116L, 0x21b4f4b5L, 0x56b3c423L, 0xcfba9599L,
      0xb8bda50fL, 0x2802b89eL, 0x5f058808L, 0xc60cd9b2L, 0xb10be924L,
      0x2f6f7c87L, 0x58684c11L, 0xc1611dabL, 0xb6662d3dL, 0x76dc4190L,
      0x01db7106L, 0x98d220bcL, 0xefd5102aL, 0x71b18589L, 0x06b6b51fL,
      0x9fbfe4a5L, 0xe8b8d433L, 0x7807c9a2L, 0x0f00f934L, 0x9609a88eL,
      0xe10e9818L, 0x7f6a0dbbL, 0x086d3d2dL, 0x91646c97L, 0xe6635c01L,
      0x6b6b51f4L, 0x1c6c6162L, 0x856530d8L, 0xf262004eL, 0x6c0695edL,
      0x1b01a57bL, 0x8208f4c1L, 0xf50fc457L, 0x65b0d9c6L, 0x12b7e950L,
      0x8bbeb8eaL, 0xfcb9887cL, 0x62dd1ddfL, 0x15da2d49L, 0x8cd37cf3L,
      0xfbd44c65L, 0x4db26158L, 0x3ab551ceL, 0xa3bc0074L, 0xd4bb30e2L,
      0x4adfa541L, 0x3dd895d7L, 0xa4d1c46dL, 0xd3d6f4fbL, 0x4369e96aL,
      0x346ed9fcL, 0xad678846L, 0xda60b8d0L, 0x44042d73L, 0x33031de5L,
      0xaa0a4c5fL, 0xdd0d7cc9L, 0x5005713cL, 0x270241aaL, 0xbe0b1010L,
      0xc90c2086L, 0x5768b525L, 0x206f85b3L, 0xb966d409L, 0xce61e49fL,
      0x5edef90eL, 0x29d9c998L, 0xb0d09822L, 0xc7d7a8b4L, 0x59b33d17L,
      0x2eb40d81L, 0xb7bd5c3bL, 0xc0ba6cadL, 0xedb88320L, 0x9abfb3b6L,
      0x03b6e20cL, 0x74b1d29aL, 0xead54739L, 0x9dd277afL, 0x04db2615L,
      0x73dc1683L, 0xe3630b12L, 0x94643b84L, 0x0d6d6a3eL, 0x7a6a5aa8L,
      0xe40ecf0bL, 0x9309ff9dL, 0x0a00ae27L, 0x7d079eb1L, 0xf00f9344L,
      0x8708a3d2L, 0x1e01f268L, 0x6906c2feL, 0xf762575dL, 0x806567cbL,
      0x196c3671L, 0x6e6b06e7L, 0xfed41b76L, 0x89d32be0L, 0x10da7a5aL,
      0x67dd4accL, 0xf9b9df6fL, 0x8ebeeff9L, 0x17b7be43L, 0x60b08ed5L,
      0xd6d6a3e8L, 0xa1d1937eL, 0x38d8c2c4L, 0x4fdff252L, 0xd1bb67f1L,
      0xa6bc5767L, 0x3fb506ddL, 0x48b2364bL, 0xd80d2bdaL, 0xaf0a1b4cL,
      0x36034af6L, 0x41047a60L, 0xdf60efc3L, 0xa867df55L, 0x316e8eefL,
      0x4669be79L, 0xcb61b38cL, 0xbc66831aL, 0x256fd2a0L, 0x5268e236L,
      0xcc0c7795L, 0xbb0b4703L, 0x220216b9L, 0x5505262fL, 0xc5ba3bbeL,
      0xb2bd0b28L, 0x2bb45a92L, 0x5cb36a04L, 0xc2d7ffa7L, 0xb5d0cf31L,
      0x2cd99e8bL, 0x5bdeae1dL, 0x9b64c2b0L, 0xec63f226L, 0x756aa39cL,
      0x026d930aL, 0x9c0906a9L, 0xeb0e363fL, 0x72076785L, 0x05005713L,
      0x95bf4a82L, 0xe2b87a14L, 0x7bb12baeL, 0x0cb61b38L, 0x92d28e9bL,
      0xe5d5be0dL, 0x7cdcefb7L, 0x0bdbdf21L, 0x86d3d2d4L, 0xf1d4e242L,
      0x68ddb3f8L, 0x1fda836eL, 0x81be16cdL, 0xf6b9265bL, 0x6fb077e1L,
      0x18b74777L, 0x88085ae6L, 0xff0f6a70L, 0x66063bcaL, 0x11010b5cL,
      0x8f659effL, 0xf862ae69L, 0x616bffd3L, 0x166ccf45L, 0xa00ae278L,
      0xd70dd2eeL, 0x4e048354L, 0x3903b3c2L, 0xa7672661L, 0xd06016f7L,
      0x4969474dL, 0x3e6e77dbL, 0xaed16a4aL, 0xd9d65adcL, 0x40df0b66L,
      0x37d83bf0L, 0xa9bcae53L, 0xdebb9ec5L, 0x47b2cf7fL, 0x30b5ffe9L,
      0xbdbdf21cL, 0xcabac28aL, 0x53b39330L, 0x24b4a3a6L, 0xbad03605L,
      0xcdd70693L, 0x54de5729L, 0x23d967bfL, 0xb3667a2eL, 0xc4614ab8L,
      0x5d681b02L, 0x2a6f2b94L, 0xb40bbe37L, 0xc30c8ea1L, 0x5a05df1bL,
      0x2d02ef8dL
   };


#define UPDCRC32(res,oct) res=crc_32_tab[(byte)res^(byte)oct] ^ ((res>>8) & 0x00FFFFFFL)

/* ------------------------------------------------------------- */

extern unsigned long crc32val;

void UpdateCRC(s, len)
register unsigned char *s;
register int len;
 /* update running CRC calculation with contents of a buffer */
{
	register unsigned long crcval;

	crcval = crc32val;
        while (len--) {
		crcval = crc_32_tab[(byte)crcval ^ (byte)(*s++)]
			^ (crcval >> 8);
        }
	crc32val = crcval;
}


