/*------------------------------------------------------------------------
       Name: bbscsigs.c
   Comments: Display file areas and select one
  ------------------------------------------------------------------------*/


#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <signal.h>
#include "bbscdef.h"
#include <sys/locking.h>


extern int      user_priv;
extern int	first_time_in;
extern int	first_msg_in;
extern int	sigreturn;
extern char     port_id[4];
extern char	callers[99];
extern timer(), mon_toggle(), sys_toggle(), chat(), hanged();

char	save_info[99];

sig_access()
{
	FILE           *fpt, *fopen();
	char           *fgets(), *getenv();
	char            choice[4];
#ifndef SYSV
	char            dir_priv_ascii[7];
#endif
#ifdef SYSV
	char            dir_priv_ascii[20];
#endif
	char		signame[32], sigdisc[30], sigtype[10];
	int             line_cnt, ret, i;
	int             index_value, ptr;
	int             length;
	int		x1, x2;

	sigreturn = 1;
	while (1) {

do_again:
	strcpy(buf128, SIGS);

	if ((fpt = fopen(buf128, "r")) == NULL) {
		portsout("\n\r\n\rThere are no SPECIAL INTEREST GROUPS today!\n\r\n\r");
		return ;
	}
		portsout("\n\r\n\r\n\r                  *********************************\n\r");
		portsout("                * Available Special Interest GROUPS *\n\r");
		portsout("                  *********************************\n\r\n\r");
		portsout("\n\r                SIGs                     Description           Type\n\r");
		portsout("    ============================== ======================     =======\n\r");

	line_cnt = 0;
	while (fpt) {
		zfl(f_lines[line_cnt], 83);
		if ((fgets(f_lines[line_cnt], 82, fpt)) == NULL) {
			if (line_cnt == 0) {
				portsout("\n\rEOF Unexpected in Function List: Notify Sysop!\n\r");
				return;
			}
			break;	/* if not 1st line */
		}		/* end of if ((fgets)) */
		if (line_cnt > 0) {
			length = strlen(f_lines[line_cnt]);
			length -= 74;
			if(length > 6)
				length = 6;
			substr(f_lines[line_cnt], dir_priv_ascii, 74, length);
			dir_priv[line_cnt] = atoi(dir_priv_ascii);
			if (dir_priv[line_cnt] > user_priv)
				goto next_read;
			substr(f_lines[line_cnt], signame, 1, 30);
			substr(f_lines[line_cnt], sigdisc, 52,22);
			x1 = strlen(signame);
			for(x2=x1; x2 < 30; x2++)
				strcat(signame, " ");
			x1 = strlen(sigdisc);
			for(x2=x1; x2 < 26; x2++)
				strcat(sigdisc," ");
			if(f_lines[line_cnt][78] == '*')
				strcpy(sigtype, "private");
			else
				strcpy(sigtype, "public");
			sprintf(who_am_i, "%s %s %s", signame, sigdisc, sigtype);


			strip(who_am_i);
			sprintf(buf128, "%2d) %s", line_cnt, who_am_i);
			strip(buf128);
			term_space(buf128);
				portsout(buf128);
				portsout("\n\r");
		}
next_read:
		++line_cnt;
	}			/* end of while (fpt) */
	if (line_cnt <= 1)
		{
		portsout("\n\r\n\rThere are no SPECIAL INTEREST GROUPS today!\n\r\n\r");
		return;
		}
		portsout(CRLF);
		portsout(" Q) Quit --- exit SIG function section");
		portsout(CRLF);
	fclose(fpt);
		portsout(CRLF);

		portsout("Enter Selection ===> ");
		portsin_cmp(choice, 2, "Qq");
		portsout(CRLF);
		*choice = toupper(*choice);

		if (*choice == 'Q')
			return;

		index_value = atoi(choice);
		if (index_value > 0 && index_value < line_cnt) {
			if (dir_priv[index_value] <= user_priv) {
				parse_sig(f_lines[index_value]);
				if(!active) {
					sigreturn = 0;
					return;
				}
				continue;
			}
		}
	}
}





parse_sig(string, sn, sd, st )
	char           *string;
{

	register char  *file_ptr, *xptr;
	register int    i, private;
	char tempr[100], temps[100], tempt[100], tempu[100], tempv[100];
	char tempw[100];
	char sigfile[99];
	char firstz[20], lastz[20];
	extern int fds;
	FILE *sigptr;

	file_ptr = buf128;
	substr(string, buf128, 1, 50);
	strip(buf128);
	term_space(buf128);
	if(string[78] != '*')
		private = 0;
	else
		private = 1;
	strcpy(tempr, ORGPATH);
	file_ptr = (tempr + strlen(tempr));
	i = 0;
	who_am_I[0] = '\0';
	xptr = who_am_I;
	while ( string[i] != ' ') {
		*file_ptr = string[i];
		*xptr = string[i];
		file_ptr++;
		xptr++;
		i++;
	}
	*file_ptr = '\0';
	*xptr = '\0';
	strcat(tempr, "/");
	strcpy(temps, tempr);
	strcpy(tempt, tempr);
	strcpy(tempv, tempr);
	strcpy(tempw, tempr);
	strcpy(tempu, ORGPATH);
	strcat(tempu, "helpsig.bbs");
	strcat(tempt, "sigwelcome.bbs");
	strcat(tempv, "sigentry.bbs");
	strcat(tempw, "features.bbs");
	strcat(temps, "files/");
	strcat(tempr, "msgs/");
	strcpy( sigfile, ORGPATH);
	strcat( sigfile, who_am_I);
	strcat( sigfile, ".bbs");
	sigptr = fopen(sigfile, "r");
	if( sigptr == NULL ) {
		portsout("\n\r\n\rThat SIG is not available today.\n\r");
		return;
	}
	while(1) {
		if( fscanf( sigptr, "%s%s", firstz, lastz) == EOF ) {
			fclose(sigptr);
			if(private) {
				portsout("\n\rThis is a private SIG and your are not listed as a member.\n\r");
				sigptr = fopen(tempv, "r");
				if(sigptr != NULL)
					cmd_p(tempv);
				fclose(sigptr);
				return;
				}
			portsout("\n\rYou are being registered into this SIG.\n\r");
			sigptr = fopen(sigfile, "a");
			fds = fileno(sigptr);
			rewind(sigptr);
			locking(fds, LK_LOCK, 0L);
			fprintf( sigptr, "%s %s\n", w_fname, w_lname);
			rewind(sigptr);
			locking(fds, LK_UNLCK, 0L);
			fclose( sigptr);
			break;
		}
		if (( strcmp(firstz, w_fname) == 0) &&
		      (strcmp(lastz, w_lname) == 0)) {
			portsout("\n\rYou are listed in this SIG.\n\r");
			fclose( sigptr );
			break;
		}
	}	
	strcpy(save_info, who_am_I);
	if(private)
		strcat(save_info, "        - A Private SIG -");
	else
		strcat(save_info, "        - A Public SIG -");
	sigptr = fopen(tempt, "r");
	if( sigptr != NULL ) {
		portsout(CRLF);
		portsout(CRLF);
		cmd_p(tempt);
	}
	fclose(sigptr);
	if ((sigptr = fopen(callers, "a")) == NULL) {	/* create or open for
									 * append */
		portsout(CRLF);
		portsout("Can't open/create callers file!");
		portsout(CRLF);
		return;
	}
		i = fprintf(sigptr, "%s %s ","   Entered SIG ", save_info);
		if (i < 0) {
			portsout(CRLF);
			portsout("Caller file has problem writing");
			portsout(CRLF);
		} else {
			fputs("\n", sigptr);
		}
		fclose(sigptr);
	while (1) {
		if(!active)
			return;
		cmd_t();
		portsout("\n\rSIG = ");
		portsout(save_info);
		portsout(CRLF);
		bbsmenu(4,0);
		portsin(firstz, 1);
		portsout(CRLF);
		*firstz = toupper(*firstz);
		switch(firstz[0]) {
		case ('A'):
			if( !privmsg(mpZ))
				break;
			additional(tempw);
			break;
		case ('G'):
			if( !privmsg(mpG))
				break;
			cmd_c();
			break;
		case ('?'):
			if( !privmsg(mpZ))
				break;
			cmd_p(tempu);
			break;
		case ('M'):
			if( !privmsg(mpMS))
				break;
			strcpy(m_pathname, tempr);
			first_msg_in = FALSE;
			hdrread();
			check_mail();
			msg_section(mpK);
			break;
		case ('F'):
			if( !privmsg(mpF))
				break;
			strcpy(f_pathname, temps);
			strcpy(u_pathname, temps);
			first_time_in = FALSE;
			cmd_f();
			break;
		case ('L'):
			return;
			break;
		case ('X'):
			if( !privmsg(mpX))
				break;
			cmd_x();
			break;
		case ('T'):
			if( !privmsg(mpT))
				break;
			toggle = !toggle;
			if (toggle ) 
				portsout("\n\rStop Mode\n\r");
			else
				portsout("\n\rContinuous Mode\n\r");
		default:
			break;
		}
	}
}
