#include <string.h>
#include <ctype.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/locking.h>
#include <sys/stat.h>
#include "bbscdef.h"
struct stat statbuf;
char QST_FILE[50];
/*
    The following questionnaire commands are available for usage:
    Command           Description
      !               Output the rest of the line and wait for an input
      ^               Same as '!' except strlen of input must be > 0
      @               Output the rest of the line and send a \n\r
      &               Same as '@' without a terminal \n\r
      $               Input line
      *               Same as '$' except strlen of input must be > 0
      %               Output \n\r
      Y || y          Output line and set flag true if answer is a Y or y
      N || n          Output line and set flag true if answer is an N or n
      {               Start conditional response based on flag = true
      }               End conditional response
      /               Exit questionnaire - normally used as a conditional
                      statement

      The COMMAND is in column one of line
*/
question(typeofqst)
int typeofqst;
{
        int result, fds, var;
        char *ptr;
        var = FALSE;
	result=change_qst(0, typeofqst);
        if( result != 0)
        {
                portsout("\n\rThere is NO questionnaire today!\n\r");
                return;
        }
        if((inbuf=fopen(QST_FILE,"r")) == NULL)
        {
                portsout("\n\rThat questionnaire was not found -- notify the sysop!\n\r");
                return;
        }
        if((otbuf=fopen(ANSWER,"a+")) == NULL)
        {
                portsout("\n\rError opening answer file!\n\r");
                exit (1);
        }
        fds = fileno(otbuf);
        rewind (otbuf);
        locking(fds, LK_LOCK, 0L);
	lseek(fds, 0L, 2);
        fprintf(otbuf,"%s\n","***********************************************");
        fprintf(otbuf, "%s %s    %s %s %s\n", w_fname, w_lname, week, date, ttime);
next_qloop:
        while ((fgets(buf128, 80, inbuf)) != NULL )
        {
                strip(buf128);
                if(buf128[0] == '$')
                {
                        portsout("\n\r? ");
                        portsin(buf128,80);
                        fprintf(otbuf, "%s\n", buf128);
                        continue;
                }
                if(buf128[0] == '*')
                {
			while (1) {
                       		portsout("\n\r? ");
                       		portsin(buf128,80);
				if( strlen(buf128) > 0 )
					break;
				portsout("\n\rInput is required.");
			}
			
                       	fprintf(otbuf, "%s\n", buf128);
                        continue;
                }
                if(buf128[0] == '!')
                {
                        ptr = buf128 + 1;
                        portsout(CRLF);
                        portsout(ptr);
                        portsout(" ? ");
                        portsin(buf128,80);
                        fprintf(otbuf, "%s\n", buf128);
                        continue;
                }
                if(buf128[0] == '^')
                {
                        ptr = buf128 + 1;
                        portsout(CRLF);
                        portsout(ptr);
                        portsout(" ? ");
			while(1) {
                        	portsin(buf128,80);
				if( strlen(buf128) > 0 )
					break;
				portsout("\n\rInput is required.");
                       		portsout("\n\r? ");
			}
                        fprintf(otbuf, "%s\n", buf128);
                        continue;
                }
                if(buf128[0] == '@')
                {
                        ptr = buf128 + 1;
                        portsout(CRLF);
                        portsout(ptr);
                        portsout(CRLF);
                        continue;
                }
                if(buf128[0] == '&')
                {
                        ptr = buf128 + 1;
                        portsout(CRLF);
                        portsout(ptr);
                        continue;
                }
                if(buf128[0] == '%' )
                {
                        portsout(CRLF);
                        continue;
                }
                if(buf128[0] == 'y' || buf128[0] == 'Y')
                {
                        ptr = buf128 + 1;
                        portsout(CRLF);
                        portsout(ptr);
                        portsout(" ? ");
                        portsin(buf128,1);
                        if(buf128[0] == 'Y' || buf128[0] == 'y') var = TRUE;
                        else var = FALSE;
                        continue;
                }
                if(buf128[0] == 'n' || buf128[0] == 'N')
                {
                        ptr = buf128 + 1;
                        portsout(CRLF);
                        portsout(ptr);
                        portsout(" ? ");
                        portsin(buf128,1);
                        if(buf128[0] == 'N' || buf128[0] == 'n') var = TRUE;
                        else var = FALSE;
                        continue;
                }
                if(buf128[0] == '/')
                {
                        rewind(otbuf);
                        locking(fds, LK_UNLCK, 0L);
                        fclose(inbuf);
                        fclose(otbuf);
                        return;
                }
                if(buf128[0] == '{' && var == TRUE ) continue;
                if(buf128[0] == '{')
                {
                        while ((fgets(buf128, 80, inbuf)) != NULL )
                        {
                                strip(buf128);
                                if(buf128[0] == '}')
                                goto next_qloop;
                        }
                        rewind(otbuf);
                        locking(fds, LK_UNLCK, 0L);
                        fclose(inbuf);
                        fclose(otbuf);
                        return;
                }
                if(buf128[0] == '}') continue;
        }
        rewind(otbuf);
        locking(fds, LK_UNLCK, 0L);
        fclose(inbuf);
        fclose(otbuf);
}


int             set_yet_q = TRUE;
extern int      user_priv;


int change_qst( type, typeofqst ) int type, typeofqst;
{
        FILE           *fpt, *fopen();
        char           *fgets(), *getenv();
        char            choice[4];
#ifndef SYSV
        char            dir_priv_ascii[7];
#endif
#ifdef SYSV
        char            dir_priv_ascii[20];
#endif

        char           *buf_ptr;
        int             line_cnt, ret, i;
        int             index_value, ptr;
        int             length;


do_again:
        strcpy(buf128, QUESTION);

        if ((fpt = fopen(buf128, "r")) == NULL) {
                portsout("\n\rError Opening Questionnaire List: Notify Sysop!\n\r");
                return (-1);
        }
        if(!type) {
        portsout("\n\r    Questionnaire     Description                                      \n\r");
        portsout("    ============= ========================================== \n\r");
        }

        line_cnt = 0;
        while (fpt) {
		zfl(f_lines[line_cnt], 81);
                if ((fgets(f_lines[line_cnt], 80, fpt)) == NULL) {
                        if (line_cnt == 0) {
                                portsout("\n\rEOF Unexpected in Questionnaire List: Notify Sysop!\n\r");
                                return (-1);
                        }
                        break;  /* if not 1st line */
                }               /* end of if ((fgets)) */
                if (line_cnt > 0) {
                        length = strlen(f_lines[line_cnt]);
                        length -= 57;
                        if(length > 6)
                                length = 6;
                        substr(f_lines[line_cnt], dir_priv_ascii, 57, length);
                        dir_priv[line_cnt] = atoi(dir_priv_ascii);
                        if (dir_priv[line_cnt] > user_priv)
                                goto next_read;
                        strcpy(who_am_i, f_lines[line_cnt]);
                        buf_ptr = who_am_i;
                        buf_ptr += 56;
                        for (ptr = 0; ptr < 6; ptr++)
                                *buf_ptr++ = ' ';
			*buf_ptr='\0';
                        sprintf(buf128, "%2d) %s", line_cnt, who_am_i);
                        if(!type) {
                        strip(buf128);
                        term_space(buf128);
                        portsout(buf128);
                        portsout("\n\r");
                        }
                }
next_read:
                ++line_cnt;
        }                       /* end of while (fpt) */
        if (line_cnt <= 1)
                return;
        if (set_yet_q && !type) {
                portsout(CRLF);
	if(!typeofqst)
                portsout(" Q) Quit to Previous Menu");
        }
        if(!type)portsout(CRLF);
        fclose(fpt);
        if(!type)portsout(CRLF);

        while (1) {
                if(!type) {
                portsout("Enter Selection ===> ");
		if(!typeofqst)
          		 portsin_cmp(choice, 2, "Qq");
		else
			portsin(choice, 2);
                portsout(CRLF);
                *choice = toupper(*choice);

                if (*choice == 'Q' && set_yet_q && !typeofqst)
                        return (-1);


                index_value = atoi(choice);
                }
                else index_value = type;
                if (index_value > 0 && index_value < line_cnt) {
                        if (dir_priv[index_value] <= user_priv) {
                                parse2arg(f_lines[index_value]);
                                set_yet_q = TRUE;
                                return (0);
                        }
                }
                if( type != 0 ) {
                        type = 0;
                        portsout("\n\rInvalid Questionnaire request!\n\r");
                        goto do_again;
                }
        }
}





parse2arg(string)
        char           *string;
{

        register char  *file_ptr, *xptr;
        register int    i;

        strcpy(QST_FILE, ORGPATH);
        file_ptr = (QST_FILE + strlen(QST_FILE));

        i = 0;
        while (string[i] != ' ') {
                *file_ptr = string[i];
                ++file_ptr;
                ++i;
        }
        *file_ptr = '\0';
	strcpy(ANSWER, QST_FILE);
	strcat(QST_FILE, ".qst");
	strcat(ANSWER, ".ans");

}
