/*------------------------------------------------------------------------
       Name: bbscbult.c
   Comments: Display file areas and select one
  ------------------------------------------------------------------------*/

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <time.h>
#include "bbscdef.h"


extern int      user_priv;
long		atol();
static int	indexb[99];
static int	first_b_r = 1;

change_bult()
{
	FILE           *fpt, *fopen();
	char           *fgets(), *getenv();
	char            choice[4];
#ifndef SYSV
	char            dir_priv_ascii[7];
#endif
#ifdef SYSV
	char            dir_priv_ascii[20];
#endif
	char           *buf_ptr;
	int             line_cnt, ret, i;
	int             index_value, ptr;
	int		j, k;
	int             length;

	if(first_b_r)
		{
		first_b_r = 0;
		for(j=0; j<99; j++)
			indexb[j]=0;
		}

	substr(z_date, z_mm, 1, 2);
	substr(z_date, z_dd, 4, 2);
	substr(z_date, z_yy, 7, 2);
	xmm = atol(z_mm);
	xdd = atol(z_dd);
	xyy = atol(z_yy);
	old_long_date = (xyy*10000L) + (xmm*100L) + xdd;
	while (1) {

do_again:
	strcpy(buf128, BULLETINS);

	if ((fpt = fopen(buf128, "r")) == NULL) {
		portsout("\n\r\n\rThere are no bulletins today!\n\r\n\r");
		return ;
	}
	portsout("\n\r\n\r\n\r                  *******************************\n\r");
	portsout("                  * Available Bulletins to Read *\n\r");
	portsout("                  *******************************\n\r\n\r");
	portsout("\n\r    Bulletin      Description                                      \n\r");
	portsout("    ============= ========================================== \n\r");

	line_cnt = 0;
	while (fpt) {
		zfl(f_lines[line_cnt], 81);
		if ((fgets(f_lines[line_cnt], 80, fpt)) == NULL) {
			if (line_cnt == 0) {
				portsout("\n\rEOF Unexpected in Bulletin List: Notify Sysop!\n\r");
				return;
			}
			break;	/* if not 1st line */
		}		/* end of if ((fgets)) */
		if (line_cnt > 0) {
			length = strlen(f_lines[line_cnt]);
			length -= 57;
			if(length > 6)
				length = 6;
			substr(f_lines[line_cnt], dir_priv_ascii, 57, length);
			dir_priv[line_cnt] = atoi(dir_priv_ascii);
			if (dir_priv[line_cnt] > user_priv)
				goto next_read;
			strcpy(who_am_i, f_lines[line_cnt]);
			buf_ptr = who_am_i;
			buf_ptr += 56;
			for (ptr = 0; ptr < 5; ptr++)
				*buf_ptr++ = ' ';
			*buf_ptr = '\0';
			sprintf(buf128, "%2d) %s", line_cnt, who_am_i);
			strip(buf128);
			term_space(buf128);
			portsout(buf128);
			portsout("\n\r");
		}
next_read:
		++line_cnt;
	}			/* end of while (fpt) */
	if (line_cnt <= 1)
		{
		portsout("\n\r\n\rThere are no bulletins today!\n\r\n\r");
		return;
		}
	portsout(CRLF);
	portsout(" Q) Quit --- exit bulletin section");
	portsout(CRLF);
	fclose(fpt);
	portsout(CRLF);
	strcpy(buf128,"The following bulletins are new for you since the last day you called:  ");
	j = strlen(buf128);
	portsout(buf128);
	for (index_value=1; index_value<line_cnt; index_value++)
		{
		if(dir_priv[index_value] <= user_priv)
			{
			check_new(f_lines[index_value], index_value);
			k = strlen(buf128);
			j+=k;
			if( j >= 72)
				{
				j = 0;
				portsout(CRLF);
				}
			}
		}
	portsout(CRLF);
	portsout(CRLF);
		portsout("Enter Selection ===> ");
		portsin_cmp(choice, 2, "Qq");
		portsout(CRLF);
		*choice = toupper(*choice);

		if (*choice == 'Q')
			return;


		index_value = atoi(choice);
		if (index_value > 0 && index_value < line_cnt) {
			if (dir_priv[index_value] <= user_priv) {
				parse_bul(f_lines[index_value]);
				indexb[index_value -1] = 1;
				continue;
			}
		}
	}
}





parse_bul(string)
	char           *string;
{

	register char  *file_ptr, *xptr;
	register int    i;

	strcpy(buf128, ORGPATH);
	file_ptr = (buf128 + strlen(buf128));

	i = 0;
	while (string[i] != ' ') {
		*file_ptr = string[i];
		++file_ptr;
		++i;
	}
	*file_ptr = '\0';
	cmd_p(buf128);

}
check_new(string, indexer)
	char           *string;
	int		indexer;
{
	static char *dater[]={ "Jan", "Feb", "Mar", "Apr", "May", "Jun",
		"Jul", "Aug", "Sep", "Oct", "Nov", "Dec", };
	char		timeptr[30];
	int		result, j, k;
	struct	stat stater;

	register char  *file_ptr, *xptr;
	register int    i;

	if(indexb[indexer-1])
		{
		file_ptr = buf128;
		*file_ptr = '\0';
		return;
		}

	strcpy(buf128, ORGPATH);
	file_ptr = (buf128 + strlen(buf128));

	i = 0;
	while (string[i] != ' ') {
		*file_ptr = string[i];
		++file_ptr;
		++i;
	}
	*file_ptr = '\0';
	file_ptr = buf128;
	result = stat(buf128, &stater);
	if(result)
		{
		*file_ptr='\0';
		return;
		}
	xmm = stater.st_mtime;
	strcpy(timeptr, ctime(&xmm));
	substr(timeptr, buf128, 5,3);
	substr(timeptr, z_dd, 9, 2);
	substr(timeptr, z_yy, 23,2);
	xdd = atol(z_dd);
	xyy = atol(z_yy);
	for ( result =0; result < 12; result++)
		{
		i = strcmp(buf128, dater[result]);
		if(!i)
			{
			xmm = (long) result +1;
			new_long_date = (xyy*10000L) + (xmm*100L) + xdd;
			if(new_long_date >= old_long_date)
				{
				itoa(buf128, indexer);
				strcat(buf128, ", ");
				portsout(buf128);
				}
			else
				 *file_ptr='\0';
			return;
			}
		}
		*file_ptr='\0';
}
