/* user file definition, release 1.10 */

#define ACTIVE		0	/*  normal user status */
#define DELETED		1	/*  user deleted, next compress will remove it */
#define PRECIOUS	2	/*  precious user, never delete him!! */
#define INCOMPLETE	3	/*  login procedure have not been completed */
#define BADUSER		4	/*  bad user, show BADUSERMSG & disconnect 
							(is also a PRECIOUS USER) */
#define TRUSTED		5	/*  trusted user, with special permissions 
							(e.g. skips *all* welcome screens)
							(is also a PRECIOUS USER) */
#define MAX_U_STATUS	5

struct Index {
	char	 name[64];
	unsigned short idx;
};

struct Flags {
	unsigned char	ansi;				/* use cursor positioning */
	unsigned char	color;				/* use colors */
	unsigned char	cls;				/* clear screen */
	unsigned char	fsced;				/* use full screen editor */
	unsigned char	help;				/* 0 = no help */
	unsigned char	more;				/* more prompt */
	unsigned char	scrsize;			/* lines / screen */
	unsigned char	disturb;			/* 0 = yes  1 = no */
	char			free[8];			/* free */
};

struct User {
	char 			fname[32];			/* first name */
	char 			lname[32];			/* last name */
	char			password[16];
	char			city[32];
	char			phone_ac[8];		/* phone area code */
	char			phone_no[16];		/* phone number */
	char			login_date[7];		/* date of first login mmddyy */
	unsigned char	runtime_tag;		/* run-time status flag for page */
	char			last_called[7];		/* date of last login mmddyy */
	unsigned char	status;				/* status flag; see defines above */
	unsigned short	last_time;			/* time of last call (minutes) */
	unsigned short	access_level;		/* access level 0-65535 */
	unsigned short	caller_no;			/* caller index number */
	unsigned short	total_calls;		/* total calls since first login */
	unsigned long	total_dl;			/* total Kbytes downloaded */
	unsigned long	total_ul;			/* total Kbytes uploaded */
	unsigned long	today_dl;			/* total bytes downloaded today */
	unsigned short	today_online;		/* total minutes online today */
	unsigned short	today_calls;		/* total calls today */
	char			last_ng[64];		/* last newsgroup visited */
	unsigned short	last_area;			/* last file area visited */
	unsigned short	total_posted;		/* total # of messages posted */
	unsigned short	time_table[24];		/* calls distrib on 24h */
	struct Flags	flags;				/* see structure */
	unsigned short	access_flags;		/* access flags mask (16 bits) */
	unsigned short	countdown;			/* minutes left before account
											will expire. 65535 = INFINITE */
	unsigned short	time_left;			/* minutes left this call, for extrn */
	unsigned char	free[26];   		/* free bytes */
};

struct Header {
	unsigned short	users;				/* total callers in file */
	unsigned long	size;				/* size of user file in bytes */
	unsigned long	total_calls;		/* total calls since the date below */
	char			last_update[14];	/* date/time of last update */
};

