/* pbm2gpr.c - convert pbm to 1-plane apollo GPR bitmap
** note that we can't write bitmap to standard output -- 
** you must supply name of bitmap with -o option.
**
** Copyright (C) 1989 by Tim Lambert (lambert@spectrum.eecs.unsw.oz)
**
** based on original program
** Copyright (C) 1988 by Jef Poskanzer.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software is provided "as is" without express or
** implied warranty.
*/
#include <stdio.h>
#ifdef	OS_SYSV
#include <string.h>
#else	OS_SYSV
#include <strings.h>
#endif	OS_SYSV

#include <apollo/base.h>
#include <apollo/gpr.h>
#include <apollo/pad.h>
#include <apollo/pfm.h>
#include <apollo/time.h>
#include <apollo/error.h>
#include "pbm.h"
#define   one_second  250000
#define   ten_seconds 10 * one_second


status_$t                      status;

/***********************************************************************/
check(void)
{
      if (status.all != status_$ok)  
      {   pfm_$error_trap(status);
      }
}
/***********************************************************************/

copyit(bits, cols, rows, bmffilename )
bit **bits;
int cols, rows;
char *bmffilename;

{
gpr_$attribute_desc_t          attribs;
gpr_$bitmap_desc_t             mem_bm;
gpr_$bitmap_desc_t             disk_bm;
gpr_$offset_t                  dim;
gpr_$position_t                base;
gpr_$position_t                dest;
gpr_$window_t                  scanline;
gpr_$window_t                  window;
short                          row,col;
gpr_$rgb_plane_t               hi_plane = (short)0;
time_$clock_t                  time_to_wait;
short int                      name_len;
short                          groups = (short)1;
gpr_$version_t                 version;
gpr_$bmf_group_header_array_t  header;
boolean                        created;
char                           *pstr;
linteger             pixel_array[2000];

    time_to_wait.high16 = (short)0;
    time_to_wait.low32 = ten_seconds;


    dim.x_size = (short)cols;
    dim.y_size = (short)rows;
    base.x_coord = (short)0;
    base.y_coord = (short)0;
    window.window_base = base;
    window.window_size = dim;

    gpr_$init(gpr_$no_display,0,dim,hi_plane,&mem_bm,&status) ;
    check();

   scanline = window;
   scanline.window_size.y_size = (short)1;
   for (row=0; row <rows; row++)
      {for (col=0; col <cols; col++)
          {pixel_array[col] = (gpr_$pixel_value_t) bits[row][col];
          }
      scanline.window_base.y_coord = row;
      gpr_$write_pixels((gpr_$pixel_value_t *)pixel_array,scanline,&status);          
      }


   name_len = 1; for (pstr = bmffilename; *++pstr; name_len++); /*pathname_len*/
   version.gpr_$major =  1;   version.gpr_$minor =  1;                      /*version*/
   header[0].n_sects         = (short)1;
   header[0].pixel_size      = (short)1;
   header[0].allocated_size  = (short)0;
   header[0].bytes_per_line  = (short)0;
   header[0].bytes_per_sect  = (long)0;
   header[0].storage_offset  = (char *)0;

   gpr_$allocate_attribute_block(&attribs,&status);
   gpr_$open_bitmap_file(gpr_$create,
                         bmffilename,
                         name_len,
                         &version,
                         &dim,
                         &groups,
                         header,
                         attribs,
                         &disk_bm,
                         &created,
                         &status); 
   check();
    gpr_$set_bitmap(disk_bm, &status);
    gpr_$pixel_blt(mem_bm,window,base,&status);
    check();
/*    gpr_$release_display(&status);*/

/*    time_$wait (time_$relative, time_to_wait, &status);*/
    gpr_$terminate(false, &status);

}

main( argc, argv )
int argc;
char *argv[];
    {
    FILE *ifd;
    bit **bits;
    char *bmffilename;
    int argn, rows, cols, padright, row, col;
    char ch;
    char name[100], *cp;
    char *usage = "usage:  %s [-o bmffile] [pbmfile]\n";

    argn = 1;

    /* Check for flags. */
    if ( argn < argc )
	{
	if ( argv[argn][0] == '-' )
	    {
	    if ( ( argv[argn][1] == 'o' || argv[argn][1] == 'O' ) &&
		 argv[argn][2] == '\0' )
		{
		argn++;
		if ( argn == argc )
		    {
		    fprintf( stderr, usage, argv[0] );
		    exit( 1 );
		    }
		bmffilename = argv[argn];
		argn++;
		}
	    else
		{
		fprintf( stderr, usage, argv[0] );
		exit( 1 );
		}
	    }
	}

    if ( argn == argc )
	{
	ifd = stdin;
	strcpy( name, "noname" );
	}
    else
	{
        ifd = fopen( argv[argn], "r" );
        if ( ifd == NULL )
	    {
	    fprintf( stderr, "%s: can't open.\n", argv[argn] );
	    exit( 1 );
	    }
	strcpy( name, argv[argn] );

#ifdef	OS_SYSV
	if ( ( cp = strchr( name, '.' ) ) != 0 )
#else	OS_SYSV
	if ( ( cp = index( name, '.' ) ) != 0 )
#endif	OS_SYSV
	    *cp = '\0';
	argn++;
	}

    if ( argn != argc )
	{
	fprintf( stderr, usage, argv[0] );
	exit( 1 );
	}

    bits = pbm_readpbm( ifd, &cols, &rows );

    if ( ifd != stdin )
	fclose( ifd );
    copyit(bits,cols,rows,bmffilename);
    exit( 0 );
    }


