/* gpr2pbm.c - convert 1-plane apollo GPR bitmap to pbm
** note that we can't read from standard input -- you must supply name of bitmap
**
** Copyright (C) 1989 by Tim Lambert (lambert@spectrum.eecs.unsw.oz)
**
** based on original program
** Copyright (C) 1988 by Jef Poskanzer.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software is provided "as is" without express or
** implied warranty.
*/
#include <stdio.h>
#ifdef	OS_SYSV
#include <string.h>
#else	OS_SYSV
#include <strings.h>
#endif	OS_SYSV

#include <apollo/base.h>
#include <apollo/gpr.h>
#include <apollo/pad.h>
#include <apollo/pfm.h>
#include <apollo/time.h>
#include <apollo/error.h>
#include "pbm.h"


status_$t                      status;

/***********************************************************************/
check(void)
{
      if (status.all != status_$ok)  
      {   pfm_$error_trap(status);
      }
}
/***********************************************************************/

topbm(bmffilename )
char *bmffilename;

{
bit **bits;
int cols, rows;
gpr_$attribute_desc_t          attribs;
gpr_$bitmap_desc_t             junk;
gpr_$bitmap_desc_t             mem_bm;
gpr_$bitmap_desc_t             disk_bm;
gpr_$offset_t                  dim;
gpr_$position_t                base;
gpr_$position_t                dest;
gpr_$window_t                  scanline;
gpr_$window_t                  window;
short                          row,col;
gpr_$rgb_plane_t               hi_plane = (short)0;
short int                      name_len;
short                          groups = (short)1;
gpr_$version_t                 version;
gpr_$bmf_group_header_array_t  header;
boolean                        created;
char                           *pstr;
linteger             pixel_array[2000];



    dim.x_size = (short)1;
    dim.y_size = (short)1;
    base.x_coord = (short)0;
    base.y_coord = (short)0;
    window.window_base = base;

    gpr_$init(gpr_$no_display,0,dim,hi_plane,&junk,&status) ;
    check();

   name_len = 1; for (pstr = bmffilename; *++pstr; name_len++); /*pathname_len*/
   version.gpr_$major =  1;   version.gpr_$minor =  1;                      /*version*/
   header[0].n_sects         = (short)1;
   header[0].pixel_size      = (short)1;
   header[0].allocated_size  = (short)0;
   header[0].bytes_per_line  = (short)0;
   header[0].bytes_per_sect  = (long)0;
   header[0].storage_offset  = (char *)0;

   gpr_$allocate_attribute_block(&attribs,&status);
   gpr_$open_bitmap_file(gpr_$readonly,
                         bmffilename,
                         name_len,
                         &version,
                         &dim,
                         &groups,
                         header,
                         attribs,
                         &disk_bm,
                         &created,
                         &status); 
   check();
   gpr_$inq_bitmap_dimensions(disk_bm,&dim,&hi_plane,&status);
   cols = (int) dim.x_size ;
   rows = (int) dim.y_size ;
   window.window_size = dim;

    gpr_$allocate_bitmap(dim,(gpr_$rgb_plane_t)1,attribs,&mem_bm,&status);
    gpr_$set_bitmap(mem_bm, &status);
    /* we just do plane 0 of the bitmap */
    gpr_$bit_blt(disk_bm,window,(gpr_$rgb_plane_t)0,base,(gpr_$rgb_plane_t)0,&status);
    check();

   bits = pbm_allocarray( cols, rows );
   scanline = window;
   scanline.window_size.y_size = (short)1;
   for (row=0; row <rows; row++){
      scanline.window_base.y_coord = row;
      gpr_$read_pixels(scanline,(gpr_$pixel_value_t *)pixel_array,&status); check();
      for (col=0; col <cols; col++){
          bits[row][col] = (bit) pixel_array[col];
          }
      }

    pbm_writepbm( stdout, bits, cols, rows );

    gpr_$terminate(false, &status);

}

main( argc, argv )
int argc;
char *argv[];
    {
    if ( argc != 2 )
	{
	fprintf( stderr, "usage: %s bmfile\n", argv[0] );
	exit( 1 );
	}

    topbm(argv[1]);

    exit( 0 );
    }

