/*
 *  This is unreleased software and Apollo accepts no responsibility for
 *  any problems that might arise from its use.
 */
   
/*
 *   This program will copy a color bitmap file to a black and white gmf file
 *   which can be printed on a black and white printer.  Currently the bitmap will be displayed
 *   on the screen prior to creating the gmf file, to convert the file without displaying  change
 *   the mode from gpr_$borrow to gpr_$no_display.

     This will not run on magma (590T) nodes in true color.   

     This program is currently set up to copy an image that has a black background (color index 0)
     to change this, change the 'bg_color' variable to the background index of the image to be
     converted.
     Example:  if background color of image is red and default colors are being used, change
               bg_color to 1.
 */
                   
#include <apollo/base.h>
#include <apollo/gpr.h>
#include <apollo/error.h>
#include <apollo/pfm.h>
#include <apollo/gmf.h>


gpr_$pixel_value_t  bg_color = 0;                  /* index of background color */

gpr_$window_t       window;
gpr_$plane_t        hi_plane;
short int           groups = 1;
gpr_$bitmap_desc_t  init_bitmap;
status_$t           status;
boolean             unobs;         
boolean             created;
gpr_$bitmap_desc_t  main_mem;                          
gpr_$bitmap_desc_t  filebm;
gpr_$rgb_plane_t    plane;
gpr_$position_t     dest_corner = {0,0};
char                *storage_ptr;
ios_$id_t           gmf_stream_id;
short int           storage_line_width;
gpr_$version_t      version;
gpr_$disp_char_t    disp_buff;
short               buff_len;                                  
short               x_dim,y_dim; 
gpr_$mask_32_t       plane_mask;   

gpr_$bmf_group_header_array_t header;
gpr_$attribute_desc_t ablk, attribs;

main( argc, argv )
int argc;
char *argv[];
{   
    plane_mask = 255;
if( (argc == 2) || (argc == 3) ) {
   printf("\nGPR to GMF file conversion utility.\n");
   printf("This is unreleased software and Apollo accepts no responsibility for\nany problems that might arise from its use.\n");
   sleep(5);
 
   gpr_$inq_disp_characteristics(gpr_$borrow,1,sizeof(disp_buff),&disp_buff,&buff_len,&status); 
     check(status);
   hi_plane = disp_buff.n_planes - 1;
   window.window_size.x_size = disp_buff.x_visible_size;
   window.window_size.y_size = disp_buff.y_visible_size;

   gpr_$init(gpr_$borrow,1,window.window_size,hi_plane,&init_bitmap,&status);
   check(status);
   unobs = gpr_$acquire_display(&status);
   check(status);
   gpr_$allocate_attribute_block(&attribs,&status);
   check(status);
   gpr_$open_bitmap_file(gpr_$readonly, argv[1], (short)strlen(argv[1]),&version,
       &window.window_size,&groups,header,attribs,&filebm,&created,&status);
   check(status);

/* transfer the image to the screen */
/* NOTE: THE FOLLOWING LINES FOR GPR_$PIXEL_BLT AND GPR_$RELEASE_DISPLAY 
  CAN BE DELETED IF THIS PROGRAM IS RUN IN GPR_$NO_DISPLAY MODE  */

   gpr_$pixel_blt(filebm,window,dest_corner,&status);
   check(status);
   gpr_$release_display(&status);

/* allocate main memory bitmap to copy data from all planes of display bitmap */

   gpr_$allocate_attribute_block(&ablk,&status);
    check(status);  
   gpr_$allocate_bitmap(window.window_size,hi_plane,ablk,&main_mem,&status);
    check(status);  
   gpr_$set_bitmap(main_mem,&status);
    check(status);  
   gpr_$clear(bg_color,&status);
    check(status);          

/* this command 'gpr_$set_raster_op_mask' is new at 9.7 */

   gpr_$set_raster_op_mask(plane_mask,gpr_$rop_src_xor_dst,&status);
   check(status);    
                           
/* This pixel blt with 'xor' raster op will change background color to index 0
   so that the printed image will be correct  */

   gpr_$pixel_blt(filebm,window,dest_corner,&status);
   check(status);

   gpr_$set_raster_op_mask(plane_mask,gpr_$rop_src_or_dst,&status);
   check(status);    

/* loop to copy displayed data from high planes to plane 0 */
   for( plane = 0; plane <= hi_plane; plane++ )
     {  
      gpr_$bit_blt(main_mem,window,plane,dest_corner,0,&status);
      check(status);  
     }

   if( argc == 2 )
     gmf_$open("gmf_plot",8,gmf_$overwrite, &gmf_stream_id,&status);
   else
     gmf_$open(argv[2],(short)strlen(argv[2]),gmf_$overwrite, &gmf_stream_id,&status);

   gpr_$inq_bitmap_pointer(main_mem,&storage_ptr, &storage_line_width,&status);
   check(status);                     
   x_dim = window.window_size.x_size;
   y_dim = window.window_size.y_size;
   gmf_$copy_plane(gmf_stream_id,true,0,storage_ptr,x_dim,y_dim,storage_line_width,&status);
   check(status);
   gmf_$close(gmf_stream_id,&status);
   check(status);
   gpr_$release_display(&status);
   gpr_$terminate(false,&status);
   if( argc == 2)
     printf("Conversion complete.  File GMF_PLOT created.\n");
   else
     printf("Conversion complete.  File %s created.\n", argv[2] );
 }
else
   printf("Invalid number of arguments to gpr_to_gmf program.\n");
}                                      



/***************************************************************************/
check(status)
status_$t status;
{ 
  if(status.all != status_$ok) pfm_$error_trap(status);
}
