/*
  Modified on 27-Sep-87 by Leonard N. Zubkoff:
    Do not draw borders on APOLLO.
*/

#include "header.h"
#include "genwindow.h"
#include <sys/types.h>
#include <sys/stat.h>
char *malloc();
void shownextpage();
void open_dvi_file ();

void CloseDvi (dviw)
     DVIW dviw;
{
  close_fonts ();
  fclose (dviw -> dvifp);
  free (dviw -> filename);
  free (dviw);
};

DVIW OpenDvi (filename)
     char *filename;
{
  return (ReOpenDvi (NULL, filename));
}

/* This takes dviw by reference because it will change dviw if the dvi */
 /* file has been modified since it was opened.  This tends to prevent */
 /* horrible things from happening when you use latex to regenerate a */
 /* file you are displaying. */
int ShowDviPage (dviw, pagenum, xscreen, yscreen)
     DVIW *dviw;
     int pagenum;
     int xscreen;
     int yscreen;
{
  if (modtime ((*dviw)->filename) != (*dviw) -> modtime) {
    /* The file has been modified since last opened. */
    char *filetmp = malloc (strlen ((*dviw) -> filename) + 1);

    strcpy (filetmp, (*dviw) -> filename);
    *dviw = ReOpenDvi (*dviw, filetmp);
    free (filetmp);
    showerror ("Your file changed.");
  } else {
    clearerror ();
  };
  if (pagenum > (*dviw) -> pages) {
    pagenum = (*dviw) -> pages;
  } else if (pagenum <= 0) {
    pagenum = 1;
  };
  clearscreen ();
  lock_canvas ();
#ifndef apollo
  /* if borders are used on the apollo system then the text page
     does not get popperly aligned.
     The borders are shown, instead of the compelete text.
   */
  draw_borders ();
#endif
  if (pagenum == (*dviw) -> pagenum) {
    check (fseek ((*dviw) -> dvifp, (*dviw) -> cpagep, 0));
    shownextpage (*dviw, xscreen, yscreen);
  } else if (pagenum == ((*dviw) -> pagenum + 1)) {
    shownextpage (*dviw, xscreen, yscreen);
  } else if (pagenum > ((*dviw) -> pagenum)) {
    showpage (&((*dviw) -> cpagep), &((*dviw) -> ppagep), TRUE,
	      pagenum - ((*dviw) -> pagenum),
	      FALSE, (*dviw) -> dvifp, xscreen, yscreen);
    (*dviw) -> pagenum = pagenum + 1;
  } else if (pagenum < ((*dviw) -> pagenum)) {
    while ((pagenum < ((*dviw) -> pagenum)--) && (*dviw) -> ppagep != -1) {
      /* Each iteration here backs up a page. */
      check (fseek((*dviw) -> dvifp, (*dviw) -> ppagep, 0));
      Nosignextend((*dviw) -> dvifp, 1);
      {
	int i;
	for(i=0; i<=9; i++)
	  Nosignextend((*dviw) -> dvifp, 4);
      }
      (*dviw) -> cpagep = (*dviw) -> ppagep;
      (*dviw) -> ppagep = Nosignextend ((*dviw) -> dvifp, 4);
    }
    check(fseek((*dviw)->dvifp,(*dviw)->cpagep,0));
    shownextpage (*dviw, xscreen, yscreen);
  } else {
    fprintf (stderr, "Terminal confusion in ShowDviPage.\n");
    exit (1);
  };
  unlock_canvas ();
  (*dviw) -> pagenum = pagenum;
  return (pagenum);
}

void shownextpage (dviw, xscreen, yscreen)
     DVIW dviw;
     int xscreen, yscreen;
{
    showpage (&(dviw -> cpagep), &(dviw -> ppagep), FALSE, 0, FALSE,
	      dviw -> dvifp, xscreen, yscreen);
}  
     
/* Open a dvi file for input and display the first page.  If
   something goes wrong, display an error and leave the current file
   unaffected. Historical potential bug:  After this routine is
   called, the first page displayed may have to be the first page in
   the document.*/ 
DVIW ReOpenDvi (olddvi, filename)
     DVIW olddvi;
     char *filename;
{
  FILE *newfp;
  DVIW newdvi;

  preload = TRUE;
   /* We have to explictly test for an empty file name here because of */
  /* a Sun stdio bug. */
  if ((*filename == '\0') || (newfp=fopen(filename,"r")) == NULL)  {
    showerror ("Can't open your file.");
    return (olddvi);
  } else if ((Nosignextend(newfp, 1)) != PRE)  {
    showerror ("Not a DVI file.");
    fclose (newfp);
    return (olddvi);
  } else if (signextend (newfp, 1) != DVIFORMAT) {
    showerror ("Wrong DVI file format.");
    fclose (newfp);
    return (olddvi);
  } else {
    clearerror ();
    if (olddvi != NULL) CloseDvi (olddvi);
    newdvi = NEWDVIW;
    newdvi -> filename = malloc (strlen (filename) + 1);
    strcpy (newdvi -> filename, filename);
    newdvi -> modtime = modtime (filename);
    newdvi -> dvifp = newfp;
    newdvi -> pages = start_reading_dvi_file (newdvi -> dvifp);
    newdvi -> pagenum = 0;
    newdvi -> cpagep = -1;
    newdvi -> ppagep = -1;
    return (newdvi);
  }
}

int modtime (filename)
     char *filename;
{
  struct stat buf;
  check (stat (filename, &buf));
  return (buf.st_mtime);
}
