/*
 ******************************************************************************
 *
 *	ParcPlace Systems, Inc.
 *	Copyright (c) 1990, ParcPlace Systems, Inc. USA   All rights reserved.
 *
 ****************************************************************************
 *
 *	File:	lmtree.H
 *
 *	Functions(s):
 *
 *	Description:
 *		OI_layout_tree_* class header
 *		Adapted from "Drawing Dynamic Trees, Sven Moen, Brown University, IEEE Software, July 1990
 *
 *	RCSid = "$Id: lmtree.H,v 4.26.1.1 1993/06/01 22:55:20 mth Exp $"
 *
 ****************************************************************************
 */

#ifndef OI_lmtree_H
#define OI_lmtree_H

#ifndef OI_layout_H
#include <OI/layout.H>
#endif /* OI_layout_H */

		class	OI_lm_polyline ;
		class	OI_lm_polygon ;
		class	OI_lm_boundary ;
		class	OI_lm_tree_node ;
		class	OI_lm_tree ;

/* ctl_bits */
#define	OI_LM_TREE_CONNECTOR		0x1		/* 1 => should have connectors between nodes */
#define	OI_LM_TREE_CONNECTORS_PRESENT	0x2		/* 1 => connectors between nodes have not been removed */

		class	OI_lm_tree : public OI_layout_method	{				/* tree layout method */
			unsigned long		ctl_bits ;					/* control bits */
		 public:
		static	OI_class		*clsp ;						/* ptr to class object for this layout method */
		 private:
			OI_bool			connectors_present() const ;
		 protected:
			OI_lm_tree_node		*next_node(const OI_lm_tree_node*) const ;
			OI_lm_tree_node		*pseudo_root() const ;				/* ptr to empty actual root to allow multiple roots */
		 public:
		//-------------------------------------------------------------------------------------------------		
		//		
		//	RESTRICTED MEMBER FUNCTIONS
		//		Functions in this section are not documented in the programmer's manual and are
		//		restricted to internal use by the toolkit.
		//		Functions not contained in user documentation are subject to change without notice
		//		and should never be used by toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
						OI_lm_tree(OI_d_tech*,OI_lm_tree_node*) ;
		virtual				~OI_lm_tree() ;
			void			allow_connectors() ;
		virtual	OI_d_tech		*connector(OI_d_tech*,OI_d_tech*) const ;
			OI_bool			is_connectors() const ;
			void			disallow_connectors() ;
			void			find_parent_sibling(long,long,OI_number,const OI_lm_tree_node**,const OI_lm_tree_node**) const ;
			void			insert_node(OI_lm_tree_node*, OI_d_tech*, OI_d_tech*) ;
		virtual	OI_lm_tree_node		*make_node(OI_d_tech*) = 0 ;
			OI_lm_tree_node		*root() const ;
			void			set_root(OI_lm_tree_node *p) ;
			void			update_connectors() ;
		//-------------------------------------------------------------------------------------------------		
		//		
		//	OVERRIDES OF DOCUMENTED PARENT MEMBER FUNCTIONS	
		//		Functions in this section are documented in the programmer's manual under the
		//		parent(s) of this object and are also available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
		virtual	OI_class		*class_object() const ;
		virtual	OI_lm_convert_geometry	*conversion_specifications(const OI_layout_method*) const ;
		virtual	void			convert_xy_to_geometry(OI_d_tech*,long,long,OI_number,void**,OI_bool*,void**,OI_bool*) const ;
		virtual	OI_bool			exact_conversion(OI_class*) const ;
		virtual	void			force_layout() ;
		virtual	OI_bool			geometry(OI_d_tech*,void**,OI_bool*,void**,OI_bool*) const ;
		virtual	OI_bool			geometry_match(OI_d_tech*,void*,void*) const ;
		virtual	char*			geometry_to_string(OI_d_tech*)const ;
		virtual	void			insert(OI_d_tech*,void*,void*) ;
		virtual	void			min_outside_size(OI_number,OI_number,OI_number*,OI_number*) const ;
		virtual	void			move(OI_d_tech*,void*,void*) ;
		virtual	void			new_default_space() ;
		virtual	OI_d_tech		*next_object(OI_d_tech*) const ;
		virtual	OI_d_tech		*previous_object(OI_d_tech*) const ;
		virtual	void			re_layout() ;
		virtual	void			remove(OI_d_tech *) ;
		virtual	void			size_change() ;
		virtual	void			slot_size_change(OI_d_tech*) ;
		virtual	void			space_change(OI_d_tech*) ;
		virtual	OI_bool			string_to_geometry(const char*,void**,OI_bool*,void**,OI_bool*)const ;	/* get slot layout geometry */
		virtual	OI_layout		type() const = 0 ;
		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED MEMBER FUNCTIONS	
		//		Functions below this point are documented in the programmer's manual under this
		//		object and are available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
			OI_d_tech		*parent_node(OI_d_tech *op) const ;		/* get ptr to parent in tree */
			OI_d_tech		*root_node() const ;				/* get ptr to root */
			OI_d_tech		*sibling_node(OI_d_tech *op) const ;		/* get ptr to next sibling in tree */
		} ;

		class	OI_lm_horz_tree : public OI_lm_tree	{				/* horizontal tree layout method */
		 public:
		static	OI_class		*clsp ;						/* ptr to class object for this layout method */
		 private:
		 protected:
		 public:
		//-------------------------------------------------------------------------------------------------		
		//		
		//	RESTRICTED MEMBER FUNCTIONS
		//		Functions in this section are not documented in the programmer's manual and are
		//		restricted to internal use by the toolkit.
		//		Functions not contained in user documentation are subject to change without notice
		//		and should never be used by toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
						OI_lm_horz_tree(OI_d_tech *dtp) ;
		virtual				~OI_lm_horz_tree() ;
		static	OI_layout_method	*make_minimal(OI_d_tech*,OI_minimal_type) ;
		virtual	OI_lm_tree_node		*make_node(OI_d_tech*) ;
		virtual	void			nominal_size(OI_number*,OI_number*) const ;
		//-------------------------------------------------------------------------------------------------		
		//		
		//	OVERRIDES OF DOCUMENTED PARENT MEMBER FUNCTIONS	
		//		Functions in this section are documented in the programmer's manual under the
		//		parent(s) of this object and are also available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
		virtual	OI_class		*class_object() const ;
		virtual	OI_layout		type() const ;
		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED MEMBER FUNCTIONS	
		//		Functions below this point are documented in the programmer's manual under this
		//		object and are available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
		} ;

		class	OI_lm_vert_tree : public OI_lm_tree	{				/* vertical tree layout method */
		 public:
		static	OI_class		*clsp ;						/* ptr to class object for this layout method */
		 private:
		 protected:
		 public:
		//-------------------------------------------------------------------------------------------------		
		//		
		//	RESTRICTED MEMBER FUNCTIONS
		//		Functions in this section are not documented in the programmer's manual and are
		//		restricted to internal use by the toolkit.
		//		Functions not contained in user documentation are subject to change without notice
		//		and should never be used by toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
						OI_lm_vert_tree(OI_d_tech *dtp) ;
		virtual				~OI_lm_vert_tree() ;
		virtual	OI_lm_tree_node		*make_node(OI_d_tech*) ;
		virtual	void			nominal_size(OI_number*,OI_number*) const ;
		//-------------------------------------------------------------------------------------------------		
		//		
		//	OVERRIDES OF DOCUMENTED PARENT MEMBER FUNCTIONS	
		//		Functions in this section are documented in the programmer's manual under the
		//		parent(s) of this object and are also available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
		virtual	OI_class		*class_object() const ;
		virtual	OI_layout		type() const ;
		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED MEMBER FUNCTIONS	
		//		Functions below this point are documented in the programmer's manual under this
		//		object and are available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
		static	OI_layout_method	*make_minimal(OI_d_tech*,OI_minimal_type) ;
		} ;

#endif /* OI_lmtree_H */
