/*
 ******************************************************************************
 *
 *	ParcPlace Systems, Inc.
 *	Copyright (c) 1990, ParcPlace Systems, Inc. USA   All rights reserved.
 *
 ****************************************************************************
 *
 *	File:	grip.H
 *
 *	Functions(s):
 *
 *	Description:
 *		OI_grip class header
 *
 *	RCSid = "$Id: grip.H,v 1.6.1.1 1993/06/01 22:54:43 mth Exp $"
 *
 ****************************************************************************
 */

#ifndef OI_grip_H
#define OI_grip_H

#ifndef OI_box_H
#include <OI/box.H>
#endif /* OI_box_H */

#define	OI_GRIP_DEFAULT_WIDTH	5
#define	OI_GRIP_DEFAULT_HEIGHT	5

class	OI_grip;

	typedef	void	(*OI_grip_fnp)(OI_grip*, void*, long, long);			/* grip moved callback function */
	typedef	void	(OI_callback::*OI_grip_memfnp)(OI_grip*, void*, long, long);	/* grip moved callback member function */

class	OI_grip : public OI_box {
			OI_origin		_start_pos;		/* Start button press event position. */
	protected:
		static	XrmQuark		q_cbGripMoved;		/* callback quark */
		static	XrmQuark		q_cbGripStart;		/* callback quark */
		static	XrmQuark		q_cbGripStop;		/* callback quark */
	public:
		static	OI_class		*clsp;			/* ptr to class record */

	private:
			void			construct();
	protected:
						OI_grip(OI_class*, const char*, OI_number, OI_number);
	public:
		//-------------------------------------------------------------------------------------------------
		//		
		//	RESTRICTED MEMBER FUNCTIONS
		//		Functions in this section are not documented in the programmer's manual and are
		//		restricted to internal use by the toolkit.
		//		Functions not contained in user documentation are subject to change without notice
		//		and should never be used by toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------
						OI_grip(const char*, OI_number, OI_number);
						~OI_grip();
			void			clone_adjust(OI_d_tech*);
			void			delta_from_start(long*, long*, XEvent*);
		static	OI_bool			init(class OI_connection*) ;
			void			set_start_pos(long x, long y)	{ _start_pos.x = x; _start_pos.y = y; }
			OI_origin		*start_pos()			{return (&_start_pos);}
			long			start_pos_x()			{return (_start_pos.x);}
			long			start_pos_y()			{return (_start_pos.y);}
		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED TRANSLATIONS FUNCTIONS	
		//		Functions below this point are documented in the programmer's manual under the
		//		translations available for this object and are available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
			void			drag(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void			press(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void			release(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED MEMBER FUNCTIONS	
		//		Functions below this point are documented in the programmer's manual under this
		//		object and are available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
			void			set_moved(OI_grip_fnp fp, void *argp=NULL);
			void			set_moved(OI_callback *objp, OI_grip_memfnp mfp, void *argp=NULL);
			void			set_start(OI_grip_fnp fp, void * = NULL);
			void			set_start(OI_callback *, OI_grip_memfnp mfp, void *argp = NULL);
			void			set_stop(OI_grip_fnp fp, void * = NULL);
			void			set_stop(OI_callback *, OI_grip_memfnp mfp, void *argp = NULL);
};

#endif /* OI_grip_H */
