/* GNU Mailutils -- a suite of utilities for electronic mail
   Copyright (C) 1999, 2001, 2004 Free Software Foundation, Inc.

   GNU Mailutils is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   GNU Mailutils is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GNU Mailutils; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA  */

#include "imap4d.h"

/*
 */

/* The CLOSE command permanently removes from the currently selected
   mailbox all messages that have the \\Deleted flag set, and returns
   to authenticated state from selected state.  */
int
imap4d_close (struct imap4d_command *command, char *arg ARG_UNUSED)
{
  const char *msg = NULL;
  int status = mailbox_flush (mbox, 1);
  if (status)
    {
      syslog (LOG_ERR, _("flushing mailbox failed: %s"), mu_strerror (status));
      msg = "flushing mailbox failed";
    }
  
  /* No messages are removed, and no error is given, if the mailbox is
     selected by an EXAMINE command or is otherwise selected read-only.  */
  status = mailbox_close (mbox);
  if (status)
    {
      syslog (LOG_ERR, _("closing mailbox failed: %s"), mu_strerror (status));
      msg = "closing mailbox failed";
    }
  mailbox_destroy (&mbox);

  if (msg)
    util_finish (command, RESP_NO, msg);
  return util_finish (command, RESP_OK, "Completed");
}
