/*
 * Blackfin testcase for testing illegal/legal 64-bit opcodes (group 1)
 * from userspace.  we track all instructions which cause some sort of
 * exception when run from userspace, this is normally EXCAUSE :
 *  - 0x22 : illegal instruction combination
 * and walk every instruction from 0x0000 to 0xffff
 */

# mach: bfin
# sim: --environment operating

#include "test.h"
	.include "testutils.inc"

#define SE_ALL_BITS 16
#include "se_allopcodes.h"

.macro se_all_load_insn
	R2 = W[P5 + 4];
	R0 = R2;
.endm

.macro se_all_next_insn
	/* increment, and go again. */
	R0 = R2;

	R0 += 1;
	/* finish once we hit the 32bit limit */
	imm32 R1, 0x10000;
	CC = R1 == R0;
	IF CC JUMP pass_lvl;

	W[P5 + 4] = R0;
.endm

.macro se_all_insn_init
	MNOP || NOP || NOP;
.endm
.macro se_all_insn_table
	/* this table must be sorted, and end with zero */
	/* start	end		SEQSTAT */
	.dw 0x0001,	0x7fff,		0x22
	.dw 0x9040,	0x9040,		0x22
	.dw 0x9049,	0x9049,		0x22
	.dw 0x9052,	0x9052,		0x22
	.dw 0x905b,	0x905b,		0x22
	.dw 0x9064,	0x9064,		0x22
	.dw 0x906d,	0x906d,		0x22
	.dw 0x9076,	0x9076,		0x22
	.dw 0x907f,	0x907f,		0x22
	.dw 0x90c0,	0x90c0,		0x22
	.dw 0x90c9,	0x90c9,		0x22
	.dw 0x90d2,	0x90d2,		0x22
	.dw 0x90db,	0x90db,		0x22
	.dw 0x90e4,	0x90e4,		0x22
	.dw 0x90ed,	0x90ed,		0x22
	.dw 0x90f6,	0x90f6,		0x22
	.dw 0x90ff,	0x90ff,		0x22
	.dw 0x9180,	0x91ff,		0x22
	.dw 0x9380,	0x93ff,		0x22
	.dw 0x9580,	0x95ff,		0x22
	.dw 0x9640,	0x967f,		0x22
	.dw 0x96c0,	0x96ff,		0x22
	.dw 0x9740,	0x97ff,		0x22
	.dw 0x9980,	0x99ff,		0x22
	.dw 0x9a40,	0x9a7f,		0x22
	.dw 0x9ac0,	0x9aff,		0x22
	.dw 0x9b40,	0x9bff,		0x22
	.dw 0x9c60,	0x9c7f,		0x22
	.dw 0x9ce0,	0x9cff,		0x22
	.dw 0x9d60,	0x9d7f,		0x22
	.dw 0x9ef0,	0x9eff,		0x22
	.dw 0x9f70,	0x9f7f,		0x22
	.dw 0xc000,	0xffff,		0x22
	.dw 0x0000,	0x0000,		0x00
.endm

	se_all_test
