/* InitialLdapContext.java --
   Copyright (C) 2001 Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


package javax.naming.ldap;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.naming.NotContextException;
import javax.naming.directory.InitialDirContext;

/**
 * @author Tom Tromey <tromey@redhat.com>
 * @date June 21, 2001
 */
public class InitialLdapContext
  extends InitialDirContext
  implements LdapContext
{
  public InitialLdapContext ()
    throws NamingException
  {
    this (null, null);
  }

  public InitialLdapContext (Hashtable environment, Control[] connControls)
    throws NamingException
  {
    super (false);

    if (connControls != null)
      {
	if (environment == null)
	  environment = new Hashtable ();
	else
	  environment = (Hashtable) environment.clone ();
	environment.put ("java.naming.ldap.control.connect",
			 connControls);
      }

    init (environment);
  }

  private LdapContext getDefaultInitLdapCtx ()
    throws NamingException
  {
    Context c = getDefaultInitCtx ();
    if (c == null)
      throw new NoInitialContextException ();
    else if (! (c instanceof LdapContext))
      throw new NotContextException ();
    return (LdapContext) c;
  }

  public ExtendedResponse extendedOperation (ExtendedRequest request)
    throws NamingException
  {
    return getDefaultInitLdapCtx ().extendedOperation (request);
  }

  public Control[] getConnectControls ()
    throws NamingException
  {
    return getDefaultInitLdapCtx ().getConnectControls ();
  }

  public Control[] getRequestControls ()
    throws NamingException
  {
    return getDefaultInitLdapCtx ().getRequestControls ();
  }

  public Control[] getResponseControls ()
    throws NamingException
  {
    return getDefaultInitLdapCtx ().getResponseControls ();
  }

  public LdapContext newInstance (Control[] reqControls)
    throws NamingException
  {
    return getDefaultInitLdapCtx ().newInstance (reqControls);
  }

  public void reconnect (Control[] connControls)
    throws NamingException
  {
    getDefaultInitLdapCtx ().reconnect (connControls);
  }

  public void setRequestControls (Control[] reqControls)
    throws NamingException
  {
    getDefaultInitLdapCtx ().setRequestControls (reqControls);
  }
}
