/*
 *	Author:  Alan Rollow, CSC/CS, Digital Equipment Corp.
 *	File:	 users.c
 *	Date:	 8/12/87
 *	Version: 1.6
 *
 *	users.c - Count the number of users logged on.  A rewrite of the
 *	original code from "mon".
 */
#ifndef	lint
static	char	SccsId[] = "@(#)users.c	1.6 (monitor) 8/12/87" ;
#endif

#include <sys/types.h>
#include <sys/file.h>
#include <sys/stat.h>

#include <utmp.h>

/*
 *	Number of elements to read from the utmp file.  For
 *	small (slow) systems this should get all the file in
 *	one read.  For large systems it may make more than one
 *	read, but the system will probably be faster.
 *
 *	I rather wish the number of users were kept in the
 *	kernel somewhere...
 */
#define	WHOBUF	128

static	int	fd ;			/* file descriptor of 'who' file */
static	time_t	mtime = 0 ;		/* modification time */
static	int	previous = 0 ;		/* previous number of users */

/*
 *	Module name for error functions.
 */
static	char	*module = "users" ;

/*
 *	Open the "who" file.  Print an error message if we can't
 *	open it.
 */
open_whofile()
{
	if((fd = open(UTMP_FILE, O_RDONLY, 0)) == -1 ) {
		warning("Can't open 'who' file: %s (%s).\n", module,
			UTMP_FILE);
		return -1 ;
	}

	return 1 ;
}

/*
 *	Use fstat(2) to see if the file has been modified, since
 *	last pass.  If not, return the previous number of usersa
 *
 *	If it has changed, read the contents and count the number
 *	of users and if an error didn't occur return to the begin-
 *	ning of the file.  Because monitor tries to be optimistic
 *	failure to read the file is not considered an error.
 */
users()
{
	long	lseek() ;
	struct stat statbuf ;
	struct utmp buf[WHOBUF] ;
	register rc, counter = 0 ;
	register struct utmp *p, *lastp ;

	if((rc = fstat(fd, &statbuf)) == -1 ) {
		warning("Can't stat 'who' file: %s.\n", module);
		return -1 ;
	}

	if( mtime == statbuf.st_mtime )
		return previous ;

	mtime = statbuf.st_mtime ;

	while((rc = read(fd, (char *)buf, WHOBUF * sizeof(struct utmp))) > 0 ) {
		lastp = buf + (rc / sizeof(struct utmp)) ;
		for(p = buf; p < lastp; p++)
			if( p->ut_name[0] != '\0' )
				counter++ ;
	}

	if( rc == -1 ) {
		warning("Can't read 'who' file: %s.\n", module);
		return -1 ;
	}

	if( lseek(fd, (long)0, L_SET) == -1 ) {
		warning("Can't rewind 'who' file: %s.\n", module);
		return -1 ;
	}

	return previous = counter ;
}

/*
 *	Close the "who" file.
 */
close_whofile()
{
	if( close(fd) == -1 )
		warning("Can't close 'who' file: %s.\n", module);
}
