/*
 *	Author:  Alan Rollow, EIS/CXO, Digital Equipment Corp.
 *	File:	 string_data.c
 *	Date:	 7/21/90
 *	Version: 1.13
 *
 *	string_data.c - Bring all the operating system string data together
 *	into one place.  Another set of strings local to monitor
 *	are kept in the source file using them.
 */
#ifndef	lint
static	char	SccsId[] = "@(#)string_data.c	1.13 (monitor) 7/21/90" ;
#endif

/*
 * Modification History
 * 
 * 27-June-1988 -- arr
 *
 *	New file.
 *
 *	Change include of monitor.h to include.h.
 *
 *	Added initializations of cpu_data structure.
 *
 * 29-November-1988 -- arr
 *
 *	Added changes for MIPS support.
 *
 * 28-December-1988 -- arr
 *
 *	Added data to cpu_types for MIPS based systems.
 *
 * April 28, 1989 -- arr
 *
 *	Added Rigel to the CPU list and NULL terminated the
 *	VAX list.
 */

#include <stdio.h>
#include <sys/types.h>

#ifdef	V4_ULTRIX
#	include <machine/cpuconf.h>
#elif	mips
#	include <machine/cpuconf.h>
#else
#	include <machine/cpu.h>
#endif

#include "include.h"

/*
 *	A convient macro for initializing the bit_names structure.
 */
#define	MACRO(s) { s, sizeof(s) - 1 }

/*
 *	The names of the CPU states.
 */
struct bit_names state_names[] = {
	MACRO("run"),			/* 0x1 */
	MACRO("tbi"),			/* 0x2 (moved to own field in V4) */
	MACRO("panic"),			/* 0x4 */
	MACRO("soft_disable"),		/* 0x8 */

	MACRO("boot"),			/* 0x10 */
	MACRO("stop"),			/* 0x20 */
	MACRO("timeout"),		/* 0x40 */
	MACRO("sigparent"),		/* 0x80 */

	MACRO("idle"),			/* 0x100 */
	MACRO("sigprof"),		/* 0x200 */
	MACRO("sigxcpu"),		/* 0x400 */
	MACRO("sigvtalrm"),		/* 0x800 */

	{ 0, 0, }
};

/*
 *	The names of the network interface bits.
 */
struct bit_names netif_names[] = {
	MACRO("up"), 			/* 01 */
	MACRO("broadcast"), 		/* 02 */
	MACRO("debug"), 		/* 04 */
	MACRO("route"),			/* 010 */
	MACRO("point-to-point"),	/* 020 */
	MACRO("notrailers"),		/* 040 */
	MACRO("running"),		/* 0100 */
	MACRO("noarp"),			/* 0200 */
	MACRO("local"),			/* 0400 */
	MACRO("dynproto"),		/* 01000 */
	MACRO("loopback"),		/* 02000 */
	MACRO("mop"),			/* 04000 */
	{ 0, 0, }
};

/* 
 *	The names of the process flags.
 */
struct bit_names flag_names[] = {
	MACRO("sload"), MACRO("ssys"), MACRO("slock"), MACRO("sswap"),
	MACRO("strc"), MACRO("swted"), MACRO("sulock"), MACRO("spage"),
	MACRO("skeep"), MACRO("somask"), MACRO("swexit"), MACRO("sphysio"),
	MACRO("svfork"), MACRO("svfdone"), MACRO("snovm"), MACRO("spagi"),
	MACRO("sseql"), MACRO("suanom"), MACRO("stimo"), MACRO("*sdetach*"),
	MACRO("sousig"), MACRO("soweupc"), MACRO("ssel"), MACRO("slogin"),
	MACRO("sptechg"), MACRO("smaster"),
	{ 0, 0, },
};

/*
 *	The names of the process states.
 */
char	*proc_states[] = {
	"-",
	"sleeping",
	"<waiting>",
	"running",
	"idle",
	"zombie",
	"stopped",
};

int	n_proc_states = sizeof(proc_states)/sizeof(proc_states[0]) ;

/*
 *	These arrays will allow cpu.c to get a CPU string from
 *	a type and subtype.
 */
struct cpu_type vax8200[] = {
#ifdef	VAX8200
	ST_8200, "VAX 8200/8250", NULL,
	ST_8300, "VAX 8300/8350", NULL,
	ST_8400, "VAX 8400/8450", NULL,
#endif
	{ 0, 0, 0, },
};

struct cpu_type vax8800[] = {
#ifdef	VAX_8800
	ST_8500, "VAX 8500/8530", NULL,
	ST_8550, "VAX 8550", NULL,
	ST_8700, "VAX 8700", NULL,
	ST_8800, "VAX 8800", NULL,
#endif
	{ 0, 0, 0, },
};

struct cpu_type microvax2[] = {
#ifdef	MVAX_II
	ST_MVAXII,  "MicroVAX/VAXstation II",   NULL,
	ST_VAXSTAR, "MicroVAX/VAXstation 2000", NULL,
#endif
	{ 0, 0, 0, },
};

#ifdef	vax
struct cpu_type cpu_types[] = {
/*
 *	The VAX list.
 */
	VAX_780,  "VAX 11/780 or 11/785", NULL,
	VAX_750,  "VAX 11/750 or 11/751", NULL,
	VAX_730,  "VAX 11/730 or 11/725", NULL,
	VAX_8600, "VAX 8600/8650", NULL,
	VAX_8200, "VAX 8200/8250/8300/8350", vax8200,
	VAX_8800, "VAX 8800/8700/8550/8530/8500", vax8800,
	MVAX_I,   "MicroVAX I", NULL,
	MVAX_II,  "MicroVAX/VAXstation II", microvax2,
/*
 *	Future CPU types will need to be #ifdef'd as these
 *	are.  This lets the data be updated for newer versions
 *	but still be backward compatiable.
 */
#ifdef	C_VAX
	C_VAX,    "MicroVAX/VAXstation 3200/3500/3600", NULL,
#endif
#ifdef	VAX_6200
	VAX_6200, "VAX 62xx/63xx", NULL,
#endif
#ifdef	C_VAXSTAR
	C_VAXSTAR, "VAXstation 3100", NULL,
#endif
#ifdef	VAX_8820
	VAX_8820, "VAX 8820/8830/8840", NULL,
#endif
#ifdef	VAX_60
	VAX_60, "VAXstation 3520/3540", NULL,
#endif
#ifdef	V_VAX
	V_VAX, "A Virtual VAX", NULL,
#endif
#ifdef	VAXSTAR
	VAXSTAR, "MicroVAX/VAXStation 2000", NULL,
#endif
#ifdef	VAX_6500
	VAX_6500, "VAX 6000-500", NULL,
#endif
#ifdef	VAX_6400
	VAX_6400, "VAX 6000-400", NULL,
#endif
#ifdef	VAX_3600
	VAX_3600, "MicroVAX 3600", NULL,
#endif
#ifdef	VAX_3400
	VAX_3400, "MicroVAX 3400", NULL,
#endif
#ifdef	VAX_3900
	VAX_3900, "MicroVAX 3900", NULL,
#endif
/*
 *	Once the VAX 9000 is properly defined, it should use
 *	this one first.  If not, I hopefully got the right
 *	magick number.
 */
#ifdef	VAX_9000
	VAX_9000, "VAX 9000", NULL,
#endif
	0xe, "VAX 9000", NULL,
	{ 0, 0, 0, },
};
#endif

struct cpu_type r2000a[] = {
#ifdef	ST_DS3100
	{ ST_DS3100, "DECstation/DECsystem 3100/2100", NULL },
#endif
#ifdef	ST_3MAX
	{ ST_3MAX,   "Unannounced CPU type", NULL },
#endif
#ifdef	ST_DS5000
	{ ST_DS5000, "DECstation/DECsystem 5000", NULL },
#endif
#ifdef	ST_DS5800
	{ ST_DS5800, "DECsystem 5810/5820/5830/5840", NULL },
#endif
#ifdef	ST_DS5400
	{ ST_DS5400, "DECsystem 5400", NULL },
#endif
#ifdef	ST_DS5500
	{ ST_DS5400, "DECsystem 5500", NULL },
#endif
	{ 0, 0, 0, },
} ;

struct cpu_type r3000[] = {
#ifdef	ST_DS3100
	{ ST_DS3100, "DECstation/DECsystem 3100/2100", NULL },
#endif
#ifdef	ST_3MAX
	{ ST_3MAX,   "Unannounced CPU type", NULL },
#endif
#ifdef	ST_DS5000
	{ ST_DS5000, "DECstation/DECsystem 5000", NULL },
#endif
#ifdef	ST_DS5800
	{ ST_DS5800, "DECsystem 5810/5820/5830/5840", NULL },
#endif
#ifdef	ST_DS5400
	{ ST_DS5400, "DECsystem 5400", NULL },
#endif
#ifdef	ST_DS5500
	{ ST_DS5400, "DECsystem 5500", NULL },
#endif
	{ 0, 0, 0, },
} ;

/*
 *	The MIPS list.
 */
#ifdef	mips
struct cpu_type cpu_types[] = {
#	ifdef	PMAX
		{ PMAX, "DECstation/DECsystem 3100/2100", NULL, },
#	endif
#	ifdef	R3000_CPU
		{ R3000_CPU, "R3000 Based Systems", r3000, },
#	endif
#	ifdef	R2000a_CPU
		{ R2000a_CPU, "R2000a Based System", r2000a, },
#	endif
	{ 0, 0, 0, },
} ;
#endif
