/*
 *	Author:  Alan Rollow, EIS/CXO, Digital Equipment Corp.
 *	File:	 sizes.c
 *	Date:	 8/21/90
 *	Version: 1.6
 *
 *	sizes.c - Print sizes of monitor records.  THis is also
 *	used to find the smallest set of include files to
 *	be able to compile record.h.
 */
#ifndef	lint
static	char	SccsId[] = "@(#)sizes.c	1.6 (monitor) 8/21/90" ;
#endif

#include <nlist.h>
#include <stdio.h>
#include <signal.h>

#include <sys/types.h>
#include <sys/dk.h>
#include <sys/buf.h>
#include <sys/file.h>
#include <sys/socket.h>
#include <sys/vmsystm.h>
#include <sys/vmmeter.h>

#if defined(V4_ULTRIX) && defined(mips)
#	include <mips/cpu.h>
#endif

#include <sys/dir.h>
#include <sys/param.h>
#include <sys/user.h>

#include <net/if.h>
#include <netinet/in.h>

#include "monitor.h"

main()
{
	printf("header:  %d\n", MON$S_HEADER) ;

	putchar('\n') ;

	printf("first:   %d\n", MON$S_FIRST) ;
	printf("last:    %d\n", MON$S_LAST) ;
	printf("sample:  %d\n", MON$S_SAMPLE) ;
	printf("reconf:  %d\n", MON$S_RECONF) ;

	putchar('\n') ;

	printf("cpu:     %d\n", MON$S_CPU) ;
	printf("tty:     %d\n", MON$S_TTY) ;
	printf("disk:    %d\n", MON$S_DISK) ;
	printf("free:    %d\n", MON$S_FREE) ;
	printf("fork:    %d\n", MON$S_FORK) ;
	printf("page:    %d\n", MON$S_PAGE) ;
	printf("proc:    %d\n", MON$S_PROC) ;
	printf("swap:    %d\n", MON$S_SWAP) ;
	printf("tape:    %d\n", MON$S_TAPE) ;
	printf("user:    %d\n", MON$S_USER) ;
	printf("netif:   %d\n", MON$S_NETIF) ;
	printf("memoy:   %d\n", MON$S_MEMORY) ;
	printf("loadave: %d\n", MON$S_LOADAVE) ;
	printf("pid:     %d\n", MON$S_PID) ;
	printf("buf:	 %d\n", MON$S_BUF) ;
	printf("nfs:     %d\n", MON$S_NFS) ;
	printf("namei:   %d\n", MON$S_NAMEI) ;
	printf("kmem:    %d\n", MON$S_KMEM) ;

	putchar('\n') ;

	printf("panic:   %d\n", MON$S_PANIC) ;
}
