/*
 *	Author:  Alan Rollow, CSC/CS, Digital Equipment Corp.
 *	File:	 save.c
 *	Date:	 3/29/90
 *	Version: 1.33
 *
 *	save.c - Functions to save data to a file.
 */
#ifndef	lint
static	char	SccsId[] = "@(#)save.c	1.33 (monitor) 3/29/90" ;
#endif

/*
 * Modification History
 * 
 * 27-June-1988 -- arr
 *
 *	Change include of monitor.h to include.h.
 *
 *	Change include of record.h to monitor.h.
 *
 * Feb. 15, 1989 -- arr
 *
 *	Correctly set mon_flag with MON$M_VALID.
 *
 * Mar. 26, 1990 -- arr
 *
 *	Added hack to work-around DECmumble include file problem.
 *
 */

#include <nlist.h>
#include <stdio.h>
#include <signal.h>

#include <sys/types.h>
#include <sys/buf.h>
#include <sys/file.h>
#include <sys/uio.h>
#include <sys/socket.h>
#include <sys/dk.h>
#include <sys/param.h>
#include <sys/dir.h>

#if defined(V4_ULTRIX) && defined(mips)
#	include <mips/cpu.h>
#endif

#include <sys/user.h>
#include <sys/vmsystm.h>
#include <sys/vmmeter.h>

#include <net/if.h>
#include <netinet/in.h>

#include "include.h"
#include "monitor.h"
#include "options.h"
#include "extern.h"

/*
 *	Module name for error functions.
 */
static	char	*module = "save" ;

/*
 *	We're going to keep the data file open for the duration
 *	of execution.  To prevent another copy of monitor to write
 *	on the same file, we'll use BLKANDSET to provide some file
 *	locking.  The O_NDELAY causes open to return with an error
 *	instead of blocking.
 */
#define	OPEN_FLAG	(O_WRONLY|O_CREAT|O_APPEND|O_BLKANDSET|O_NDELAY)

static	int	fd = -1 ;	/* a common file descriptor */

/*
 *	Initialization function for save.
 *
 *	By this time we should know what data records are being saved.
 *	It seems reasonable that we can set aside an array of iovec[]
 *	structures and write the data out with writev(2).
 */
open_save(op)
OPTION	*op ;
{
	if( op->opt_standard )
		fd = fileno(stdout);
	else
		fd = open(op->opt_file, OPEN_FLAG, 0644);

	if( fd == -1 )
		fatal("Can't open data file: %s (%s).\n", module, op->opt_file);

	if( write(fd, (char *)&first, MON$S_FIRST) == -1 )
		fatal("Can't write first record: %s.\n", module);

	init_iovec(op);
}

/*
 *	Un-initialization function for save.
 *
 *	ARGSUSED
 */
close_save(op)
OPTION	*op ;
{
	long	time() ;

	if( !killed )
		last.mon_signal = -1 ;

	last.mon_edate = time((long *)0);
	last.mon_flag  = MON$M_VALID ;

	if( getrusage(RUSAGE_SELF, &last.mon_usage) == -1 )
		warning("Can't get resource information: %s.\n", module) ;

	if( write(fd, (char *)&last, MON$S_LAST) == -1 )
		fatal("Can't write last record: %s.\n", module);

	if( close(fd) == -1 )
		fatal("Can't close output file: %s.\n", module);
}

/*
 *	Save the collected data in "file".
 *
 *	ARGSUSED
 */
save(op)
OPTION	*op ;
{
	if( writev(fd, iov, n_records) != sample.mon_datalen )
		fatal("Writev failed: %s.\n", module);

	return MON_NORMAL ;
}
