/*
 *	Author:  Alan Rollow, CSC/CS, Digital Equipment Corp.
 *	File:	 options.h
 *	Date:	 8/21/90
 *	Version: 1.39
 *
 *	options.h - This file includes structure declarations	defines,
 *	etc, for the option structure.
 */

/*
 * Modification History
 *
 * 28-June-1988 -- arr
 *
 *	Added data structures for the "set" bits.
 *
 * 29-June-1988 -- arr
 *
 *	Remove unneeded OPT_ constants.
 *
 *	Include the display_table and collect_table structure
 *	declarations.
 *
 * 29-November-1988 -- arr
 *
 *	Added an #undef for PC before curses.h.  This is due to a
 *	conflict with one of the MIPS machine specific include files.
 *
 * Jan. 18, 1989 -- arr
 *
 *	Added "all" data option.  This is now the default.  I also
 *	removed the ALLOW_NAMES #ifdef.
 *
 * Feb. 10, 1989 -- arr
 *
 *	Changed the name of RECTYPE3 to RECONF.
 */

/*
 *	Latched include files needed by this one.
 */
#ifdef	PC
#undef	PC
#endif
#include <curses.h>

/*
 *	These are like the device switch tables used by the
 *	kernel.  These will be used to initialize the function
 *	pointers in the option structure.  Eventually I may
 *	make them part of the global data and only keep an
 *	index in the option structure.
 */
struct display_table {
	int	code,
		interactive,
		sleep ;
	int	(*display)() ;
	int	(*open)() ;
	int	(*close)() ;
	int	(*redraw)() ;
	int	(*help)() ;
} ;

struct collect_table {
	int	code ;
	int	(*collect)(),
		(*open)(),
		(*close)() ;
};

/*
 *	The bit field overlay for the structure of the data
 *	flag bits.
 */
struct	opt_data_bits {
	unsigned o_control : 2,		/* control records */
		 o_sample : 1,		/* sample record */
		 o_reconf : 1,		/* reconfiguration */
		 o_cpu : 1, 		/* interrupts, etc. */
		 o_tty : 1,		/* tty I/O */
		 o_disk : 1,		/* disk I/O */
		 o_free : 1,		/* free memory */
		 o_fork : 1,		/* fork stats */
		 o_page : 1,		/* paging info */
		 o_proc : 1,		/* process info */
		 o_swap : 1,		/* swap space info */
		 o_tape : 1,		/* tape I/O (unused) */
		 o_user : 1,		/* number of users */
		 o_netif : 1,		/* network interface */
		 o_memory : 1,		/* memory stats */
		 o_loadave : 1,		/* load averages */
		 o_pid : 1,		/* process by pid */
		 o_buf : 1,		/* buffer cache */
		 o_nfs : 1,		/* nfs */
		 o_namei : 1,		/* namei cache */
		 o_kmem : 1 ;		/* kernem memory allocator stats */
};

/*
 *	The bit field overlay for the flag bits.
 */
struct	opt_flag_bits {
	unsigned : 1,			/* eat the first record on replay */
		 o_inter : 1,		/* is running interactively */
		 o_total : 1,		/* display disk totals */
		 o_curses : 1,		/* curses has been turned on */
		 o_standard : 1,	/* use stdin or stdout */
		 o_sleep_set : 1,	/* sleep option set */
		 : 1,			/* This used to be the output_set bit */
		 o_mag_sample : 1,	/* enable/disable magnification */
		 o_rate : 1 ;		/* divide by elapsed time */
};

/*
 *	The first longword of the structure contains bits which for the
 *	tells what data is be gathered.  The second longword is used for
 *	flags controlling program operation.
 *
 *	The opt_inter bit is set whenever the program is being 
 *	interactively (some display modes).  If the opt_file is NULL
 *	the data will be collected live, otherwise it will be taken
 *	from the file.
 */
typedef struct option {
	union	{
		int	o_data ;		/* what unions are for... */
		struct	opt_data_bits o_db ;
	} union_data ;

	union	{
		int	o_flag ;			/* more unions */
		struct	opt_flag_bits o_fb ;
	} union_flag ;

	int	display_mode ;	/* display mode */
	int	collect_mode ;	/* collection mode */
	int	opt_proc_id ;	/* process id for proc data collection */
	int	opt_sleep ;	/* how long to sleep between collect()'s */
	int	opt_magnify ;	/* Bit mask of data option to magnify */

	double	opt_fract ;	/* What fraction of a second to sleep */

	char	*opt_file ;	/* output/input file */
	char	*opt_prompt ;	/* prompt for screen function */
	char	*opt_output ;	/* output file for screen and print dumps */
	char	*opt_kernel ;	/* name of kernel to get namelist. */

	/*
	 * Address of functions to do work of screen updateing or saving.
	 *
	 *	display	  - The function to be used to generate output.
	 *	help_display - A display specific help function.
	 *	open_display  - Function to be called to setup the display
	 *		function.
	 *	close_display - Function to be called to clean up after
	 *		the display function.
	 *	redraw_display - Redraw the screen.  Generalized function
	 *		for the 'r' command.
	 *
	 *	collect	  - Function to called to collect data for
	 *		the "display" function.
	 *	open_collect  - Function to be called to do initialization
	 *		for (*opt_collect)().
	 *	close_collect - Function to be called to clean up after
	 *		(*opt_collect)().
	 */

	int	(*display)() ;
	int	(*help_display)() ;
	int	(*open_display)() ;
	int	(*close_display)() ;
	int	(*redraw_display)() ;

	int	(*collect)() ;
	int	(*open_collect)() ;
	int	(*close_collect)() ;
} OPTION ;

/*
 *	A bit field used locally to the options code to determine
 *	what options have already been set.  If some options haven't
 *	been set when the command line parsing is finished, defaults
 *	will be used, that depend on the display and collection mode.
 */
struct set_bits {
	unsigned output : 1,	/* The output file for screen dump */
		 display : 1,	/* The display mode has been set. */
		 collect : 1,	/* The collection mode has been set. */
		 file : 1,	/* The name of the data file has been set */
		 data : 1 ;	/* The data flag has been set. */
};

/*
 *	Return values for collection functions.
 */
#define	MON_EXIT	(-1)
#define	MON_CONTINUE	(0)
#define	MON_NORMAL	(1)

/*
 *	Masks for the "grouped" options.
 */
#define	MON$M_IO	(MON$M_TTY | MON$M_DISK | MON$M_NETIF)
#define	MON$M_OS	(MON$M_CPU | MON$M_FORK | MON$M_PAGE | MON$M_MEMORY)
#define	MON$M_MON	(MON$M_CPU | MON$M_TTY | MON$M_DISK | MON$M_FORK | \
			 MON$M_PAGE | MON$M_PROC | MON$M_USER | MON$M_NETIF | \
			 MON$M_MEMORY | MON$M_LOADAVE)
#define	MON$M_ALL	(MON$M_CPU | MON$M_TTY | MON$M_DISK | MON$M_FORK | \
			 MON$M_PAGE | MON$M_PROC | MON$M_USER | MON$M_NETIF | \
			 MON$M_MEMORY | MON$M_LOADAVE | MON$M_SWAP | MON$M_BUF | \
			 MON$M_NAMEI )

/*
 *	Mapping for the first union.
 */
#define	opt_data	union_data.o_data

/*
 *	Control records
 */
#define opt_control 	union_data.o_db.o_control
#define opt_sample 	union_data.o_db.o_sample
#define	opt_reconf	union_data.o_db.o_reconf
/*
 *	Data records
 */
#define opt_cpu 	union_data.o_db.o_cpu
#define opt_tty 	union_data.o_db.o_tty
#define opt_disk 	union_data.o_db.o_disk
#define opt_free 	union_data.o_db.o_free
#define opt_fork 	union_data.o_db.o_fork 
#define opt_proc 	union_data.o_db.o_proc 
#define opt_page 	union_data.o_db.o_page
#define opt_swap	union_data.o_db.o_swap
#define	opt_user	union_data.o_db.o_user
#define opt_netif 	union_data.o_db.o_netif
#define opt_memory 	union_data.o_db.o_memory
#define opt_loadave 	union_data.o_db.o_loadave
#define	opt_pid		union_data.o_db.o_pid
#define	opt_buf		union_data.o_db.o_buf
#define	opt_nfs		union_data.o_db.o_nfs
#define	opt_namei	union_data.o_db.o_namei
#define	opt_kmem	union_data.o_db.o_kmem

/*
 *	Mapping for the second union.
 */
#define	opt_flag	union_flag.o_flag
#define	opt_inter	union_flag.o_fb.o_inter
#define	opt_eatit	union_flag.o_fb.o_eatit
#define	opt_total	union_flag.o_fb.o_total
#define opt_curses	union_flag.o_fb.o_curses
#define opt_standard	union_flag.o_fb.o_standard
#define	opt_rate	union_flag.o_fb.o_rate
#define	opt_mag_sample	union_flag.o_fb.o_mag_sample
#define sleep_set	union_flag.o_fb.o_sleep_set

/*
 *	Option table defination indexes.
 *
 *	"Display" modes (0-7).
 */
#define	OPT_SAVE	0	/* write the data to a file */
#define	OPT_SCREEN	1	/* use curses */
#define	OPT_WINDOW	2	/* use X or some such */
#define	OPT_LINE	3	/* use normal printf's */
#define OPT_NOP		4	/* don't display anything */
#define	OPT_PRINT	5	/* Reserved for future use. */
#define	OPT_READ	6	/* simple printing of the records */
/*
 *	Collection mode (8-15).
 */
#define	OPT_LIVE	8	/* Collect the data from a running system */
#define OPT_REPLAY	9	/* Collect the data from a file */
#define	OPT_NET		10	/* collect the data from another node */
#define	OPT_NAMES	11	/* monitor version of "names" program */
/*
 *	Data selection (16-39).
 */
#define	OPT_CPU		(16)
#define	OPT_TTY		(17)
#define	OPT_DISK	(18)
#define	OPT_FREE	(19)
#define	OPT_FORK	(20)
#define	OPT_PAGE	(21)
#define	OPT_PROC	(22)
#define	OPT_SWAP	(23)
#define	OPT_USER	(25)
#define	OPT_NETIF	(26)
#define	OPT_STATE	(27)
#define	OPT_MEMORY	(28)
#define	OPT_LOADAVE	(29)
#define	OPT_IO		(30)
#define	OPT_MON		(31)
#define	OPT_ALL		(32)
#define OPT_PID		(33)
#define	OPT_OS		(34)
#define	OPT_BUF		(35)
#define	OPT_NFS		(36)
#define	OPT_NAMEI	(37)
#define	OPT_KMEM	(38)
/*
 *	"-" preceded options.
 */
#define	OPT_FILE	(40)
#define	OPT_TOTAL	(41)
#define	OPT_OUTPUT	(42)
#define	OPT_SLEEP	(43)
#define	OPT_DEBUG	(45)
#define	OPT_PROMPT	(46)
#define	OPT_HELP	(47)
#define	OPT_VERSION	(48)
#define OPT_MAGNIFY	(49)
#define	OPT_KERNEL	(50)
#define	OPT_SAMPLE	(51)

/*
 *	Bit defines for option type bit field.
 */
#define OPT_COLLECT	01
#define OPT_DISPLAY	02
#define OPT_DATA	04
#define OPT_MINUS	010	/* a '-' preceded option */
#define OPT_RFFU	020	/* reserved for future use */
#define OPT_NOSUP	040	/* not supported */
