/*
 *	Author:  Alan Rollow, CSC/CS, Digital Equipment Corp.
 *	File:	 monitor.h
 *	Date:	 5/17/90
 *	Version: 1.44
 *
 *	monitor.h - Record structures and defines.
 *
 *	Taken from the record test directory - Version 1.4.
 */

/*
 * Modification history.
 *
 *  Jan. 4, 1988 -- arr
 *
 *	Added architecture constants and field to FIRST.
 *
 *	Expanded size of version and node name string
 *	in FIRST.
 *
 *	Changed signal information in LAST to allow MIPS
 *	and VAX record to be the same size.  I took out the
 *	scp structure because it didn't contain much of
 *	interest.
 *
 *	Added padding to LOADAVE to allow MIPS and VAX
 *	record to be the same size.
 *
 *	Changed minor version number.
 *
 *  Jan. 5, 1988 -- arr
 *
 *	Changed PAGE to store only the data from vmmeter that
 *	it uses.
 *
 *	Changed MEMORY to store only the data from vmtotal that
 *	it uses. 
 *
 *	Added some field to CPU for the MIPS counters.
 *
 * Jan. 11 and 12 -- arr
 *
 *	Added body of the mon_swap data structure.
 *
 * Jan. 16, 1989 -- arr
 *
 *	change MON$C_MAXSWAP to 20 from 24.
 *
 *	added Swap space, buffer cache and namei cache.
 *
 * Jan. 19, 1989 -- arr
 *
 *	added cache detail structure to buffer cache.
 *
 * Jan. 25, 1989 -- arr
 *
 *	Removed extra long word from detail structure.
 *
 * Feb.  9, 1989 -- arr
 *
 *	Redesigned BUF structure.
 *
 * Week ending Feb. 18, 1989 -- arr
 *
 *	Added mon_nbpg and mon_bsize to FIRST record.
 *	Added mon_name to CPU record.
 *	Added text of username and group (real and effective) to PID.
 *
 * May 7, 1989 -- arr
 *
 *	Added rusage structure to LAST record.
 *
 * Dec. 27, 1989 -- arr
 *
 *	Changed the usage of ucred in the mon_pid structure
 *	to be mon_ucred.  This doesn't change size or format
 *	of monitor data, so I won't change the version number.
 *
 *	I made the change because V4.0 added a longword to the
 *	ucred structure.
 *
 *	I also changed the mon_cpunum elements in mon_tty and
 *	mon_nfs to mon_rffu.  This doesn't change the size
 *	either.
 *
 * May 16, 1990 -- arr
 *
 *	Added alternate constant names.  The usage of the
 *	constants isn't changed so this will not change the
 *	version number.  Once I decide which naming style
 *	is best I'll take out the extra ones.  A future
 *	version will use the alternate names, but the old
 *	will stay for a while.  Eventually the old names
 *	will go away.
 */

/*
 *	This is the value of DEV_SIZE taken from <sys/devio.h>.
 */
#define	DEV_SIZE	(8)

/*
 *	The version number defined as constants.
 */
#define	MON$C_MAJOR	(1)
#define MON$C_MINOR	(30)

#define	MON_MAJOR	(MON$C_MAJOR)
#define	MON_MINOR	(MON$C_MINOR)

#define	MonitorRevMajor	(MON$C_MAJOR)
#define	MonitorRevMinor	(MON$C_MINOR)

/*
 *	Architecture constants.
 */
#define	MON$C_VAX	(1)
#define	MON$C_MIPS	(2)

#define	MON_VAX		(MON$C_VAX)
#define	MON_MIPS	(MON$C_MIPS)

#define	MonitorArchVAX	(MON$C_VAX)
#define	MonitorArchMIPS	(MON$C_MIPS)

/*
 *	The "monitor" data file consists of a number of (different
 *	length) records with a common header format.  Each header 
 *	looks like:
 *
 *		31				0
 *		+---------------+-------+-------+
 *		|    length 	|  flag | type	|
 *		+---------------+-------+-------+
 *
 *	The C structure of the header is:
 *
 *	struct mon_header {
 *		char	mon_type,
 *			mon_flag ;
 *		short	mon_length ;
 *	};
 *
 *	Each record contains other information that will be detailed
 *	in the comments on that structure.
 */

/*
 *	This is the structure of the record header.  Each record will
 *	have this at the beginning.
 */
#define	MON$S_HEADER	(sizeof(struct mon_header))
#define	MON_HEADER_S	(MON$S_HEADER)
#define	MonitorHeaderSize (MON$S_HEADER)

/*
 *	Flag bits.
 */
#define	MON$M_VALID	(01)	/* data is valid */
#define	MON_VALID_M	(MON$M_VALID)
#define MonitorValidMask (MON$M_VALID)

struct	mon_header {
	char	mon_type,		/* record type */
		mon_flag ;		/* Other information */
	short	mon_length ;		/* record length */
};

/*
 *	The MON$C_ #define is number of the record type.  It can be used 
 *	as an index into tables.  It also represents the bit within 
 *	the options field for that data type.  The control records aren't 
 *	part of the options field, but space is set aside for them to make 
 *	life easier in places.  The MON$M_ #define is the mask formed from 
 *	shifting a one MON$C_ places (1 << MON$C_).
 *
 *	The MON$S_ #define is the size of the associated structure
 *	"sizeof(struct mon_)"
 */

/*
 *	These are the control records.
 */

/*
 *	This record will be written each time the program starts
 *	running.  It also contains static system information.
 *
 *	It is possible for the data file to have more than one "first"
 *	record.  If the program is started again with the same output
 *	file, the "first" and "last" records can be used to figure out
 *	when, etc.  There should be only one copy of the program writting
 *	to a given file at a time.
 */
#define	MON$C_FIRST	(0)
#define	MON_FIRST	(MON$C_FIRST)
#define MonitorFirst	(MON$C_FIRST)

#define	MON$M_FIRST		(1 << MON$C_FIRST)
#define	MON_FIRST_M		(MON$M_FIRST)
#define MonitorFirstMask	(MON$M_FIRST)

#define	MON$S_FIRST		(sizeof(struct mon_first))
#define	MON_FIRST_S		(MON$C_FIRST)
#define MonitorFirstSize	(MON$C_FIRST)

#define	MON$S_VERSION		(128)
#define	MON_VERSION_S		(MON$S_VERSION)
#define	MonitorVersionSize	 (MON$S_VERSION)

#define	MON$S_HOSTNAME		(128)
#define	MON_HOSTNAME_S		(MON$S_HOSTNAME)
#define	MonitorHostnameSize	(MON$S_HOSTNAME)

struct	mon_first {
	char	mon_type,		/* MON$C_FIRST */
		mon_flag ;		/* Other information */
	short	mon_length ;		/* MON$S_FIRST */

	int	mon_sleep,		/* time between samples for this run */
		mon_options, 		/* the options mask of collected data */
		mon_pid, 			/* process id of the process */
		mon_hz,				/* clock speed/frequency */
		mon_nbpg,			/* bytes per page of memory */
		mon_bsize,			/* value of DEV_BSIZE */
		mon_physmem ;			/* physical memory */

	struct timeval mon_boot ;		/* When the system was booted */

	long	mon_sdate ;			/* Time monitor was started */

	int	mon_cpu,			/* number of CPU's */
		mon_disk,			/* number of disks */
		mon_netif,			/* number of interfaces */
		mon_buf ;			/* number of BUF's */

	int	mon_arch ;			/* architecture number */
	dev_t	mon_record ;			/* record.h version */

	char	mon_version[MON$S_VERSION+1] ;	/* version string */
	char	mon_hostname[MON$S_HOSTNAME+1] ;	/* host name */
};

/*
 *	This record will be written if the program is given the
 *	opportunity to exit gracefully.
 */
#define	MON$C_LAST	(1)
#define	MON_LAST	(MON$C_LAST)
#define MonitorLast	(MON$C_LAST)

#define	MON$M_LAST		(1 << MON$C_LAST)
#define	MON_LAST_M		(MON$M_LAST)
#define MonitorLastMask		(MON$M_LAST)

#define	MON$S_LAST		(sizeof(struct mon_last))
#define	MON_LAST_S		(MON$S_LAST)
#define MonitorLastSize		(MON$S_LAST)

struct	mon_last {
	char	mon_type, 		/* MON$C_LAST */
		mon_flag ;		/* Other information */
	short	mon_length ;		/* MON$C_LAST */
	int	mon_signal,		/* signal that kill the process */
		mon_code ;		/* code from signal handler */
	long	mon_edate ;		/* Time monitor stopped */

	struct rusage mon_usage ;	/* resource usage information */
};

/*
 *	This record is written before each sample.  It contains
 *	the timestamp, sum of the length of the data records and
 *	the number of clock ticks since the system was booted.
 */
#define	MON$C_SAMPLE		(2)
#define	MON_SAMPLE		(MON$C_SAMPLE)
#define MonitorSample		(MON$C_SAMPLE)

#define	MON$M_SAMPLE		(1 << MON$C_SAMPLE)
#define	MON_SAMPLE_M		(MON$M_SAMPLE)
#define MonitorSampleMask	(MON$M_SAMPLE)

#define	MON$S_SAMPLE		(sizeof(struct mon_sample))
#define	MON_SAMPLE_S		(MON$S_SAMPLE)
#define MonitorSampleSize	(MON$S_SAMPLE)

struct	mon_sample {
	char	mon_type,		/* MON$C_SAMPLE */
		mon_flag ;		/* Other information */
	short	mon_length ;		/* MON$S_SAMPLE */

	int	mon_datalen ;		/* sum of data structure lengths */
	long	mon_timestamp ;		/* time the sample taken */
	int	mon_ticks ;		/* clock ticks since boot */
};

/*
 *	A Re-configuration structure.  One of these will appear when
 *	the number of CPU, disk, netif or buf's has changed.  Not
 *	implemented yet.
 */
#define	MON$C_RECONF		(3)
#define	MON_RECONF		(MON$C_RECONF)
#define MonitorReconf		(MON$C_RECONF)

#define	MON$M_RECONF		(1 << MON$C_RECONF)
#define	MON_RECONF_M		(MON$M_RECONF)
#define MonitorReconfMask	(MON$M_RECONF)

#define	MON$S_RECONF		(sizeof(struct mon_reconf))
#define	MON_RECONF_S		(MON$S_RECONF)
#define MonitorReconfSize	(MON$S_RECONF)

struct	mon_reconf {
	char	mon_type,		/* MON$C_RECONF */
		mon_flag ;		/* Other information */
	short	mon_length ;		/* MON$S_RECONF */

	int	mon_sleep,		/* time between samples for this run */
		mon_options ; 		/* the options mask of collected data */

	long	mon_rdate ;		/* date that monitor was reconfig'd */

	int	mon_cpu,		/* number of CPU's */
		mon_disk,		/* number of disks */
		mon_netif,		/* number of interfaces */
		mon_buf ;		/* number of BUF's */
};

/*
 *	And these are the data records.
 */

/*
 *	Assorted running CPU information, interrupts, system calls,
 *	time, in CPU states, cpuid, etc.  Some of the information is
 *	kept on a per CPU basis, the rest is kept globally.  The global
 *	data is stored in the first CPU record.
 *
 *	Per CPU data:
 *
 *		mon_ident, mon_state, mon_cpu, mon_index, mon_time,
 *		mon_swtch, mon_subtype.
 *
 *	Global CPU data:
 *
 *		mon_trap, mon_syscall, mon_intr, mon_pdma.
 *
 *	These are only of interest on the MIPS, but will be kept
 *	for the VAX to make the data structures compatable.
 *
 *		mon_tblpid, mon_soft.
 *
 *	Eventually I'll add the Interprocessor Interrupt stats
 *	that were added in V4 and will probably merge in the
 *	tty data since is collected per CPU.  I may also change
 *	the way the CPU type is stored.
 */
#define MON$C_CPU	(4)
#define	MON_CPU		(MON$C_CPU)
#define MonitorCPU	(MON$C_CPU)

#define MON$M_CPU	(1 << MON$C_CPU)
#define	MON_CPU_M	(MON$M_CPU)
#define MonitorCPUMask	(MON$M_CPU)

#define	MON$S_CPU	(sizeof(struct mon_cpu))
#define	MON_CPU_S	(MON$S_CPU)
#define MonitorCPUSize	(MON$S_CPU)

#define	MON$S_CPUNAME	(64)
#define	MON_CPUNAME	(MON$S_CPUNAME)
#define MonitorCPUName	(MON$S_CPUNAME)


struct	mon_cpu {
	char	 mon_type,		/* MON$C_CPU */
		 mon_flag ;		/* Other information */
	short	 mon_length ;		/* MON$S_CPU */
/*
 *	Static CPU data.
 */
	int	 mon_ident,		/* CPU id */
		 mon_state ;		/* State of this processor */
	long	 mon_subtype ;		/* CPU subtype */
	short	 mon_cpu, 		/* system index/counter */
		 mon_index ; 		/* internal index/counter */
/*
 *	Dynamic CPU data.
 */
	long	 mon_time[CPUSTATES] ;	/* Time in CPU states */
	unsigned mon_swtch,		/* context switchs */
		 mon_trap,		/* calls to trap() */
		 mon_syscall,		/* calls to syscall() */
		 mon_intr,		/* device interrupts */
		 mon_pdma ;		/* pseudo-dma interrupts */
/*
 *	MIPS stuff.
 */
	unsigned mon_tlbpid,		/* calls to new_tlbpid() */
		 mon_soft ;		/* software interrupts */
/*
 *	A copy of the CPU name.
 */
	char	 mon_name[MON$S_CPUNAME+1] ;
/*
 * 	Address of cp_time data or cpudata structure (cpudata + mon_index)
 *	for this cpu.  This is only interesting internal to monitor.
 */
	caddr_t	 mon_where ;
};

/*
 *	TTY input and output counts.
 */
#define MON$C_TTY	(5)
#define	MON_TTY		(MON$C_TTY)
#define MonitorTTY	(MON$C_TTY)

#define MON$M_TTY	(1 << MON$C_TTY)
#define	MON_TTY_M	(MON$M_TTY)
#define MonitorTTYMask	(MON$M_TTY)

#define	MON$S_TTY	(sizeof(struct mon_tty))
#define	MON_TTY_S	(MON$S_TTY)
#define MonitorTTYSize	(MON$S_TTY)

struct	mon_tty {
	char	mon_type,		/* MON$C_TTY */
		mon_flag ;		/* Other information */
	short	mon_length ;		/* MON$S_TTY */

	int	mon_ttyin,		/* tty input */
		mon_ttyout,		/* tty output */
		mon_rffu ;		/* Reserved */
};

/*
 *	Disk I/O information, on a per disk basis.
 */
#define	MON$C_DISK	(6)
#define	MON_DISK	(MON$C_DISK)
#define MonitorDisk	(MON$C_DISK)

#define MON$M_DISK	(1 << MON$C_DISK)
#define	MON_DISK_M	(MON$M_DISK)
#define MonitorDiskMask	(MON$M_DISK)

#define	MON$S_DISK	(sizeof(struct mon_disk))
#define	MON_DISK_S	(MON$S_DISK)
#define MonitorDiskSize	(MON$S_DISK)

struct	mon_disk {
	char	mon_type,		/* MON$C_DISK */
		mon_flag ;		/* Other information */
	short	mon_length ;		/* MON$S_DISK */
/*
 *	Static data.
 */
	char	mon_name[DEV_SIZE+1] ;	/* disk name */
	short	mon_unit,		/* unit number */
		mon_dk,			/* system disk number */
		mon_index ;		/* internal index */
	long	mon_disk ;		/* device specific info */
	float	mon_mspw ;		/* dk_mspw - static */
/*
 *	Performance data.
 */
	long	mon_time,		/* dk_time */
		mon_seek,		/* dk_seek */
		mon_xfer,		/* dk_xfer */
		mon_wds ;		/* dk_wds */
/*
 *	Once upon a time this record was maintained as a linked list.
 *	The pointer to next record is now reserved for "future use".
 */
	long	mon_rffu[1] ;		/* reserved */
};

/*
 *	The number free memory pages.  The number of free pages is
 *	also kept in the MEMORY structure, but if you are only interested
 *	in the free memory, you can use this record.
 */
#define	MON$C_FREE	(7)
#define	MON_FREE	(MON$C_FREE)
#define MonitorFree	(MON$C_FREE)

#define MON$M_FREE	(1 << MON$C_FREE)
#define	MON_FREE_M	(MON$M_FREE)
#define MonitorFreeMask	(MON$M_FREE)

#define	MON$S_FREE	(sizeof(struct mon_free))
#define	MON_FREE_S	(MON$S_FREE)
#define MonitorFreeSize	(MON$S_FREE)

struct	mon_free {
	char	mon_type,		/* MON$C_FREE */
		mon_flag ;		/* Other information */
	short	mon_length ;		/* MON$S_FREE */

	int	mon_freemem ;		/* free memory in pages */
};

/*
 *	The fork stats.
 */
#define	MON$C_FORK	(8)
#define	MON_FORK	(MON$C_FORK)
#define MonitorFork	(MON$C_FORK)

#define MON$M_FORK	(1 << MON$C_FORK)
#define	MON_FORK_M	(MON$M_FORK)
#define MonitorForkMask	(MON$M_FORK)

#define	MON$S_FORK	(sizeof(struct mon_fork))
#define	MON_FORK_S	(MON$S_FORK)
#define MonitorForkSize	(MON$S_FORK)

struct	mon_fork {
	char	mon_type,		/* MON$C_FORK */
		mon_flag ;		/* Other information */
	short	mon_length ;		/* MON$S_FORK */

	int	mon_fork,		/* number of forks */
		mon_fork_size, 		/* size of forks */
		mon_vfork,		/* number of vforks */
		mon_vfork_size ;	/* size of vforks */
};

/*
 *	Paging information.
 */
#define	MON$C_PAGE	(9)
#define	MON_PAGE	(MON$C_PAGE)
#define MonitorPage	(MON$C_PAGE)

#define MON$M_PAGE	(1 << MON$C_PAGE)
#define	MON_PAGE_M	(MON$M_PAGE)
#define MonitorPageMask	(MON$M_PAGE)

#define	MON$S_PAGE	(sizeof(struct mon_page))
#define	MON_PAGE_S	(MON$S_PAGE)
#define MonitorPageSize	(MON$S_PAGE)

struct	mon_page {
	char	mon_type,		/* MON$C_PAGE */
		mon_flag ;		/* Other information */
	short	mon_length ;		/* MON$S_PAGE */

	int	mon_deficit,		/* _deficit */
		mon_freemem ;		/* _freemem */

	unsigned mon_pswpin,		/* pages swapped in */
		 mon_pswpout,		/* pages swapped out */
		 mon_pgin,		/* pageins */
		 mon_pgout,		/* pageouts */
		 mon_pgpgin,		/* pages paged in */
		 mon_pgpgout,		/* pages paged out */
		 mon_intrans,		/* intransit blocking page faults */
		 mon_pgrec,		/* total page reclaims */
		 mon_xsfrec,		/* in free list rather than on swapdev */
		 mon_xifrec,		/* in free list rather than in filsys */
		 mon_exfod,		/* pages filled on demand from a.out */
		 mon_zfod,		/* pages zero filled on demand */
		 mon_vrfod,		/* fills of pages mapped by vread() */
		 mon_nexfod,		/* number of exfod's created */
		 mon_nzfod,		/* number of zfod's created */
		 mon_nvrfod,		/* number of vrfod's created */
		 mon_pgfrec,		/* page reclaims from free list */
		 mon_faults,		/* total faults taken */
		 mon_scan,		/* scans in page out daemon */
		 mon_rev,		/* revolutions of the hand */
		 mon_seqfree,		/* pages taken from sequential programs */
		 mon_dfree,		/* pages freed by daemon */
		 mon_fastpgrec,		/* fast reclaims in locore */
		 mon_swpin,		/* swapins */
		 mon_swpout ;		/* swapouts */
};

/*
 *	The "number of process in various states" info.
 */
#define MON$C_PROC	(10)
#define	MON_PROC	(MON$C_PROC)
#define MonitorProc	(MON$C_PROC)

#define MON$M_PROC	(1 << MON$C_PROC)
#define	MON_PROC_M	(MON$M_PROC)
#define MonitorProcMask	(MON$M_PROC)

#define	MON$S_PROC	(sizeof(struct mon_proc))
#define	MON_PROC_S	(MON$S_PROC)
#define MonitorProcSize	(MON$S_PROC)

struct	mon_proc {
	char	mon_type,		/* MON$C_PROC */
		mon_flag ;		/* Other information */
	short	mon_length ;		/* MON$S_PROC */

	short	mon_rq,			/* length of run queue */
		mon_dw,			/* jobs in "disk wait" */
		mon_pw,			/* jobs in page wait */
		mon_sl,			/* jobs sleeping in core */
		mon_sw ;		/* swaped jobs */
};

/*
 *	The physical swap space usage info.
 */
#define	MON$C_SWAP	(11)
#define	MON_SWAP	(MON$C_SWAP)
#define MonitorSwap	(MON$C_SWAP)

#define MON$M_SWAP	(1 << MON$C_SWAP)
#define	MON_SWAP_M	(MON$M_SWAP)
#define MonitorSwapMask	(MON$M_SWAP)

#define	MON$S_SWAP	(sizeof(struct mon_swap))
#define	MON_SWAP_S	(MON$S_SWAP)
#define MonitorSwapSize	(MON$S_SWAP)

#define	MON$C_MAXSWAP	(20)
#define	MON_MAXSWAP	(MON$C_MAXSWAP)
#define MonitorMaxSwap	(MON$C_MAXSWAP)

struct	mon_swap {
	char	mon_type,		/* MON$C_SWAP */
		mon_flag ;		/* Other information */
	short	mon_length ;		/* MON$S_SWAP */

	/*
 	 *	In V4.0 dmmin will be unused and the value of swapfrag
	 *	will be put in dmmax.
	 */
	int	mon_dmmin ;		/* the value of dmmin */
	int	mon_dmmax ;		/* the value of dmmax */
#define	mon_swapfrag	mon_dmmax

	int	mon_total, 		/* Total space available */
		mon_text, 		/* text space */
		mon_smem, 		/* shared memory */
		mon_free, 		/* space free */
		mon_used, 		/* Swap space in use */
		mon_wasted ;		/* space wasted */

	/*
	 *	The usage of available space.  If you take the
	 *	index of a non-zero value of this array and
	 *	do a left of one with it (1 << index), that
	 *	the size in kilobytes of that entry.  V4.0
	 *	systems will only use one member of this array
	 *	but it will be the appropriate one.  A future
	 *	version of monitor that doesn't have to support
	 *	pre-V4.0 systems will just count swapfrag's.
	 */
	int	mon_avail[MON$C_MAXSWAP] ;
};

/*
 *	Tape I/O information.  This record isn't used.  Do I
 *	really think that tape stats will get added someday?
 *	Should I bother keeping it around?
 *
 *	Answer: Only until I need another record because of
 *	readv/writev vector limit.
 */
#define	MON$C_TAPE	(12)
#define	MON_TAPE	(MON$C_TAPE)
#define MonitorTape	(MON$C_TAPE)

#define MON$M_TAPE	(1 << MON$C_TAPE)
#define	MON_TAPE_M	(MON$M_TAPE)
#define MonitorTapeMask	(MON$M_TAPE)

#define	MON$S_TAPE	(sizeof(struct mon_tape))
#define	MON_TAPE_S	(MON$S_TAPE)
#define MonitorTapeSize	(MON$S_TAPE)

struct	mon_tape {
	char	mon_type,		/* MON$C_TAPE */
		mon_flag ;		/* Other information */
	short	mon_length ;		/* MON$S_TAPE */
};

/*
 *	The number of users logged in.
 */
#define MON$C_USER	(13)
#define	MON_USER	(MON$C_USER)
#define MonitorUser	(MON$C_USER)

#define MON$M_USER	(1 << MON$C_USER)
#define	MON_USER_M	(MON$M_USER)
#define MonitorUserMask	(MON$M_USER)

#define	MON$S_USER	(sizeof(struct mon_user))
#define	MON_USER_S	(MON$S_USER)
#define MonitorUserSize	(MON$S_USER)

struct	mon_user {
	char	mon_type,		/* MON$C_USER */
		mon_flag ;		/* Other information */
	short	mon_length ;		/* MON$S_USER */

	int	mon_user ;		/* number of users logged on */
};

/*
 *	Network interface info, on a per interface basis.
 *
 *	In some future version I'll add byte counts in addition
 *	to packet counts since this is much more interesting.
 */
#define	MON$C_NETIF		(14)
#define	MON_NETIF		(MON$C_NETIF)
#define MonitorNetif		(MON$C_NETIF)

#define MON$M_NETIF		(1 << MON$C_NETIF)
#define	MON_NETIF_M		(MON$M_NETIF)
#define MonitorNetifMask	(MON$M_NETIF)

#define	MON$S_NETIF		(sizeof(struct mon_netif))
#define	MON_NETIF_S		(MON$S_NETIF)
#define MonitorNetifSize	(MON$S_NETIF)

struct	mon_netif {
/*
 *	Static data
 */
	char	mon_type,		/* MON$C_NETIF */
		mon_flag ;		/* Other information */
	short	mon_length ;		/* MON$S_NETIF */
	char	mon_name[IFNAMSIZ+1] ;	/* interface name 'lo' or 'de' */
	short	mon_unit,		/* unit number */
		mon_if,			/* like the "dk" number for disks */
		mon_index ;		/* internal netif number */
	long	mon_netif ;		/* device specific information */
/*
 *	Dynamic data
 */
	short	mon_if_flags ;		/* up/down, broadcast, etc */
	int	mon_ipackets,		/* input packets */
		mon_ierrors,		/* input errors */
		mon_opackets,		/* output packets */
		mon_oerrors,		/* output errors */
		mon_collisions ;	/* collisions */

	long	mon_rffu[1];		/* reserved */
/*
 *	Useful pointer.
 */
	struct ifnet	 *mon_ifnet ;	/* address of kernel ifnet struct */
};

/*
 *	All the memory info.
 */
#define	MON$C_MEMORY		(15)
#define	MON_MEMORY		(MON$C_MEMORY)
#define MonitorMemory		(MON$C_MEMORY)

#define MON$M_MEMORY		(1 << MON$C_MEMORY)
#define	MON_MEMORY_M		(MON$M_MEMORY)
#define MonitorMemoryMask	(MON$M_MEMORY)

#define	MON$S_MEMORY		(sizeof(struct mon_memory))
#define	MON_MEMORY_S		(MON$S_MEMORY)
#define MonitorMemorySize	(MON$S_MEMORY)

struct	mon_memory {
	char	mon_type,		/* MON$C_MEMORY */
		mon_flag ;		/* Other information */
	short	mon_length ;		/* MON$S_MEMORY */

	int	mon_vm,			/* total virtual memory */
		mon_avm,		/* active vitrual memory */
		mon_rm,			/* total real memory */
		mon_arm,		/* active real memory */
		mon_vmtxt,		/* virtual memory used by text */
		mon_avmtxt,		/* active vitrual memory used by text */
		mon_rmtxt,		/* real memory used by text */
		mon_armtxt,		/* active real memory used by text */
		mon_free ;		/* free memory */
};

/*
 *	The load averages.  It would be nice if Ultrix would #define
 *	the number of load averages, but I will do it for now.
 */
#define	MON$C_LOADAVE		(16)
#define	MON_LOADAVE		(MON$C_LOADAVE)
#define MonitorLoadave		(MON$C_LOADAVE)

#define MON$M_LOADAVE		(1 << MON$C_LOADAVE)
#define	MON_LOADAVE_M		(MON$M_LOADAVE)
#define MonitorLoadaveMask	(MON$M_LOADAVE)

#define	MON$S_LOADAVE		(sizeof(struct mon_loadave))
#define	MON_LOADAVE_S		(MON$S_LOADAVE)
#define MonitorLoadaveSize	(MON$S_LOADAVE)

#define	MON$N_LOADAVE		(3)	/* Number of load averages */
#define	MON_MAXLOADAVE		(MON$N_LOADAVE)
#define MonitorMaxLoadave	(MON$N_LOADAVE)

struct	mon_loadave {
	char	mon_type, 		/* MON$C_LOADAVE */
		mon_flag ;		/* Other information */
	short	mon_length ;		/* length */

	int	mon_filler ;			/* padding for VAX */
	double	mon_loadave[MON$N_LOADAVE] ;	/* load averages */
};

/*
 *	Structure for storing per process information.
 */
#define	MON$C_PID	(17)
#define	MON_PID		(MON$C_PID)
#define MonitorPID	(MON$C_PID)

#define	MON$M_PID	(1 << MON$C_PID)
#define	MON_PID_M	(MON$M_PID)
#define MonitorPIDMask	(MON$M_PID)

#define	MON$S_PID	(sizeof(struct mon_pid))
#define	MON_PID_S	(MON$S_PID)
#define MonitorPIDSize	(MON$S_PID)

#define	MON$S_USERNAME	(16)
#define	MON_USERNAME	(MON$S_USERNAME)
#define MonitorUsername	(MON$S_USERNAME)

#define	MON$S_GROUPNAME		(32)
#define	MON_GROUPNAME		(MON$S_GROUPNAME)
#define MonitorGroupname	(MON$S_GROUPNAME)

struct mon_pid {
	char	mon_type,		/* MON$C_PID */
		mon_flag ;		/* currently unused */
	short	mon_length ;		/* MON$S_PID */

	char	mon_comm[MAXNAMLEN+1],	/* command name */
		mon_stat,		/* process status */
		mon_pri,		/* priority, negative is high */
		mon_nice ;		/* How "nice" is the process */

	short	mon_pgrp,		/* process group */
		mon_pid ;		/* pid from the proc structure */
	dev_t	mon_ttyd ;		/* controlling tty */
	caddr_t	mon_wchan ;		/* the "wait channel" */

	size_t	mon_rssize ;		/* resident set size */

	int	mon_pflag,		/* process flags */
		mon_cpundx ;		/* index of CPU, from soft pcb */

	struct mon_ucred {
		u_short	cr_ref ;
		short	cr_uid ;
		short	cr_gid ;
		int	cr_groups[NGROUPS] ;
		short	cr_ruid ;
		short	cr_rgid ;
	} mon_cred ;			/* credential structure */

	struct rusage	mon_self,	/* usage stats for self */
			mon_child ;	/* usage stats for children */

	struct proc 	*mon_proc ;	/* kernel address of proc structure */

	char	mon_username[MON$S_USERNAME+1],		/* Name of effective uid */
		mon_realuser[MON$S_USERNAME+1],		/* Name of real uid */
		mon_groupname[MON$S_GROUPNAME+1],	/* Name of effective gid */
		mon_realgroup[MON$S_GROUPNAME+1] ;	/* Name of real gid */
} ;

/*
 *	This record will be used to keep buffer cache information.
 */
#define MON$C_BUF	(18)
#define	MON_BUF		(MON$C_BUF)
#define MonitorBuf	(MON$C_BUF)

#define MON$M_BUF	(1 << MON$C_BUF)
#define	MON_BUF_M	(MON$M_BUF)
#define MonitorBufMask	(MON$M_BUF)

#define	MON$S_BUF	(sizeof(struct mon_buf))
#define	MON_BUF_S	(MON$S_BUF)
#define MonitorBufSize	(MON$S_BUF)

/*
 *	More detailed information about the fields.
 *
 *	The mon_bufpages field is the size of the buffer cache in 
 *	bytes.  The field mon_nused is the number of buffers associated 
 *	with a device.  The field mon_bcount is the sum of the b_bcount 
 *	element of the buffer headers.  The field mon_bufsize is the 
 *	sum of the b_bufsize element.  I have seen cases where these 
 *	were the same size and where they were different.  The field
 *	mon_cache is the number of buffers that had the B_CACHE bit
 *	set in their flag.
 *
 *	The same size appeared on a diskless DECstation 3100.  I don't
 *	know if being DS3100 or being diskless was significant to this 
 *	case.
 *
 *	One BUF struct is allocated for each device that has buffers
 *	attached to it.  A few extra are allocated since monitor doesn't
 *	handle the number of a particular record type changing yet.  The
 *	result of this is that I allocate enough for all the potential
 *	devices and then use only that many.  The first BUF record will 
 *	contain the totals for all the buffer cache. 
 */
struct mon_buf {
	char	mon_type,		/* MON$C_BUF */
		mon_flag ;		/* see values for flags above */
	short	mon_length ;		/* MON$S_BUF */

	int	mon_nbuf,		/* number of buffers */
		mon_bufpages,		/* pages allocated to buffers */
		mon_nused,		/* number of buffers used */
		mon_bcount,		/* amount of memory in use */
		mon_bufsize ;		/* amount of memory allocated */

	/*
	 *	These count which of the b_flags are set.  The
	 *	choice was somewhat arbitrary.
	 */
	int	mon_cache,		/* The CACHE bit was set */
		mon_delwri,		/* The DELWRI bit was set */
		mon_read,		/* the READ bit was set */
		mon_busy,		/* the BUSY bit was set */
		mon_done,		/* the DONE bit was set */
		mon_inval,		/* the INVAL bit was set */
		mon_error,		/* the ERROR bit was set */
		mon_rffu[4] ;		/* save room for four other flags */
		
	dev_t	mon_device ;		/* which device */
					/* the compiler will probably pad here */

	int	mon_inode ;		/* "hot" {g,i}node.  For future use */

	char	mon_fsname[MAXPATHLEN+1] ;
};

/* 
 *	This record will be used to keep NFS information.  This
 *	will probably be implemented in version past the one for
 *	ULTRIX V4.0.
 */
#define MON$C_NFS	(19)
#define	MON_NFS		(MON$C_NFS)
#define MonitorNFS	(MON$C_NFS)

#define MON$M_NFS	(1 << MON$C_NFS)
#define	MON_NFS_M	(MON$M_NFS)
#define MonitorNFSMask	(MON$M_NFS)

#define	MON$S_NFS	(sizeof(struct mon_nfs))
#define	MON_NFS_S	(MON$S_NFS)
#define MonitorNFSSize	(MON$S_NFS)

struct mon_nfs {
	char	mon_type,		/* MON$C_NFS */
		mon_flag ;		/* unused */
	short	mon_length ;		/* MON$S_NFS */

	int	mon_rffu ;		/* Reserved */
};

/* 
 *	This record will be used to keep namei cache information.
 *
 *	In V4.0 it doesn't appear that badhits and falsehits
 *	are counted.
 */
#define MON$C_NAMEI		(20)
#define	MON_NAMEI		(MON$C_NAMEI)
#define MonitorNamei		(MON$C_NAMEI)

#define MON$M_NAMEI		(1 << MON$C_NAMEI)
#define	MON_NAMEI_M		(MON$M_NAMEI)
#define MonitorNameiMask	(MON$M_NAMEI)

#define	MON$S_NAMEI		(sizeof(struct mon_namei))
#define	MON_NAMEI_S		(MON$S_NAMEI)
#define MonitorNameiSize	(MON$S_NAMEI)

struct mon_namei {
	char	mon_type,		/* MON$C_NAMEI */
		mon_flag ;		/* unused */
	short	mon_length ;		/* MON$S_NAMEI */

	long	mon_goodhits,		/* hits that we can reall use */
		mon_badhits,		/* hits we must drop */
		mon_falsehits,		/* hits with id mismatch */
		mon_miss,		/* misses */
		mon_long,		/* long names that ignore cache */
		mon_pass2,		/* names found with passes == 2 */
		mon_2passes ;		/* number of times we attempt it */
};

/*
 *	Statistics from the kernel memory allocator.  Reserved
 *	for future use.
 */
#define	MON$C_KMEM 	(21)
#define	MON_KMEM	(MON$C_KMEM)
#define MonitorKmem	(MON$C_KMEM)

#define	MON$M_KMEM 	(1 << MON$C_KMEM)
#define	MON_KMEM_M	(MON$M_KMEM)
#define MonitorKmemMask	(MON$M_KMEM)

#define	MON$S_KMEM 	(sizeof(struct mon_kmem))
#define	MON_KMEM_S	(MON$S_KMEM)
#define MonitorKmemSize	(MON$S_KMEM)

struct	mon_kmem {
	char	mon_type,		/* MON$C_KMEM */
		mon_flag ;		/* Other information */
	short	mon_length ;		/* MON$S_KMEM */

	long	mon_rffu[16] ;		/* set aside some space */
};

/*
 *	This record might be used to mark the end of record types
 *	and/or as a place holder for unimplimented record types
 *	that might slip into the data file.
 *
 *	This record will never normally occur.  A "panic" is in order
 *	if we actually see one.
 *
 *	In a future version I'll define the union before the panic
 *	record and make the size of the buffer:
 *
 *		sizeof(union) - sizeof(header)
 *
 *	Doing it now would change the size and I don't want to do
 *	that right now.
 */
#define	MON$C_PANIC		(22)	/* This record will never occur (normally) */
#define	MON_PANIC		(MON$C_PANIC)
#define MonitorPanic		(MON$C_PANIC)

#define	MON$M_PANIC		(1 << MON$C_PANIC)
#define	MON_PANIC_M		(MON$M_PANIC)
#define MonitorPanicMask	(MON$M_PANIC)

#define	MON$S_PANIC		(sizeof(struct mon_panic))
#define	MON_PANIC_S		(MON$S_PANIC)
#define MonitorPanicSize	(MON$S_PANIC)

struct	mon_panic {
	char	mon_type,		/* MON$C_PANIC */
		mon_flag ;		/* Other information */
	short	mon_length ;		/* MON$S_PANIC */

	char	mon_buffer[BUFSIZ] ;	/* some place to put the data */
};

/*
 *	A union of all the records in case somebody needs it.
 */
#define	MON$S_RECORD		(sizeof(union mon_record))
#define	MON_RECORD		(MON$C_RECORD)
#define MonitorRecord		(MON$C_RECORD)

/*
 *	I need to add mon_kmem to this.
 */
union	mon_record {
	struct mon_header  header ;
	struct mon_first   first ;
	struct mon_last	   last ;
	struct mon_sample  sample ;
	struct mon_reconf  reconf ;

	struct mon_cpu     cpu ;
	struct mon_tty     tty ;
	struct mon_disk    disk ;
	struct mon_free    free ;
	struct mon_fork    fork ;
	struct mon_page    page ;
	struct mon_proc    proc ;
	struct mon_swap    swap ;
	struct mon_tape    tape ;
	struct mon_user    user ;
	struct mon_netif   netif ;
	struct mon_memory  memory ;
	struct mon_loadave loadave ;
	struct mon_pid     pid ;
	struct mon_buf     buf ;
	struct mon_nfs     nfs ;
	struct mon_namei   namei ;

	struct mon_panic   panic ;
};

/*
 *	The number of record types.
 */
#define	MON$N_RECORDS		(22)
#define	MON_MAXRECORDS		(MON$N_RECORDS)
#define MonitorMaxRecords	(MON$N_RECORDS)

/*
 *	This is a summary of the record type numbers.
 *
 *	Control records
 *
 *	MON$C_FIRST	0	# the first record written to the file.
 *	MON$C_LAST	1	# hopefully the last record written
 *	MON$C_SAMPLE	2	# sample summary
 *	MON$C_RECONF	3	# reserved for future use
 *
 *	Data records
 *
 *	MON$C_CPU	4	# interrupts, system calls, time in states, etc
 *	MON$C_TTY	5	# tty I/O 
 *	MON$C_DISK	6	# disk I/O
 *	MON$C_FREE	7	# free memory
 *	MON$C_FORK	8	# fork data
 *	MON$C_PAGE	9	# paging data
 *	MON$C_PROC	10	# process data
 *	MON$C_SWAP	11	# swap space utilization (unused)
 *	MON$C_TAPE	12	# tape I/O (unused)
 *	MON$C_USER	13	# number of users
 *	MON$C_NETIF	14	# network interface data
 *	MON$C_MEMORY	15	# all memory information
 *	MON$C_LOADAVE	16	# load averages
 *	MON$C_PID	17	# process by pid
 *	MON$C_BUF	18	# buffer cache
 *	MON$C_NFS	19	# NFS information
 *	MON$C_NAMEI	20	# namei cache
 *	MON$C_KMEM	21	# Kernel memory allocator stats.
 *
 *	MON$C_PANIC	22	# This record will never occur (normally)
 */
