/*
 *	Author:  Alan Rollow, CSC/CS, Digital Equipment Corp.
 *	File:	 iovec.c
 *	Date:	 3/29/90
 *	Version: 1.14
 *
 *	iovec.c - Function(s) to manage the I/O vector.
 */
#ifndef	lint
static	char	SccsId[] = "@(#)iovec.c	1.14 (monitor) 3/29/90" ;
#endif

/*
 * Modification History
 * 
 * 27-June-1988 -- arr
 *
 *	Change include of monitor.h to include.h.
 *
 *	Change include of record.h to monitor.h.
 *
 * Feb. 10, 1989 -- arr
 *
 *	Added a case to the switch for the BUF records.
 *
 * Mar. 26, 1990 -- arr
 *
 *	Added hack to work-around DECmumble include file problem.
 *
 */

#include <nlist.h>
#include <stdio.h>
#include <signal.h>

#include <sys/types.h>
#include <sys/dk.h>
#include <sys/param.h>
#include <sys/dir.h>

#if defined(V4_ULTRIX) && defined(mips)
#	include <mips/cpu.h>
#endif

#include <sys/user.h>
#include <sys/buf.h>
#include <sys/uio.h>
#include <sys/socket.h>
#include <sys/vmsystm.h>
#include <sys/vmmeter.h>

#include <net/if.h>
#include <netinet/in.h>

#include "options.h"
#include "monitor.h"
#include "include.h"
#include "extern.h"

/*
 *	Count the number of records and initialize the I/O vector.
 */
init_iovec(op)
register OPTION	*op ;
{
	register int i, index = 0 ;

	for(i = 0; i < sizeof(op->opt_data) * NBBY; i++) {
		if((op->opt_data & (1 << i)) == 0 )
			continue ;

		switch( i ) {
		case MON$C_DISK:
			iov[index].iov_len = MON$S_DISK * n_disk ;
			iov[index].iov_base = (caddr_t)disk ;
			break ;
		case MON$C_NETIF:
			iov[index].iov_len = MON$S_NETIF * n_netif ;
			iov[index].iov_base = (caddr_t)netif ;
			break ;
		case MON$C_CPU:
			iov[index].iov_len = MON$S_CPU * n_cpu ;
			iov[index].iov_base = (caddr_t)cpu ;
			break ;
		case MON$C_BUF:
			iov[index].iov_len = MON$S_BUF * n_buf ;
			iov[index].iov_base = (caddr_t)mon_buf ;
			break ;
		default:
			iov[index].iov_len = records[i].size ;
			iov[index].iov_base = (caddr_t)records[i].addr;
			break ;
		}

		index++ ;
	}

/*
 *	Set externals.
 */
	n_records = index ;
}
