/*
 *	Author:  Alan Rollow, CSC/CS, Digital Equipment Corp.
 *	File:	 functions.c
 *	Date:	 3/29/90
 *	Version: 1.43
 *
 *	functions.c - The functions used by the read display function to print
 *	out the contents of the data records.
 */
#ifndef	lint
static	char	SccsId[] = "@(#)functions.c	1.43 (monitor) 3/29/90" ;
#endif

/*
 * Modification History
 * 
 * 27-June-1988 -- arr
 *
 *	Change include of monitor.h to include.h.
 *
 *	Change include of record.h to monitor.h.
 *
 * 29-June-1988 -- arr
 *
 *	Fixed f_first() to NULL terminate long version strings.
 *
 * 29-November-1988 -- arr
 *
 *	Removed sc_sp and sc_ps from the function to print the 
 *	LAST record.  These are not in the MIPS signal context
 *	and don't seem very useful.
 *
 * jan. 4, 1989 -- arr
 *
 *	Remove all the scp stuff.
 *
 * Jan. 5, 1989 -- arr
 *
 *	Fix the references to the mon_meter structure.
 *
 * Jan. 15, 1989 -- arr
 *
 *	Populate the functions to print swap data, buffer cache and
 *	namei cache..
 *
 * Jan. 24, 1989 -- arr
 *
 *	Move the f_buf and f_namei functions to buf.c and namei.c
 *	respectively.
 *
 * Week ending Feb. 18, 1989 -- arr
 *
 *	Added n_buf to f_first().
 *
 *	Moved title printf's from read.c to here.  I also
 *	now check the mon_flag field to see if the VALID
 *	bit is set.
 *
 *	Moved f_cpu() to cpu.c.
 *
 *	Moved f_first(), f_last() and f_sample() to sample.c.
 *
 *	Moved f_pid() to pid.c.
 *
 * Feb. 26, 1989 -- arr
 *
 *	Moved f_fork() to it's own file, fork.c.
 *
 * Mar. 26, 1990 -- arr
 *
 *	Added hack to work-around DECmumble include file problem.
 *
 */

#include <nlist.h>
#include <stdio.h>
#include <signal.h>

#include <sys/types.h>
#include <sys/buf.h>
#include <sys/file.h>
#include <sys/socket.h>
#include <sys/dk.h>
#include <sys/param.h>
#include <sys/dir.h>

#if defined(V4_ULTRIX) && defined(mips)
#	include <mips/cpu.h>
#endif

#include <sys/user.h>
#include <sys/vmsystm.h>
#include <sys/vmmeter.h>

#include <net/if.h>
#include <netinet/in.h>

#include "include.h"
#include "monitor.h"
#include "extern.h"

/*
 *	Functions that don't return (int).
 */
char	*str_disk(),
	*str_netif(),
	*str_stats(),
	*str_state(),
	*str_flags() ;

/*
 *	Print the record name and number.
 */
f_nop(p)
struct mon_header *p ;
{
	printf("%s (%d).\n", records[p->mon_type].string, p->mon_type);
}

/*
 *
 */
f_panic()
{
	printf("\tThis wasn't supposed to happen.\n") ;
}

/*
 *	Here start the functions to print out data records.
 */

f_disk(p)
struct mon_disk *p ;
{
	if((p->mon_flag & MON$M_VALID) == 0 )
		return ;

	printf("%s.\n", records[MON$C_DISK].string) ;

	printf("\tname:       %s%d\n", p->mon_name, p->mon_unit);
	printf("\tdk:         %d\n", p->mon_dk);
	printf("\tindex:      %d\n", p->mon_index);
	printf("\tdisk:       <%x>\n", p->mon_disk);

	printf("\tmspw:       %f\n", p->mon_mspw);
	printf("\ttime:       %u ticks\n", p->mon_time);
	printf("\tseek:       %u\n", p->mon_seek);
	printf("\txfer:       %u\n", p->mon_xfer);
	printf("\twds:        %u\n", p->mon_wds);
}

f_free(p)
struct mon_free *p ;
{
	if((p->mon_flag & MON$M_VALID) == 0 )
		return ;

	printf("%s.\n", records[MON$C_FREE].string) ;

	printf("\tfree: %d Kb.\n", pgtok(p->mon_freemem));
}

f_paging(p)
struct mon_page *p ;
{
	if((p->mon_flag & MON$M_VALID) == 0 )
		return ;

	printf("%s.\n", records[MON$C_PAGE].string) ;

	printf("\tdeficit:   %d\n", p->mon_deficit);
	printf("\tfreemem:   %d Kb.\n", pgtok(p->mon_freemem)) ;
	printf("\tpswpin:    %u\n", p->mon_pswpin);
	printf("\tpswpout:   %u\n", p->mon_pswpout);
	printf("\tpgin:      %u\n", p->mon_pgin);
	printf("\tpgout:     %u\n", p->mon_pgout);
	printf("\tpgpgin:    %u\n", p->mon_pgpgin);
	printf("\tpgpgout:   %u\n", p->mon_pgpgout);
	printf("\tintrans:   %u\n", p->mon_intrans);
	printf("\tpgrec:     %u\n", p->mon_pgrec);
	printf("\txsfrec:    %u\n", p->mon_xsfrec);
	printf("\txifrec:    %u\n", p->mon_xifrec);
	printf("\texfod:     %u\n", p->mon_exfod);
	printf("\tzfod:      %u\n", p->mon_zfod);
	printf("\tvrfod:     %u\n", p->mon_vrfod);
	printf("\tnexfod:    %u\n", p->mon_nexfod);
	printf("\tnzfod:     %u\n", p->mon_nzfod);
	printf("\tnvrfod:    %u\n", p->mon_nvrfod);
	printf("\tpgfrec:    %u\n", p->mon_pgfrec);
	printf("\tfaults:    %u\n", p->mon_faults);
	printf("\tscan:      %u\n", p->mon_scan);
	printf("\trev:       %u\n", p->mon_rev);
	printf("\tseqfree:   %u\n", p->mon_seqfree);
	printf("\tdfree:     %u\n", p->mon_dfree);
	printf("\tfastpgrec: %u\n", p->mon_fastpgrec);
	printf("\tswpout:    %u\n", p->mon_swpout);
	printf("\tswpin:     %u\n", p->mon_swpin);
}

f_process(p)
struct mon_proc *p ;
{
	if((p->mon_flag & MON$M_VALID) == 0 )
		return ;

	printf("%s.\n", records[MON$C_PROC].string) ;

	printf("\trq:   %d\n", p->mon_rq);
	printf("\tdw:   %d\n", p->mon_dw);
	printf("\tpw:   %d\n", p->mon_pw);
	printf("\tsl:   %d\n", p->mon_sl);
	printf("\tsw:   %d\n", p->mon_sw);
}

f_swap(p)
struct mon_swap *p ;
{
	int	i ;

	if((p->mon_flag & MON$M_VALID) == 0 )
		return ;

	printf("%s.\n", records[MON$C_SWAP].string) ;

	printf("\ttotal:    %d Kb.\n", btok(p->mon_total)) ;
	printf("\tused:     %d Kb.\n", btok(p->mon_used)) ;
	printf("\ttext:     %d Kb.\n", btok(p->mon_text)) ;
	printf("\tsmem:     %d Kb.\n", btok(p->mon_smem)) ;
	printf("\tfree:     %d Kb.\n", btok(p->mon_free)) ;
	printf("\twasted:   %d Kb.\n", btok(p->mon_wasted)) ;

	for(i = 0; i < MON$C_MAXSWAP; i++)
		if( p->mon_avail[i] )
			printf("\tavail[%d]: %d of %d Kb.\n",
				i, p->mon_avail[i], 1 << i) ;
}

/*
 *	Not Implimented.  This is used for the SWAP, BUF, NFS and NAMEI
 *	records.
 */
f_ni()
{
	printf("\tNot implimented.\n");
}

/*
 *	Number of users.
 */
f_user(p)
struct mon_user *p ;
{
	if((p->mon_flag & MON$M_VALID) == 0 )
		return ;

	printf("%s.\n", records[MON$C_USER].string) ;

	printf("\tusers:      %d\n", p->mon_user);
}

f_memory(p)
struct mon_memory *p ;
{
	if((p->mon_flag & MON$M_VALID) == 0 )
		return ;

	printf("%s.\n", records[MON$C_MEMORY].string) ;

	printf("\tvm:         %d Kb.\n", pgtok(p->mon_vm));
	printf("\tavm:        %d Kb.\n", pgtok(p->mon_avm));
	printf("\trm:         %d Kb.\n", pgtok(p->mon_rm));
	printf("\tarm:        %d Kb.\n", pgtok(p->mon_arm));
	printf("\tvmtxt:      %d Kb.\n", pgtok(p->mon_vmtxt));
	printf("\tavmtxt:     %d Kb.\n", pgtok(p->mon_avmtxt));
	printf("\trmtxt:      %d Kb.\n", pgtok(p->mon_rmtxt));
	printf("\tarmtxt:     %d Kb.\n", pgtok(p->mon_armtxt));
	printf("\tfree:       %d Kb.\n", pgtok(p->mon_free));
}

f_loadave(p)
struct mon_loadave *p ;
{
	register i ;

	if((p->mon_flag & MON$M_VALID) == 0 )
		return ;

	printf("%s.\n", records[MON$C_LOADAVE].string) ;

	for(i = 0; i < MON$N_LOADAVE; i++)
		printf("\t[%d]: %.2f\n", i, p->mon_loadave[i]);
}
