/*
 *	Author:  Alan Rollow, CSC/CS, Digital Equipment Corp.
 *	File:	 disk.c
 *	Date:	 3/29/90
 *	Version: 1.26
 *
 *	disk.c - Based the information in the mon_disk structure
 *	calculate the things of interest.
 *
 *	calculate_disk(index, kbps, tps, msps)
 *	int	index ;
 *	double	*kbps, *tps ;
 *	int	*msps ;
 *
 *	kbps - Kilobytes transfered per second.
 *	tps  - Transfers per second.
 *	msps - Milli/micro seconds per seek (or transfer on DSA disks).
 */
#ifndef	lint
static	char	SccsId[] = "@(#)disk.c	1.26	(monitor) 3/29/90" ;
#endif

/*
 * Modification History
 * 
 * 27-June-1988 -- arr
 *
 *	Change include of monitor.h to include.h.
 *
 *	Change include of record.h to monitor.h.
 *
 * Mar. 26, 1990 -- arr
 *
 *	Added hack to work-around DECmumble include file problem.
 *
 */

#include <stdio.h>
#include <signal.h>
#include <curses.h>
#include <nlist.h>

#include <sys/types.h>
#include <sys/dk.h>
#include <sys/param.h>
#include <sys/dir.h>

#if defined(V4_ULTRIX) && defined(mips)
#	include <mips/cpu.h>
#endif

#include <sys/user.h>
#include <sys/buf.h>
#include <sys/socket.h>
#include <sys/vmsystm.h>
#include <sys/vmmeter.h>

#include <net/if.h>
#include <netinet/in.h>

#include "monitor.h"
#include "include.h"
#include "options.h"
#include "extern.h"

/*
 *	Default display.
 */
extern	int	lines ;		/* length of screen being used */
extern	WINDOW	*wp ;

/*
 *	Given an address to a mon_disk structure calculate:
 *
 *		kbps - Kilobytes per second.
 *		tps  - Transfers per second.
 *		msps - Milliseconds per seek.
 */
double	calculate_disk(index, kbps, tps, msps)
register index ;
double	*kbps, *tps ;
int	*msps ;
{
	double	xfer_time, idle_time, words, etime, delta_disk() ;

	etime = delta_disk(index, sample.mon_ticks) ;

	/*
	 *	The algorithm for these calculations was derived
	 *	the iostat(1) and vmstat(1) programs.  It wasn't
	 *	commented there either.
	 *
	 *	Someday, I promise...
	 */
	words = (unsigned)disk[index].mon_wds * 32.0 ;
	xfer_time = disk[index].mon_mspw * words ;
	idle_time = (disk[index].mon_time/(double)first.mon_hz) - xfer_time ;

	if( xfer_time < 0 ) {
		idle_time += xfer_time ;
		xfer_time = 0 ;
	}

	if( idle_time < 0 ) {
		xfer_time += idle_time ;
		idle_time = 0 ;
	}

	*kbps = words / 512.0 / etime ;
	*tps  = disk[index].mon_xfer / etime ;

	if( disk[index].mon_seek )
		*msps = (idle_time * 1000) / disk[index].mon_seek ;
	else if( disk[index].mon_xfer )
		*msps = (idle_time * 1000) / disk[index].mon_xfer ;
	else
		*msps = 0 ;

	return etime ;
}

#define	DISK_TITLE	(3)
#define	DISK_OFFSET	(6)
#define	DISK_WIDTH	(0)

#define	DISK_BASE_LINES	(5)

/*
 *	Print the header for disk I/O data.
 *
 *	ARGSUSED
 */
open_disk(op)
OPTION	*op ;
{
	register disk_entry = 0, x, y = 3, i ;
	char	 *heading = "Disk:   kbps   tps   msps" ;

	lines = DISK_BASE_LINES ;

	sample_header() ;

	/*
 	 *	Print the headings side-by-side.
	 */
	wmove(wp, DISK_TITLE, 0) ;
	wprintw(wp, "%s", heading);

	wmove(wp, DISK_TITLE, COLS / 2) ;
	wprintw(wp, "%s", heading);

	for(i = 0; i < n_disk; i++) {
		if( disk_entry % 2 )
			x = COLS / 2 ;
		else {
			x = 0 ;
			y++ ;
			lines++ ;
		}

		disk_entry++ ;

		wmove(wp, y, x) ;
		wprintw(wp, "%s%d", disk[i].mon_name, disk[i].mon_unit);
	}
}

/*
 *	"magnify" the disk I/O information.  The only really
 *	interesting thing to do with the disk I/O data is
 *	to make sure that all of it can be seen.  If the screen
 *	is 24 lines long, then it is long enough.  I also added
 *	one decimal place to the floating point numbers to make
 *	them look different from the main screen.
 *
 *	ARGSUSED
 */
magnify_disk(op)
OPTION	*op ;
{
	register disk_entry = 0, y = 3, x = 0, i ;
	double	 kbps, tps, etime, calculate_disk() ;
	int	 msps ;

	for(i = 0; i < n_disk; i++) {
		if( disk_entry++ % 2 )
			x = (COLS / 2) + DISK_OFFSET ;
		else {
			x = DISK_OFFSET ;
			y++ ;
		}

		etime = calculate_disk(i, &kbps, &tps, &msps);

		wmove(wp, y, x) ;
		wprintw(wp, "%6.1f %5.1f  %5d", kbps, tps, msps);
	}

	sample_body(etime) ;
}
