/*
 *	Author:  Alan Rollow, CSC/CS, Digital Equipment Corp.
 *	File:	 data.c
 *	Date:	 3/29/90
 *	Version: 1.45
 *
 *	data.c - This file contains declarations for global data.
 */
#ifndef	lint
static	char	SccsId[] = "@(#)data.c	1.45 (monitor) 3/29/90" ;
#endif

/*
 * Modification History
 * 
 * 27-June-1988 -- arr
 *
 *	Change include of monitor.h to include.h.
 *
 *	Change include of record.h to monitor.h.
 *
 *  4-January-1989 -- arr
 *
 *	Added architecture info.	
 *
 * Jan. 13, 1989 -- arr
 *
 *	Added items to the name list for swap space collection.
 *
 * Jan. 16, 1989 -- arr
 *
 *	Added namelist and other data for buffer cache and namei cache.
 *
 * Feb. 10, 1989 -- arr
 *
 *	Changed mon_buf to a pointer and added n_buf.  Also made
 *	changes for the addition of the RECONF record.
 *
 * Mar. 26, 1990 -- arr
 *
 *	Added hack to work-around DECmumble include file problem.
 *
 */

#include <nlist.h>
#include <stdio.h>
#include <signal.h>
#include <curses.h>

#include <sys/types.h>
#include <sys/buf.h>
#include <sys/uio.h>
#include <sys/dk.h>
#include <sys/param.h>
#include <sys/dir.h>

#if defined(V4_ULTRIX) && defined(mips)
#	include <mips/cpu.h>
#endif

#include <sys/user.h>
#include <sys/socket.h>
#include <sys/vmsystm.h>
#include <sys/vmmeter.h>

#include <net/if.h>
#include <netinet/in.h>

#include "include.h"
#include "monitor.h"

/*
 *	The version consists of a major version number and a
 *	minor version number.  It will be stored in a dev_t
 *	so I can use the Ultrix major/minor number macro's.
 */
dev_t	record_version = makedev(MON$C_MAJOR, MON$C_MINOR) ;

/*
 *	The machine architecture that this version
 *	was compiled on.
 */
#ifdef	vax
int	architecture = MON$C_VAX ;
#endif
#ifdef	mips
int	architecture = MON$C_MIPS ;
#endif

/*
 *	The kernal data structures we are interested in.
 */
struct nlist	namelist[] = {
/*
 *	Memory data, process counts.
 */
	{ "_freemem" },		/* NM_FREE */
	{ "_total" },		/* NM_TOTAL */
/*
 *	Paging data, CPU instrumentation, Fork info
 */
	{ "_avenrun" },		/* NM_LOADAVE */
	{ "_rate" },		/* NM_RATE */
	{ "_sum", },		/* NM_SUM */
	{ "_deficit" },		/* NM_DEFICIT */
	{ "_forkstat" },	/* NM_FORK */
/*
 *	Disk data
 */
	{ "_dk_busy" },		/* NM_DK_BUSY */
	{ "_dk_time" },		/* NM_DK_TIME */
	{ "_dk_seek" },		/* NM_DK_SEEK */
	{ "_dk_xfer" },		/* NM_DK_XFER */
	{ "_dk_wds" },		/* NM_DK_WDS */
/*
 *	TTY data
 */
	{ "_tk_nin" },		/* NM_TTY_IN */
	{ "_tk_nout" },		/* NM_TTY_OUT */
/*
 *	Names of things and other "static" data.
 */
	{ "_dk_mspw" },		/* NM_DK_MSPW */
	{ "_ubdinit" },		/* NM_UBDINIT */
	{ "_mbdinit" },		/* NM_MBDINIT */
	{ "_ifnet" },		/* NM_IFNET */
	{ "_hz" },		/* NM_HZ */
	{ "_physmem" },		/* NM_PHYSMEM */
	{ "_version" },		/* NM_VERSION */
	{ "_cpu" },		/* NM_CPU */
	{ "_cpudata" },		/* NM_CPUDATA */
	{ "_maxcpu" },		/* NM_MAXCPU */
	{ "_cpu_subtype" },	/* NM_CPU_SUBTYPE */
/*
 *	When the system booted.
 */
	{ "_boottime" },	/* NM_BOOT */
/*
 *	This will only be used by the MIPS based systems,
 *	but it doesn't need to be #ifdef'd.
 */
	{ "_cpu_systype" },	/* NM_CPU_SYSTYPE */
/*
 *	Namei cache.
 */
	{ "_nchstats" },	/* NM_NAMEI */
/*
 *	Buffer cache
 */
	{ "_buf" },		/* NM_BUF */
	{ "_nbuf" },		/* NM_NBUF */
	{ "_bufpages" },	/* NM_BUFPAGES */
/*
 *	V4.0 stuff.
 */
	{ "_smp" },		/* NM_SMP */
/*
 *	End of list.
 */
	{ 0 }
};

/*
 *	The place we are going to store the data.  The first three are
 *	preallocated control records.
 */
struct	mon_first	first  = { MON$C_FIRST,  0, MON$S_FIRST };
struct	mon_last	last   = { MON$C_LAST,   0, MON$S_LAST };
struct	mon_sample	sample = { MON$C_SAMPLE, 0, MON$S_SAMPLE };
struct  mon_reconf	reconf = { MON$C_RECONF, 0, MON$S_RECONF };

/*
 *	These down to the next comment section are preallocated
 *	data records.
 */
struct	mon_tty		tty      = { MON$C_TTY,     MON$M_VALID, MON$S_TTY } ;
struct	mon_page	mon_page = { MON$C_PAGE,    MON$M_VALID, MON$S_PAGE } ;
struct	mon_proc	mon_proc = { MON$C_PROC,    MON$M_VALID, MON$S_PROC } ;
struct	mon_swap	mon_swap = { MON$C_SWAP,    MON$M_VALID, MON$S_SWAP } ;
struct	mon_user	mon_user = { MON$C_USER,    MON$M_VALID, MON$S_USER } ;
struct	mon_memory	memory   = { MON$C_MEMORY,  MON$M_VALID, MON$S_MEMORY } ;
struct	mon_free	mon_free = { MON$C_FREE,    MON$M_VALID, MON$S_FREE } ;
struct	mon_loadave	loadave  = { MON$C_LOADAVE, MON$M_VALID, MON$S_LOADAVE } ;
struct	mon_pid		mon_pid  = { MON$C_PID,	    MON$M_VALID, MON$S_PID } ;
struct	mon_fork	mon_fork = { MON$C_FORK,    MON$M_VALID, MON$S_FORK } ;
struct	mon_namei	namei    = { MON$C_NAMEI,   MON$M_VALID, MON$S_NAMEI } ;
struct  mon_kmem	mon_kmem = { MON$C_KMEM,    0,           MON$S_KMEM } ;

/*
 *	"Dynamic" records.  These records initialized on a per
 *	whatever basis.
 */
struct	mon_disk	disk[DK_NDRIVE] ;

struct	mon_cpu		*cpu = 0 ;
struct	mon_netif	*netif = 0 ;
struct  mon_buf		*mon_buf = 0 ;

/*
 *	Other assorted globals.
 */
int	kmem ;			/* file descriptor for /dev/kmem */
int	mem ;			/* file descriptor for /dev/mem */
int	swap ;			/* file descriptor for /dev/drum */
int	killed = 0 ;		/* Gets set when we are asked to die */
int	maxcpu ;		/* Number of configured processors (live) */

unsigned n_cpu = 0,		/* Number of CPUs */
	 n_buf = 0,		/* Number of buf records */
	 n_disk = 0,		/* Number of disks */
	 n_netif = 0 ;		/* Number of network interfaces */

/*
 *	Array of records, sizes and names used by save and replay.
 */
struct records records[] = {
	(char *)&first,		MON$S_FIRST,	"First",
	(char *)&last,		MON$S_LAST,	"Last",
	(char *)&sample,	MON$S_SAMPLE,	"Sample",
	0,			MON$S_RECONF,	"Reconfiguration",
	0,			MON$S_CPU,	"CPU",
	(char *)&tty,		MON$S_TTY,	"TTY I/O",
	0,			MON$S_DISK,	"Disk I/O",
	(char *)&mon_free,	MON$S_FREE,	"Free memory",
	(char *)&mon_fork,	MON$S_FORK,	"Fork",
	(char *)&mon_page,	MON$S_PAGE,	"Page",
	(char *)&mon_proc,	MON$S_PROC,	"Process States",
	(char *)&mon_swap,	MON$S_SWAP,	"Swap",
	0,			MON$S_TAPE,	"Tape",
	(char *)&mon_user,	MON$S_USER,	"User",
	0,			MON$S_NETIF,	"Network interfaces",
	(char *)&memory,	MON$S_MEMORY,	"Memory",
	(char *)&loadave,	MON$S_LOADAVE,	"Load average",
	(char *)&mon_pid,	MON$S_PID,	"Process by ID",
	0,			MON$S_BUF,	"Buffer cache",
	0,			MON$S_NFS,	"NFS",
	(char *)&namei,		MON$S_NAMEI,	"Namei cache",
	(char *)&mon_kmem,	MON$S_KMEM,	"Kmem",
	0,			MON$S_PANIC,	"Panic!",
};

/*
 *	Arrays of strings to hold values of selected data type
 *	and the number of each.
 */
struct list	cpu_list   = { 0, 0, 0 },
		disk_list  = { 0, 0, 0 },
		netif_list = { 0, 0, 0 } ;

/*
 *	The I/O vector used by the readv(2) and writev(2) system calls.
 *	"n_records" is the number of array members that are going to
 *	be used.
 */
struct 	iovec 	iov[MON$N_RECORDS] ;
int		n_records = 0 ;
