h24553
s 00007/00009/00102
d D 1.6 87/08/12 15:37:01 alan 6 5
c clean up messages, use UTMP_FILE - V0.95
e
s 00034/00014/00077
d D 1.5 86/11/17 18:42:20 alan 5 4
c See commentary on V0.54 in version.c
c 
e
s 00001/00001/00090
d D 1.4 86/08/26 18:04:40 alan 4 3
c modify all SccsId strings
e
s 00002/00001/00089
d D 1.3 86/07/31 14:07:49 alan 3 2
c Change many fprintf's to info's and add arguments to assorted warning and
c fatal error messages.
c 
e
s 00009/00009/00081
d D 1.2 86/07/11 13:02:42 alan 2 1
c Change some error messages
c 
e
s 00090/00000/00000
d D 1.1 86/05/29 10:49:06 alan 1 0
c date and time created 86/05/29 10:49:06 by alan
e
u
U
t
T
I 1
/*
 *	Author:  Alan Rollow, CSC/CS, Digital Equipment Corp.
 *	File:	 %M%
 *	Date:	 %G%
 *	Version: %I%
 *
 *	%M% - Count the number of users logged on.  A rewrite of the
 *	original code from "mon".
 */
#ifndef	lint
D 4
static	char	SccsId[] = "%W% %G%" ;
E 4
I 4
D 5
static	char	SccsId[] = "%W%	(monitor)	%G%" ;
E 5
I 5
static	char	SccsId[] = "%W% (monitor) %G%" ;
E 5
E 4
#endif

#include <sys/types.h>
#include <sys/file.h>
#include <sys/stat.h>

#include <utmp.h>

I 5
/*
 *	Number of elements to read from the utmp file.  For
 *	small (slow) systems this should get all the file in
 *	one read.  For large systems it may make more than one
 *	read, but the system will probably be faster.
 *
 *	I rather wish the number of users were kept in the
 *	kernel somewhere...
 */
E 5
#define	WHOBUF	128

D 2
static	int	fd ;			/* file descriptor of who file */
E 2
I 2
static	int	fd ;			/* file descriptor of 'who' file */
E 2
static	time_t	mtime = 0 ;		/* modification time */
static	int	previous = 0 ;		/* previous number of users */

I 5
/*
 *	Module name for error functions.
 */
static	char	*module = "users" ;

E 5
D 2
char	*whofile = "/etc/utmp" ;	/* current who file */
E 2
I 2
D 6
char	*whofile = "/etc/utmp" ;	/* current 'who' file */
E 2

E 6
/*
 *	Open the "who" file.  Print an error message if we can't
 *	open it.
 */
open_whofile()
{
D 6
	if((fd = open(whofile, O_RDONLY, 0)) == -1 ) {
D 2
		warning("monitor: can't open who file: %s.\n");
E 2
I 2
D 3
		warning("monitor: users: can't open 'who' file: %s.\n");
E 3
I 3
D 5
		warning("monitor: users: can't open 'who' file: %s (%s).\n",
E 5
I 5
		warning("can't open 'who' file: %s (%s).\n", module,
E 5
			whofile);
E 6
I 6
	if((fd = open(UTMP_FILE, O_RDONLY, 0)) == -1 ) {
		warning("Can't open 'who' file: %s (%s).\n", module,
			UTMP_FILE);
E 6
E 3
E 2
		return -1 ;
	}

	return 1 ;
}

/*
D 5
 *	Close the "who" file.
 */
close_whofile()
{
	if( close(fd) == -1 )
D 2
		warning("monitor: can't close who file: %s.\n");
E 2
I 2
		warning("monitor: users: can't close 'who' file: %s.\n");
E 2
}

/*
E 5
I 5
 *	Use fstat(2) to see if the file has been modified, since
 *	last pass.  If not, return the previous number of usersa
E 5
 *
I 5
 *	If it has changed, read the contents and count the number
 *	of users and if an error didn't occur return to the begin-
 *	ning of the file.  Because monitor tries to be optimistic
 *	failure to read the file is not considered an error.
E 5
 */
users()
{
	long	lseek() ;
	struct stat statbuf ;
	struct utmp buf[WHOBUF] ;
	register rc, counter = 0 ;
	register struct utmp *p, *lastp ;

	if((rc = fstat(fd, &statbuf)) == -1 ) {
D 2
		warning("monitor: can't stat who file: %s.\n");
E 2
I 2
D 5
		warning("monitor: users: can't stat 'who' file: %s.\n");
E 5
I 5
D 6
		warning("can't stat 'who' file: %s.\n", module);
E 6
I 6
		warning("Can't stat 'who' file: %s.\n", module);
E 6
E 5
E 2
		return -1 ;
	}

	if( mtime == statbuf.st_mtime )
		return previous ;

	mtime = statbuf.st_mtime ;

	while((rc = read(fd, (char *)buf, WHOBUF * sizeof(struct utmp))) > 0 ) {
		lastp = buf + (rc / sizeof(struct utmp)) ;
		for(p = buf; p < lastp; p++)
			if( p->ut_name[0] != '\0' )
				counter++ ;
	}

D 2
	if( lseek(fd, (long)0, L_SET) == -1 ) {
		warning("monitor: can't rewind who file: %s.\n");
E 2
I 2
	if( rc == -1 ) {
D 5
		warning("monitor: users: can't read 'who' file: %s.\n");
E 5
I 5
D 6
		warning("can't read 'who' file: %s.\n", module);
E 6
I 6
		warning("Can't read 'who' file: %s.\n", module);
E 6
E 5
E 2
		return -1 ;
	}

D 2
	if( rc == -1 ) {
		warning("monitor: error reading who file: %s.\n");
E 2
I 2
	if( lseek(fd, (long)0, L_SET) == -1 ) {
D 5
		warning("monitor: users: can't rewind 'who' file: %s.\n");
E 5
I 5
D 6
		warning("can't rewind 'who' file: %s.\n", module);
E 6
I 6
		warning("Can't rewind 'who' file: %s.\n", module);
E 6
E 5
E 2
		return -1 ;
	}

	return previous = counter ;
I 5
}

/*
 *	Close the "who" file.
 */
close_whofile()
{
	if( close(fd) == -1 )
D 6
		warning("can't close 'who' file: %s.\n", module);
E 6
I 6
		warning("Can't close 'who' file: %s.\n", module);
E 6
E 5
}
E 1
