h46453
s 00057/00054/00899
d D 1.15 90/08/21 22:43:26 alan 15 14
c dust off lint
e
s 00001/00002/00952
d D 1.14 90/05/23 21:25:47 alan 14 13
c dust off a bit of lint
e
s 00010/00000/00944
d D 1.13 90/03/29 16:16:53 alan 13 12
c The hack to fix the DECmumble include file problem.
e
s 00312/00451/00632
d D 1.12 90/02/22 12:17:32 alan 12 11
c Changed swap collection code to use swapu data structure
e
s 00001/00001/01082
d D 1.11 89/12/28 15:43:11 alan 11 10
c Changed uses of vmunix to op->opt_kernel and setup opt_kernel correctly.
c 
e
s 00014/00003/01069
d D 1.10 89/12/28 14:15:12 alan 10 9
c put in a firewall around the use of rcount
e
s 00029/00021/01043
d D 1.9 89/12/27 10:54:18 alan 9 8
c dust off lint
e
s 00358/00071/00706
d D 1.8 89/12/26 17:15:04 alan 8 7
c added V4.0 support
e
s 00128/00027/00649
d D 1.7 89/12/25 18:55:30 alan 7 6
c 1.  Gave it a private namelist.
c 2.  Cleaned up namelist checking to make V4.0/V3.x differences work
c     better.
c 
e
s 00002/00002/00674
d D 1.6 89/03/09 21:08:46 alan 6 5
c reorder local include files to satisify VAXC
e
s 00005/00001/00671
d D 1.5 89/02/16 19:03:59 alan 5 4
c convert pgtok() and btok() macros to functions that uses data set in the FIRST record
e
s 00009/00005/00663
d D 1.4 89/01/17 19:07:02 alan 4 3
c fixed box
e
s 00095/00015/00573
d D 1.3 89/01/17 19:05:15 alan 3 2
c fleshed out magnification display
e
s 00024/00001/00564
d D 1.2 89/01/16 22:15:23 alan 2 1
c Added a check of the namelist to setup_swap().
c 
e
s 00565/00000/00000
d D 1.1 89/01/16 11:43:58 alan 1 0
c date and time created 89/01/16 11:43:58 by alan
e
u
U
t
T
I 1
/*
 *	Author:  Alan Rollow, EIS/CXO, Digital Equipment Corp.
D 3
 *	File:	 %M%
 *	Date:	 %G%
 *	Version: %I%
E 3
I 3
D 4
 *	File:	 swap.c
 *	Date:	 1/16/89
 *	Version: 1.2
E 4
I 4
 *	File:	 %M%
 *	Date:	 %G%
 *	Version: %I%
E 4
E 3
 *
D 3
 *	%M% - Collect swap space data.
E 3
I 3
D 4
 *	swap.c - Collect swap space data.
E 4
I 4
 *	%M% - Collect and display data on swap space usage.
E 4
E 3
 */
#ifndef	lint
D 3
static	char	SccsId[] = "%W% (monitor) %G%" ;
E 3
I 3
D 4
static	char	SccsId[] = "@(#)swap.c	1.2 (monitor) 1/16/89" ;
E 4
I 4
static	char	SccsId[] = "%W% (monitor) %G%" ;
E 4
E 3
#endif

I 2
/*
 * Modification history.
 *
 * Jan. 15, 1989 -- arr
 *
 *	Check the namelist in the setup function.
I 4
 *
 * Jan. 16, 1989 -- arr
 *
 *	Added code for the display function.
I 5
 *
 * Feb. 15, 1989 -- arr
 *
 *	Use the function version of pgtok() and btok() instead
 *	of the macros.
I 8
 *
 * Dec. 25, 1989 -- arr
 *
 *	Setup private namelist.
 *
 * Dec. 26, 1989 -- arr
 *
 *	Add code to handle V4.0 differences.  This may all get backed out
 *	by Engineering, but works at the moment.
I 13
 *
 * Mar. 26, 1990 -- arr
 *
 *	Added hack to work-around DECmumble include file problem.
 *
E 13
E 8
E 5
E 4
 */

E 2
#include <nlist.h>
#include <stdio.h>
#include <signal.h>

#include <sys/types.h>
#include <sys/dk.h>
#include <sys/buf.h>
#include <sys/file.h>
#include <sys/socket.h>
#include <sys/vm.h>

#include <sys/dir.h>
I 13

#if defined(V4_ULTRIX) && defined(mips)
#	include <mips/cpu.h>
#endif

E 13
#include <sys/param.h>
#include <sys/user.h>
#include <sys/proc.h>
#include <sys/text.h>
#include <sys/map.h>
#include <sys/conf.h>
#include <sys/ipc.h>
#include <sys/shm.h>

#include <net/if.h>
#include <netinet/in.h>

#include <machine/pte.h>

I 6
#include "monitor.h"
E 6
#include "options.h"
D 6
#include "extern.h"
E 6
#include "include.h"
D 6
#include "monitor.h"
E 6
I 6
#include "extern.h"
E 6
D 5
#include "pgtok.h"
E 5

/*
 *	Functions that don't return (int).
 */
char	*calloc() ;
D 15
void	free() ;
E 15
I 15
void	free(), nlist() ;
E 15
long	rmalloc() ;

/*
 *	Things that live elsewhere, but are not of general
 *	interest.
 */
extern	int	lines ;
I 3
extern	WINDOW	*wp ;
E 3

/*
 *	Architecture dependent macros.
 */
D 8
#ifdef vax
E 8
I 8
D 12
#ifdef	vax
E 8
#	define	CLRND(x) 	(((x) + (sys_clsize-1)) & ~(sys_clsize-1))
D 8
#	define	MON_IPC_MASK	(IPC_ALLOC)
E 8
I 8
#	define	STACK_MACRO(p)	\
		ctod(CLRND(UPAGES + (CLRND(ctopt((p)->p_ssize + HIGHPAGES)))))
#	define	DATA_MACRO(p) 	\
		ctod(CLRND(CLRND(ctopt((p)->p_tsize+(p)->p_dsize)) - \
		(p)->p_tsize/NPTEPG))
#elif  mips
#	define	CLRND(x) 	(x)
#	define	STACK_MACRO(p)	ctod(CLRND(UPAGES) + CLRND(ctopt((p)->p_ssize)))
#	define	DATA_MACRO(p)	ctod(CLRND(ctopt((p)->p_dsize)))
E 8
#endif

D 8
#ifdef mips
#	define	CLRND(x) 	(x)
E 8
I 8
#ifdef	V4_ULTRIX
E 8
#	define	MON_IPC_MASK	(IPC_ALLOC|IPC_SYSTEM)
I 8
D 9
#	define	DMAP_BUFSIZ	(1)
E 9
#else
E 12
I 12
#ifndef	V4_ULTRIX
E 12
#	ifdef	vax
#		define	MON_IPC_MASK	(IPC_ALLOC)
I 12
#		define	CLRND(x) 	(((x) + (sys_clsize-1)) & ~(sys_clsize-1))
#		define	STACK_MACRO(p)	\
			ctod(CLRND(UPAGES + (CLRND(ctopt((p)->p_ssize + HIGHPAGES)))))
#		define	DATA_MACRO(p) 	\
			ctod(CLRND(CLRND(ctopt((p)->p_tsize+(p)->p_dsize)) - \
			(p)->p_tsize/NPTEPG))
E 12
#	elif	mips
#		define	MON_IPC_MASK	(IPC_ALLOC|IPC_SYSTEM)
I 12
#		define	CLRND(x) 	(x)
#		define	STACK_MACRO(p)	ctod(CLRND(UPAGES) + CLRND(ctopt((p)->p_ssize)))
#		define	DATA_MACRO(p)	ctod(CLRND(ctopt((p)->p_dsize)))
E 12
#	endif
D 9
#	define	DMAP_BUFSIZ	(4096)
E 9
E 8
#endif

I 9
D 12
#define	DMAP_BUFSIZ	(4096)

E 12
E 9
/*
 *	Passed to the error message routines.
 */
static	char	*module = "swap" ;

/*
 *	Things only used locally.  These will be initialized
D 12
 *	in setup_swap().
E 12
I 12
 *	in setup_swap().  Some of them aren't needed in V4 so
 *	we'll #ifdef around them.
E 12
 */
I 12
#ifdef	V4_ULTRIX
static	struct swapu_t	swapu ;
#else
E 12
static	struct proc	*proc,    *p_addr ;
static	struct text	*xtext,   *t_addr ;
D 12
static	struct map	*swapmap, *smp_addr ;
static	struct swdevt	*swdevt,  *swp_addr ;
E 12
static	struct smem 	*smem;
I 8
D 9
static  int		*bitmap,  *bitmap_addr, bitmap_size ;
E 9
E 8
static	struct sminfo 	sminfo;

static	int	nproc ;
static	int	ntext ;
I 12
static	int	start, end ;	  /* loop counters for the display function */
static	int	sys_clsize ;
#endif

/*
 *	These are needed for all versions.
 */
static	struct map	*swapmap, *smp_addr ;
static	struct swdevt	*swdevt,  *swp_addr ;

E 12
static	int	nswapmap ;
static	int	nswdev ;
D 15
static	int	dmmin ;
D 8
static	int	dmmax ;
E 8
I 8
static	int	dmmax ;		  /* this will double as swapfrag from V4.0 */
static	int	swapfrag ;	  /* this will set when dmmax is */
E 15
I 15
static	int	dmmax ;		 /* this will double as swapfrag from V4.0 */
E 15
D 12
static	int	sys_clsize ;
E 12
E 8
static	int	swap_ticks = 0 ;
I 3
D 9
static	int	start, end ;	  /* loop counters for the display function */
E 9
E 3

I 15
#ifdef	V4_ULTRIX
static	int	swapfrag ;	/* this will be set when dmmax is */
#else
static	int	dmmin ;		/* this won't be used for pre-V4.0 */
#endif

E 15
I 9
D 12
#ifdef	DYNAMIC_SWAP
static  int	*bitmap,  *bitmap_addr, bitmap_size ;
E 9
I 8
static	char	dmap_buf[DMAP_BUFSIZ] ;
I 9
#else
static	int	start, end ;	  /* loop counters for the display function */
#endif
E 12
I 12
/*
 *	After little consideration, it looks like the easiest
 *	way to handle the namelist differents between V4 and
 *	pre-V4 are two different name lists and sets of constants.
 *
 *	This has the advantage that the V4 namelist is smaller
 *	and therefore nlist(3) will be quicker.  It also makes
 *	checking for all the required namelist enties easier
 *	because we can just walk down the array.
 */
#ifdef	V4_ULTRIX
/*
 *	This is the local namelist for V4.0.
 */
struct nlist swap_nm[] = {
	{ "_swapmap" },		/* SWAP_NM_SWAPMAP */
	{ "_nswapmap" },	/* SWAP_NM_NSWAPMAP */
	{ "_swdevt" },		/* SWAP_NM_SWDEVT */
	{ "_nswdev" },		/* SWAP_NM_NSWDEV */
	{ "_swapfrag" },	/* SWAP_NM_SWAPFRAG */
	{ "_swapu" },		/* SWAP_NM_SWAPU */
	{ 0 }
};
E 12

E 9
E 8
I 7
/*
D 12
 *	We even have a local namelist.
E 12
I 12
 *	Constants for local namelist.
E 12
 */
I 12
#define	SWAP_NM_SWAPMAP 	(0)
#define	SWAP_NM_NSWAPMAP 	(1)
#define	SWAP_NM_SWDEVT 		(2)
#define	SWAP_NM_NSWDEV 		(3)
#define	SWAP_NM_SWAPFRAG	(4)
#define	SWAP_NM_SWAPU		(5)

#else
/*
 *	This is the pre-V4.0 namelist.
 */
E 12
struct nlist swap_nm[] = {
	{ "_dmmin" },		/* SWAP_NM_DMMIN */
	{ "_dmmax" },		/* SWAP_NM_DMMAX */
	{ "_proc" },		/* SWAP_NM_PROC */
	{ "_nproc" },		/* SWAP_NM_NPROC */
	{ "_text" },		/* SWAP_NM_TEXT */
	{ "_ntext" },		/* SWAP_NM_NTEXT */
	{ "_swapmap" },		/* SWAP_NM_SWAPMAP */
	{ "_nswapmap" },	/* SWAP_NM_NSWAPMAP */
	{ "_swdevt" },		/* SWAP_NM_SWDEVT */
	{ "_nswdev" },		/* SWAP_NM_NSWDEV */
	{ "_smem" },		/* SWAP_NM_SMEM */
	{ "_sminfo" },		/* SWAP_NM_SMINFO */
D 12
	{ "_proc_bitmap" },	/* SWAP_NM_PROC_BITMAP */
	{ "_swapfrag" },	/* SWAP_NM_SWAPFRAG */
E 12
	{ 0 }
};
E 7
I 3

I 7
/*
 *	Constants for local namelist.
 */
#define	SWAP_NM_DMMIN 		(0)
#define	SWAP_NM_DMMAX 		(1)
#define	SWAP_NM_PROC 		(2)
#define	SWAP_NM_NPROC 		(3)
#define	SWAP_NM_TEXT 		(4)
#define	SWAP_NM_NTEXT 		(5)
#define	SWAP_NM_SWAPMAP 	(6)
#define	SWAP_NM_NSWAPMAP 	(7)
#define	SWAP_NM_SWDEVT 		(8)
#define	SWAP_NM_NSWDEV 		(9)
#define	SWAP_NM_SMEM 		(10)
#define	SWAP_NM_SMINFO 		(11)
D 12
#define	SWAP_NM_PROC_BITMAP	(12)
#define	SWAP_NM_SWAPFRAG	(13)
E 12

I 12
#endif

D 15

E 15
E 12
I 8
/*
 *	Free the space allocated tables for the swap information.
 */
E 8
E 7
E 3
free_swap()
{
D 8
	free((char *)proc) ;
E 8
I 8
D 12
	if( proc )
		free((char *)proc) ;
E 8

D 8
	free((char *)xtext) ;
E 8
I 8
	if( xtext )
		free((char *)xtext) ;
E 8

E 12
D 8
	free((char *)swapmap) ;
E 8
I 8
	if( swapmap )
		free((char *)swapmap) ;
E 8

D 8
	free((char *)swdevt) ;
E 8
I 8
	if( swdevt )
		free((char *)swdevt) ;

I 9
D 12
#ifdef	DYNAMIC_SWAP
E 9
	if( bitmap )
		free((char *)bitmap) ;
E 12
I 12
#ifndef	V4_ULTRIX
	if( proc )
		free((char *)proc) ;

	if( xtext )
		free((char *)xtext) ;
E 12
I 9
#endif
E 9
E 8
}

/*
 *	Allocate space for the various data structures we're
 *	to need.  Reading them as a block is VERY much faster
 *	than one at time.  If Ultrix ever makes these data
 *	structures lists instead of arrays, then the code will
 *	have to change.  Hopefully by then there will be an
 *	ioctl(2) or getsysinfo(2) call to get information.
 */
D 2
setup_swap()
E 2
I 2
setup_swap(op)
OPTION	*op ;
E 2
{
I 2
D 9
	int     i ;
E 9
I 7
D 12
	long	addr ;
E 12
I 12
D 14
	long	 addr ;
E 14
	register i ;
E 12
E 7

D 7
        /*
         *      Make sure all the namelist elements have reasonable
         *      values.
         */
        for(i = NM_TEXT; i <= NM_SMINFO; i++) {
		if( namelist[i].n_value == 0 ) {
			info("Swap space data is not available: %s.\n",
				namelist[i].n_name, module) ;
			op->opt_swap = 0 ;
		}
	}
E 7
I 7
D 11
	(void)nlist("/vmunix", swap_nm) ;
E 11
I 11
	(void)nlist(op->opt_kernel, swap_nm) ;
E 11
E 7

I 12
        /*
         *      This just walks through the array to see if all the
	 *	needed symbols are there.
         */
        for(i = 0; i < sizeof(swap_nm)/sizeof(swap_nm[0]) - 1; i++) {
		if( swap_nm[i].n_value == 0 ) {
			info("Swap space data is not available: %s.\n",
				swap_nm[i].n_name, module) ;
			op->opt_swap = 0 ;
		}
	}

E 12
E 2
	/*
I 7
D 12
	 *	Check the namelist.
E 12
I 12
	 *	Allocate space for the swap maps.
E 12
	 */
D 12
	check_swap_namelist(op) ;
E 12
I 12
	nswapmap = get_word((long)swap_nm[SWAP_NM_NSWAPMAP].n_value);
	smp_addr = (struct map *)get_word((long)swap_nm[SWAP_NM_SWAPMAP].n_value) ;
E 12

I 12
	if((swapmap = (struct map *)calloc((unsigned)nswapmap,
	    sizeof(struct map))) == (struct map *) NULL) {
		fatal("Can't allocate space for swap map: %s.\n", module) ;
	}

E 12
	/*
I 12
	 *	Allocate space for the swap device table.
	 */
	nswdev   = get_word((long)swap_nm[SWAP_NM_NSWDEV].n_value);
	swp_addr = (struct swdevt *)swap_nm[SWAP_NM_SWDEVT].n_value ;

	if((swdevt = (struct swdevt *)calloc((unsigned)nswdev,
	    sizeof (struct swdevt))) == (struct swdevt *) NULL) {
		fatal("Can't allocate space for swapdev table: %s.\n", module) ;
	}

	/*
	 *	The version specific setup for V4 is very simple.
	 */
#ifdef	V4_ULTRIX
	/*
	 *	Swapfrag is the interesting size in V4.0, but to
D 15
	 *	some of the other code simpiler we'll overload
E 15
I 15
	 *	make some of the other code simpiler we'll overload
E 15
	 *	dmmax to hold swapfrag.
	 */
	dmmax = swapfrag = get_word(swap_nm[SWAP_NM_SWAPFRAG].n_value) ;

D 15
	mon_swap.mon_dmmax = dmmax ;
E 15
I 15
	mon_swap.mon_dmmax = swapfrag ;
E 15
	mon_swap.mon_dmmin = 0 ;
#else
	/*
	 *	Initialize dmmin and dmmax, if there are there.  The
	 *	namelist check will ensure they are there if they
	 *	need to be.  The space for dmmax will used for swapfrag
	 *	for V4.0.
	 */
D 15
	dmmin = mon_swap.mon_dmmin = get_word(swap_nm[SWAP_NM_DMMIN].n_value) ;
	dmmax = mon_swap.mon_dmmax = get_word(swap_nm[SWAP_NM_DMMAX].n_value) ;
E 15
I 15
	dmmin = mon_swap.mon_dmmin = get_word((long)swap_nm[SWAP_NM_DMMIN].n_value) ;
	dmmax = mon_swap.mon_dmmax = get_word((long)swap_nm[SWAP_NM_DMMAX].n_value) ;
E 15
	
	/*
E 12
I 8
	 *	The system CLICK size, used by a macro later on.
	 *
	 *	512 is clicks, not pages
	 */
	sys_clsize = getpagesize() / 512;
D 12

E 12
	/*
E 8
E 7
	 *	Allocate space for the proc table for future use.
	 */
D 7
	nproc  = get_word((long)namelist[NM_NPROC].n_value);
	p_addr = (struct proc *)get_word((long)namelist[NM_PROC].n_value) ;
E 7
I 7
	nproc  = get_word((long)swap_nm[SWAP_NM_NPROC].n_value);
	p_addr = (struct proc *)get_word((long)swap_nm[SWAP_NM_PROC].n_value) ;
E 7

D 3
	if((proc = (struct proc *)calloc((unsigned)nproc, 
E 3
I 3
	if((proc = (struct proc *)calloc((unsigned)nproc,
E 3
	    sizeof(struct proc))) == (struct proc *) NULL){
		fatal("Can't allocate space for proc table: %s.\n", module) ;
	}

	/*
I 8
D 12
	 *	This was something added in V4.0.
	 */
D 9
#ifdef	V4_SWAP
E 9
I 9
#ifdef	DYNAMIC_SWAP
E 9
	bitmap_size = (nproc+31)/32 ;
	bitmap_addr = (int *)swap_nm[SWAP_NM_PROC_BITMAP].n_value ;

	if((bitmap = (int *)calloc(bitmap_size, sizeof(int))) == NULL )
		fatal("Can't allocate space for proc table bitmap: %s.\n", 
			module) ;
#endif

	/*
E 12
E 8
	 *	Allocate space for the text table for future use.
	 */
D 7
	ntext  = get_word((long)namelist[NM_NTEXT].n_value);
	t_addr = (struct text *)get_word((long)namelist[NM_TEXT].n_value) ;
E 7
I 7
	ntext  = get_word((long)swap_nm[SWAP_NM_NTEXT].n_value);
	t_addr = (struct text *)get_word((long)swap_nm[SWAP_NM_TEXT].n_value) ;
E 7

D 3
	if((xtext = (struct text *)calloc((unsigned)ntext, 
E 3
I 3
	if((xtext = (struct text *)calloc((unsigned)ntext,
E 3
	    sizeof(struct text))) == (struct text *) NULL) {
		fatal("Can't allocate space for text table: %s.\n", module) ;
	}

	/*
	 *	Allocate space for the shared memory info.
	 */
D 3
	readk((long)namelist[NM_SMINFO].n_value, (char *)&sminfo, 
E 3
I 3
D 7
	readk((long)namelist[NM_SMINFO].n_value, (char *)&sminfo,
E 7
I 7
	readk((long)swap_nm[SWAP_NM_SMINFO].n_value, (char *)&sminfo,
E 7
E 3
		sizeof(struct sminfo)) ;

D 3
	if((smem = (struct smem *)calloc((unsigned)sminfo.smmni, 
E 3
I 3
	if((smem = (struct smem *)calloc((unsigned)sminfo.smmni,
E 3
	    sizeof(struct smem))) == (struct smem *) NULL) {
		fatal("Can't allocate space for shared memory table: %s.\n", module) ;
	}
D 12

	/*
	 *	Allocate space for the swap maps.
	 */
D 7
	nswapmap = get_word((long)namelist[NM_NSWAPMAP].n_value);
	smp_addr = (struct map *)get_word((long)namelist[NM_SWAPMAP].n_value) ;
E 7
I 7
	nswapmap = get_word((long)swap_nm[SWAP_NM_NSWAPMAP].n_value);
	smp_addr = (struct map *)get_word((long)swap_nm[SWAP_NM_SWAPMAP].n_value) ;
E 7

D 3
	if((swapmap = (struct map *)calloc((unsigned)nswapmap, 
E 3
I 3
	if((swapmap = (struct map *)calloc((unsigned)nswapmap,
E 3
	    sizeof(struct map))) == (struct map *) NULL) {
		fatal("Can't allocate space for swap map: %s.\n", module) ;
	}

	/*
	 *	Allocate space for the swap device table.
	 */
D 7
	nswdev   = get_word((long)namelist[NM_NSWDEV].n_value);
	swp_addr = (struct swdevt *)namelist[NM_SWDEVT].n_value ;
E 7
I 7
	nswdev   = get_word((long)swap_nm[SWAP_NM_NSWDEV].n_value);
	swp_addr = (struct swdevt *)swap_nm[SWAP_NM_SWDEVT].n_value ;
E 7

D 3
	if((swdevt = (struct swdevt *)calloc((unsigned)nswdev, 
E 3
I 3
	if((swdevt = (struct swdevt *)calloc((unsigned)nswdev,
E 3
	    sizeof (struct swdevt))) == (struct swdevt *) NULL) {
		fatal("Can't allocate space for swapdev table: %s.\n", module) ;
	}

	/*
D 7
	 *	Set dmmin and dmmax.  These won't change so they
	 *	should be in the setup.
E 7
I 7
	 *	Initialize dmmin and dmmax, if there are there.  The
	 *	namelist check will ensure they are there if they
D 8
	 *	need to be.
E 8
I 8
	 *	need to be.  The space for dmmax will used for swapfrag
	 *	for V4.0.
E 8
E 7
	 */
D 7
	dmmin = mon_swap.mon_dmmin = get_word((long)namelist[NM_DMMIN].n_value);
	dmmax = mon_swap.mon_dmmax = get_word((long)namelist[NM_DMMAX].n_value);
E 7
I 7
	if((addr = swap_nm[SWAP_NM_DMMIN].n_value) == 0 )
		dmmin = mon_swap.mon_dmmin = 0 ;
	else
		dmmin = mon_swap.mon_dmmin = get_word(addr) ;

D 8
	if((addr = swap_nm[SWAP_NM_DMMAX].n_value) == 0 )
		dmmax = mon_swap.mon_dmmax = 0 ;
	else
E 8
I 8
	if((addr = swap_nm[SWAP_NM_DMMAX].n_value) != 0 )
E 8
		dmmax = mon_swap.mon_dmmax = get_word(addr) ;
I 8
	else if((addr = swap_nm[SWAP_NM_SWAPFRAG].n_value) != 0 )
		swapfrag = dmmax = mon_swap.mon_dmmax = get_word(addr) ;
	else
		swapfrag = dmmax = mon_swap.mon_dmmax = 0 ;
E 12
I 12
#endif
E 12
D 9

E 9
E 8
E 7
}

/*
 *	Fill a mon_swap structure.  This is closely derived from
 *	the source of pstat.c.
 */
collect_swap()
{
D 9
	int leftover, db, sb, i, j, smsize ;
E 9
I 9
D 12
	int leftover, i ;
E 9
D 8
	int sys_clsize = getpagesize() / 512; /* 512 is clicks, not pages */
E 8

E 12
I 12
D 15
	register leftover, i ;
E 15
I 15
	register leftover ;
E 15
E 12
	register struct mapent *me;
D 12
	register struct text   *xp;
E 12
	register struct swdevt *sw;
I 12
#ifndef	V4_ULTRIX
	register struct text   *xp;
E 12
	register struct proc   *pp;
	register struct smem   *sp ;
I 12
#endif
E 12

	/*
	 *	Read the swap device table.
	 */
	readk((long)swp_addr, (char *)swdevt, nswdev * sizeof(struct swdevt)) ;

	/*
D 12
	 *	Read the proc table.
E 12
I 12
	 *	Read the swap maps.
E 12
	 */
D 12
	readk((long)p_addr, (char *)proc, nproc * sizeof(struct proc)) ;
E 12
I 12
	readk((long)smp_addr, (char *)swapmap, nswapmap * sizeof(struct map)) ;
E 12

I 12
	swapmap->m_name = "swap";
	swapmap->m_limit = (struct mapent *)&swapmap[nswapmap];

#ifdef	V4_ULTRIX
E 12
	/*
I 8
D 12
	 *	Read the mystery bitmap.
E 12
I 12
	 *      Read the swap usage structure.
E 12
	 */
D 9
#ifdef	V4_SWAP
E 9
I 9
D 12
#ifdef	DYNAMIC_SWAP
E 9
	readk((long)bitmap_addr, (char *)bitmap, bitmap_size * sizeof(int)) ;
#endif
E 12
I 12
	readk((long)swap_nm[SWAP_NM_SWAPU].n_value, (caddr_t)&swapu,
		sizeof(struct swapu_t)) ;
#else
	/*
	 *	Read the proc table.
	 */
	readk((long)p_addr, (char *)proc, nproc * sizeof(struct proc)) ;
E 12

	/*
E 8
	 *	Read the text table.
	 */
	readk((long)t_addr, (char *)xtext, ntext * sizeof(struct text)) ;

	/*
	 *	Read the shared memory stuff.
	 */
D 3
	readk((long)namelist[NM_SMEM].n_value, (char *)smem, 
E 3
I 3
D 7
	readk((long)namelist[NM_SMEM].n_value, (char *)smem,
E 7
I 7
	readk((long)swap_nm[SWAP_NM_SMEM].n_value, (char *)smem,
E 7
E 3
		sminfo.smmni * sizeof(struct smem)) ;
I 12
#endif
E 12

	/*
D 12
	 *	Read the swap maps.
	 */
	readk((long)smp_addr, (char *)swapmap, nswapmap * sizeof(struct map)) ;

	swapmap->m_name = "swap";
	swapmap->m_limit = (struct mapent *)&swapmap[nswapmap];

	/*
E 12
	 *	Initialize the members of the mon_swap structure.
	 */
	mon_swap.mon_total  = 0 ;
	mon_swap.mon_free   = 0 ;
	mon_swap.mon_text   = 0 ;
	mon_swap.mon_smem   = 0 ;
	mon_swap.mon_wasted = 0 ;

	/*
	 *	Add up the amount of swap space.
	 */
	for (sw = swdevt; sw < &swdevt[nswdev]; sw++)
		mon_swap.mon_total += sw->sw_nblks;

	/*
I 8
D 12
	 *	V4 appears to reserve some space.
E 12
I 12
	 *	This is where the two different version of counting
	 *	swap swap space get ugly.  V4 provides a data structure
	 *	where the kernel keeps track of this information.  Before
	 *	that we had to wander through all sorts of other kernel
	 *	structure to count it up.
E 12
	 */
D 9
#ifdef	V4_SWAP
E 9
I 9
D 12
#ifdef	DYNAMIC_SWAP
E 12
I 12
#ifdef	V4_ULTRIX

	/*
	 *	The subtractions are because V4 appears to reserve
D 15
	 *	to CLICKS.  Doing this makes the numbers match with
E 15
I 15
	 *	two CLICKS.  Doing this makes the numbers match with
E 15
	 *	those of pstat(8).
	 */
E 12
E 9
	mon_swap.mon_total = mon_swap.mon_total - ctod(CLSIZE) - ctod(CLSIZE) ;
D 12
#endif
E 12

I 12
	mon_swap.mon_text   = swapu.txt ;
	mon_swap.mon_smem   = swapu.smem ;
	mon_swap.mon_used   = swapu.total_used ;
	mon_swap.mon_wasted = swapu.wasted ;
	mon_swap.mon_free   = mon_swap.mon_total - mon_swap.mon_used ;
#else
E 12
	/*
E 8
	 *	Count up the amount of free space.
	 */
	for (me = (struct mapent *)(swapmap+1);
	    me < (struct mapent *)&swapmap[nswapmap]; me++)
		mon_swap.mon_free += me->m_size;

	/*
	 *	Count up the space allocated to text.
	 */
	for (xp = xtext; xp < &xtext[ntext]; xp++)
D 8
		if ((xp->x_flag & XFREE) == 0) {
			mon_swap.mon_text += ctod(xp->x_size);
			if (xp->x_flag & XPAGI)
				mon_swap.mon_text += ctod(CLRND(ctopt(xp->x_size)));
		}
E 8
I 8
		if((xp->x_flag & XFREE) == 0)
			swap_text(&mon_swap, xp) ;
E 8

	/*
	 *	Count up the space allocated to shared memory.
	 */
	for (sp = smem; sp < &smem[sminfo.smmni]; sp++) {
D 8
		if ((sp->sm_perm.mode & MON_IPC_MASK) == IPC_ALLOC) {
			smsize = CLRND(btoc(sp->sm_size));
			mon_swap.mon_smem += ctod(smsize);
			mon_swap.mon_smem += ctod(CLRND(ctopt(smsize)));
		}
E 8
I 8
		if ((sp->sm_perm.mode & MON_IPC_MASK) == IPC_ALLOC)
			swap_smem(&mon_swap, sp) ;
E 8
	}

	mon_swap.mon_used = mon_swap.mon_text + mon_swap.mon_smem ;

	/*
D 8
	 *	Walk the proc table.
E 8
I 8
	 *	Walk the proc table.  The order of the checks
	 *	for an interesting process probably matters.
	 *	all the useful works ends up being done in
	 *	the appropriate version of swap_proc().
E 8
	 */
D 8
	for (pp = proc; pp < &proc[nproc]; pp++) {
E 8
I 8
D 14
	for (pp = proc, i = 0; pp < &proc[nproc]; pp++, i++) {
E 14
I 14
	for (pp = proc; pp < &proc[nproc]; pp++) {
E 14
D 12
#ifdef	V4_ULTRIX
E 12
E 8
		/*
I 8
D 12
		 *	Do some check on the process bitmap.
		 */
		if((bitmap[i/32] & (1 << (i%32))) == 0 )
			continue ;
#endif
		/*
E 12
E 8
		 *	Ignore used and zombie processes.
		 */
D 8
		if (pp->p_stat == 0 || pp->p_stat == SZOMB)
E 8
I 8
		if( pp->p_stat == 0 || pp->p_stat == SZOMB )
E 8
			continue;

D 7
		if (pp->p_flag & SSYS)
E 7
I 7
D 12
#ifdef	V4_ULTRIX
		if( pp->p_type & SSYS )
			continue ;
#else
E 12
		if( pp->p_flag & SSYS )
E 7
			continue;
I 7
D 12
#endif
E 12
E 7

D 8
		/*
		 *	Get the size allocated to data.
		 */
		db = ctod(pp->p_dsize), sb = up(db);
		mon_swap.mon_used   += sb;
		mon_swap.mon_wasted += sb - db;

		/*
		 *	Get the size allocated to stack.
		 */
		db = ctod(pp->p_ssize), sb = up(db);
		mon_swap.mon_used   += sb;
		mon_swap.mon_wasted += sb - db;

		/*
		 *	Get the size allocated to the swapped _u area.
		 */
D 7
		if ((pp->p_flag&SLOAD) == 0)
E 7
I 7
#ifdef	V4_ULTRIX
		if(( pp->p_sched & SLOAD) == 0 )
E 7
			mon_swap.mon_used += vusize(pp);
I 7
#else
		if(( pp->p_flag & SLOAD) == 0 )
			mon_swap.mon_used += vusize(pp);
#endif
E 8
I 8
		swap_proc(&mon_swap, pp) ;
E 8
E 7
	}
I 12
#endif
E 12

	/*
D 8
	 *	Find out what sized pieces the swap space is
	 *	available in.  This is done by using the swap
	 *	space algorithm to allocate pieces from DMMAX
	 *	down to DMMIN.
E 8
I 8
	 *	This will calculate how the swap space is
	 *	divided up.  There are two versions.
E 8
	 */
D 8
	for (i = dmmax; i >= dmmin; i /= 2) {
		j = 0;
E 8
I 8
	swap_available(&mon_swap, swapmap) ;
E 8

D 8
		while(rmalloc(swapmap, i) != 0 )
			j++;

		mon_swap.mon_avail[ffs(i)-2] = j ;
	}

E 8
	/*
	 *	Add up whatever is left over.
	 */
	leftover = 0 ;

	for (me = (struct mapent *)(swapmap+1);
	    me < (struct mapent *)&swapmap[nswapmap]; me++)
		leftover += me->m_size;

	mon_swap.mon_avail[0] = btok(leftover) ;
}

D 12
up(size)
register int size ;
{
	register int i, block;

	i = 0;
	block = dmmin;
	while (i < size) {
		i += block;
		if (block < dmmax)
			block *= 2;
	}
	return (i);
}

E 12
/*
D 12
 * Compute number of pages to be allocated to the u. area
 * and data and stack area page tables, which are stored on the
 * disk immediately after the u. area.
 */
vusize(p)
	register struct proc *p;
{
	register int tsz = p->p_tsize / NPTEPG;

	/*
	 * We do not need page table space on the disk for page
D 3
	 * table pages wholly containing text. 
E 3
I 3
	 * table pages wholly containing text.
E 3
	 */
	return (clrnd(UPAGES +
	    clrnd(ctopt(p->p_tsize+p->p_dsize+p->p_ssize+UPAGES)) - tsz));
}

/*
E 12
 * Allocate 'size' units from the given
 * map. Return the base of the allocated space.
 * In a map, the addresses are increasing and the
 * list is terminated by a 0 size.
 *
 * Algorithm is first-fit.
 *
 * This routine knows about the interleaving of the swapmap
 * and handles that.
 */
long
rmalloc(mp, size)
register struct map *mp;
register size;
{
	register struct mapent *ep = (struct mapent *)(mp+1);
	register int addr;
D 15
	register struct mapent *bp;
	swblk_t first, rest;
E 15
I 15
	register struct mapent *bufp;
	swblk_t sw_first, rest;
E 15

	if (size <= 0 || size > dmmax)
		return (0);
	/*
	 * Search for a piece of the resource map which has enough
	 * free space to accomodate the request.
	 */
D 15
	for (bp = ep; bp->m_size; bp++) {
		if (bp->m_size >= size) {
E 15
I 15
	for (bufp = ep; bufp->m_size; bufp++) {
		if (bufp->m_size >= size) {
E 15
			/*
			 * If allocating from swapmap,
			 * then have to respect interleaving
			 * boundaries.
			 */
			if (nswdev > 1 &&
D 15
			    (first = dmmax - bp->m_addr%dmmax) < bp->m_size) {
				if (bp->m_size - first < size)
E 15
I 15
			    (sw_first = dmmax - bufp->m_addr%dmmax) < bufp->m_size) {
				if (bufp->m_size - sw_first < size)
E 15
					continue;
D 15
				addr = bp->m_addr + first;
				rest = bp->m_size - first - size;
				bp->m_size = first;
E 15
I 15
				addr = bufp->m_addr + sw_first;
				rest = bufp->m_size - sw_first - size;
				bufp->m_size = sw_first;
E 15
				if (rest)
					rmfree(mp, rest, addr+size);
				return (addr);
			}
			/*
			 * Allocate from the map.
			 * If there is no space left of the piece
			 * we allocated from, move the rest of
			 * the pieces to the left.
			 */
D 15
			addr = bp->m_addr;
			bp->m_addr += size;
E 15
I 15
			addr = bufp->m_addr;
			bufp->m_addr += size;
E 15
D 8
			if ((bp->m_size -= size) == 0) {
E 8
I 8

D 15
			if((bp->m_size -= size) == 0 ) {
E 15
I 15
			if((bufp->m_size -= size) == 0 ) {
E 15
E 8
				do {
D 15
					bp++;
					(bp-1)->m_addr = bp->m_addr;
				} while ((bp-1)->m_size = bp->m_size);
E 15
I 15
					bufp++;
					(bufp-1)->m_addr = bufp->m_addr;
				} while ((bufp-1)->m_size = bufp->m_size);
E 15
			}
I 8

E 8
			if (addr % CLSIZE)
				return (0);
I 8

E 8
			return (addr);
		}
	}
	return (0);
}

/*
 * Free the previously allocated space at addr
 * of size units into the specified map.
 * Sort addr into map and combine on
 * one or both ends if possible.
 */
rmfree(mp, size, addr)
struct map *mp;
long	size ;
int	addr;
{
	register struct mapent *firstbp;
D 15
	register struct mapent *bp;
E 15
I 15
	register struct mapent *bufp;
E 15
	register int t;

	/*
	 * Both address and size must be
	 * positive, or the protocol has broken down.
	 */
	if (addr <= 0 || size <= 0)
		goto badrmfree;
	/*
	 * Locate the piece of the map which starts after the
	 * returned space (or the end of the map).
	 */
D 15
	firstbp = bp = (struct mapent *)(mp + 1);
	for (; bp->m_addr <= addr && bp->m_size != 0; bp++)
E 15
I 15
	firstbp = bufp = (struct mapent *)(mp + 1);
	for (; bufp->m_addr <= addr && bufp->m_size != 0; bufp++)
E 15
		continue;
	/*
	 * If the piece on the left abuts us,
	 * then we should combine with it.
	 */
D 15
	if (bp > firstbp && (bp-1)->m_addr+(bp-1)->m_size >= addr) {
E 15
I 15
	if (bufp > firstbp && (bufp-1)->m_addr+(bufp-1)->m_size >= addr) {
E 15
		/*
		 * Check no overlap (internal error).
		 */
D 15
		if ((bp-1)->m_addr+(bp-1)->m_size > addr)
E 15
I 15
		if ((bufp-1)->m_addr+(bufp-1)->m_size > addr)
E 15
			goto badrmfree;
		/*
		 * Add into piece on the left by increasing its size.
		 */
D 15
		(bp-1)->m_size += size;
E 15
I 15
		(bufp-1)->m_size += size;
E 15
		/*
		 * If the combined piece abuts the piece on
		 * the right now, compress it in also,
		 * by shifting the remaining pieces of the map over.
		 */
D 15
		if (bp->m_addr && addr+size >= bp->m_addr) {
			if (addr+size > bp->m_addr)
E 15
I 15
		if (bufp->m_addr && addr+size >= bufp->m_addr) {
			if (addr+size > bufp->m_addr)
E 15
				goto badrmfree;
D 15
			(bp-1)->m_size += bp->m_size;
			while (bp->m_size) {
				bp++;
				(bp-1)->m_addr = bp->m_addr;
				(bp-1)->m_size = bp->m_size;
E 15
I 15
			(bufp-1)->m_size += bufp->m_size;
			while (bufp->m_size) {
				bufp++;
				(bufp-1)->m_addr = bufp->m_addr;
				(bufp-1)->m_size = bufp->m_size;
E 15
			}
		}
		goto done;
	}
	/*
	 * Don't abut on the left, check for abutting on
	 * the right.
	 */
D 15
	if (addr+size >= bp->m_addr && bp->m_size) {
		if (addr+size > bp->m_addr)
E 15
I 15
	if (addr+size >= bufp->m_addr && bufp->m_size) {
		if (addr+size > bufp->m_addr)
E 15
			goto badrmfree;
D 15
		bp->m_addr -= size;
		bp->m_size += size;
E 15
I 15
		bufp->m_addr -= size;
		bufp->m_size += size;
E 15
		goto done;
	}
	/*
	 * Don't abut at all.  Make a new entry
	 * and check for map overflow.
	 */
	do {
D 15
		t = bp->m_addr;
		bp->m_addr = addr;
E 15
I 15
		t = bufp->m_addr;
		bufp->m_addr = addr;
E 15
		addr = t;
D 15
		t = bp->m_size;
		bp->m_size = size;
		bp++;
E 15
I 15
		t = bufp->m_size;
		bufp->m_size = size;
		bufp++;
E 15
	} while (size = t);
	/*
D 15
	 * Segment at bp is to be the delimiter;
E 15
I 15
	 * Segment at bufp is to be the delimiter;
E 15
D 3
	 * If there is not room for it 
E 3
I 3
	 * If there is not room for it
E 3
	 * then the table is too full
	 * and we must discard something.
	 */
D 15
	if (bp+1 > mp->m_limit) {
E 15
I 15
	if (bufp+1 > mp->m_limit) {
E 15
		/*
D 15
		 * Back bp up to last available segment.
E 15
I 15
		 * Back bufp up to last available segment.
E 15
		 * which contains a segment already and must
		 * be made into the delimiter.
		 * Discard second to last entry,
		 * since it is presumably smaller than the last
		 * and move the last entry back one.
		 */
D 15
		bp--;
		bp[-1] = bp[0];
		bp[0].m_size = bp[0].m_addr = 0;
E 15
I 15
		bufp--;
		bufp[-1] = bufp[0];
		bufp[0].m_size = bufp[0].m_addr = 0;
E 15
	}
done:
	return;
badrmfree:
	panic("Manipulation of swapmap failed!\n", "map");
}

I 12

E 12
/*
I 12
 *	The following functions are used to do specialized
 *	counting of swap space usage.  Only swap_available()
 *	is used in both the V4 and pre-V4 versions.
 */
#ifdef	V4_ULTRIX
/*
 *	V4.0 makes this simpler.  The swap space consists of
 *	of swapfrag size pieces.  Those that are free are
 *	available.
 */
swap_available(sp, map)
struct mon_swap *sp ;
struct map *map ;
{
	register i = 0;

        while( rmalloc(map, swapfrag) != 0 )
                i++;

	sp->mon_avail[ffs(swapfrag)-2] = i ;
}
#else
/*
 *	Before V4.0 the swap space consisted of dmmin to dmmax
 *	sized pieces.  It counts them working down from dmmax
 *	to dmmin.
 */
swap_available(sp, map)
register struct mon_swap *sp ;
register struct map *map ;
{
	register i, j ;

	/*
	 *	Find out what sized pieces the swap space is
	 *	available in.  This is done by using the swap
	 *	space algorithm to allocate pieces from DMMAX
	 *	down to DMMIN.
	 */
	for (i = dmmax; i >= dmmin; i /= 2) {
		j = 0;

		while( rmalloc(map, i) != 0 )
			j++;

		sp->mon_avail[ffs(i)-2] = j ;
	}
}

/*
 *	This calculates how much swap space is allocated to text.
 */
swap_text(sp, xp)
register struct mon_swap *sp ;
register struct text *xp ;
{
	sp->mon_text += ctod(xp->x_size);
	if( xp->x_flag & XPAGI )
		sp->mon_text += ctod(CLRND(ctopt(xp->x_size)));
}

/*
 *	This calculates how much swap space is allocated to shared
 *	memory.
 */
swap_smem(sp, sm)
register struct mon_swap *sp ;
register struct smem *sm ;
{
	register smsize ;

	smsize = CLRND(btoc(sm->sm_size));
	sp->mon_smem += ctod(smsize);
	sp->mon_smem += ctod(CLRND(ctopt(smsize)));
}

/*
 *	This calculates how much swap space is allocated to
 *	a process.
 */
swap_proc(sp, p)
register struct mon_swap *sp ;
register struct proc *p ;
{
	register db, sb ;

	/*
	 *	Get the size allocated to data.
	 */
	db = ctod(p->p_dsize), sb = up(db);
	sp->mon_used   += sb;
	sp->mon_wasted += sb - db;

	/*
	 *	Get the size allocated to stack.
	 */
	db = ctod(p->p_ssize), sb = up(db);
	sp->mon_used   += sb;
	sp->mon_wasted += sb - db;

	/*
	 *	Get the size allocated to the swapped _u area.
	 */
	if((p->p_flag & SLOAD) == 0 )
		sp->mon_used += vusize(p);
}

up(size)
register int size ;
{
	register int i, block;

	i = 0;
	block = dmmin;
	while (i < size) {
		i += block;
		if (block < dmmax)
			block *= 2;
	}
	return (i);
}

/*
 * Compute number of pages to be allocated to the u. area
 * and data and stack area page tables, which are stored on the
 * disk immediately after the u. area.
 */
vusize(p)
	register struct proc *p;
{
	register int tsz = p->p_tsize / NPTEPG;

	/*
	 * We do not need page table space on the disk for page
	 * table pages wholly containing text.
	 */
	return (clrnd(UPAGES +
	    clrnd(ctopt(p->p_tsize+p->p_dsize+p->p_ssize+UPAGES)) - tsz));
}
#endif

/*
E 12
 *	Constants for placement of SWAP data.
 */
D 3
#define	SWAP_LINES	(3)
E 3
I 3
#define	SWAP_LINES	(17)
D 8
#define	SWAP_TOTAL_X	(7)
E 8
I 8
#define	SWAP_TOTAL_X	(11)
E 8
#define	SWAP_TOTAL_Y	(5)
#define	SWAP_X		(15)
#define	SWAP_Y		(3)
#define	SWAP_DATA	(SWAP_Y + 4)
#define	SWAP_AVAIL_Y	(15)
#define	SWAP_AVAIL_X	(0)
E 3

/*
 *	Setup the static screen for displaying swap space
 *	information.
 *
 *	ARGSUSED
 */
open_swap(op)
OPTION	*op ;
{
I 9
D 12
#ifndef	DYNAMIC_SWAP
E 12
I 12
#ifndef	V4_ULTRIX
E 12
E 9
I 3
	register i, printed ;
I 9
#endif
E 9

E 3
	sample_header() ;

	lines = SWAP_LINES ;
I 3

	wmove(wp, SWAP_Y, 0) ;

D 8
	wprintw(wp, "dmmin: %10u Kb.\n", btok(mon_swap.mon_dmmin)) ;
	wprintw(wp, "dmmax: %10u Kb.\n", btok(mon_swap.mon_dmmax)) ;
	wprintw(wp, "Total: %10u Kb.\n\n", 0) ;
E 8
I 8
	wprintw(wp, "dmmin:     %10u KB.\n", btok(mon_swap.mon_dmmin)) ;
D 9
#ifdef	V4_SWAP
E 9
I 9
D 12
#ifdef	DYNAMIC_SWAP
E 12
I 12
#ifdef	V4_ULTRIX
E 12
E 9
	wprintw(wp, "swapfrag:  %10u KB.\n", btok(mon_swap.mon_dmmax)) ;
#else
	wprintw(wp, "dmmax:     %10u KB.\n", btok(mon_swap.mon_dmmax)) ;
#endif
	wprintw(wp, "Total:     %10u KB.\n\n", 0) ;
E 8

	wprintw(wp, "Text:          %6.2f %%\n",   0.0) ;
	wprintw(wp, "Free:          %6.2f %%\n",   0.0) ;
	wprintw(wp, "Used:          %6.2f %%\n",   0.0) ;
	wprintw(wp, "Wasted:        %6.2f %%\n",   0.0) ;
	wprintw(wp, "Missing:       %6.2f %%\n",   0.0) ;
	wprintw(wp, "Shared Memory: %6.2f %%\n\n", 0.0) ;

	wprintw(wp, "Usage of available space:") ;

I 8
D 9
#ifdef	V4_SWAP
E 9
I 9
D 12
#ifdef	DYNAMIC_SWAP
E 12
I 12
#ifdef	V4_ULTRIX
E 12
E 9
	lines += 2 ;
#else
E 8
	start = ffs(btok(mon_swap.mon_dmmin)) - 1;
	end   = ffs(btok(mon_swap.mon_dmmax)) ;

	for(i = start, printed = 1; i < end; i++) {
		printed++ ;

		if((printed % 3) == 0 )
			lines++ ;
	}
I 8
#endif
E 8
E 3
}

/*
 *	Display the dynamic data of the swap space information.
 *
 *	ARGSUSED
 */
magnify_swap(op)
OPTION	*op ;
{
I 3
D 9
	register total, missing, i, printed ;
E 9
I 9
	register total, missing, i ;
D 12
#ifndef	DYNAMIC_SWAP
E 12
I 12
#ifndef	V4_ULTRIX
E 12
	register printed ;
#endif
E 9

E 3
	sample_body((double)(sample.mon_ticks - swap_ticks)/first.mon_hz) ;
	swap_ticks = sample.mon_ticks ;
I 3

	total   = mon_swap.mon_total ;
	missing = total - (mon_swap.mon_used + mon_swap.mon_free) ;

	wmove(wp, SWAP_TOTAL_Y, SWAP_TOTAL_X) ;
	wprintw(wp, "%10u",  btok(total)) ;

	wmove(wp, SWAP_DATA, SWAP_X) ;
	wprintw(wp, "%6.2f", (double)(100.0 * mon_swap.mon_text)/total) ;

	wmove(wp, SWAP_DATA + 1, SWAP_X) ;
	wprintw(wp, "%6.2f", (double)(100.0 * mon_swap.mon_free)/total) ;

	wmove(wp, SWAP_DATA + 2, SWAP_X) ;
	wprintw(wp, "%6.2f", (double)(100.0 * mon_swap.mon_used)/total) ;

	wmove(wp, SWAP_DATA + 3, SWAP_X) ;
	wprintw(wp, "%6.2f", (double)(100.0 * mon_swap.mon_wasted)/total) ;

	wmove(wp, SWAP_DATA + 4, SWAP_X) ;
	wprintw(wp, "%6.2f", (double)(100.0 * missing)/total) ;

	wmove(wp, SWAP_DATA + 5, SWAP_X) ;
	wprintw(wp, "%6.2f", (double)(100.0 * mon_swap.mon_smem)/total) ;

	wmove(wp, SWAP_AVAIL_Y, SWAP_AVAIL_X) ;

D 8
	wprintw(wp, "%8d Kb: %5d ", 1 << 0, mon_swap.mon_avail[0]) ;
E 8
I 8
	wprintw(wp, "%8d KB: %5d ", 1 << 0, mon_swap.mon_avail[0]) ;
E 8

I 8
D 9
#ifdef	V4_SWAP
E 9
I 9
D 12
#ifdef	DYNAMIC_SWAP
E 12
I 12
#ifdef	V4_ULTRIX
E 12
E 9
	i = ffs(btok(mon_swap.mon_dmmax)) - 1;
	wprintw(wp, "\n%8d KB: %5d", 1 << i, mon_swap.mon_avail[i]) ;
#else
E 8
	for(i = start, printed = 1; i < end; i++) {
D 8
		wprintw(wp, "%8d Kb: %5d", 1 << i, mon_swap.mon_avail[i]) ;
E 8
I 8
		wprintw(wp, "%8d KB: %5d", 1 << i, mon_swap.mon_avail[i]) ;
E 8

		printed++ ;

		if((printed % 3) == 0 )
			wprintw(wp, "\n") ;
		else
			wprintw(wp, " ") ;
	}
I 8
#endif
E 8

	wclrtoeol(wp) ;
I 7
}

D 12
/*
 *	Check the namelist for everything we need.
 */
check_swap_namelist(op)
OPTION	*op ;
{
	register i ;

        /*
         *      These are always needed, so check them first.
         */
        for(i = SWAP_NM_PROC; i <= SWAP_NM_SMINFO; i++) {
		if( swap_nm[i].n_value == 0 ) {
			info("Swap space data is not available: %s.\n",
				swap_nm[i].n_name, module) ;
			op->opt_swap = 0 ;
		}
	}

D 8
#ifdef	V4_ULTRIX
E 8
I 8
D 9
#ifdef	V4_SWAP
E 9
I 9
#ifdef	DYNAMIC_SWAP
E 9
E 8
	/*
	 *	These are only needed for V4.0.
	 */
	if( swap_nm[SWAP_NM_PROC_BITMAP].n_value == 0 ) {
		info("Swap space data is not available: _proc_bitmap.\n",
			module) ;
		op->opt_swap = 0 ;
	}
	if( swap_nm[SWAP_NM_SWAPFRAG].n_value == 0 ) {
		info("Swap space data is not available: _swapfrag.\n", module) ;
		op->opt_swap = 0 ;
	}
#else
	/*
	 *	And these are needed before V4.0.
	 */
	if( swap_nm[SWAP_NM_DMMIN].n_value == 0 ) {
		info("Swap space data is not available: _dmmin.\n", module) ;
		op->opt_swap = 0 ;
	}

	if( swap_nm[SWAP_NM_DMMAX].n_value == 0 ) {
		info("Swap space data is not available: _dmmax.\n", module) ;
		op->opt_swap = 0 ;
	}
#endif
I 8
}
E 8

I 8
/*
 *	This calculates how much swap space is allocated to text.
 */
D 9
#ifdef	V4_SWAP
E 9
I 9
#ifdef	DYNAMIC_SWAP
E 9
/*
 *
 */
swap_text(sp, xp)
register struct mon_swap *sp ;
register struct text *xp ;
{
	struct dmap *dmptr = (struct dmap *)&dmap_buf[0], lmap ;
	register rcount, last, temp ;

	if(xp->x_dmap == 0 || xp->x_gptr == NULL)
		return ;

        readk((long)xp->x_dmap, (caddr_t)&lmap, sizeof(struct dmap)) ;

	sp->mon_text += (swapfrag * lmap.dm_cnt);

        last = lmap.dm_last - 1;
D 10
        rcount = (last * sizeof(int)) + sizeof(struct dmap);
E 10
I 10
        if((rcount = (last * sizeof(int)) + sizeof(struct dmap)) > DMAP_BUFSIZ ) {
		info("Bogus value for rcount: skipping text entry.\n", module) ;
		return ;
	}
E 10

	readk((long)xp->x_dmap, (caddr_t)dmptr, rcount) ;

        /*
         * check if swap allocated for the last fragment
         */
        if(dmptr->dm_map[last] != 0)
	        sp->mon_wasted += (swapfrag - ((ctod(xp->x_size))%swapfrag));

	temp = get_word((long)lmap.dm_ptdaddr) ;

	if( temp != 0 )
		sp->mon_text += ctod(CLRND(ctopt(xp->x_size)));
E 8
E 7
E 3
}
I 8
#else
swap_text(sp, xp)
register struct mon_swap *sp ;
register struct text *xp ;
{
	sp->mon_text += ctod(xp->x_size);
	if( xp->x_flag & XPAGI )
		sp->mon_text += ctod(CLRND(ctopt(xp->x_size)));
}
#endif

/*
 *	This calculates how much swap space is allocated to shared
 *	memory.
 */
D 9
#ifdef	V4_SWAP
E 9
I 9
#ifdef	DYNAMIC_SWAP
E 9
swap_smem(sp, sm)
register struct mon_swap *sp ;
register struct smem *sm ;
{
D 9
	register smsize ;
E 9
	struct dmap lmap ;

	readk((long)sm->sm_dmap, (caddr_t)&lmap, sizeof(struct dmap)) ;

	sp->mon_smem += (swapfrag * lmap.dm_cnt);
}
#else
swap_smem(sp, sm)
register struct mon_swap *sp ;
register struct smem *sm ;
{
	register smsize ;

	smsize = CLRND(btoc(sm->sm_size));
	sp->mon_smem += ctod(smsize);
	sp->mon_smem += ctod(CLRND(ctopt(smsize)));
}
#endif


/*
 *	This calculates how much swap space is allocated to
 *	a process.
 */
D 9
#ifdef	V4_SWAP
E 9
I 9
#ifdef	DYNAMIC_SWAP
E 9
/*
 *	This is how V4.0 does it.  It is more complicated due to
 *	the support for dynamic swap space.
 */
swap_proc(sp, p)
register struct mon_swap *sp ;
register struct proc *p ;
{
D 9
	register last, rcount, temp ;
E 9
I 9
	register last, rcount ;
E 9
	struct dmap *dmptr = (struct dmap *)&dmap_buf[0], lmap ;

	/*
	 *	I think this part does the data size.
	 */
	readk((long)p->p_dmap, (char *)&lmap, sizeof(struct dmap)) ;

	sp->mon_used += (swapfrag * lmap.dm_cnt);

	last = lmap.dm_last - 1;
D 10
	rcount = (last * sizeof(int)) + sizeof(struct dmap);
E 10
I 10
        if((rcount = (last * sizeof(int)) + sizeof(struct dmap)) > DMAP_BUFSIZ ) {
		info("Bogus value for rcount: skipping process data entry.\n", module) ;
		return ;
	}

E 10
	readk((long)p->p_dmap, (caddr_t)dmptr, rcount) ;

	/*
	 * check if swap allocated for the last fragment
	 */
	if(dmptr->dm_map[last] != 0)
		sp->mon_wasted += (swapfrag - ((ctod(p->p_dsize))%swapfrag));	

	/*
	 *	If the page tapes have been swapped count them.
	 */
	if( get_word((long)lmap.dm_ptdaddr) != 0 )
		sp->mon_used += DATA_MACRO(p) ;

	/*
	 *	If the previous assumption was true this does
	 *	stack size.
	 */
	readk((long)p->p_smap, (caddr_t)&lmap, sizeof(struct dmap)) ;

	sp->mon_used += (swapfrag * lmap.dm_cnt);

	last = lmap.dm_last - 1;
D 10
	rcount = (last * sizeof(int)) + sizeof(struct dmap); 
E 10
I 10
        if((rcount = (last * sizeof(int)) + sizeof(struct dmap)) > DMAP_BUFSIZ ) {
		info("Bogus value for rcount: skipping process stack entry.\n", module) ;
		return ;
	}

E 10
	readk((long)p->p_smap, (caddr_t)dmptr, rcount) ;

	if(dmptr->dm_map[last] != 0) 
		sp->mon_wasted += (swapfrag - ((ctod(p->p_ssize))%swapfrag));	

	/*
	 *	If the page tapes have been swapped count them.
	 */
	if( get_word((long)lmap.dm_ptdaddr)  != 0 )
		sp->mon_used += STACK_MACRO(p) ;
}
#else
/*
 *	This is the pre-V4.0 way.  Nice, simple.
 */
swap_proc(sp, p)
register struct mon_swap *sp ;
register struct proc *p ;
{
	register db, sb ;

	/*
	 *	Get the size allocated to data.
	 */
	db = ctod(p->p_dsize), sb = up(db);
	sp->mon_used   += sb;
	sp->mon_wasted += sb - db;

	/*
	 *	Get the size allocated to stack.
	 */
	db = ctod(p->p_ssize), sb = up(db);
	sp->mon_used   += sb;
	sp->mon_wasted += sb - db;

	/*
	 *	Get the size allocated to the swapped _u area.
	 */
#ifdef	V4_ULTRIX
	if((p->p_sched & SLOAD) == 0 )
		sp->mon_used += vusize(p);
#else
	if((p->p_flag & SLOAD) == 0 )
		sp->mon_used += vusize(p);
#endif
}
#endif

/*
 *	Version specific functions to find how the swap
 *	space is divided up.  Both versions use a clone
 *	of the kernel swap space allocator.
 */
D 9
#ifdef	V4_SWAP
E 9
I 9
#ifdef	DYNAMIC_SWAP
E 9
/*
 *	V4.0 makes this simpler.  The swap space consists of
 *	of swapfrag size pieces.  That that are free are
 *	available.
 */
swap_available(sp, map)
struct mon_swap *sp ;
struct map *map ;
{
	register i = 0;

        while( rmalloc(map, swapfrag) != 0 )
                i++;

	sp->mon_avail[ffs(swapfrag)-2] = i ;
}
#else
/*
 *	Before V4.0 the swap space consisted of dmmin to dmmax
 *	sized pieces.  It counts them working down from dmmax
 *	to dmmin.
 */
swap_available(sp, map)
register struct mon_swap *sp ;
register struct map *map ;
{
	register i, j ;

	/*
	 *	Find out what sized pieces the swap space is
	 *	available in.  This is done by using the swap
	 *	space algorithm to allocate pieces from DMMAX
	 *	down to DMMIN.
	 */
	for (i = dmmax; i >= dmmin; i /= 2) {
		j = 0;

		while( rmalloc(map, i) != 0 )
			j++;

		sp->mon_avail[ffs(i)-2] = j ;
	}
}
#endif
E 12
E 8
E 1
