h25304
s 00000/00126/00012
d D 1.14 86/07/31 14:47:51 alan 14 13
c Not used anymore.  The code has been removed.
c 
e
s 00010/00030/00128
d D 1.13 86/07/30 17:27:57 alan 13 12
c Much code changed.  Most of it involved turning disks and tapes into array
c instead of linked lists, and netif and cpu in dynamically allocated arrays.
c I also combined some of the I/O vector code into one place and changed all
c the various references.
c 
c The code at this point is reasonably lint free but needs a LOT of clean up
c work.  There is a lot of inconsistant usage of "first.mon_..." and "n_...".
c 
c TODO: All the code needs to looked over and cleaned up.  The "total"
c structure for disks and tapes need to become static instead of dynamic.
c I need to merge the stack code into the approproiate mba and uba code.
c 
c The multiple CPU code needs to be tested.  I can probably simulate a
c save file from a Multiple CPU run, but...
c 
e
s 00001/00001/00157
d D 1.12 86/07/13 15:32:50 alan 12 11
c fix syntax error
e
s 00001/00002/00157
d D 1.11 86/07/13 15:25:04 alan 11 10
c make 'unsupported device type' a panic
e
s 00002/00001/00157
d D 1.10 86/07/13 14:40:08 alan 10 9
c dust off even more lint
e
s 00008/00007/00150
d D 1.9 86/07/11 19:32:02 alan 9 8
c Dust off LOTS of lint...
c 
e
s 00002/00000/00155
d D 1.8 86/05/30 11:25:33 alan 8 7
c Added initial value of "mon_flag" to all the data records.  This will be
c used to dynamically add and remove data from a display.
c 
e
s 00006/00011/00149
d D 1.7 86/05/28 15:30:42 alan 7 6
c removed tape_counter
e
s 00000/00006/00160
d D 1.6 86/05/23 19:32:08 alan 6 5
c Rather than use a structure hanging off the data record for keeping totals
c and deltas, I decided to allocate an array of structures once I know how
c many I need.  This is done in replay and gather.  The functions to free
c and allocate memory are in delta.c
c 
e
s 00000/00025/00166
d D 1.5 86/05/18 18:09:23 alan 5 4
c moved delta_disk() code to delta.c
e
s 00031/00000/00160
d D 1.4 86/05/16 09:17:30 alan 4 3
c changes for adding disk and netif data to screen function.
c 
e
s 00004/00000/00156
d D 1.3 86/05/08 18:00:17 alan 3 2
c initialized mon_type and mon_length
e
s 00144/00000/00012
d D 1.2 86/05/06 17:57:35 alan 2 1
c Changed from "yes there is a device" here, to code to build linked lists and i
c initialize static data.
c 
e
s 00012/00000/00000
d D 1.1 86/05/05 17:09:26 alan 1 0
c date and time created 86/05/05 17:09:26 by alan
e
u
U
t
T
I 1
/*
 *	Author:  Alan Rollow, CSC/CS, Digital Equipment Corp.
 *	File:	 %M%
 *	Date:	 %G%
 *	Version: %I%
 *
 *	%M% - Function to push device information onto the appropriate
 *	stack.
 */
#ifndef	lint
static	char	SccsId[] = "%W% %G%" ;
#endif
I 2
D 14

#include <nlist.h>
#include <stdio.h>
#include <signal.h>

#include <sys/types.h>

#include <sys/dk.h>
#include <sys/buf.h>
#include <sys/file.h>
#include <sys/socket.h>
#include <sys/vmsystm.h>
#include <sys/vmmeter.h>

#include <vaxuba/ubavar.h>
#include <vaxmba/mbavar.h>

#include <net/if.h>
#include <netinet/in.h>

#include "extern.h"
#include "monitor.h"
#include "record.h"

I 9
char	*malloc(),
	*strcpy() ;
I 10

E 10
E 9
D 7
static	int	tape_counter = 0 ;

E 7
D 13
static	struct mon_tape *current_tape = 0 ;
static	struct mon_disk *current_disk = 0 ;

E 13
/*
 *	This function will take a device name (hp, tms, de, etc),
 *	the address of a ..._device structure, a bus constant and
D 13
 *	a device type constant and add that device to the list
 *	of that device type.  It will also allocate space for the 
 *	structure and increment the appropriate counter.
E 13
I 13
 *	a device type constant and fill in the approproiate array
 *	member for that device type.
E 13
 *
 *	Currently the only kind of device that push_device() will
 *	recognize are Tapes and Disk, because they have to added
 *	two different places.
 *
 *		controller - Controller or Formatter number
 *		bus - mba or uba number.
 *		unit - Unit number on controller
 *		device - system wide device number 
I 13
 *
 *	This code may be merged into mba.c and uba.c in the future.
E 13
 */
push_device(name, p, bus, type)
char	*name, *p;
int	bus, type ;
{
D 7
	if( type == TAPE ) {
E 7
I 7
	if( type == TAPE )
E 7
		add_tape(name, p, bus) ;
D 7
		n_tape++ ;
	}
	else if( type == DISK ) {
E 7
I 7
	else if( type == DISK )
E 7
		add_disk(name, p, bus) ;
D 7
		n_disk++ ;
	}
E 7
	else
D 9
		fprintf(stderr, "monitor: unsupported device type: %d.\n",
E 9
I 9
D 11
		fprintf(stderr, "monitor: stack: unsupported device type: %d.\n",
E 9
			type);
E 11
I 11
D 12
		panic("monitor: stack: unsupported device type.\n);
E 12
I 12
		panic("monitor: stack: unsupported device type.\n");
E 12
E 11
}

add_tape(name, p, bus)
char	*name, *p ;
int	bus ;
{
	struct uba_device *up ;
D 9
	struct mba_slave *mp ;
E 9
D 13
	struct mon_tape *tp ;
E 13
I 13
	register struct mon_tape *tp ;
E 13

D 9
	if((tp = (struct mon_tape *)malloc(MON$S_TAPE)) == NULL )
		fatal("monitor: no space for tape structure: %s.\n");
E 9
I 9
D 13
	if((tp = (struct mon_tape *)malloc((unsigned)MON$S_TAPE)) == NULL )
		fatal("monitor: stack: no space for mon_tape: %s.\n");
E 13
I 13
	tp = tape + n_tape ;
E 13
E 9

I 7
	tp->mon_length = MON$S_TAPE ;
	tp->mon_index = tp->mon_tp = n_tape++ ;
E 7
D 13
	tp->mon_next = NULL ;
E 13
I 3
	tp->mon_type = MON$K_TAPE ;
I 8
	tp->mon_flag = 1 ;
E 8
D 7
	tp->mon_length = MON$S_TAPE ;
E 3
	tp->mon_tp   = tape_counter++ ;
E 7

D 9
	strcpy(tp->mon_name, name);
E 9
I 9
	(void)strcpy(tp->mon_name, name);
E 9

	if( bus == MBA ) {
		struct mba_slave *msp = (struct mba_slave *)p ;

		tp->mon_bus = -1 ;
		tp->mon_unit = msp->ms_slave ;
		tp->mon_controller = msp->ms_ctlr ;
	}
	else if( bus == UBA ) {
		up = (struct uba_device *)p ;

		tp->mon_bus = up->ui_ubanum ;
		tp->mon_unit = up->ui_slave ;
		tp->mon_controller = up->ui_ctlr ;
	}
	else			/* no other choices... yet */
		;
D 13

	if( tape == NULL )
		current_tape = tape = tp ;
	else {
		current_tape->mon_next = tp ;
		current_tape = tp ;
	}
E 13
}

add_disk(name, p, bus)
char	*name, *p ;
int	bus ;
{
D 13
	struct uba_device *up ;
	struct mba_device *mp ;
	struct mon_disk *dp ;
E 13
I 13
	register struct uba_device *up ;
	register struct mba_device *mp ;
	register struct mon_disk *dp ;
E 13
I 4
D 6
	char		*cp ;
E 6
E 4

D 9
	if((dp = (struct mon_disk *)malloc(MON$S_DISK)) == NULL )
		fatal("monitor: no space for disk structure: %s.\n");
E 9
I 9
D 13
	if((dp = (struct mon_disk *)malloc((unsigned)MON$S_DISK)) == NULL )
		fatal("monitor: stack: no space for mon_disk: %s.\n");
E 13
I 13
	dp = disk + n_disk ;
E 13
E 9

I 3
D 7
	dp->mon_type = MON$K_DISK ;
E 7
	dp->mon_length = MON$S_DISK ;
I 7
	dp->mon_index = n_disk++ ;
	dp->mon_type = MON$K_DISK ;
I 8
	dp->mon_flag = 1 ;
E 8
E 7
E 3
D 13
	dp->mon_next = NULL ;
E 13

D 10
	strcpy(dp->mon_name, name);
E 10
I 10
	(void)strcpy(dp->mon_name, name);
E 10

	if( bus == MBA ) {
		mp = (struct mba_device *)p ;

		dp->mon_dk = mp->mi_dk ;
		dp->mon_bus = mp->mi_mbanum ;
		dp->mon_unit = mp->mi_unit ;
		dp->mon_controller = mp->mi_drive ;
	}
	else if( bus == UBA ) {
		up = (struct uba_device *)p ;

		dp->mon_dk = up->ui_dk ;
		dp->mon_bus = up->ui_ubanum ;
		dp->mon_unit = up->ui_unit ;
		dp->mon_controller = up->ui_ctlr ;
	}
	else
		;
D 6

I 4
	if((cp = (char *)malloc(sizeof(struct tot_disk))) == NULL )
		fatal("monitor: can't allocate space for disk totals: %s.\n");

	dp->mon_total = (struct tot_disk *)cp ;
E 6
D 13

E 4
	if( disk == NULL )
		current_disk = disk = dp ;
	else {
		current_disk->mon_next = dp ;
		current_disk = dp ;
	}
E 13
I 4
}
E 14
D 5

delta_disk(dp)
struct mon_disk *dp ;
{
	register tmp ;
	struct tot_disk *tp ;

	tp = dp->mon_total ;

	tmp = dp->mon_xfer ;
	      dp->mon_xfer -= tp->t_xfer ;
	      tp->t_xfer = tmp ;

	tmp = dp->mon_seek ;
	      dp->mon_seek -= tp->t_seek ;
	      tp->t_seek = tmp ;

	tmp = dp->mon_wds ;
	      dp->mon_wds -= tp->t_wds ;
	      tp->t_wds = tmp ;

	tmp = dp->mon_time ;
	      dp->mon_time -= tp->t_time ;
	      tp->t_time = tmp ;
E 4
}
E 5
E 2
E 1
