h31826
s 00010/00000/00129
d D 1.33 90/03/29 16:17:10 alan 33 32
c The hack to fix the DECmumble include file problem.
e
s 00003/00000/00126
d D 1.32 89/05/07 22:44:11 alan 32 31
c added rusage structure to LAST record
e
s 00005/00000/00121
d D 1.31 89/02/15 20:13:19 alan 31 30
c correctly set mon_flag
e
s 00011/00001/00110
d D 1.30 88/06/27 18:16:49 alan 30 29
c changed include of monitor.h and record.h
e
s 00005/00006/00106
d D 1.29 87/08/12 15:27:22 alan 29 28
c error message clean up - V0.95
e
s 00001/00001/00111
d D 1.28 87/04/03 14:30:12 alan 28 27
c 1.  Mostly rearranged include files so that the sources would compile
c     using VAXC.
c 2.  Changed an error monitor that pcc let get by.
c 
e
s 00000/00001/00112
d D 1.27 87/02/05 16:29:42 alan 27 26
c See comment on V0.81 in version.c.
c 
e
s 00004/00000/00109
d D 1.26 87/01/21 16:37:31 alan 26 25
c This is the first pass at makeing changes to record.h.  The intent of
c this delta is to change record.h and update the files that broke so
c that they will compile and a runnable version is produced.  This
c version may not run correctly.  A few other changes were added at
c same time, which were related to the changes to record.h.  See the
c commentary on V0.68 in version.c.  The next couple of deltas will
c be clean up this one.
c 
e
s 00002/00002/00107
d D 1.25 86/12/07 22:21:20 alan 25 24
c See V0.57 in version.c
e
s 00015/00008/00094
d D 1.24 86/11/18 12:42:25 alan 24 23
c See commentary on V0.55 in version.c
c 
e
s 00002/00000/00100
d D 1.23 86/09/29 20:02:36 alan 23 22
c remove the lint
e
s 00001/00001/00099
d D 1.22 86/08/26 18:03:25 alan 22 21
c modify all SccsId strings
e
s 00008/00003/00092
d D 1.21 86/08/14 16:19:54 alan 21 20
c add '-' support for stdout
e
s 00012/00020/00083
d D 1.20 86/08/13 14:05:28 alan 20 19
c clean up error message and add file locking
e
s 00006/00003/00097
d D 1.19 86/07/31 14:07:09 alan 19 18
c Change many fprintf's to info's and add arguments to assorted warning and
c fatal error messages.
c 
e
s 00001/00110/00099
d D 1.18 86/07/30 17:27:13 alan 18 17
c Much code changed.  Most of it involved turning disks and tapes into array
c instead of linked lists, and netif and cpu in dynamically allocated arrays.
c I also combined some of the I/O vector code into one place and changed all
c the various references.
c 
c The code at this point is reasonably lint free but needs a LOT of clean up
c work.  There is a lot of inconsistant usage of "first.mon_..." and "n_...".
c 
c TODO: All the code needs to looked over and cleaned up.  The "total"
c structure for disks and tapes need to become static instead of dynamic.
c I need to merge the stack code into the approproiate mba and uba code.
c 
c The multiple CPU code needs to be tested.  I can probably simulate a
c save file from a Multiple CPU run, but...
c 
e
s 00003/00007/00206
d D 1.17 86/07/27 14:09:01 alan 17 16
c Convert CPU's to array's instead of linked lists.  I also cleaned up some
c lint in the process.  Disks and tapes will be next...
c 
e
s 00000/00002/00213
d D 1.16 86/07/13 14:39:33 alan 16 15
c dust off even more lint
e
s 00017/00018/00198
d D 1.15 86/07/11 19:26:41 alan 15 14
c Dust off LOTS of lint...
c 
e
s 00023/00024/00193
d D 1.14 86/06/29 15:27:29 alan 14 13
c Assorted work on the magnify function and general cleanup.
c 
e
s 00000/00009/00217
d D 1.13 86/06/27 16:41:41 alan 13 12
c Moved the initialization of the first record from save.c to live.c
c 
e
s 00008/00008/00218
d D 1.12 86/05/26 15:52:38 alan 12 11
c I combined the mon_state and mon_cpu structures into one (mon_cpu) which
c is supposed to be all the system data that is kept on a per CPU basis.
c See record.h for more info.  Most of the changes that occured in the files
c were a result of removing references to mon_state and opt_state.
c 
c Other changes unrelated to this:
c 1.  Changed NM_PAGE to NM_RATE.  This was in three files, monitor.h and
c     two of the others.
c 2.  I added loop for the collecting the "tape" data to save.c.  This is
c     a very short loop since there is no tape data in the system.
c 
e
s 00006/00032/00220
d D 1.11 86/05/22 15:49:13 alan 11 10
c Save had an array of structure in it that was used to store the length
c and address of all the "interesting" records that were to be saved.
c Since replay also needed a similiar array, I moved the from save.c to
c data.c and included the structure declaration in monitor.h.  An external
c declaration was added to extern.h.
c 
e
s 00002/00002/00250
d D 1.10 86/05/22 11:21:54 alan 10 9
c changed init and uninit to open and close
e
s 00096/00013/00156
d D 1.9 86/05/19 20:03:03 alan 9 8
c Replaced many write with one writev() for the data and write for the first
c and last records.  Read will be modified later to take advantage of this.
c Then I can use it to start on replay()...
c 
e
s 00000/00002/00169
d D 1.8 86/05/12 19:12:04 alan 8 7
c Moved the sample timestamp assignment from save() to gather().
c 
e
s 00025/00023/00146
d D 1.7 86/05/12 15:46:54 alan 7 6
c moved 'first_time' code to init_save()
e
s 00000/00000/00169
d D 1.6 86/05/09 11:11:42 alan 6 5
c moved out writting code, arranged to write all enabled records
e
s 00115/00016/00054
d D 1.5 86/05/09 10:26:36 alan 5 4
c started adding code for list writes and then moved it write.c
e
s 00001/00001/00069
d D 1.4 86/04/23 17:23:01 alan 4 3
c Changed all occurances of "idle" to "monitor"
c 
e
s 00004/00036/00066
d D 1.3 86/04/23 16:06:48 alan 3 2
c added time stamp.
c 
e
s 00062/00006/00040
d D 1.2 86/04/22 17:07:34 alan 2 1
c First working version
e
s 00046/00000/00000
d D 1.1 86/04/22 10:15:57 alan 1 0
c date and time created 86/04/22 10:15:57 by alan
e
u
U
t
T
I 1
/*
 *	Author:  Alan Rollow, CSC/CS, Digital Equipment Corp.
 *	File:	 %M%
 *	Date:	 %G%
 *	Version: %I%
 *
D 5
 *	%M% - 
E 5
I 5
 *	%M% - Functions to save data to a file.
E 5
 */
#ifndef	lint
D 22
static	char	SccsId[] = "%W% %G%" ;
E 22
I 22
D 24
static	char	SccsId[] = "%W%	(monitor)	%G%" ;
E 24
I 24
static	char	SccsId[] = "%W% (monitor) %G%" ;
E 24
E 22
#endif

I 30
/*
 * Modification History
 * 
 * 27-June-1988 -- arr
 *
 *	Change include of monitor.h to include.h.
 *
 *	Change include of record.h to monitor.h.
I 31
 *
 * Feb. 15, 1989 -- arr
 *
 *	Correctly set mon_flag with MON$M_VALID.
I 33
 *
 * Mar. 26, 1990 -- arr
 *
 *	Added hack to work-around DECmumble include file problem.
 *
E 33
E 31
 */

E 30
I 2
#include <nlist.h>
#include <stdio.h>
I 5
#include <signal.h>
E 5

E 2
#include <sys/types.h>
I 2
D 5
#include <sys/vm.h>
#include <sys/dk.h>
E 5
I 5
#include <sys/buf.h>
E 5
E 2
#include <sys/file.h>
I 26
D 27
#include <sys/devio.h>
E 27
E 26
I 9
#include <sys/uio.h>
E 9
I 5
#include <sys/socket.h>
#include <sys/dk.h>
I 26
#include <sys/param.h>
#include <sys/dir.h>
I 33

#if defined(V4_ULTRIX) && defined(mips)
#	include <mips/cpu.h>
#endif

E 33
#include <sys/user.h>
E 26
#include <sys/vmsystm.h>
#include <sys/vmmeter.h>
E 5

D 4
#include "idle.h"
E 4
I 4
D 5
#include "monitor.h"
E 5
I 5
#include <net/if.h>
#include <netinet/in.h>

I 30
#include "include.h"
E 30
E 5
E 4
D 28
#include "extern.h"
E 28
I 5
#include "monitor.h"
D 30
#include "record.h"
E 30
E 5
I 2
#include "options.h"
I 28
#include "extern.h"
E 28
E 2

I 5
D 14
static	int	first_time = 1 ;

E 14
D 11
static struct table {
	char	*addr ;
	int	size ;
	char	*string ;
} array[] = {
	(char *)&first,		MON$S_FIRST, "first",
	(char *)&last,		MON$S_LAST, "last",
	(char *)&sample,	MON$S_SAMPLE, "sample",
	0,			MON$S_RECTYPE3, "record type 3",
	(char *)&cpu,		MON$S_CPU, "cpu",
	(char *)&tty,		MON$S_TTY, "tty",
	0,			MON$S_DISK, "disk",
	(char *)&freemem,	MON$S_FREE, "free",
	(char *)&fork,		MON$S_FORK, "fork",
	(char *)&page,		MON$S_PAGE, "page",
	(char *)&proc,		MON$S_PROC, "proc",
	0,			MON$S_SWAP, "swap",
	0,			MON$S_TAPE, "tape",
	(char *)&user,		MON$S_USER, "user",
	0,			MON$S_NETIF, "netif",
	0,			MON$S_STATE, "state",
	(char *)&memory,	MON$S_MEMORY, "memory",
	(char *)&loadave,	MON$S_LOADAVE, "loadave",
	0,			MON$S_PANIC, "panic!",
};

E 11
I 9
/*
I 24
 *	Module name for error functions.
 */
static	char	*module = "save" ;

/*
E 24
I 20
 *	We're going to keep the data file open for the duration
 *	of execution.  To prevent another copy of monitor to write
 *	on the same file, we'll use BLKANDSET to provide some file
 *	locking.  The O_NDELAY causes open to return with an error
 *	instead of blocking.
 */
#define	OPEN_FLAG	(O_WRONLY|O_CREAT|O_APPEND|O_BLKANDSET|O_NDELAY)

D 21
static	int	fd = 0 ;	/* a common file descriptor */
E 21
I 21
static	int	fd = -1 ;	/* a common file descriptor */
E 21

/*
E 20
D 11
 *	This is going to turn into an array of iovec's.
E 11
I 11
D 14
 *	This is going to turn into an records of iovec's.
E 14
I 14
D 18
 *	This is going to turn into an array of iovec's.
E 14
E 11
 */
typedef struct iovec IOVEC ;
E 9

I 9
IOVEC	*iov ;
D 14
int	n_records = 0 ;
E 14
I 14
static	n_records = 0 ;
E 14

E 9
E 5
/*
E 18
I 2
 *	Initialization function for save.
I 9
 *
 *	By this time we should know what data records are being saved.
D 11
 *	It seems reasonable that we can set aside an array of iovec[]
E 11
I 11
D 14
 *	It seems reasonable that we can set aside an records of iovec[]
E 14
I 14
 *	It seems reasonable that we can set aside an array of iovec[]
E 14
E 11
 *	structures and write the data out with writev(2).
E 9
 */
D 10
init_save(p)
E 10
I 10
D 14
open_save(p)
E 10
OPTION	*p ;
E 14
I 14
open_save(op)
OPTION	*op ;
E 14
{
I 7
D 20
	int	fd ;
I 9
D 15
	int	i ;
E 15
D 18
	char	*calloc() ;
E 18
E 9

E 7
D 3
	char	*malloc() ;

	if((data = (DATA *)malloc(p->opt_sample * sizeof(DATA))) == NULL )
		fatal("idle: can't allocate space for data: %s\n");

E 3
D 16
	close(fileno(stdin));
I 7

E 16
D 14
	if((fd = open(p->opt_file, O_WRONLY|O_CREAT|O_APPEND, 0644)) == -1 )
E 14
I 14
	if((fd = open(op->opt_file, O_WRONLY|O_CREAT|O_APPEND, 0644)) == -1 )
E 20
I 20
D 21
	if((fd = open(op->opt_file, OPEN_FLAG, 0644)) == -1 )
E 20
E 14
D 15
		fatal("monitor: can't open output file: %s.\n");
E 15
I 15
D 19
		fatal("monitor: save: can't open output file: %s.\n");
E 19
I 19
		fatal("monitor: save: can't open data file: %s (%s).\n", 
E 21
I 21
	if( op->opt_standard )
		fd = fileno(stdout);
	else
		fd = open(op->opt_file, OPEN_FLAG, 0644);

	if( fd == -1 )
D 24
		fatal("monitor: save: can't open data file: %s (%s).\n",
E 24
I 24
D 29
		fatal("can't open data file: %s (%s).\n", module,
E 24
E 21
			op->opt_file);
E 29
I 29
		fatal("Can't open data file: %s (%s).\n", module, op->opt_file);
E 29
E 19
E 15

D 13
	first.mon_options = p->opt_data ;
	first.mon_sleep   = p->opt_sleep ;
	first.mon_cpu     = n_cpu ;
	first.mon_disk    = n_disk ;
	first.mon_tape    = n_tape ;
	first.mon_netif   = n_netif ;
I 9
	first.mon_pid 	  = getpid();
	first.mon_sdate	  = time(0);
E 9

E 13
D 9
	write_first(fd);
E 9
I 9
	if( write(fd, (char *)&first, MON$S_FIRST) == -1 )
D 15
		fatal("monitor: can't write first record: %s.\n");
E 15
I 15
D 24
		fatal("monitor: save: can't write first record: %s.\n");
E 24
I 24
D 29
		fatal("can't write first record: %s.\n", module);
E 29
I 29
		fatal("Can't write first record: %s.\n", module);
E 29
E 24
E 15
E 9

D 9
	sample.mon_datalen = sample_length(p);
E 9
I 9
D 14
	sample.mon_datalen = sample_length(p, &n_records);
E 14
I 14
D 18
	n_records = sample_length(op);
E 18
I 18
	init_iovec(op);
E 18
E 14
E 9
D 20

	if( close(fd) == -1 )
D 15
		fatal("monitor: can't close output file: %s.\n");
E 15
I 15
		fatal("monitor: save: can't close output file: %s.\n");
E 20
E 15
I 9
D 18

D 15
	if((iov = (IOVEC *)calloc(n_records, sizeof(struct iovec))) == NULL )
		fatal("monitor: can't calloc() space for iov's: %s.\n");
E 15
I 15
	if((iov = (IOVEC *)calloc((unsigned)n_records, sizeof(struct iovec))) == NULL )
		fatal("monitor: save: no space for iov's: %s.\n");
E 15

D 14
	init_iov(p);
E 14
I 14
	init_iov(op);
E 18
E 14
E 9
E 7
}

/*
 *	Un-initialization function for save.
I 24
 *
 *	ARGSUSED
E 24
 */
I 23
D 24
/* ARGSUSED */
E 24
E 23
D 5
uninit_save(p)
OPTION	*p ;
E 5
I 5
D 10
uninit_save(op)
E 10
I 10
close_save(op)
E 10
OPTION	*op ;
E 5
{
I 5
D 25
	time_t	time() ;
E 25
I 25
	long	time() ;
E 25
D 20
	int	fd ;
E 20

D 7
	if((fd = open(op->opt_file, O_WRONLY|O_CREAT|O_APPEND, 0644)) == -1 ) {
		warning("monitor: can't open file for last record: %s.\n");
		return -1 ;
	}
E 7
I 7
D 20
	if((fd = open(op->opt_file, O_WRONLY|O_CREAT|O_APPEND, 0644)) == -1 )
D 15
		fatal("monitor: can't open file for last record: %s.\n");
E 15
I 15
D 19
		fatal("monitor: save: can't open file for last record: %s.\n");
E 19
I 19
		fatal("monitor: save: can't open file for last record: %s. (%s)\n",
			op->opt_file);
E 19
E 15
E 7

E 20
	if( !killed )
		last.mon_signal = -1 ;

D 15
	last.mon_edate = time(0);
E 15
I 15
D 25
	last.mon_edate = time((time_t *)0);
E 25
I 25
	last.mon_edate = time((long *)0);
I 31
	last.mon_flag  = MON$M_VALID ;
E 31
E 25
E 15

I 32
	if( getrusage(RUSAGE_SELF, &last.mon_usage) == -1 )
		warning("Can't get resource information: %s.\n", module) ;

E 32
	if( write(fd, (char *)&last, MON$S_LAST) == -1 )
D 7
		warning("monitor: can't write last record: %s.\n");
E 7
I 7
D 15
		fatal("monitor: can't write last record: %s.\n");
E 15
I 15
D 24
		fatal("monitor: save: can't write last record: %s.\n");
E 24
I 24
D 29
		fatal("can't write last record: %s.\n", module);
E 29
I 29
		fatal("Can't write last record: %s.\n", module);
E 29
E 24
E 15
E 7

	if( close(fd) == -1 )
D 7
		warning("monitor: can't close output file: %s.\n");
		
E 7
I 7
D 15
		fatal("monitor: can't close output file: %s.\n");
E 15
I 15
D 24
		fatal("monitor: save: can't close output file: %s.\n");
E 24
I 24
D 29
		fatal("can't close output file: %s.\n", module);
E 29
I 29
		fatal("Can't close output file: %s.\n", module);
E 29
E 24
E 15
E 7
E 5
D 3
	free(data);
E 3
}

/*
E 2
 *	Save the collected data in "file".
I 24
 *
 *	ARGSUSED
E 24
 */
I 23
D 24
/* ARGSUSED */
E 24
E 23
D 2
save(file, opt)
char	*file ;
OPTION	*opt ;		/* currently unused */
E 2
I 2
save(op)
D 15
OPTION	*op ;		/* currently unused */
E 15
I 15
OPTION	*op ;
E 15
E 2
{
D 2
	int	fd ;
E 2
I 2
D 3
	int	fd, size = sizeof(DATA) * op->opt_sample ;
	DATA	summary ;
E 3
I 3
D 5
	int	fd;
E 5
I 5
D 15
	int	fd, i;
E 15
I 15
D 20
	register fd ;
E 15
E 5
E 3
E 2

D 2
	if((fd = open(file, O_WRONLY|O_CREAT|O_APPEND, 0644)) == -1 )
E 2
I 2
D 7
	if((fd = open(op->opt_file, O_WRONLY|O_CREAT|O_APPEND, 0644)) == -1 )
E 7
I 7
D 15
	if((fd = open(op->opt_file, O_WRONLY|O_CREAT|O_APPEND, 0644)) == -1 ) {
		warning("monitor: can't open output file: %s.\n");
E 7
E 2
		return -1 ;
D 7

I 2
D 3
	summarize_data(&summary, op->opt_sample);

E 3
E 2
	/*
D 5
	 * This should go something like...
	 *
	 *	if( opt->opt_type ) {
	 *		n_written = write(fd, data_type, sizeof(data_type)) ;
	 *		if( n_written != sizeof(data_type))a
	 *			error();
	 *	}
E 5
I 5
 	 *	If this is the first call to save, then write out the
	 *	"first" record and initialize as much of the sample 
	 *	record as possible.
E 5
	 */
I 5
	if( first_time ) {
		first.mon_options = op->opt_data ;
		first.mon_sleep = op->opt_sleep ;
E 5

D 2
	if( write(fd, data, sizeof(DATA)) != sizeof(DATA))
E 2
I 2
D 3
	if( write(fd, (char *)&summary, sizeof(DATA)) != sizeof(DATA))
E 3
I 3
D 5
	data.timestamp = time(0);
E 5
I 5
		write_first(fd);
E 5

D 5
	if( write(fd, (char *)&data, sizeof(DATA)) != sizeof(DATA))
E 5
I 5
		sample.mon_datalen = sample_length(op);

		first_time = 0 ;
E 7
	}
E 15
I 15
	if((fd = open(op->opt_file, O_WRONLY|O_CREAT|O_APPEND, 0644)) == -1 )
D 19
		fatal("monitor: save: can't open output file: %s.\n");
E 19
I 19
		fatal("monitor: save: can't open data file: %s (%s).\n",
			op->opt_file);
E 19
E 15

E 20
D 8
	sample.mon_timestamp = time(0);

E 8
D 9
	if( write(fd, (char *)&sample, MON$S_SAMPLE) != MON$S_SAMPLE)
E 5
E 3
E 2
		return -1 ;
E 9
I 9
	if( writev(fd, iov, n_records) != sample.mon_datalen )
D 15
		fatal("monitor: writev failed: %s.\n");
E 15
I 15
D 24
		fatal("monitor: save: writev failed: %s.\n");
E 24
I 24
D 29
		fatal("writev failed: %s.\n", module);
E 29
I 29
		fatal("Writev failed: %s.\n", module);
E 29
E 24
E 15
E 9
D 20

I 5
D 9
	for(i = MON$K_CPU; i < sizeof(op->opt_data) * 8; i++) {
		if( op->opt_data & (1 << i))
			write_records(&array[i], i, fd) ;
	}

E 9
E 5
	if( close(fd) == -1 )
D 15
		return -1 ;
E 15
I 15
		fatal("monitor: save: can't close output file: %s.\n");
E 20

	return MON_NORMAL ;
E 15
I 5
D 18
}

/*
D 9
 *
E 9
I 9
 *	Figure out how big a sample and count the number of
 *	records involved.
E 9
 */
D 9
sample_length(op)
OPTION	*op ;
E 9
I 9
D 14
sample_length(op, ip)
E 14
I 14
sample_length(op)
E 14
register OPTION	*op ;
D 14
register int 	*ip ;
E 14
E 9
{
D 9
	int	i, total_size = 0 ;
E 9
I 9
D 14
	register int	i, total_size = 0 ;
E 14
I 14
	register int i, n = 0 ;
E 14
E 9

I 14
	sample.mon_datalen = 0 ;

E 14
	for(i = 0; i < sizeof(op->opt_data) * 8; i++)
		if( op->opt_data & (1 << i)) {
			switch( i ) {
			case MON$K_DISK:
D 14
				total_size += (n_disk * MON$S_DISK);
I 9
				*ip += n_disk ;
E 14
I 14
				sample.mon_datalen += (n_disk * MON$S_DISK);
				n += n_disk ;
E 14
E 9
				break ;
			case MON$K_TAPE:
D 14
				total_size += (n_tape * MON$S_TAPE);
I 9
				*ip += n_tape ;
E 14
I 14
				sample.mon_datalen += (n_tape * MON$S_TAPE);
				n += n_tape ;
E 14
E 9
				break ;
			case MON$K_NETIF:
D 14
				total_size += (n_netif * MON$S_NETIF);
I 9
				*ip += n_netif ;
E 14
I 14
				sample.mon_datalen += (n_netif * MON$S_NETIF);
				n += n_netif ;
E 14
E 9
				break ;
D 12
			case MON$K_STATE:
				total_size += (n_cpu * MON$S_STATE);
E 12
I 12
			case MON$K_CPU:
D 14
				total_size += (n_cpu * MON$S_CPU);
E 12
I 9
				*ip += n_cpu ;
E 14
I 14
				sample.mon_datalen += (n_cpu * MON$S_CPU);
				n += n_cpu ;
E 14
E 9
				break ;
			default:
D 11
				total_size += array[i].size ;
E 11
I 11
D 14
				total_size += records[i].rec_size ;
E 11
I 9
				(*ip)++ ;
E 14
I 14
				sample.mon_datalen += records[i].rec_size ;
				n++ ;
E 14
E 9
				break ;
			}
		}

D 14
	return total_size ;
E 14
I 14
	return n ;
E 14
I 9
}

/*
D 11
 *	After an array of iovec's has been allocated initialize each
E 11
I 11
 *	After an records of iovec's has been allocated initialize each
E 11
 *	one with the address of the record and its length.
 */
init_iov(op)
OPTION	*op ;
{
	register i, index = 0 ;
I 12
D 17
	struct mon_cpu *cp = cpu ;
E 17
E 12
	struct mon_disk *dp = disk ;
	struct mon_tape *tp = tape ;
	struct mon_netif *np = netif ;
D 12
	struct mon_state *sp = state ;
E 12

	for(i = 0; i < sizeof(op->opt_data) * 8; i++) {
		if((op->opt_data & (1 << i)) == 0 ) 
			continue ;

		switch( i ) {
		case MON$K_DISK:
			while( dp ) {
				(iov+index)->iov_base = (caddr_t)dp ;
				(iov+index)->iov_len = MON$S_DISK ;
				index++ ;
				dp = dp->mon_next ;
			}
			break ;
		case MON$K_TAPE:
			while( tp ) {
				(iov+index)->iov_base = (caddr_t)tp ;
				(iov+index)->iov_len = MON$S_TAPE ;
				index++ ;
				tp = tp->mon_next ;
			}
			break ;
		case MON$K_NETIF:
			while( np ) {
				(iov+index)->iov_base = (caddr_t)np ;
				(iov+index)->iov_len = MON$S_NETIF ;
				index++ ;
				np = np->mon_next ;
			}
			break ;
D 12
		case MON$K_STATE:
			while( sp ) {
				(iov+index)->iov_base = (caddr_t)sp ;
				(iov+index)->iov_len = MON$S_STATE;
E 12
I 12
		case MON$K_CPU:
D 17
			while( cp ) {
				(iov+index)->iov_base = (caddr_t)cp ;
				(iov+index)->iov_len = MON$S_CPU ;
E 12
				index++ ;
D 12
				sp = sp->mon_next ;
E 12
I 12
				cp = cp->mon_next ;
E 12
			}
E 17
I 17
			(iov+index)->iov_base = (caddr_t)cpu ;
			(iov+index)->iov_len = MON$S_CPU * first.mon_cpu ;
			index++ ;
E 17
			break ;
		default:
D 11
			(iov+index)->iov_base = (caddr_t)array[i].addr;
			(iov+index)->iov_len = array[i].size;
E 11
I 11
			(iov+index)->iov_base = (caddr_t)records[i].rec_addr;
			(iov+index)->iov_len = records[i].rec_size;
E 11
			index++ ;
			break ;
		}
	}
E 18
E 9
E 5
I 2
D 3
}

summarize_data(sp, n)
DATA	*sp ;
int	n ;
{
	int	i, j ;

	for(i = 0; i < n; i++) {
		for(j = 0; j < 4; j++)
			sp->loadave[j] += data[i].loadave[j] ;

		for(j = 0; j < CPUSTATES; j++)
			sp->cpu_time[j] += data[i].cpu_time[j] ;

		sp->free += data[i].free ;
	}

	for(i = 0; i < 4 ; i++)
		sp->loadave[i] /= n ;

	for(i = 0; i < CPUSTATES; i++)
		sp->cpu_time[i] /= n ;

	sp->free /= n ;
E 3
E 2
}
E 1
