h58284
s 00005/00000/00106
d D 1.12 89/01/13 16:34:25 alan 12 11
c dust off lint picked up in adding get_word()
e
s 00001/00001/00105
d D 1.11 89/01/13 14:48:56 alan 11 10
c fixed bug in get_word() arg list.
e
s 00029/00000/00077
d D 1.10 89/01/12 22:54:12 alan 10 9
c added get_word()
e
s 00006/00006/00071
d D 1.9 87/08/12 15:25:28 alan 9 8
c error message clean up - V0.95
e
s 00042/00004/00035
d D 1.8 87/03/03 15:42:31 alan 8 7
c see the commentary for V0.83 in version.c
e
s 00003/00003/00036
d D 1.7 87/02/02 16:22:11 alan 7 6
c V0.79 in version.c
e
s 00012/00003/00027
d D 1.6 86/11/18 12:42:14 alan 6 5
c See commentary on V0.55 in version.c
c 
e
s 00001/00001/00029
d D 1.5 86/08/26 18:04:23 alan 5 4
c modify all SccsId strings
e
s 00002/00002/00028
d D 1.4 86/07/11 19:32:11 alan 4 3
c Dust off LOTS of lint...
c 
e
s 00002/00000/00028
d D 1.3 86/05/30 10:06:37 alan 3 2
c dust off some lint
e
s 00002/00002/00026
d D 1.2 86/05/09 17:43:46 alan 2 1
c Changed warning to fatal.
c 
e
s 00028/00000/00000
d D 1.1 86/05/09 11:21:59 alan 1 0
c date and time created 86/05/09 11:21:59 by alan
e
u
U
t
T
I 1
/*
 *	Author:  Alan Rollow, CSC/CS, Digital Equipment Corp.
 *	File:	 %M%
 *	Date:	 %G%
 *	Version: %I%
 *
 *	%M% - Function to read stuff from kernel space.
 */
#ifndef	lint
D 5
static	char	SccsId[] = "%W% %G%" ;
E 5
I 5
D 6
static	char	SccsId[] = "%W%	(monitor)	%G%" ;
E 6
I 6
static	char	SccsId[] = "%W% (monitor) %G%" ;
E 6
E 5
#endif

I 10
/*
 * Modification history.
 *
 * 1/12/89 -- arr
 *
 *	Added get_word().  It will be used a lot by the
 *	swap code and anything else that only needs a 
 *	longword.
 */

E 10
#include <sys/types.h>
#include <sys/file.h>

I 8
#include <stdio.h>

E 8
I 6
/*
I 12
 *	Functions that don't return (int).
 */
long	lseek() ;

/*
E 12
 *	Module name for error functions.
 */
static	char	*module = "read_kernel" ;
I 8
extern	char	*program_name ;
E 8

E 6
D 8
extern	int	kmem ;
E 8
I 8
extern	int	kmem, mem, swap ;
I 10

/*
 *	Seek to "where" in /dev/kmem and read a longword
 *	into "longword" and then return it.  This may take
 *	an file descriptior later to make it more general.
 */
D 11
get_word(addr)
E 11
I 11
get_word(where)
E 11
long	where ;
{
	long	longword ;

	if( lseek(kmem, where, L_SET) == -1 )
		fatal("Can't lseek in /dev/kmem: %s.\n", module);

	if( read(kmem, (char *)&longword, sizeof(long)) == -1 )
		fatal("Can't read from /dev/kmem: %s.\n", module);

	return longword ;
}
E 10
E 8

I 6
/*
 *	Seek to "where" in the kernel and read "size" bytes
 *	into the space at "addr".
 */
E 6
readk(where, addr, size)
D 7
long	where ;
char	*addr ;
int	size ;
E 7
I 7
D 8
register long	where ;
register char	*addr ;
register int	size ;
E 8
I 8
long	where ;
char	*addr ;
int	size ;
E 8
E 7
{
I 3
	long	lseek() ;

E 3
	if( lseek(kmem, where, L_SET) == -1 )
D 2
		warning("monitor: can't lseek in /dev/kmem: %s.\n");
E 2
I 2
D 4
		fatal("monitor: can't lseek in /dev/kmem: %s.\n");
E 4
I 4
D 6
		fatal("monitor: readk: can't lseek in /dev/kmem: %s.\n");
E 6
I 6
D 9
		fatal("can't lseek in /dev/kmem: %s.\n", module);
E 9
I 9
		fatal("Can't lseek in /dev/kmem: %s.\n", module);
E 9
E 6
E 4
E 2

	if( read(kmem, addr, size) == -1 )
D 2
		warning("monitor: can't read from /dev/kmem: %s.\n");
E 2
I 2
D 4
		fatal("monitor: can't read from /dev/kmem: %s.\n");
E 4
I 4
D 6
		fatal("monitor: readk: can't read from /dev/kmem: %s.\n");
E 6
I 6
D 9
		fatal("can't read from /dev/kmem: %s.\n", module);
E 9
I 9
		fatal("Can't read from /dev/kmem: %s.\n", module);
E 9
I 8
}

/*
 *	Seek to "where" in physical memory and read "size" bytes in
 *	the space at "addr".
 */
readm(where, addr, size)
long	where ;
char	*addr ;
int	size ;
{
	long	lseek() ;

	if( lseek(mem, where, L_SET) == -1 )
D 9
		fatal("can't lseek in /dev/mem: %s.\n", module);
E 9
I 9
		fatal("Can't lseek in /dev/mem: %s.\n", module);
E 9

	if( read(mem, addr, size) == -1 )
D 9
		fatal("can't read from /dev/mem: %s.\n", module);
E 9
I 9
		fatal("Can't read from /dev/mem: %s.\n", module);
E 9
}

/*
 *	Read stuff from the swap device.
 */
reads(where, addr, size)
long	where ;
char	*addr ;
int	size ;
{
	long	lseek() ;

	if( lseek(swap, where, L_SET) == -1 )
D 9
		fatal("can't lseek in /dev/drum: %s.\n", module);
E 9
I 9
		fatal("Can't lseek in /dev/drum: %s.\n", module);
E 9

	if( read(swap, addr, size) == -1 )
D 9
		fatal("can't read from /dev/drum: %s.\n", module);
E 9
I 9
		fatal("Can't read from /dev/drum: %s.\n", module);
E 9
E 8
E 6
E 4
E 2
}
E 1
