h47140
s 00010/00000/00144
d D 1.37 90/03/29 16:16:27 alan 37 36
c The hack to fix the DECmumble include file problem.
e
s 00003/00003/00141
d D 1.36 89/02/25 09:57:07 alan 36 35
c editorial change to rec_ elements
e
s 00011/00018/00133
d D 1.35 89/02/15 19:29:13 alan 35 34
c properly set mon_flag in all records
e
s 00012/00001/00139
d D 1.34 89/02/10 15:21:50 alan 34 33
c Change for new BUF record and RECONF record.
c 
e
s 00011/00028/00129
d D 1.33 89/01/16 18:53:25 alan 33 32
c pound out bugs in the data collection for swap, namei cache and buffer cache
e
s 00002/00002/00155
d D 1.32 89/01/15 20:23:13 alan 32 31
c added functions for swap space
e
s 00009/00110/00148
d D 1.31 88/06/29 23:31:24 alan 31 30
c See the modification history for 29-June-1988.
c 
e
s 00012/00002/00246
d D 1.30 88/06/27 18:16:12 alan 30 29
c changed include of monitor.h and record.h
e
s 00016/00014/00232
d D 1.29 87/11/18 16:40:27 alan 29 28
c V0.99 -> T1.0-1
e
s 00006/00006/00240
d D 1.28 87/08/12 15:26:22 alan 28 27
c error message clean up - V0.95
e
s 00000/00002/00246
d D 1.27 87/08/11 13:58:45 alan 27 26
c V0.93 - removed pgtok macro
e
s 00001/00001/00247
d D 1.26 87/04/03 14:30:33 alan 26 25
c 1.  Mostly rearranged include files so that the sources would compile
c     using VAXC.
c 2.  Changed an error monitor that pcc let get by.
c 
e
s 00002/00001/00246
d D 1.25 87/03/03 15:41:25 alan 25 24
c see the commentary for V0.83 in version.c
e
s 00001/00001/00246
d D 1.24 87/02/09 15:48:28 alan 24 23
c added f_nop() as place holder for tape function
e
s 00002/00013/00245
d D 1.23 87/02/05 16:29:08 alan 23 22
c See comment on V0.81 in version.c.
c 
e
s 00012/00001/00246
d D 1.22 87/02/04 16:23:46 alan 22 21
c see V0.80 in version.c
e
s 00004/00000/00243
d D 1.21 87/01/21 16:36:58 alan 21 20
c This is the first pass at makeing changes to record.h.  The intent of
c this delta is to change record.h and update the files that broke so
c that they will compile and a runnable version is produced.  This
c version may not run correctly.  A few other changes were added at
c same time, which were related to the changes to record.h.  See the
c commentary on V0.68 in version.c.  The next couple of deltas will
c be clean up this one.
c 
e
s 00123/00003/00120
d D 1.20 86/11/19 09:39:43 alan 20 19
c See commentary on V0.56 in version.c
c 
e
s 00061/00176/00062
d D 1.19 86/11/16 16:31:27 alan 19 18
c See comments for V0.51 in version.c
c 
e
s 00005/00034/00233
d D 1.18 86/10/30 20:43:20 alan 18 17
c 1.  Make "disk" and "tape" static arrays.
c 2.  Make "iov" static array.
c 
e
s 00001/00001/00266
d D 1.17 86/10/30 14:46:20 alan 17 16
c change read_extern.h to extern.h
e
s 00010/00009/00257
d D 1.16 86/10/30 14:24:06 alan 16 15
c dust off lint
e
s 00007/00007/00259
d D 1.15 86/05/26 16:57:47 alan 15 14
c Changes due to change in mon_cpu and mon_state structures.
c 
e
s 00008/00004/00258
d D 1.14 86/05/20 17:56:47 alan 14 13
c fixed return codes so read_session would read more than one session
e
s 00179/00044/00083
d D 1.13 86/05/20 16:25:33 alan 13 12
c rewrote to use readv() to read the sample
e
s 00002/00314/00125
d D 1.12 86/05/20 09:32:06 alan 12 11
c 1.  Broke read.c up into modules:
c     read.c - read records out of the file and call approproiate function.
c     functions.c - The data functions.
c     read_data.c - Global data.
c     read_extern.h - Declarations of global data.
c 
e
s 00005/00001/00434
d D 1.11 86/05/12 14:53:15 alan 11 10
c added list count fields to first record
e
s 00011/00003/00424
d D 1.10 86/05/11 18:26:12 alan 10 9
c read now takes filenames
e
s 00046/00002/00381
d D 1.9 86/05/11 17:03:54 alan 9 8
c added code to print the netif flags as names
e
s 00006/00000/00377
d D 1.8 86/05/11 15:17:43 alan 8 7
c 1.  Print out etime with tty structure.
c 2.  Print out flags with netif structure.
c 
e
s 00000/00001/00377
d D 1.7 86/05/11 14:23:09 alan 7 6
c removed reference mon_total when printing out mon_state structure.
e
s 00271/00047/00107
d D 1.6 86/05/10 19:16:35 alan 6 5
c added many, many functions for printing records
e
s 00116/00042/00038
d D 1.5 86/05/08 14:41:31 alan 5 4
c replaced previous version with code from ../reocord/read.c
e
s 00016/00013/00064
d D 1.4 86/04/24 17:07:37 alan 4 3
c changed output format
e
s 00001/00001/00076
d D 1.3 86/04/24 09:40:31 alan 3 2
c changed idle to monitor
e
s 00011/00003/00066
d D 1.2 86/04/23 16:08:25 alan 2 1
c Now knows about timestamp.
c 
e
s 00069/00000/00000
d D 1.1 86/04/23 11:27:04 alan 1 0
c date and time created 86/04/23 11:27:04 by alan
e
u
U
t
T
I 1
/*
 *	Author:  Alan Rollow, CSC/CS, Digital Equipment Corp.
 *	File:	 %M%
 *	Date:	 %G%
 *	Version: %I%
 *
D 5
 *	%M% - 
E 5
I 5
D 19
 *	%M% - program to read monitor data files.  This will used
 *		to verify written records.
E 19
I 19
 *	%M% - Display functions to provide the functionality of
 *	the old "read" program.
E 19
 *
 *	Taken from ~alan/src/mon/record/read.c Labeled:
 *
 *		"@(#)read.c	1.2 5/2/86"
I 9
 *
D 19
 *	The print_if code was taken from ~alan/src/mon/names/netif.c Labeled:
 *
 *		"@(#)netif.c	1.3 5/6/86" ;
 *
E 19
I 19
 *	Adapted from ~alan/src/monitor/read/read.c V1.18.
I 20
 *
D 31
 *	There are two sets of "READ" functions in this file.  The
 *	..._read() function are used when the collection mode is
 *	LIVE.  The ..._dump() functions are used when the collection
 *	mode is REPLAY.  Both sets of functions use the f_...()
 *	functions to actually print the record contents.
 *
 *	The "dump" functions are Very simple.  They open file, read
 *	a record and print the contents of the record until EOF and
 *	then close the file.
 *
 *	The read functions expect expect each record to be in the
 *	"expected" place before they try to print it.
E 31
E 20
E 19
E 9
E 5
 */
#ifndef	lint
D 18
static	char	SccsId[] = "%W% %G%" ;
E 18
I 18
D 19
static	char	SccsId[] = "%W% (read-monitor) %G%" ;
E 19
I 19
static	char	SccsId[] = "%W% (monitor) %G%" ;
E 19
E 18
#endif

I 30
/*
 * Modification History
 * 
 * 27-June-1988 -- arr
 *
 *	Change include of monitor.h to include.h.
 *
 *	Change include of record.h to monitor.h.
I 31
 *
 * 29-June-1988 -- arr
 *
 *	Remove the special code for reading saved data files.  I'm
 *	going to use the regular replay instead.
 *
 *	Dusted off some lint.
 *
 *	Remove the include of options.h since it wasn't needed.
I 33
 *
 * Jan. 15, 1989 -- arr
 *
 *	Move record dump function table to tables.c.
I 34
 *
 * Feb. 10, 1989 -- arr
 *
 *	Added case to switch for BUF records.	
I 35
 *
 * Feb. 15, 1989 -- arr
 *
 *	Moved header printf's to f_...() functions.
I 37
 *
 * Mar. 26, 1990 -- arr
 *
 *	Added hack to work-around DECmumble include file problem.
 *
E 37
E 35
E 34
E 33
E 31
 */

E 30
I 5
#include <nlist.h>
E 5
I 4
#include <stdio.h>
I 5
#include <signal.h>
E 5

E 4
#include <sys/types.h>
I 21
D 22
#include <sys/devio.h>
E 22
E 21
I 5
#include <sys/buf.h>
E 5
#include <sys/file.h>
D 5
#include <sys/vm.h>
E 5
I 5
#include <sys/socket.h>
E 5
#include <sys/dk.h>
I 21
#include <sys/param.h>
#include <sys/dir.h>
I 37

#if defined(V4_ULTRIX) && defined(mips)
#	include <mips/cpu.h>
#endif

E 37
#include <sys/user.h>
E 21
I 13
#include <sys/uio.h>
E 13
I 5
#include <sys/vmsystm.h>
#include <sys/vmmeter.h>
E 5

D 5
#include <machine/param.h>
E 5
I 5
#include <net/if.h>
#include <netinet/in.h>
E 5

I 6
#include <machine/param.h>

I 22
D 23
#ifdef	V20
#	include <sys/devio.h>
#endif

E 23
E 22
D 27
#define	pgtok(x)	((x)*NBPG/1024)

E 27
E 6
I 5
D 12
#include "extern.h"
E 5
D 3
#include "idle.h"
E 3
I 3
#include "monitor.h"
E 12
I 12
D 19
#include "read.h"
E 19
I 19
D 30
#include "monitor.h"
E 30
I 30
#include "include.h"
E 30
E 19
D 17
#include "read_extern.h"
E 17
I 17
D 26
#include "extern.h"
E 26
I 20
D 31
#include "options.h"
E 31
E 20
E 17
E 12
I 5
D 30
#include "record.h"
E 30
I 30
#include "monitor.h"
E 30
I 26
#include "extern.h"
E 26
E 5
E 3

I 20
/*
I 22
D 31
 *	Version number of record file.
 */
extern	dev_t	record_version ;

/*
E 22
 *	Module name for error functions.
 */
static	char	*module = "read" ;

/*
E 31
D 33
 *	Function declarations so they can be used in the table.
E 33
I 33
 *	In tables.c
E 33
 */
E 20
I 13
D 19
/*
 *	Local data and stuff.
 */
struct mon_header header ;
E 19
I 19
D 33
int	f_first(), f_last(), f_sample(), f_nop(),	/* control records */
D 23
	f_tty(), f_disk(), f_tape(), f_netif(),		/* I/O records */
E 23
I 23
	f_tty(), f_disk(), f_netif(),			/* I/O records */
E 23
D 32
	f_cpu(), f_fork(), f_proc(),			/* OS records */
E 32
I 32
	f_cpu(), f_fork(), f_proc(), f_swap(),		/* OS records */
E 32
D 25
	f_user(), f_loadave(),				/* misc records */
E 25
I 25
D 29
	f_user(), f_loadave(), f_pid(),			/* misc records */
E 25
	f_free(), f_page(), f_swap(), f_memory() ;	/* memory management */
E 29
I 29
	f_user(), f_loadave(), f_pid(), f_panic(),	/* misc records */
	f_free(), f_page(), f_ni(), f_memory() ;	/* memory management */
E 33
I 33
extern	int	(*dump_functions[])() ;
E 33
E 29
E 19

I 20
/*
D 33
 *	Array of function pointers, one for each record type.
 */
E 20
D 19
typedef struct iovec IOVEC ;
E 19
I 19
int	(*funct[])() = {
	f_first, f_last, f_sample, f_nop,	/* control records */
	f_cpu, f_tty,				/* data records */
	f_disk, f_free, f_fork,			/*    ditto    */
D 29
	f_page, f_proc, f_swap,			/*    ditto    */
D 23
	f_tape, f_user,				/*    ditto    */
E 23
I 23
D 24
	f_user,					/*    ditto    */
E 24
I 24
	f_nop, f_user,				/*    ditto    */
E 29
I 29
D 32
	f_page, f_proc, f_ni,			/* PAGE, PROC and SWAP */
E 32
I 32
	f_page, f_proc, f_swap,			/* PAGE, PROC and SWAP */
E 32
	f_ni, f_user,				/* TAPE, USER  */
E 29
E 24
E 23
	f_netif,				/*    ditto    */
	f_memory,				/*    ditto    */
	f_loadave,				/*    ditto    */
I 25
	f_pid,					/*      ""     */
I 29
	f_ni, f_ni, f_ni,			/* BUF, NFS, NAMEI */
	f_panic,				/* The Panic! record */
E 29
E 25
};
E 19

I 20
/*
E 33
D 31
 *	Since the dump functions won't use readv(2) to get
 *	the records, I can use stdio for input.
 */
static	FILE	*fp = NULL ;

/*
E 31
 *	Print the contents of the FIRST record.
 */
E 20
D 18
IOVEC	*iov ;
E 18
I 18
D 19
IOVEC	iov[MON$N_RECORDS] ;
E 18

E 13
D 5
DATA	previous ;
E 5
I 5
D 6
int	nop(), f_tty(), f_free(), f_loadave(), f_last(), f_sample();
E 6
I 6
D 12
struct	mon_panic	misc ;
struct	mon_header	header ;
struct 	mon_swap	swap = { MON$K_SWAP, MON$S_SWAP };
E 6
E 5

I 6
int	nop();
int	f_first(), f_last(), f_sample() ;
int	f_cpu(), f_tty(), 
	f_disk(), f_fork(), f_free(), f_page(), f_proc(), 
	f_swap(), f_tape(), f_user(),
	f_netif(), f_state(), 
	f_memory(),
	f_loadave();

E 6
D 2
main()
E 2
I 2
D 5
main(argc, argv)
int	argc ;
char	**argv ;
E 5
I 5
struct {
	char	*mon_string,
		*mon_addr ;
	int	(*f_sum)() ;
} array[] = {
D 6
	"First",	(char *)&first,		nop,
E 6
I 6
	"First",	(char *)&first,		f_first,
E 6
	"Last",		(char *)&last,		f_last,
	"Sample",	(char *)&sample,	f_sample,
	"Rectype3",	(char *)&misc,		nop,
D 6
	"CPU",		(char *)&misc,		nop,
E 6
I 6
	"CPU",		(char *)&cpu,		f_cpu,
E 6
	"TTY",		(char *)&tty,		f_tty,
D 6
	"Disk",		(char *)&misc,		nop,
E 6
I 6
	"Disk",		0,			f_disk,
E 6
	"Free",		(char *)&freemem,	f_free,
D 6
	"Fork",		(char *)&misc,		nop,
	"Page",		(char *)&misc,		nop,
	"Proc",		(char *)&misc,		nop,
	"Swap",		(char *)&misc,		nop,
	"Tape",		(char *)&misc,		nop,
	"User",		(char *)&misc,		nop,
	"Netif",	(char *)&misc,		nop,
	"State",	(char *)&state,		nop,
	"Memory",	(char *)&misc,		nop,
E 6
I 6
	"Fork",		(char *)&fork,		f_fork,
	"Page",		(char *)&page,		f_page,
	"Proc",		(char *)&proc,		f_proc,
	"Swap",		(char *)&swap,		f_swap,
	"Tape",		0,			f_tape,
	"User",		(char *)&user,		f_user,
	"Netif",	0,			f_netif,
	"State",	0,			f_state,
	"Memory",	(char *)&memory,	f_memory,
E 6
	"Loadave",	(char *)&loadave,	f_loadave,
	"PANIC!",	0,
};

E 12
D 10
main()
E 10
I 10
main(argc, argv)
int	argc ;
char	**argv ;
E 19
I 19
open_read()
E 19
E 10
E 5
E 2
{
D 4
	int	fd, n_read, i ;
	DATA	current, previous ;
E 4
I 4
D 5
	int	fd, n_read, state ;
	DATA	current, prev ;
E 4
	double	tmp, total_time ;
I 2
	char	*file ;
E 5
I 5
D 10
	int	fd, rc, n_record = 0 ;
E 10
I 10
D 19
	int	fd, rc ;
E 10
D 13
	register size, type ;
D 6
	char	*space ;
E 6
I 6
	char	*space, *malloc() ;
E 13
I 10
	char	*filename ;
E 10
E 6
E 5
E 2

I 10
	if( argc == 1 )
		filename = "monitor.dat" ;
	else
		filename = argv[1] ;

E 10
D 2
	if((fd = open("monitor.dat", O_RDONLY, 0)) == -1 )
E 2
I 2
D 5
	if( argc == 1 )
		file = "monitor.dat" ;
	else
		file = argv[1] ;
E 5
I 5
D 6
	if((fd = open("record.dat", O_RDONLY, 0)) == -1 )
		fatal("read: can't open file: %s\n.");
E 6
I 6
	/*
D 13
	 *	Allocate space for multiple record records.
E 13
I 13
	 *	Open the data file.
E 13
	 */
I 13
	if((fd = open(filename, O_RDONLY, 0)) == -1 )
		fatal("read: can't open file: %s.\n");
E 13
E 6
E 5

I 6
D 13
	init_dynamics() ;
E 13
I 13
	while((rc = read_session(fd)) > 0 )
		;
E 13
D 14

E 14
I 14
/*
		printf("\n\n\t\t\tBeginning new session\n\n");
*/
E 14
I 13
	if( rc == -1 )
		fatal("read: error on read: %s\n.");

	if( close(fd) == -1 )
		fatal("read: error on close: %d\n.");
E 19
I 19
D 29
	printf("%s.\n", records[MON$K_FIRST].rec_string);
D 20
	f_first(records[MON$K_FIRST].rec_addr) ;
E 20
I 20
	f_first((struct mon_first *)records[MON$K_FIRST].rec_addr) ;
E 29
I 29
D 35
	printf("%s.\n", records[MON$C_FIRST].rec_string);
	f_first((struct mon_first *)records[MON$C_FIRST].rec_addr) ;
E 35
I 35
D 36
	(*dump_functions[MON$C_FIRST])((struct mon_first *)records[MON$C_FIRST].rec_addr) ;
E 36
I 36
	(*dump_functions[MON$C_FIRST])((struct mon_first *)records[MON$C_FIRST].addr) ;
E 36
E 35
E 29
E 20
E 19
}

I 20
/*
 *	Call print_record() for each data record in the sample.
 */
E 20
D 19
allocate_dynamics()
E 19
I 19
display_read()
E 19
{
D 19
	register char	*p ;
	char	 *calloc() ;
E 19
I 19
	register options, type ;
E 19

D 19
	if( n_cpu ) {
D 15
		if((p = calloc(n_cpu, MON$S_STATE)) == NULL )
E 15
I 15
		if((p = calloc(n_cpu, MON$S_CPU)) == NULL )
E 15
			fatal("read: can't allocate space for cpu's: %s.\n");
E 19
I 19
	options = first.mon_options ;
E 19

D 15
		array[MON$K_STATE].mon_addr = p ;
		array[MON$K_STATE].mon_size = MON$S_STATE * n_cpu ;
		state = (struct mon_state *)p ;
E 15
I 15
D 19
		array[MON$K_CPU].mon_addr = p ;
		array[MON$K_CPU].mon_size = MON$S_CPU * n_cpu ;
		cpu = (struct mon_cpu *)p ;
E 15
	}

D 18
	if( n_disk ) {
		if((p = calloc(n_disk, MON$S_DISK)) == NULL )
			fatal("read: can't allocate space for disk's: %s.\n");

		array[MON$K_DISK].mon_addr = p ;
E 18
I 18
	if( n_disk )
E 18
		array[MON$K_DISK].mon_size = MON$S_DISK * n_disk ;
D 18
		disk = (struct mon_disk *)p ;
	}
E 18

D 18
	if( n_tape ) {
		if((p = calloc(n_tape, MON$S_TAPE)) == NULL )
			fatal("read: can't allocate space for tape's: %s.\n");

		array[MON$K_TAPE].mon_addr = p ;
E 18
I 18
	if( n_tape )
E 18
		array[MON$K_TAPE].mon_size = MON$S_TAPE * n_tape ;
D 18
		tape = (struct mon_tape *)p ;
	}
E 18

	if( n_netif ) {
		if((p = calloc(n_netif, MON$S_NETIF)) == NULL )
			fatal("read: can't allocate space for netif's: %s.\n");

		array[MON$K_NETIF].mon_addr = p ;
		array[MON$K_NETIF].mon_size = MON$S_NETIF * n_netif ;
		netif = (struct mon_netif *)p ;
	}
E 19
I 19
	for(type = 0; type < MON$N_RECORDS; type++)
		if( options & (1 << type))
			print_record(type) ;
E 19
}

D 19
init_iov(opt_data)
int	opt_data ;
{
D 16
	int	n_records = 0, i, iovcnt = 0 ;
E 16
I 16
	int	 i, iovcnt = 0 ;
E 19
D 18
	unsigned n_records = 0 ;
E 18
E 16
D 20

E 20
I 20
/*
 *	Call the approproiate f_...() function for each data record.
 */
E 20
D 19
	for(i = 0 ; i < sizeof(opt_data) * 8 ; i++)
D 18
		if( opt_data & (1 << i))
			n_records++ ;

	if((iov = (IOVEC *)calloc(n_records, sizeof(IOVEC))) == NULL )
		fatal("read: can't allocate space for iovec's: %s.\n");

	for(i = 0 ; i < sizeof(opt_data) * 8 ; i++)
E 18
		if( opt_data & (1 << i)) {
			iov[iovcnt].iov_base = array[i].mon_addr ;
			iov[iovcnt].iov_len = array[i].mon_size ;
			iovcnt++ ;
		}

D 18
	return n_records ;
E 18
I 18
	return iovcnt ;
E 18
}

print_record(p)
IOVEC	*p ;
E 19
I 19
static	print_record(type)
register type ;
E 19
{
D 19
	struct mon_header *hp = (struct mon_header *)p->iov_base ;
	register int	type ;
	register int	i ;
E 19
I 19
	register i ;
E 19

D 19
	type = hp->mon_type ;

E 19
	switch( type ) {
D 19
	case MON$K_DISK:
		for(i = 0 ; i < n_disk ; i++)
			(*array[MON$K_DISK].f_sum)(disk + i);
		break; 
	case MON$K_TAPE:
		for(i = 0 ; i < n_tape ; i++)
			(*array[MON$K_TAPE].f_sum)(tape + i);
		break; 
	case MON$K_NETIF:
		for(i = 0 ; i < n_netif ; i++)
			(*array[MON$K_NETIF].f_sum)(netif + i);
		break; 
E 19
D 15
	case MON$K_STATE:
E 15
I 15
D 29
	case MON$K_CPU:
E 29
I 29
	case MON$C_CPU:
E 29
E 15
D 19
		for(i = 0 ; i < n_cpu ; i++)
D 15
			(*array[MON$K_STATE].f_sum)(state + i);
E 15
I 15
			(*array[MON$K_CPU].f_sum)(cpu + i);
E 15
		break ;
	default:
		(*array[type].f_sum)(p->iov_base) ;
	}
}
E 19
I 19
D 35
		for(i = 0; i < n_cpu ; i++) {
			printf("%s.\n", records[type].rec_string);
D 33
			f_cpu(cpu + i ) ;
E 33
I 33
			(*dump_functions[type])(cpu + i ) ;
E 33
		}
E 35
I 35
		for(i = 0; i < n_cpu ; i++)
			(*dump_functions[type])(cpu + i) ;
E 35
E 19

D 19
read_session(fd)
register fd ;
{
	int	i, rc, type, size, n_records ;

D 14
	if( read(fd, (char *)&first, MON$S_FIRST) != MON$S_FIRST )
E 14
I 14
	if((rc = read(fd, (char *)&first, MON$S_FIRST)) == -1 )
E 14
		fatal("read: can't read first record: %s.\n");
I 14
	else if( rc == 0 )
		return 0 ;
E 14

	(*array[MON$K_FIRST].f_sum)(&first) ;

	first.mon_options &= ~MON$M_SAMPLE ;	/* turn off the sample */

	n_cpu   = first.mon_cpu ; 
	n_disk  = first.mon_disk ;
	n_tape  = first.mon_tape ;
	n_netif = first.mon_netif ;

E 13
	/*
D 13
	 *	Open the data file.
E 13
I 13
	 *	Allocate space for the linked lists.
E 13
	 */
D 10
	if((fd = open("monitor.dat", O_RDONLY, 0)) == -1 )
E 10
I 10
D 13
	if((fd = open(filename, O_RDONLY, 0)) == -1 )
E 10
		fatal("read: can't open file: %s.\n");
E 13
I 13
	allocate_dynamics() ;
E 13

I 13
	n_records = init_iov(first.mon_options) ;

E 13
E 6
D 5
	if((fd = open(file, O_RDONLY, 0)) == -1 )
E 2
		fatal("read: can't open data file: %s.\n");
E 5
I 5
D 16
	while((rc = read(fd, &header, MON$S_HEADER)) > 0 ) {
E 16
I 16
	while((rc = read(fd, (char *)&header, MON$S_HEADER)) > 0 ) {
E 16
D 13
		size = header.mon_length - MON$S_HEADER;
E 13
		type = header.mon_type ;
I 13
		size = header.mon_length - MON$S_HEADER ;
E 13
E 5

D 5
	while((n_read = read(fd, &current, sizeof(DATA))) != 0 ) {
		if( n_read == -1 )
			fatal("read: error on read: %s.\n");
E 5
I 5
D 13
		if( type < 0 || type >= MON$K_PANIC )
			panic("read: Help me Savvik.\n");
E 13
I 13
		if( read(fd, array[type].mon_addr + MON$S_HEADER, size) <= 0 )
			fatal("read: can't read remainder of record: %s.\n");
E 13
E 5

D 5
		total_time = 0. ;
E 5
I 5
D 13
		space = array[type].mon_addr + MON$S_HEADER ;
E 13
I 13
		switch( type ) {
		case MON$K_SAMPLE:
D 16
			f_sample(array[MON$K_SAMPLE].mon_addr);
E 16
I 16
			f_sample((struct mon_sample *)array[MON$K_SAMPLE].mon_addr);
E 16
E 13
E 5

D 4
		for(i = 0; i < CPUSTATES; i++) {
			tmp = current.cpu_time[i] ;
			current.cpu_time[i] -= previous.cpu_time[i] ;
			previous.cpu_time[i] = tmp ;
			total_time += current.cpu_time[i] ;
E 4
I 4
D 5
		for(state = 0; state < CPUSTATES; state++) {
			tmp = current.cpu_time[state] ;
			current.cpu_time[state] -= prev.cpu_time[state] ;
			prev.cpu_time[state] = tmp ;
			total_time += current.cpu_time[state] ;
E 5
I 5
D 13
		if((rc = read(fd, space, size)) != size ) {
			perror("read: error on read in loop");
E 13
I 13
D 14
			if((rc = readv(fd, iov, n_records)) == -1 )
E 14
I 14
			if( readv(fd, iov, n_records) == -1 )
E 14
				fatal("read: can't read data sampe: %s.\n") ;
			
			for(i = 0; i < n_records; i++)
				print_record(iov+i) ;

E 19
E 13
D 34
			break ;
E 34
I 34
		break ;
	case MON$C_BUF:
D 35
		for(i = 0; i < n_buf ; i++) {
			printf("%s.\n", records[type].rec_string);
			(*dump_functions[type])(mon_buf + i ) ;
		}
E 35
I 35
		for(i = 0; i < n_buf ; i++)
			(*dump_functions[type])(mon_buf + i) ;
E 35

		break ;
E 34
E 5
E 4
D 13
		}
E 13
I 13
D 19
		case MON$K_LAST:
			(*array[MON$K_LAST].f_sum)(array[MON$K_LAST].mon_addr);
E 19
I 19
D 29
	case MON$K_DISK:
E 29
I 29
	case MON$C_DISK:
E 29
D 35
		for(i = 0; i < n_disk ; i++) {
			printf("%s.\n", records[type].rec_string);
E 35
I 35
		for(i = 0; i < n_disk ; i++)
E 35
D 33
			f_disk(disk + i) ;
E 33
I 33
			(*dump_functions[type])(disk + i) ;
E 33
D 23
		}
E 19
E 13

D 5
		print_info(&current, total_time);
E 5
I 5
D 6
		if( type == MON$K_SAMPLE )
			putchar('\n');

E 6
D 13
		(*array[type].f_sum)(array[type].mon_addr);
E 5
	}
E 13
I 13
D 19
			free_dynamics() ;
E 19
I 19
		break ;
	case MON$K_TAPE:
		for(i = 0; i < n_tape ; i++) {
			printf("%s.\n", records[type].rec_string);
			f_tape(tape + i) ;
E 23
D 35
		}
E 35
E 19
D 16
			free(iov);
E 16
I 16
D 18
			free((char *)iov);
E 18
E 16
E 13

D 5
	close(fd);
E 5
I 5
D 13
	if( rc == -1 )
		fatal("read: error on read: %s\n.");
E 13
I 13
D 14
			return 0 ;
E 14
I 14
D 19
			return 1 ;
E 14
E 13

D 13
	if( close(fd) == -1 )
		fatal("read: error on close: %d\n.");
E 5
}
E 13
I 13
		case MON$K_FIRST:
			printf("read: didn't see a 'last' record.\n");
			return -1 ;
		default:
			fprintf(stderr, "read: unexpected data record: %s.\n",
				array[type].mon_string);
			abort();
E 19
I 19
		break ;
D 29
	case MON$K_NETIF:
E 29
I 29
	case MON$C_NETIF:
E 29
D 35
		for(i = 0; i < n_netif ; i++) {
			printf("%s.\n", records[type].rec_string);
E 35
I 35
		for(i = 0; i < n_netif ; i++)
E 35
D 33
			f_netif(netif + i) ;
E 33
I 33
			(*dump_functions[type])(netif + i) ;
E 33
E 19
D 35
		}
E 35
D 19
	}
E 19
E 13

I 6
D 13
init_dynamics()
{
	struct mon_header *p ;
E 13
I 13
D 19
	fprintf(stderr, "read: data file may still be active.\n");
E 13

D 13
	if((array[MON$K_DISK].mon_addr = malloc(MON$S_DISK)) == NULL )
		fatal("read: can't allocate space for disk: %s.\n");
E 13
I 13
	free_dynamics() ;
E 13

D 13
	p = (struct mon_header *)array[MON$K_DISK].mon_addr ;
	p->mon_type = MON$K_DISK ;
	p->mon_length = MON$S_DISK ;
E 13
I 13
D 16
	free(iov);
E 16
I 16
D 18
	free((char *)iov);
E 16
E 13

E 18
D 13
	if((array[MON$K_TAPE].mon_addr = malloc(MON$S_TAPE)) == NULL )
		fatal("read: can't allocate space for tape: %s.\n");
E 13
I 13
	return rc ;
E 19
I 19
		break ;
	default:
D 35
		printf("%s.\n", records[type].rec_string);
E 35
D 33
		(*funct[type])(records[type].rec_addr) ;
E 33
I 33
D 36
		(*dump_functions[type])(records[type].rec_addr) ;
E 36
I 36
		(*dump_functions[type])(records[type].addr) ;
E 36
E 33
	}
E 19
}
I 20

/*
 *	Print the LAST record.
 */
E 20
E 13
D 19

D 13
	p = (struct mon_header *)array[MON$K_TAPE].mon_addr ;
	p->mon_type = MON$K_TAPE ;
	p->mon_length = MON$S_TAPE ;
E 13
I 13
free_dynamics()
E 19
I 19
close_read()
E 19
{
D 19
	if( n_cpu )
D 15
		free(state);
E 15
I 15
D 16
		free(cpu);
E 16
I 16
		free((char *)cpu);
E 16
E 15
E 13
D 18

D 13
	if((array[MON$K_NETIF].mon_addr = malloc(MON$S_NETIF)) == NULL )
		fatal("read: can't allocate space for netif: %s.\n");
E 13
I 13
	if( n_disk )
D 16
		free(disk);
E 16
I 16
		free((char *)disk);
E 16
E 13

D 13
	p = (struct mon_header *)array[MON$K_NETIF].mon_addr ;
	p->mon_type = MON$K_NETIF ;
	p->mon_length = MON$S_NETIF ;
E 13
I 13
	if( n_tape )
D 16
		free(tape);
E 16
I 16
		free((char *)tape);
E 18
E 16
E 13

D 13
	if((array[MON$K_STATE].mon_addr = malloc(MON$S_STATE)) == NULL )
		fatal("read: can't allocate space for state: %s.\n");
E 13
I 13
	if( n_netif )
D 16
		free(netif);
E 16
I 16
		free((char *)netif);
E 16
E 13

E 19
I 19
D 29
	printf("%s.\n", records[MON$K_LAST].rec_string);
D 20
	f_last(records[MON$K_LAST].rec_addr) ;
E 20
I 20
	f_last((struct mon_last *)records[MON$K_LAST].rec_addr) ;
E 29
I 29
D 35
	printf("%s.\n", records[MON$C_LAST].rec_string);
E 35
D 33
	f_last((struct mon_last *)records[MON$C_LAST].rec_addr) ;
E 33
I 33
D 36
	(*dump_functions[MON$C_LAST])((struct mon_last *)records[MON$C_LAST].rec_addr) ;
E 36
I 36
	(*dump_functions[MON$C_LAST])((struct mon_last *)records[MON$C_LAST].addr) ;
E 36
E 33
E 29
E 20
E 19
D 13
	p = (struct mon_header *)array[MON$K_STATE].mon_addr ;
	p->mon_type = MON$K_STATE ;
	p->mon_length = MON$S_STATE ;
E 13
D 12
}

/*
 *
 */
E 6
D 5
#define	pgtok(a)	((a)*NBPG/1024)
E 5
I 5
nop(p)
struct mon_header *p ;
{
I 6
	printf("%s (%d).\n", array[p->mon_type].mon_string, p->mon_type);
}

f_first(p)
struct mon_first *p ;
{
E 6
	printf("%s.\n", array[p->mon_type].mon_string);
I 6
	printf("\tsleep:    %d\n", p->mon_sleep);
	printf("\toptions:  %o\n", p->mon_options);
	printf("\tpid:      %d\n", p->mon_pid);
	printf("\thz:       %d\n", p->mon_hz);
D 11
	printf("\tphysmem:  %d\n", pgtok(p->mon_physmem));
E 11
I 11
	printf("\tphysmem:  %d Kb.\n", pgtok(p->mon_physmem));
E 11
	printf("\tsdate:    %s", ctime(&p->mon_sdate));
I 11
	printf("\tcpu:      %d\n", p->mon_cpu);
	printf("\tdisk:     %d\n", p->mon_disk);
	printf("\ttape:     %d\n", p->mon_tape);
	printf("\tnetif:    %d\n", p->mon_netif);
E 11
	printf("\tversion:  %s", p->mon_version);
	printf("\thostname: %s\n", p->mon_hostname);
E 6
}
E 5

D 5
print_info(dp, total_time)
DATA	*dp ;
double	total_time ;
E 5
I 5
D 6
struct mon_tty prev ;
E 6

D 6
f_tty(p)
struct mon_tty *p ;
E 6
I 6
f_sample(p)
struct mon_sample *p ;
E 6
E 5
{
D 2
	printf("%s", ctime(&current.timestamp));
E 2
I 2
D 4
	printf("%s", ctime(&dp->timestamp));
E 4
I 4
D 5
	char	*time_string, *newline, *index(), *ctime() ;
E 5
I 5
D 6
	int	tmp_in, tmp_out ;
E 6
I 6
	printf("%s.\n", array[p->mon_type].mon_string);
	printf("\ttimestamp: %s", ctime(&p->mon_timestamp));
	printf("\tdatalen:   %d\n", p->mon_datalen);
}
E 6
E 5
E 4
E 2

D 4
	printf("Load Average: %.2f %.2f %.2f %.2f\n",
		dp->loadave[0], dp->loadave[1],
		dp->loadave[2], dp->loadave[3]);
	printf("CPU Times: %3.0f %3.0f %3.0f %3.0f\n",
E 4
I 4
D 5
	time_string = ctime(&dp->timestamp);
	if((newline = index(time_string, '\n')) != NULL )
		*newline = '\0' ;
E 5
I 5
D 6
	tmp_in = p->mon_ttyin ; 
	tmp_out =  p->mon_ttyout ;
	p->mon_ttyin -= prev.mon_ttyin ;
	p->mon_ttyout -= prev.mon_ttyout ;
	prev.mon_ttyin = tmp_in ;
	prev.mon_ttyout = tmp_out ;
E 6
I 6
f_last(p)
struct mon_last *p ;
{
	printf("%s.\n", array[p->mon_type].mon_string);
	printf("\tedate:   %s", ctime(&p->mon_edate));
	printf("\tsignal:  %d\n", p->mon_signal);
	printf("\tcode:    %d\n", p->mon_code);
	printf("\tonstack: %d\n", p->mon_scp.sc_onstack);
	printf("\tmask:    %d\n", p->mon_scp.sc_mask);
	printf("\tsp:      %x\n", p->mon_scp.sc_sp);
	printf("\tpc:      %x\n", p->mon_scp.sc_pc);
	printf("\tpsl:     %x\n", p->mon_scp.sc_ps);
}
E 6
E 5

D 5
	printf("%s - %5d - %.2f - %3.0f %3.0f %3.0f %3.0f\n",
		time_string, pgtok(dp->free), dp->loadave[0],
E 4
		100. * dp->cpu_time[0] / total_time,
		100. * dp->cpu_time[1] / total_time,
		100. * dp->cpu_time[2] / total_time,
		100. * dp->cpu_time[3] / total_time);
E 5
I 5
D 6
	printf("\t%s <%d,%d>.\n", array[p->mon_type].mon_string,
		p->mon_ttyin, p->mon_ttyout);
E 6
I 6
/*
 *	Here start the functions to print out data records.
 */

f_cpu(p)
struct mon_cpu *p ;
{
	printf("%s.\n", array[p->mon_type].mon_string);
	printf("\tswtch:   %u\n", p->mon_swtch);
	printf("\ttrap:    %u\n", p->mon_trap);
	printf("\tsyscall: %u\n", p->mon_syscall);
	printf("\tintr:    %u\n", p->mon_intr);
	printf("\tpdma:    %u\n", p->mon_pdma);
E 6
}

D 6
#include <machine/param.h>
#define	pgtok(x)	((x)*NBPG/1024)
E 6
I 6
f_tty(p)
struct mon_tty *p ;
{
	printf("%s.\n", array[p->mon_type].mon_string);
	printf("\tttyin:  %d\n", p->mon_ttyin);
	printf("\tttyout: %d\n", p->mon_ttyout);
I 8
	printf("\tetime:  %f\n", p->mon_etime);
E 8
}
E 6

I 6
f_disk(p)
struct mon_disk *p ;
{
	printf("%s.\n", array[p->mon_type].mon_string);
	printf("\tname:       %s%d\n", p->mon_name, p->mon_unit);
	printf("\tdk:         %d\n", p->mon_dk);
	printf("\tcontroller: %d\n", p->mon_controller);
	printf("\tbus:        %d\n", p->mon_bus);
	printf("\tetime:      %f\n", p->mon_etime);
	printf("\ttime:       %d\n", p->mon_time);
	printf("\tseek:       %d\n", p->mon_seek);
	printf("\txfer:       %d\n", p->mon_xfer);
	printf("\twds:        %d\n", p->mon_wds);
I 8
#ifdef	sun
	printf("\tbps:	      %f\n", p->mon_bps);
#else
E 8
	printf("\tmspw:       %f\n", p->mon_mspw);
I 8
#endif
E 8
}

E 6
f_free(p)
struct mon_free *p ;
{
D 6
	printf("\t%s (%d).\n", array[p->mon_type].mon_string,
		pgtok(p->mon_freemem));
E 6
I 6
	printf("%s.\n", array[p->mon_type].mon_string);
	printf("\tfree: %d Kb.\n", pgtok(p->mon_freemem));
E 6
}

D 6
f_loadave(p)
struct mon_loadave *p ;
E 6
I 6
f_fork(p)
struct mon_fork *p ;
E 6
{
D 6
	printf("\t%s (%4.2f).\n", array[p->mon_type].mon_string,
		p->mon_loadave[1]);
E 6
I 6
	printf("%s.\n", array[p->mon_type].mon_string);
	printf("\tcntfork:  %d\n", p->mon_fork.cntfork);
	printf("\tcntvfork: %d\n", p->mon_fork.cntvfork);
	printf("\tsizfork:  %d\n", p->mon_fork.sizfork);
	printf("\tsizvfork: %d\n", p->mon_fork.sizvfork);
E 6
}

D 6
f_last(p)
struct mon_last *p ;
E 6
I 6
f_page(p)
struct mon_page *p ;
E 6
{
D 6
	printf("%s - Signal (%d), code (%d)\n", array[p->mon_type].mon_string,
		p->mon_signal, p->mon_code);
E 6
I 6
	printf("%s.\n", array[p->mon_type].mon_string);
	printf("\tdeficit:   %d\n", p->mon_deficit);
	printf("\tpswpin:    %u\n", p->mon_meter.v_pswpin);
	printf("\tpswpout:   %u\n", p->mon_meter.v_pswpout);
	printf("\tpgin:      %u\n", p->mon_meter.v_pgin);
	printf("\tpgout:     %u\n", p->mon_meter.v_pgout);
	printf("\tpgpgin:    %u\n", p->mon_meter.v_pgpgin);
	printf("\tpgpgout:   %u\n", p->mon_meter.v_pgpgout);
	printf("\tintrans:   %u\n", p->mon_meter.v_intrans);
	printf("\tpgrec:     %u\n", p->mon_meter.v_pgrec);
	printf("\txsfrec:    %u\n", p->mon_meter.v_xsfrec);
	printf("\txifrec:    %u\n", p->mon_meter.v_xifrec);
	printf("\texfod:     %u\n", p->mon_meter.v_exfod);
	printf("\tzfod:      %u\n", p->mon_meter.v_zfod);
	printf("\tvrfod:     %u\n", p->mon_meter.v_vrfod);
	printf("\tnexfod:    %u\n", p->mon_meter.v_nexfod);
	printf("\tnzfod:     %u\n", p->mon_meter.v_nzfod);
	printf("\tnvrfod:    %u\n", p->mon_meter.v_nvrfod);
	printf("\tpgfrec:    %u\n", p->mon_meter.v_pgfrec);
	printf("\tfaults:    %u\n", p->mon_meter.v_faults);
	printf("\tscan:      %u\n", p->mon_meter.v_scan);
	printf("\trev:       %u\n", p->mon_meter.v_rev);
	printf("\tseqfree:   %u\n", p->mon_meter.v_seqfree);
	printf("\tdfree:     %u\n", p->mon_meter.v_dfree);
	printf("\tfastpgrec: %u\n", p->mon_meter.v_fastpgrec);
	printf("\tswpout:    %u\n", p->mon_meter.v_swpout);
	printf("\tswpin:     %u\n", p->mon_meter.v_swpin);
E 6
}

D 6
f_sample(p)
struct mon_sample *p ;
E 6
I 6
f_proc(p)
struct mon_proc *p ;
E 6
{
D 6
	printf("%s - %s", array[p->mon_type].mon_string,
		ctime(&p->mon_timestamp));
E 6
I 6
	printf("%s.\n", array[p->mon_type].mon_string);
	printf("\trq:   %d\n", p->mon_rq);
	printf("\tdw:   %d\n", p->mon_dw);
	printf("\tpw:   %d\n", p->mon_pw);
	printf("\tsl:   %d\n", p->mon_sl);
	printf("\tsw:   %d\n", p->mon_sw);
E 6
E 5
D 4
	printf("Free Memory: %d\n\n", pgtok(dp->free));
E 4
}
I 6

f_swap(p)
struct mon_swap *p ;
{
	printf("%s.\n", array[p->mon_type].mon_string);
	printf("\tNot implimented.\n");
}

f_tape(p)
struct mon_tape *p ;
{
	printf("%s.\n", array[p->mon_type].mon_string);
	printf("\tname:       %s%d\n", p->mon_name, p->mon_unit);
	printf("\ttp:         %d\n", p->mon_tp);
	printf("\tcontroller: %d\n", p->mon_controller);
	printf("\tbus:        %d\n", p->mon_bus);
}

f_user(p)
struct mon_user *p ;
{
	printf("%s.\n", array[p->mon_type].mon_string);
	printf("\tNot implimented.\n");
}

f_netif(p)
struct mon_netif *p ;
{
	printf("%s.\n", array[p->mon_type].mon_string);
	printf("\tname:       %s%d\n", p->mon_name, p->mon_unit);
I 8
D 9
	printf("\tflags:      %x\n", p->mon_flags);
E 9
I 9

	print_if(p->mon_flags, "\tflags:      <");

E 9
E 8
	printf("\tipackets:   %d\n", p->mon_ipackets);
	printf("\tierrors:    %d\n", p->mon_ierrors);
	printf("\topackets:   %d\n", p->mon_opackets);
	printf("\toerrors:    %d\n", p->mon_oerrors);
	printf("\tcollisions: %d\n", p->mon_collisions);
	printf("\taddr:       %x\n", p->mon_ifnet);
}

f_state(p)
struct mon_state *p ;
{
	printf("%s.\n", array[p->mon_type].mon_string);
	printf("\t[0]:   %d\n", p->mon_time[0]);
	printf("\t[1]:   %d\n", p->mon_time[1]);
	printf("\t[2]:   %d\n", p->mon_time[2]);
	printf("\t[3]:   %d\n", p->mon_time[3]);
	printf("\twhere: %x\n", p->mon_where);
	printf("\tcpuid: %x\n", p->mon_cpuid);
	printf("\tcpu:   %d\n", p->mon_cpu);
D 7
	printf("\ttotal: %f\n", p->mon_total);
E 7
}

f_memory(p)
struct mon_memory *p ;
{
	printf("%s.\n", array[p->mon_type].mon_string);
	printf("\tvm:     %d Kb.\n", pgtok(p->mon_vm));
	printf("\tavm:    %d Kb.\n", pgtok(p->mon_avm));
	printf("\trm:     %d Kb.\n", pgtok(p->mon_rm));
	printf("\tarm:    %d Kb.\n", pgtok(p->mon_arm));
	printf("\tvmtxt:  %d Kb.\n", pgtok(p->mon_vmtxt));
	printf("\tavmtxt: %d Kb.\n", pgtok(p->mon_avmtxt));
	printf("\trmtxt:  %d Kb.\n", pgtok(p->mon_rmtxt));
	printf("\tarmtxt: %d Kb.\n", pgtok(p->mon_armtxt));
	printf("\tfree:   %d Kb.\n", pgtok(p->mon_free));
}

f_loadave(p)
struct mon_loadave *p ;
{
	printf("%s.\n", array[p->mon_type].mon_string);
	printf("\t[0]: %.2f\n", p->mon_loadave[0]);
	printf("\t[1]: %.2f\n", p->mon_loadave[1]);
	printf("\t[2]: %.2f\n", p->mon_loadave[2]);
	printf("\t[3]: %.2f\n", p->mon_loadave[3]);
}

/*
D 9
	printf("\t: %\n", p->mon_);
E 9
I 9
 *	Print out the names of the interface flag bits.
E 9
 */
I 9
static	char	*netif_names[] = {
	"up", 			/* 01 */
	"broadcast", 		/* 02 */
	"debug", 		/* 04 */
	"route",		/* 010 */
	"pointopoint",		/* 020 */
	"notrailers",		/* 040 */
	"running",		/* 0100 */
	"noarp",		/* 0200 */
	"local",		/* 0400 */
	"dynproto",		/* 01000 */
	"loopback",		/* 02000 */
	"04000",		/* 04000 */
	"010000",
	"020000",
	"040000",
	"0100000",
};

print_if(flags, format)
short	flags ;
char	*format ;
{
	int	i, comma = 0 ;

	printf("%s", format);

	for(i = 0; i < sizeof(flags) * 8; i++) {
		if((1 << i) & flags ) {
			if( comma++ )
				putchar(',');
			printf("%s", netif_names[i]);
		}
	}

	printf(">\n");
E 12
D 31
}
I 19

I 20
/*
 *	Keep track of the last record read.
 */
D 29
static	int	last_record = MON$K_PANIC ;
E 29
I 29
static	int	last_record = MON$C_PANIC ;
E 29

/*
 *	Open the data file and make sure the first record
 *	is a FIRST record.
 */
open_dump(op)
OPTION	*op ;
{
	if((fp = fopen(op->opt_file, "r")) == NULL )
D 28
		fatal("can't open data file: %s (%s).\n", module,
E 28
I 28
		fatal("Can't open data file: %s (%s).\n", module,
E 28
			op->opt_file) ;

	if( fread((char *)&first, MON$S_FIRST, 1, fp) == 0 ) {
		if( feof(fp))
			fatal("Unexpected EOF: %s.\n", module) ;
		else
			fatal("Error reading first record: %s.\n", module) ;
	}

D 29
	if( first.mon_type != MON$K_FIRST )
E 29
I 29
	if( first.mon_type != MON$C_FIRST )
E 29
D 28
		panic("first record is not the right type!\n", module) ;
E 28
I 28
		panic("First record is not the right type!\n", module) ;
E 28
I 22

	if( first.mon_record != record_version )
D 28
		fatal("record structure/data file version mismatch.\n", module) ;
E 28
I 28
		fatal("Record structure/data file version mismatch.\n", module) ;
E 28
E 22

	open_read() ;

	last_record = first.mon_type ;
}

/*
 *	Get a record and print the contents.
 */
dump_records()
{
	register size, type ;
	char	 buf[MON$S_PANIC] ;
	struct mon_header *hp = (struct mon_header *)buf ;

	if( fread(buf, MON$S_HEADER, 1, fp) == 0 ) {
		if( feof(fp))
			return MON_EXIT ;
		else
			fatal("Can't read record header: %s.\n", module) ;
	}

	size = hp->mon_length - MON$S_HEADER ;
	last_record = type = hp->mon_type ;

	if( fread(buf + MON$S_HEADER, size, 1, fp) == 0 ) {
		if( feof(fp))
D 28
			fatal("Unexpected EOF: %s.\n", module) ;
E 28
I 28
			fatal("Unexpected EOF.\n", module) ;
E 28
		else
D 28
			fatal("Can't read rest of record", module) ;
E 28
I 28
			fatal("Can't read rest of record: %s.\n", module) ;
E 28
	}

	printf("%s.\n", records[type].rec_string);

	if( funct[type] )
		(*funct[type])(buf);

	return MON_NORMAL ;
}

/*
 *	Verify that a LAST record was the last record was found
 *	and close the file.
 */
close_dump()
{
D 29
	if( last_record != MON$K_LAST )
E 29
I 29
	if( last_record != MON$C_LAST )
E 29
		info("Data file may still be active.\n", module) ;

	if( fclose(fp) == EOF )
D 28
		warning("can't close data file: %s.\n", module) ;
E 28
I 28
		warning("Can't close data file: %s.\n", module) ;
E 31
E 28
}
E 20
E 19
E 9
E 6
E 1
