h06068
s 00021/00022/00761
d D 1.30 90/08/21 22:43:31 alan 30 29
c dust off lint
e
s 00011/00001/00772
d D 1.29 90/03/29 16:16:59 alan 29 28
c The hack to fix the DECmumble include file problem.
e
s 00001/00001/00772
d D 1.28 89/12/28 15:43:14 alan 28 27
c Changed uses of vmunix to op->opt_kernel and setup opt_kernel correctly.
c 
e
s 00001/00001/00772
d D 1.27 89/12/27 11:50:06 alan 27 26
c fixed a usage of (struct ucred)
e
s 00002/00001/00771
d D 1.26 89/12/26 09:40:58 alan 26 25
c fixed bug in redraw_pid()
e
s 00075/00017/00697
d D 1.25 89/12/25 19:23:13 alan 25 24
c added a private namelist
e
s 00018/00001/00696
d D 1.24 89/12/25 17:28:22 alan 24 23
c added new swap stuff for V4.0
e
s 00001/00001/00696
d D 1.23 89/02/25 09:56:54 alan 23 22
c editorial change to rec_ elements
e
s 00077/00046/00620
d D 1.22 89/02/17 18:53:45 alan 22 21
c added username and group strings to PID record.  Also fixed a big in sample.c that didn't write the elapsed time correctly
e
s 00001/00001/00665
d D 1.21 89/02/16 19:29:17 alan 21 20
c dust off some lint
e
s 00004/00006/00662
d D 1.20 89/02/16 19:03:18 alan 20 19
c convert pgtok() and btok() macros to functions that uses data set in the FIRST record
e
s 00005/00003/00663
d D 1.19 89/01/07 00:38:04 alan 19 18
c I might have fixed an alignment problem
e
s 00092/00044/00574
d D 1.18 89/01/04 10:54:51 alan 18 17
c V1.1 changes for MIPS support.  This is a check-point of the support
e
s 00050/00046/00568
d D 1.17 88/06/29 23:31:07 alan 17 16
c See the modification history for 29-June-1988.
c 
e
s 00011/00001/00603
d D 1.16 88/06/27 18:16:01 alan 16 15
c changed include of monitor.h and record.h
e
s 00001/00001/00603
d D 1.15 88/01/06 19:24:52 alan 15 14
c Change offset of read ID string from RSSIZE-1 to RSSIZE.
c 
e
s 00014/00008/00590
d D 1.14 87/11/18 12:16:52 alan 14 13
c V0.98
e
s 00010/00010/00588
d D 1.13 87/08/12 15:25:51 alan 13 12
c error message clean up - V0.95
e
s 00006/00001/00592
d D 1.12 87/08/10 21:28:31 alan 12 11
c See commentary on V0.92 in version.c
e
s 00069/00064/00524
d D 1.11 87/05/20 17:13:30 alan 11 10
c changed all curses calls to use w... versions
e
s 00092/00038/00496
d D 1.10 87/04/17 15:47:44 alan 10 9
c Changed all calls to curses to use the 'w' version of the function.  Currently
c all of these write to the 'stdscr'.  This will changed in the next delta.
c 
e
s 00001/00001/00533
d D 1.9 87/04/03 14:32:16 alan 9 8
c 1.  Mostly rearranged include files so that the sources would compile
c     using VAXC.
c 2.  Changed an error monitor that pcc let get by.
c 
e
s 00016/00005/00518
d D 1.8 87/03/03 15:43:22 alan 8 7
c see the commentary for V0.83 in version.c
e
s 00079/00022/00444
d D 1.7 87/02/18 15:41:39 alan 7 6
c a couple of days ago I rm'd a pretty nice version of the process magnify
c code.  I rewrote it into an even nicer version.  The last few deltas
c where check points of this rewritten code.  Except for lint like
c changes this will probably be the released version.
c 
e
s 00025/00017/00441
d D 1.6 87/02/17 13:46:16 alan 6 5
c semi-final version without context switches
e
s 00062/00007/00396
d D 1.5 87/02/16 17:50:20 alan 5 4
c and yet another checkpoint
e
s 00028/00000/00375
d D 1.4 87/02/16 17:14:29 alan 4 3
c yet another checkpoint
e
s 00058/00004/00317
d D 1.3 87/02/16 17:00:55 alan 3 2
c another checkpoint
e
s 00067/00016/00254
d D 1.2 87/02/16 16:47:50 alan 2 1
c paranoia
e
s 00270/00000/00000
d D 1.1 87/02/14 16:01:15 alan 1 0
c date and time created 87/02/14 16:01:15 by alan
e
u
U
t
T
I 1
/*
 *	Author:  Alan Rollow, EIS/CXO, Digital Equipment Corp.
 *	File:	 %M%
 *	Date:	 %G%
 *	Version: %I%
 *
 *	%M% - Read stuff in the proc table.
 */
#ifndef	lint
static	char	SccsId[] = "%W% (monitor) %G%" ;
#endif

I 16
/*
 * Modification History
 * 
 * 27-June-1988 -- arr
 *
 *	Change include of monitor.h to include.h.
 *
 *	Change include of record.h to monitor.h.
I 17
 *
 * 29-June-1988 -- arr
 *
 *	Removed code for close_pid() and changed open_pid() to
 *	setup_proc().  Some of the open_pid() was moved to open_live()
 *	in live.c.
 *
 *	Changed collect_pid() so that it could be called from live().
I 18
 *
 * 30-November-1988 -- arr
 *
 *	First pass at reading on the user structure on the PMAX.  It's
 *	ugly, but it works.
 * 
 *  1-December-1988 -- arr
 *
 *	After close examination of the VAX and MAX code I was
 *	able to reduce the architecture specific pieces to a
 *	mininium and isolate them as much as possible.
 *
I 20
 * Feb. 15, 1989 -- arr
 *
D 25
 *	Remove the pgtok() and btok() macros.  This will the
E 25
I 25
 *	Remove the pgtok() and btok() macros.  This use will the
E 25
 *	function version.
I 25
 *
 * November, 1989 -- arr
 *
 *	Changes for V4.0.
 *
 * Dec. 25, 1989 -- arr
 *
D 29
 *	Add a private pid_nm.
E 29
I 29
 *	Add a private namelist (pid_nm).
 *
 * Mar. 26, 1990 -- arr
 *
 *	Added hack to work-around DECmumble include file problem.
 *
E 29
E 25
E 20
E 18
E 17
 */

E 16
#include <nlist.h>
#include <stdio.h>
#include <signal.h>
I 3
#include <curses.h>
#include <pwd.h>
#include <grp.h>
E 3

#include <sys/types.h>
#include <sys/dk.h>
#include <sys/buf.h>
#include <sys/file.h>
#include <sys/socket.h>
#include <sys/vmsystm.h>
#include <sys/vmmeter.h>
#include <sys/vmmac.h>

#include <sys/dir.h>
I 29

#if defined(V4_ULTRIX) && defined(mips)
#	include <mips/cpu.h>
#endif

E 29
#include <sys/param.h>
#include <sys/user.h>
#include <sys/proc.h>

#include <net/if.h>
#include <netinet/in.h>

#include <machine/pte.h>
D 20
#include <machine/param.h>
E 20

D 16
#include "record.h"
E 16
#include "monitor.h"
I 16
#include "include.h"
E 16
D 9
#include "extern.h"
E 9
#include "options.h"
I 9
#include "extern.h"
E 9
D 20

/*
I 6
 *	A macro for turning pages into Kb.
 */
D 12
#define	pgtok(a)	((a)*NBPG/1024)
E 12
I 12
#include "pgtok.h"
E 20
E 12

/*
E 6
 *	Module name for error functions.
 */
D 13
static	char	*module = "pid.c" ;
E 13
I 13
static	char	*module = "pid" ;
E 13

/*
I 8
 *	Declarations for functions that don't return (int).
 */
char	*str_flags(),
	*str_stats(),
	*str_timeval(),
	*strncpy(),
	*strcpy() ;

void	nlist() ;

/*
E 8
 *	Local copies of kernel stuff.
 */
static	int		nproc ;
D 30
static	struct proc 	proc, *p ;
E 30
I 30
static	struct proc 	proc ;
E 30
static	struct user	user ;
static	struct pte	*Usrptmap, *usrpt ;

I 25
#define	PID_NM_PROC	(0)
#define	PID_NM_NPROC	(1)
#define	PID_NM_USRPTMAP	(2)
#define	PID_NM_USRPT	(3)

struct nlist pid_nm[] = {
	{ "_proc" },		/* PID_NM_PROC */
	{ "_nproc" },		/* PID_NM_NPROC */
	{ "_Usrptmap" },	/* PID_NM_USRPTMAP */
	{ "_usrpt" },		/* PID_NM_USRPT */
	{ 0 }
} ;

E 25
/*
I 22
 *	Remember what the last {real,effective} uid and gid were so
 *	that I don't have to look them up at every sample.
 */
int	prev_uid = -1,
	prev_ruid = -1,
	prev_gid = -1,
	prev_rgid = -1 ;

/*
E 22
 *	File descriptors declared in data.c
 */
extern	int	mem, swap ;
D 17
extern	int	debug ;
E 17

/*
I 11
 *	Default display.
 */
I 12
extern	int	lines ;			/* length of the display being used. */
E 12
extern	WINDOW	*wp ;

/*
E 11
D 17
 *	ARGSUSED
E 17
I 17
 *	Called from open_live().  This finishs the setup for getting
 *	information about a process.
E 17
 */
D 17
open_pid(op)
E 17
I 17
setup_proc(op)
E 17
OPTION	*op ;
{
	int	i ;
I 30
	struct proc *p ;
E 30

I 17
	/*
	 *	This is the address of the interesting proc 
	 *	structure.  If it's still 0 after walking
	 *	though the proc table then we didn't find 
	 *	the process we wanted.
	 */
E 17
	mon_pid.mon_proc = 0 ;

D 17
	nlist("/vmunix", namelist) ;

	if((kmem = open("/dev/kmem", O_RDONLY)) == -1 )
D 13
		fatal("can't open /dev/kmem: %s.\n", module) ;
E 13
I 13
		fatal("Can't open /dev/kmem: %s.\n", module) ;
E 13

	if((mem = open("/dev/mem", O_RDONLY)) == -1 )
D 13
		fatal("can't open /dev/mem: %s.\n", module) ;
E 13
I 13
		fatal("Can't open /dev/mem: %s.\n", module) ;
E 13

	if((swap = open("/dev/drum", O_RDONLY)) == -1 )
D 13
		fatal("can't open /dev/drum: %s.\n", module) ;
E 13
I 13
		fatal("Can't open /dev/drum: %s.\n", module) ;
E 13

	if( namelist[NM_PROC].n_value == 0 || namelist[NM_NPROC].n_value == 0 )
D 13
		fatal("No proc table.\n", module) ;
E 13
I 13
		fatal("No proccess table.\n", module) ;
E 13

E 17
I 17
	/*
I 25
 	 *	Initialize and check the namelist.
	 */
D 28
	(void)nlist("/vmunix", pid_nm) ;
E 28
I 28
	(void)nlist(op->opt_kernel, pid_nm) ;
E 28

	if( check_namelist_pid() == 0 ) {
		info("Disabling process-by-id data collection.\n", module) ;
		op->opt_pid = 0 ;
		return ;
	}

	/*
E 25
	 *	Get the address of the user page table map and
	 *	the user page table (I guess, this was taken
	 *	from ps(1)).
	 */
E 17
D 25
	Usrptmap = (struct pte *)namelist[NM_USRPTMAP].n_value ;
	usrpt = (struct pte *)namelist[NM_USRPT].n_value ;
E 25
I 25
	Usrptmap = (struct pte *)pid_nm[PID_NM_USRPTMAP].n_value ;
	usrpt = (struct pte *)pid_nm[PID_NM_USRPT].n_value ;
E 25

I 17
	/*
	 *	Get the value of nproc and the address of the
	 *	proc table.
	 */
E 17
D 25
	readk((long)namelist[NM_NPROC].n_value, (char *)&nproc, sizeof(int)) ;
	readk((long)namelist[NM_PROC].n_value, (char *)&p, sizeof(struct proc *)) ;
E 25
I 25
	readk((long)pid_nm[PID_NM_NPROC].n_value, (char *)&nproc, sizeof(int)) ;
	readk((long)pid_nm[PID_NM_PROC].n_value, (char *)&p, sizeof(struct proc *)) ;
E 25

I 17
	/*
	 *	While reading the entire proc table at one shot might
	 *	be more efficient this method (one at a time) will be
	 *	to change if Ultrix goes to a dynamic proc list.
	 */
E 17
	for(i = 0; i < nproc; i++) {
		readk((long)(p + i), (char *)&proc, sizeof(proc)) ;

		if( proc.p_stat == 0 )
			continue ;

		if( proc.p_pid == op->opt_proc_id ) {
			mon_pid.mon_proc = p + i ;
			break ;
		}
	}

D 17
	if( !mon_pid.mon_proc )
E 17
I 17
	if( mon_pid.mon_proc == 0 )
E 17
D 13
		fatal("process not in table.\n", module) ;
E 13
I 13
		fatal("Process not in table.\n", module) ;
E 13
D 17

	setup_first(op) ;
E 17
}

/*
D 17
 *	ARGSUSED
E 17
I 17
 *	This is called from live() to collect information about
 *	a process.
E 17
 */
collect_pid(op)
OPTION	*op ;
{
I 22
D 27
	register struct ucred *cp ;
E 27
I 27
	register struct mon_ucred *cp ;
E 27

E 22
	/*
D 17
	 *	Fill in the common data; timestamp, ticks, etc.
	 */
	collect_common(op) ;

	/*
E 17
	 *	Read the current contents of the proc structure.
	 */
	readk((long)mon_pid.mon_proc, (char *)&proc, sizeof(proc)) ;

	/*
D 17
	 *	The pid of this proc entry is not the one we're
E 17
I 17
	 *	If the pid of this proc entry is not the one we're
E 17
	 *	watching, we're done.
	 */
	if((mon_pid.mon_pid = proc.p_pid) != op->opt_proc_id )
		return MON_EXIT ;

D 17
	mon_pid.mon_pflag = proc.p_flag ;
E 17
I 17
	/*
	 *	Save the process status first.
	 */
E 17
	mon_pid.mon_stat = proc.p_stat ;
I 17

	/*
	 *	If the process is a zombie, ignore it, but keep running.
	 */
	if( proc.p_stat == SZOMB )
		return MON_NORMAL ;

	/*
	 *	Save the other interesting information from the
	 *	proc structure.
	 */
I 24
#ifdef	V4_ULTRIX
	mon_pid.mon_pflag = proc.p_type | proc.p_sched ;
#else
E 24
	mon_pid.mon_pflag = proc.p_flag ;
I 24
#endif
E 24
E 17
	mon_pid.mon_rssize = proc.p_rssize ;
	mon_pid.mon_pri = proc.p_pri ;
	mon_pid.mon_nice = proc.p_nice ;
	mon_pid.mon_pgrp = proc.p_pgrp ;
I 14
	mon_pid.mon_wchan = proc.p_wchan ;
E 14

D 30
	if( read_user(&proc, &user) == -1 ) {
E 30
I 30
	if( read_user() == -1 ) {
E 30
D 13
		info("user struct not available.\n", module) ;
E 13
I 13
		info("User structure not available.\n", module) ;
E 13
		return MON_NORMAL ;
	}

D 8
	strcpy(mon_pid.mon_comm, user.u_comm) ;
E 8
I 8
	(void)strcpy(mon_pid.mon_comm, user.u_comm) ;
E 8

I 18
#ifdef	vax
E 18
	mon_pid.mon_cpundx = user.u_pcb.pcb_cpundx ;
I 18
D 25
#endif
#ifdef	mips
E 25
I 25
#elif	mips
E 25
	mon_pid.mon_cpundx = 0 ;
#endif
E 18
	mon_pid.mon_self = user.u_ru ;
	mon_pid.mon_child = user.u_cru ;
	mon_pid.mon_ttyd = user.u_ttyd ;

	readk((long)user.u_cred, (char *)&mon_pid.mon_cred, sizeof(struct ucred)) ;
I 22
	cp = &mon_pid.mon_cred ;
E 22

I 22
	/*
	 *	Look up the names.
	 */
	if( prev_uid != cp->cr_uid )
		uid_string(prev_uid = cp->cr_uid, mon_pid.mon_username) ;

	if( prev_ruid != cp->cr_ruid )
		uid_string(prev_ruid = cp->cr_ruid, mon_pid.mon_realuser) ;

	if( prev_gid != cp->cr_gid )
		gid_string(prev_gid = cp->cr_gid, mon_pid.mon_groupname) ;

	if( prev_rgid != cp->cr_rgid )
		gid_string(prev_rgid = cp->cr_rgid, mon_pid.mon_realgroup) ;


E 22
	return MON_NORMAL ;
D 17
}

/*
 *	Close the files we opened.
 *
 *	ARGSUSED
 */
close_pid(op)
OPTION	*op ;
{
	if( close(kmem) == -1 )
D 13
		warning("can't close /dev/kmem", module) ;
E 13
I 13
		warning("Can't close /dev/kmem: %s.\n", module) ;
E 13

	if( close(mem) == -1 )
D 13
		warning("can't close /dev/mem", module) ;
E 13
I 13
		warning("Can't close /dev/mem : %s.\n", module) ;
E 13

	if( close(swap) == -1 )
D 13
		warning("can't close /dev/drum", module) ;
E 13
I 13
		warning("Can't close /dev/drum: %s.\n", module) ;
E 17
E 13
}

/*
D 18
 *	This function will either fail in readk(), or work.  A
 *	failure in readk() will cause the program to exit.
E 18
I 18
 *	Read the user structure and put a copy into *user.  If
 *	user structure is swapped then read it directly into
 *	*user from the swap device.  Otherwise we have to perform
 *	ritual of arcane magick to get the physical address and
 *	read it from /dev/mem.  I will not attempt to document
 *	the ritual except to copy comments as were provided in
D 30
 *	great grimores known as ps.c and pstat.c.
E 30
I 30
 *	the great grimores known as ps.c and pstat.c.
E 30
 *
 *	For some reason unknown to me at the moment, this function
 *	returns a 0 upon success, but doesn't return an error on
 *	failure.  Instead it causes the program to exit via readk(),
 *	readm() or reads().  I'll fix this in a future hack.
E 18
 */
D 18
get_ubase(mproc, ubase)
struct proc *mproc ;
int	*ubase ;
{
	struct pte *pteaddr, apte;

	pteaddr = &Usrptmap[btokmx(mproc->p_p0br) + mproc->p_szpt - 1];

	readk((long)pteaddr, (char *)&apte, sizeof(apte)) ;

	*ubase = apte.pg_pfnum+1;
}

/*
 *	Given a process structure, put a copy of the user structure 
 *	into "user".
 */
E 18
D 30
read_user(proc, user)
struct proc *proc ;
struct user *user ;
E 30
I 30
read_user()
E 30
{
D 18
	int	ubase ;
E 18
	union {
		struct user user;
		char upages[UPAGES+CLSIZE][NBPG];
	} un_user;

	register i, ncl, addr ;
I 24
D 25
	struct dmap l_dmap;
E 25
	int ublkno;
I 25

E 25
E 24
D 18
	struct pte arguutl[UPAGES+CLSIZE];
E 18
I 18
#ifdef	vax
	struct pte wpte[UPAGES+CLSIZE];
D 25
#endif
#ifdef	mips
E 25
I 25
#elif	mips
E 25
	struct pte wpte[UPAGES] ;
#endif
E 18

I 25
#ifdef	V4_ULTRIX
	struct dmap l_dmap;
#endif

E 25
D 18
/*
 *	If the process isn't in-core try to read it from the swap
 *	device.
 */
	if ((proc->p_flag & SLOAD) == 0) {
E 18
I 18
	/*
	 *	If the user structure is on the swap device
	 *	we can read it easily based on the address
	 *	in the proc structure.  Only to simplify
	 *	nesting in the code below we'll return as
	 *	soon as it's read.
I 24
	 *
	 *	The ritual for getting the swap space address
	 *	became more complicated in V4.0.
E 24
	 */
I 24
#ifdef	V4_ULTRIX
D 30
	if((proc->p_sched & SLOAD) == 0 ) {
		readk(proc->p_smap, (char *)&l_dmap, sizeof(struct dmap)) ;
E 30
I 30
	if((proc.p_sched & SLOAD) == 0 ) {
		readk(proc.p_smap, (char *)&l_dmap, sizeof(struct dmap)) ;
E 30

		readk(l_dmap.dm_ptdaddr, (char *)&ublkno, sizeof(int)) ;
#else
E 24
D 30
	if((proc->p_flag & SLOAD) == 0 ) {
E 18
D 24
		addr = dtob(proc->p_swaddr) ;
E 24
I 24
		ublkno = proc->p_swaddr ;
E 30
I 30
	if((proc.p_flag & SLOAD) == 0 ) {
		ublkno = proc.p_swaddr ;
E 30
#endif
		addr = dtob(ublkno) ;
E 24
D 18
	
E 18
I 18

E 18
D 30
		reads((long)addr, (char *)user, sizeof(struct user)) ;
E 30
I 30
		reads((long)addr, (char *)&user, sizeof(struct user)) ;
E 30

		return 0 ;
	}

D 18
	/* ubase is the 1st page of the user page table */
	/* We will use this to seek to then back up UPAGES+CLSIZE pte's */
	/* and read in the pte's to get all the pages of the u area */
E 18
I 18
	/*
	 *	Architecture specific versions of this ritual are
	 *	provided below.
	 */
D 30
	addr = get_uaddr(proc) ;
E 30
I 30
	addr = get_uaddr(&proc) ;
E 30
E 18

D 18
	get_ubase(proc, &ubase) ;
E 18
I 18
#ifdef	vax
	readm((long)addr, (char *)wpte, sizeof(wpte)) ;
D 25
#endif
#ifdef	mips
E 25
I 25
#elif	mips
E 25
	readk((long)addr, (char *)wpte, sizeof(wpte)) ;
#endif
E 18

D 18
	addr = ctob(ubase) - (UPAGES+CLSIZE) * sizeof(struct pte) ;

	readm((long)addr, (char *)arguutl, sizeof(arguutl)) ;

	/* Now figure out the number of clicks to read */

E 18
	ncl = (sizeof(struct user) + NBPG*CLSIZE - 1) / (NBPG*CLSIZE);

D 18
	/* Read them in reverse order into the union which serves */
	/* to let us read an even number of clicks even though the user */
	/* structure may be smaller than that. */

E 18
I 18
	/*
	 *	Back fill the union un_user with the clicks of
	 *	of the user structure.
	 */
E 18
	while (--ncl >= 0) {
		i = ncl * CLSIZE;
D 18

		addr = ctob(arguutl[CLSIZE+i].pg_pfnum) ;

E 18
I 18
#ifdef	vax
		addr = ctob(wpte[CLSIZE+i].pg_pfnum) ;
D 25
#endif
#ifdef	mips
E 25
I 25
#elif	mips
E 25
		addr = ctob(wpte[i].pg_pfnum) ;
#endif
E 18
		readm((long)addr, un_user.upages[i], CLSIZE*NBPG) ;
	}

D 30
	*user = un_user.user ;
E 30
I 30
	user = un_user.user ;
E 30

	return 0 ;
}

I 18
/*
 *	Architecture specific rituals for getting the physical
 *	address of the user structure.  It is interesting to
D 22
 *	note that VAX ritual is a complex ritual more suited to 
 *	Cabbalist or Magick Square mystic, while the PMAX ritual
 *	is a simple Word of Power.
E 22
I 22
 *	note that the VAX ritual is a complex ritual more suited 
 *	to the Cabbalist or Magick Square mystic, while the PMAX 
 *	ritual is a simple Word of Power.
E 22
 */
#ifdef	vax
get_uaddr(p)
struct proc *p ;
{
	struct pte *pteaddr, apte;

	pteaddr = &Usrptmap[btokmx(p->p_p0br) + p->p_szpt - 1];

	readk((long)pteaddr, (char *)&apte, sizeof(apte)) ;

	return ctob(apte.pg_pfnum+1) - (UPAGES+CLSIZE) * sizeof(struct pte) ;
}
D 25
#endif
I 22

E 22
#ifdef	mips
E 25
I 25
#elif	mips
E 25
D 30
get_uaddr(p)
struct proc *p ;
E 30
I 30
get_uaddr(procp)
struct proc *procp ;
E 30
{
D 30
	return (int)p->p_addr ;
E 30
I 30
	return (int)procp->p_addr ;
E 30
}
#endif
E 18
D 2
extern	pid_ticks ;
E 2
I 2
/*
I 7
 *	Data for delta function.
 */
int	pid_ticks[2],
	soft_faults[2],
	hard_faults[2],
	in_block[2],
	out_block[2],
	send_message[2],
	rcv_message[2] ;

/*
 *	Calculate the changes in process (by id) stats.
 *
 *	"Which" is one of {CHILD,SELF} depending on whether the
 *	child or parent stats are being used.
 */
double	delta_pid(ticks, which)
int	ticks ;
int	which ;
{
	double	 etime ;
	register tmp ;
	register struct rusage *rp ;

	rp = which == SELF ? &mon_pid.mon_self : &mon_pid.mon_child ;

	etime = (double)(ticks - pid_ticks[which])/first.mon_hz ;
	pid_ticks[which] = ticks ;

	tmp = rp->ru_minflt ;
	      rp->ru_minflt -= soft_faults[which] ;
	      soft_faults[which] = tmp ;

	tmp = rp->ru_majflt ;
	      rp->ru_majflt -= hard_faults[which] ;
	      hard_faults[which] = tmp ;

	tmp = rp->ru_inblock ;
	      rp->ru_inblock -= in_block[which] ;
	      in_block[which] = tmp ;

	tmp = rp->ru_oublock ;
	      rp->ru_oublock -= out_block[which] ;
	      out_block[which] = tmp ;

	tmp = rp->ru_msgsnd ;
	      rp->ru_msgsnd -= send_message[which] ;
	      send_message[which] = tmp ;

	tmp = rp->ru_msgrcv ;
	      rp->ru_msgrcv -= rcv_message[which] ;
	      rcv_message[which] = tmp ;

	return etime ;
}

/*
E 7
D 22
 *	Code and data for displaying process data.
 */
D 6
#define	S_NAMES		(16)
E 6
I 6
#define	S_NAMES		(12)
E 6
E 2

D 2
redraw_pid()
{
	sample_header() ;
E 2
I 2
/*
 *	Remember what the last {real,effective} uid and gid were so
 *	that I don't have to look them up at every sample.
 */
int	prev_uid,
	prev_ruid,
	prev_gid,
	prev_rgid ;
E 2

D 2
	printw("CPU time (self):\n") ;
	printw("CPU time (child):\n") ;
	printw("State:\n") ;
}
E 2
I 2
D 3
char	username[S_NAMES],
	groupname[S_NAMES],
	real_user[S_NAMES],
	real_group[S_NAMES] ;
E 3
I 3
char	username[S_NAMES+1],
	groupname[S_NAMES+1],
	real_user[S_NAMES+1],
	real_group[S_NAMES+1] ;
E 3
E 2

D 2
magnify_pid()
{
	sample_body((double)(sample.mon_ticks - pid_ticks)/first.mon_hz)  ;
	pid_ticks = sample.mon_ticks ;
E 2
I 2
/*
E 22
D 7
 *	Number of clock ticks at last sample.  In os.c.
 */
extern	pid_ticks ;
E 2

D 2
	mvprintw(3, 19, "%s", str_timeval(&mon_pid.mon_self.ru_utime)) ;
	mvprintw(4, 19, "%s", str_timeval(&mon_pid.mon_child.ru_utime)) ;
	mvprintw(5, 19, "%s", str_stats(mon_pid.mon_stat)) ;
}
E 2
I 2
/*
E 7
 *	Functions to turn {u,g}id's into names.
 */
I 3
gid_string(gid, buf)
char	*buf ;
{
D 30
	struct group *p, *getgrgid() ;
E 30
I 30
	struct group *gp, *getgrgid() ;
E 30
E 3

I 3
D 22
	buf[S_NAMES] = '\0' ;
E 22
I 22
	buf[MON$S_GROUPNAME] = '\0' ;
E 22

D 30
	if((p = getgrgid(gid)) == NULL )
E 30
I 30
	if((gp = getgrgid(gid)) == NULL )
E 30
D 8
		sprintf(buf, "#%d", gid) ;
E 8
I 8
		(void)sprintf(buf, "#%d", gid) ;
E 8
	else
D 8
		strncpy(buf, p->gr_name, S_NAMES) ;
E 8
I 8
D 22
		(void)strncpy(buf, p->gr_name, S_NAMES) ;
E 22
I 22
D 30
		(void)strncpy(buf, p->gr_name, MON$S_GROUPNAME) ;
E 30
I 30
		(void)strncpy(buf, gp->gr_name, MON$S_GROUPNAME) ;
E 30
E 22
E 8
}

uid_string(uid, buf)
char	*buf ;
{
D 30
	struct passwd *p, *getpwuid() ;
E 30
I 30
	struct passwd *up, *getpwuid() ;
E 30

D 22
	buf[S_NAMES] = '\0' ;
E 22
I 22
	buf[MON$S_USERNAME] = '\0' ;
E 22

D 30
	if((p = getpwuid(uid)) == NULL )
E 30
I 30
	if((up = getpwuid(uid)) == NULL )
E 30
D 8
		sprintf(buf, "#%d", uid) ;
E 8
I 8
		(void)sprintf(buf, "#%d", uid) ;
E 8
	else
D 8
		strncpy(buf, p->pw_name, S_NAMES) ;
E 8
I 8
D 22
		(void)strncpy(buf, p->pw_name, S_NAMES) ;
E 22
I 22
D 30
		(void)strncpy(buf, p->pw_name, MON$S_USERNAME) ;
E 30
I 30
		(void)strncpy(buf, up->pw_name, MON$S_USERNAME) ;
E 30
E 22
E 8
}

E 3
/*
 *	Constants for the placement of stuff on the screen.
 *
 *	Offsets within the line.
 */
#define	PID_OFFSET	(14)
D 5
#define	PID_PRIORITY	(39)
E 5
I 5
#define	PID_PRI		(39)
E 5
#define	PID_NICE	(52)
#define	PID_TTYD	(68)
D 5
#define	PID_CPU		(10)
E 5
I 5
#define	PID_CPU_X	(10)
E 5
D 7
#define	PID_FAULT	(33)
E 7
I 7
#define	PID_FAULT	(36)
E 7
#define	PID_BLOCK	(50)
D 7
#define	PID_MESSAGE	(66)
E 7
I 7
#define	PID_MESSAGE	(69)
E 7
#define	PID_SWAP	(0)
#define	PID_SIG		(14)
D 6
#define	PID_RSSIZE	(29)
#define	PID_MAXRSS	(46)
#define	PID_INDEX	(62)
E 6
I 6
#define	PID_MAXRSS	(29)
#define	PID_ID		(46)
I 7
#define	PID_CSW		(46)
E 7
E 6
/*
 *	Vertical offsets.  (what line is it on...)
 */
#define	PID_COMM	(3)
D 5
#define	PID_FLAGS	(PID_COMM+1)
E 5
I 5
D 14
#define	PID_FLAG	(PID_COMM+1)
E 5
#define	PID_STATE	(PID_COMM+2)
D 5
#define	PID_UID		(7)
#define	PID_GID		(PID_UID+1)
E 5
I 5
D 6
#define	PID_EFF		(7)
#define	PID_REAL	(PID_EFF+1)
E 6
I 6
#define	PID_RSSIZE	(8)
E 6
E 5
#define	PID_CPU		(10)
E 14
I 14
#define	PID_WCHAN	(PID_COMM+1)
#define	PID_FLAG	(PID_COMM+2)
#define	PID_STATE	(PID_COMM+3)
#define	PID_RSSIZE	(9)
#define	PID_CPU		(11)
E 14
#define	PID_USER	(PID_CPU+1)
#define	PID_SYSTEM	(PID_CPU+2)
D 14
#define	PID_SINGLE	(14)
E 14
I 14
#define	PID_SINGLE	(15)
E 14
/*
 *	Widths of fields for building headers.
 */
#define	STATE_WIDTH	(28)
#define	PRI_WIDTH	(16)
D 5
#define	NICE_WIDTH	(15)
E 5
I 5
D 19
#define	NICE_WIDTH	(14)
E 19
I 19
#define	NICE_WIDTH	(15)
#define	TTYD_WIDTH	(5)
E 19
E 5
#define	CPU_WIDTH	(28)
#define	FAULT_WIDTH	(16)
#define	BLOCK_WIDTH	(15)
#define	SWAP_WIDTH	(13)
#define	SIG_WIDTH	(14)
D 6
#define	RSSIZE_WIDTH	(16)
E 6
I 6
#define	ID_WIDTH	(28)
#define	RSSIZE_WIDTH	(13)
E 6
D 7
#define	MAXRSS_WIDTH	(15)
E 7
I 7
#define	MAXRSS_WIDTH	(16)
E 7
I 6
#define INDEX_WIDTH	(14)
E 6
I 3

I 12
D 14
#define	PID_LINES	(17)
E 14
I 14
#define	PID_LINES	(18)
E 14

E 12
/*
 *	Clear the screen and print the headers for process data.
 *
 *	This function will also look-up the names corresponding to
 *	the user and group id's.
 */
redraw_pid()
{
I 12
	lines = PID_LINES ;

E 12
D 10
	clear() ;
E 10
I 10
D 11
	wclear(stdscr) ;
E 11
I 11
	wclear(wp) ;
E 11
E 10

D 10
	move(0, 0);
E 10
I 10
D 11
	wmove(stdscr, 0, 0);
E 11
I 11
	wmove(wp, 0, 0);
E 11
E 10

	sample_header() ;

D 10
	mvprintw(PID_COMM, 0, "Command:\nFlags:\n") ;
E 10
I 10
D 11
	wmove(stdscr, PID_COMM, 0) ;
	wprintw(stdscr, "Command:\nFlags:\n") ;
E 11
I 11
	wmove(wp, PID_COMM, 0) ;
D 14
	wprintw(wp, "Command:\nFlags:\n") ;
E 14
I 14
	wprintw(wp, "Command:\nWChan:\nFlags:\n") ;
I 26
	wrefresh(wp) ;
E 26
E 14
E 11
E 10

D 10
	printw("%-*.*s %-*.*s %-*.*s %-*.*s ttyd:",
E 10
I 10
D 11
	wprintw(stdscr, "%-*.*s %-*.*s %-*.*s %-*.*s ttyd:",
E 11
I 11
D 19
	wprintw(wp, "%-*.*s %-*.*s %-*.*s %-*.*s ttyd:",
E 19
I 19
D 26
	wprintw(wp, "%-*.*s %-*.*s %-*.*s %-*.*s %-*.*s",
E 26
I 26
	wprintw(wp, "%-*.*s %-*.*s %-*.*s %-*.*s",
E 26
E 19
E 11
E 10
		STATE_WIDTH, STATE_WIDTH, "State:",
		PRI_WIDTH,   PRI_WIDTH,   "Priority:",
D 19
		NICE_WIDTH,  NICE_WIDTH,  "Nice:") ;
E 19
I 19
		NICE_WIDTH,  NICE_WIDTH,  "Nice:",
		TTYD_WIDTH,  TTYD_WIDTH,  "ttyd:") ;
E 19
I 4

D 22
	uid_string(prev_uid = mon_pid.mon_cred.cr_uid, username) ;
	uid_string(prev_ruid = mon_pid.mon_cred.cr_ruid, real_user) ;
	gid_string(prev_gid = mon_pid.mon_cred.cr_gid, groupname) ;
	gid_string(prev_rgid = mon_pid.mon_cred.cr_rgid, real_group) ;

E 22
D 5
	mvprintw(PID_UID, 0, "User ID:\nGroup ID:") ;
E 5
I 5
D 6
	mvprintw(PID_EFF, 0, "Effective ID:\nReal ID:") ;
E 6
I 6
D 10
	mvprintw(PID_RSSIZE-1, 0, "%-*.*s %-*.*s Effective ID:",
E 10
I 10
D 11
	wmove(stdscr, PID_RSSIZE - 1, 0) ;
	wprintw(stdscr, "%-*.*s %-*.*s Effective ID:",
E 11
I 11
	wmove(wp, PID_RSSIZE - 1, 0) ;
	wprintw(wp, "%-*.*s %-*.*s Effective ID:",
E 11
E 10
		RSSIZE_WIDTH, RSSIZE_WIDTH, "RSSize (Kb):",
		INDEX_WIDTH, INDEX_WIDTH, "CPU Index:") ;
E 6
E 5

I 6
D 10
	mvprintw(PID_RSSIZE, 0, "%*.*s Real ID:", ID_WIDTH, ID_WIDTH, "") ;
E 10
I 10
D 11
	wmove(stdscr, PID_RSSIZE, 0) ;
	wprintw(stdscr, "%*.*s Real ID:", ID_WIDTH, ID_WIDTH, "") ;
E 11
I 11
	wmove(wp, PID_RSSIZE, 0) ;
	wprintw(wp, "%*.*s Real ID:", ID_WIDTH, ID_WIDTH, "") ;
E 11
E 10

E 6
D 10
	mvprintw(PID_CPU, 0, "%-*.*s %-*.*s %-*.*s Messages:",
E 10
I 10
D 11
	wmove(stdscr, PID_CPU, 0) ;
	wprintw(stdscr, "%-*.*s %-*.*s %-*.*s Messages:",
E 11
I 11
	wmove(wp, PID_CPU, 0) ;
	wprintw(wp, "%-*.*s %-*.*s %-*.*s Messages:",
E 11
E 10
		CPU_WIDTH,   CPU_WIDTH, "CPU time:",
		FAULT_WIDTH, FAULT_WIDTH, "Page Faults:",
		BLOCK_WIDTH, BLOCK_WIDTH, "Block I/O:");

D 7
	mvprintw(PID_USER, 0, "%-*.*s %-*.*s %-*.*s (S)",
E 7
I 7
D 10
	mvprintw(PID_USER, 0, "%-*.*s %-*.*s %-*.*s (Send)",
E 10
I 10
D 11
	wmove(stdscr, PID_USER, 0) ;
	wprintw(stdscr, "%-*.*s %-*.*s %-*.*s (Send)",
E 11
I 11
	wmove(wp, PID_USER, 0) ;
	wprintw(wp, "%-*.*s %-*.*s %-*.*s (Send)",
E 11
E 10
E 7
		CPU_WIDTH,   CPU_WIDTH, "(User)",
D 7
		FAULT_WIDTH, FAULT_WIDTH, "(H)",
E 7
I 7
		FAULT_WIDTH, FAULT_WIDTH, "(Hard)",
E 7
		BLOCK_WIDTH, BLOCK_WIDTH, "(I)") ;

D 7
	mvprintw(PID_SYSTEM, 0, "%-*.*s %-*.*s %-*.*s (R)",
E 7
I 7
D 10
	mvprintw(PID_SYSTEM, 0, "%-*.*s %-*.*s %-*.*s (Rcv.)",
E 10
I 10
D 11
	wmove(stdscr, PID_SYSTEM, 0) ;
	wprintw(stdscr, "%-*.*s %-*.*s %-*.*s (Rcv.)",
E 11
I 11
	wmove(wp, PID_SYSTEM, 0) ;
	wprintw(wp, "%-*.*s %-*.*s %-*.*s (Rcv.)",
E 11
E 10
E 7
		CPU_WIDTH,   CPU_WIDTH, "(System)",
D 7
		FAULT_WIDTH, FAULT_WIDTH, "(S)",
E 7
I 7
		FAULT_WIDTH, FAULT_WIDTH, "(Soft)",
E 7
		BLOCK_WIDTH, BLOCK_WIDTH, "(O)") ;

D 6
	mvprintw(PID_SINGLE, 0, "%-*.*s %-*.*s %-*.*s %-*.*s CPU index:",
E 6
I 6
D 7
	mvprintw(PID_SINGLE, 0, "%-*.*s %-*.*s MAXrss (Kb):",
E 7
I 7
D 10
	mvprintw(PID_SINGLE, 0, "%-*.*s %-*.*s %-*.*s Context Switches",
E 10
I 10
D 11
	wmove(stdscr, PID_SINGLE, 0) ;
	wprintw(stdscr, "%-*.*s %-*.*s %-*.*s Context Switches",
E 11
I 11
	wmove(wp, PID_SINGLE, 0) ;
	wprintw(wp, "%-*.*s %-*.*s %-*.*s Context Switches",
E 11
E 10
E 7
E 6
		SWAP_WIDTH, SWAP_WIDTH, "Swaps:",
D 6
		SIG_WIDTH, SIG_WIDTH, "Signals:",
		RSSIZE_WIDTH, RSSIZE_WIDTH, "RSSize:",
		MAXRSS_WIDTH, MAXRSS_WIDTH, "MAXRSS:") ;
E 6
I 6
D 7
		SIG_WIDTH, SIG_WIDTH, "Signals:") ;
E 7
I 7
		SIG_WIDTH, SIG_WIDTH, "Signals:",
D 14
		MAXRSS_WIDTH, MAXRSS_WIDTH, "MAXrss (Kb):") ;
E 14
I 14
		MAXRSS_WIDTH, MAXRSS_WIDTH, "MAXrss (Kb):");
E 14
E 7
E 6
E 4
}

I 5
/*
 *	Print the data for the process.
 */
E 5
magnify_pid()
{
I 5
D 22
	register struct ucred *cp = &mon_pid.mon_cred ;
E 22
	register struct rusage *rp = &mon_pid.mon_self ;
I 7
	double	 etime ;
E 7

D 7
	sample_body((double)(sample.mon_ticks - pid_ticks)/first.mon_hz) ;
	pid_ticks = sample.mon_ticks ;
E 7
I 7
	etime = delta_pid(sample.mon_ticks, SELF) ;
E 7

I 7
	sample_body(etime) ;

E 7
D 10
	mvprintw(PID_COMM, PID_OFFSET, "%s", mon_pid.mon_comm) ;
	clrtoeol() ;
E 10
I 10
D 11
	wmove(stdscr, PID_COMM, PID_OFFSET) ;
	wprintw(stdscr, "%s", mon_pid.mon_comm) ;
	wclrtoeol(stdscr) ;
E 11
I 11
	wmove(wp, PID_COMM, PID_OFFSET) ;
	wprintw(wp, "%s", mon_pid.mon_comm) ;
I 14
	wclrtoeol(wp) ;

	wmove(wp, PID_WCHAN, PID_OFFSET) ;
	wprintw(wp, "%x", mon_pid.mon_wchan) ;
E 14
	wclrtoeol(wp) ;
E 11
E 10

D 10
	mvprintw(PID_FLAG, PID_OFFSET, "<%s>", str_flags(mon_pid.mon_pflag)) ;
	clrtoeol() ;
E 10
I 10
D 11
	wmove(stdscr, PID_FLAG, PID_OFFSET) ;
	wprintw(stdscr, "<%s>", str_flags(mon_pid.mon_pflag)) ;
	wclrtoeol(stdscr) ;
E 11
I 11
	wmove(wp, PID_FLAG, PID_OFFSET) ;
	wprintw(wp, "<%s>", str_flags(mon_pid.mon_pflag)) ;
	wclrtoeol(wp) ;
E 11
E 10

D 10
	mvprintw(PID_STATE, PID_OFFSET, "%-9s", str_stats(mon_pid.mon_stat)) ;
	mvprintw(PID_STATE, PID_PRI, "%3d", mon_pid.mon_pri) ;
	mvprintw(PID_STATE, PID_NICE, "%3d", mon_pid.mon_nice) ;
	mvprintw(PID_STATE, PID_TTYD, "<%d,%d>", major(mon_pid.mon_ttyd),
		minor(mon_pid.mon_ttyd)) ;
	clrtoeol() ;
E 10
I 10
	/*
	 *	Stuff that goes on the STATE line.
	 */
D 11
	wmove(stdscr, PID_STATE, PID_OFFSET) ;
	wprintw(stdscr, "%-9s", str_stats(mon_pid.mon_stat)) ;
E 11
I 11
	wmove(wp, PID_STATE, PID_OFFSET) ;
	wprintw(wp, "%-9s", str_stats(mon_pid.mon_stat)) ;
E 11
E 10

I 10
D 11
	wmove(stdscr, PID_STATE, PID_PRI) ;
	wprintw(stdscr, "%3d", mon_pid.mon_pri) ;
E 11
I 11
	wmove(wp, PID_STATE, PID_PRI) ;
	wprintw(wp, "%3d", mon_pid.mon_pri) ;
E 11

D 11
	wmove(stdscr, PID_STATE, PID_NICE) ;
	wprintw(stdscr, "%3d", mon_pid.mon_nice) ;
E 11
I 11
	wmove(wp, PID_STATE, PID_NICE) ;
	wprintw(wp, "%3d", mon_pid.mon_nice) ;
E 11

D 11
	wmove(stdscr, PID_STATE, PID_TTYD) ;
	wprintw(stdscr, "<%d,%d>", major(mon_pid.mon_ttyd), minor(mon_pid.mon_ttyd)) ;
	wclrtoeol(stdscr) ;
E 11
I 11
	wmove(wp, PID_STATE, PID_TTYD) ;
	wprintw(wp, "<%d,%d>", major(mon_pid.mon_ttyd), minor(mon_pid.mon_ttyd)) ;
	wclrtoeol(wp) ;
E 11

E 10
D 22
	if( prev_uid != cp->cr_uid )
		uid_string(prev_uid = cp->cr_uid, username) ;

	if( prev_ruid != cp->cr_ruid )
		uid_string(prev_ruid = cp->cr_ruid, real_user) ;

	if( prev_gid != cp->cr_gid )
		gid_string(prev_gid = cp->cr_gid, groupname) ;

	if( prev_rgid != cp->cr_rgid )
		gid_string(prev_rgid = cp->cr_rgid, real_group) ;

E 22
D 6
	mvprintw(PID_EFF, PID_OFFSET, "<%s,%s>", username, groupname) ;
E 6
I 6
D 10
	mvprintw(PID_RSSIZE-1, PID_ID, "<%s,%s>", username, groupname) ;
E 6
	clrtoeol() ;
E 10
I 10
	/*
	 *	Prin the user ID and resident set size.
	 */
D 11
	wmove(stdscr, PID_RSSIZE-1, PID_ID) ;
	wprintw(stdscr, "<%s,%s>", username, groupname) ;
	wclrtoeol(stdscr) ;
E 11
I 11
	wmove(wp, PID_RSSIZE-1, PID_ID) ;
D 22
	wprintw(wp, "<%s,%s>", username, groupname) ;
E 22
I 22
	wprintw(wp, "<%s,%s>", mon_pid.mon_username, mon_pid.mon_groupname) ;
E 22
	wclrtoeol(wp) ;
E 11
E 10

D 6
	mvprintw(PID_REAL, PID_OFFSET, "<%s,%s>", real_user, real_group) ;
E 6
I 6
D 10
	mvprintw(PID_RSSIZE, PID_ID, "<%s,%s>", real_user, real_group) ;
E 6
	clrtoeol() ;
E 10
I 10
D 11
	wmove(stdscr, PID_RSSIZE-1, PID_ID) ;
	wprintw(stdscr, "<%s,%s>", real_user, real_group) ;
	wclrtoeol(stdscr) ;
E 11
I 11
D 15
	wmove(wp, PID_RSSIZE-1, PID_ID) ;
E 15
I 15
	wmove(wp, PID_RSSIZE, PID_ID) ;
E 15
D 22
	wprintw(wp, "<%s,%s>", real_user, real_group) ;
E 22
I 22
	wprintw(wp, "<%s,%s>", mon_pid.mon_realuser, mon_pid.mon_realgroup) ;
E 22
	wclrtoeol(wp) ;
E 11
E 10

I 6
D 10
	mvprintw(PID_RSSIZE, 0, "%-*d %-10d", RSSIZE_WIDTH,
		pgtok(mon_pid.mon_rssize), mon_pid.mon_cpundx) ;
E 10
I 10
D 11
	wmove(stdscr, PID_RSSIZE, 0) ;
	wprintw(stdscr, "%-*d %-10d", RSSIZE_WIDTH, pgtok(mon_pid.mon_rssize),
E 11
I 11
	wmove(wp, PID_RSSIZE, 0) ;
	wprintw(wp, "%-*d %-10d", RSSIZE_WIDTH, pgtok(mon_pid.mon_rssize),
E 11
		mon_pid.mon_cpundx) ;
E 10

E 6
D 10
	mvprintw(PID_USER, PID_CPU_X, "%s", str_timeval(&rp->ru_utime)) ;
D 7
	mvprintw(PID_USER, PID_FAULT, "%-10d", rp->ru_majflt) ;
	mvprintw(PID_USER, PID_BLOCK, "%-10d", rp->ru_inblock) ;
	mvprintw(PID_USER, PID_MESSAGE, "%-10d", rp->ru_msgsnd) ;
E 7
I 7
	mvprintw(PID_USER, PID_FAULT, "%-7.2f", rp->ru_majflt / etime) ;
	mvprintw(PID_USER, PID_BLOCK, "%-7.2f", rp->ru_inblock / etime ) ;
	mvprintw(PID_USER, PID_MESSAGE, "%-7.2f", rp->ru_msgsnd / etime ) ;
E 10
I 10
	/*
	 *	Stuff that goes on the "user" line.
	 */
D 11
	wmove(stdscr, PID_USER, PID_CPU_X) ;
	wprintw(stdscr, "%s", str_timeval(&rp->ru_utime)) ;
E 11
I 11
	wmove(wp, PID_USER, PID_CPU_X) ;
	wprintw(wp, "%s", str_timeval(&rp->ru_utime)) ;
E 11
E 10
E 7

D 10
	mvprintw(PID_SYSTEM, PID_CPU_X, "%s", str_timeval(&rp->ru_stime)) ;
D 7
	mvprintw(PID_SYSTEM, PID_FAULT, "%-10d", rp->ru_minflt) ;
	mvprintw(PID_SYSTEM, PID_BLOCK, "%-10d", rp->ru_oublock) ;
	mvprintw(PID_SYSTEM, PID_MESSAGE, "%-10d", rp->ru_msgrcv) ;
E 7
I 7
	mvprintw(PID_SYSTEM, PID_FAULT, "%-7.2f", rp->ru_minflt / etime ) ;
	mvprintw(PID_SYSTEM, PID_BLOCK, "%-7.2f", rp->ru_oublock / etime ) ;
	mvprintw(PID_SYSTEM, PID_MESSAGE, "%-7.2f", rp->ru_msgrcv / etime ) ;
E 10
I 10
D 11
	wmove(stdscr, PID_USER, PID_FAULT) ;
	wprintw(stdscr, "%-7.2f", rp->ru_majflt / etime) ;
E 11
I 11
	wmove(wp, PID_USER, PID_FAULT) ;
	wprintw(wp, "%-7.2f", rp->ru_majflt / etime) ;
E 11
E 10
E 7

D 10
	mvprintw(PID_SINGLE+1, PID_SWAP, "%-10d", rp->ru_nswap) ;
	mvprintw(PID_SINGLE+1, PID_SIG, "%-10d", rp->ru_nsignals) ;
D 6
	mvprintw(PID_SINGLE+1, PID_RSSIZE, "%-10d", mon_pid.mon_rssize) ;
	mvprintw(PID_SINGLE+1, PID_MAXRSS, "%-10d", rp->ru_maxrss) ;
	mvprintw(PID_SINGLE+1, PID_INDEX, "%-10d", mon_pid.mon_cpundx) ;
E 6
I 6
	mvprintw(PID_SINGLE+1, PID_MAXRSS, "%-10d", pgtok(rp->ru_maxrss)) ;
I 7
	mvprintw(PID_SINGLE+1, PID_CSW, "%-10d", rp->ru_nvcsw + rp->ru_nivcsw) ;
E 10
I 10
D 11
	wmove(stdscr, PID_USER, PID_BLOCK) ;
	wprintw(stdscr, "%-7.2f", rp->ru_inblock / etime ) ;
E 11
I 11
	wmove(wp, PID_USER, PID_BLOCK) ;
	wprintw(wp, "%-7.2f", rp->ru_inblock / etime ) ;
E 11

D 11
	wmove(stdscr, PID_USER, PID_MESSAGE) ;
	wprintw(stdscr, "%-7.2f", rp->ru_msgsnd / etime ) ;
E 11
I 11
	wmove(wp, PID_USER, PID_MESSAGE) ;
	wprintw(wp, "%-7.2f", rp->ru_msgsnd / etime ) ;
E 11

	/*
	 *	Stuff that goes on the "system" line.
	 */
D 11
	wmove(stdscr, PID_SYSTEM, PID_CPU_X) ;
	wprintw(stdscr, "%s", str_timeval(&rp->ru_stime)) ;
E 11
I 11
	wmove(wp, PID_SYSTEM, PID_CPU_X) ;
	wprintw(wp, "%s", str_timeval(&rp->ru_stime)) ;
E 11

D 11
	wmove(stdscr, PID_SYSTEM, PID_FAULT) ;
	wprintw(stdscr, "%-7.2f", rp->ru_minflt / etime ) ;
E 11
I 11
	wmove(wp, PID_SYSTEM, PID_FAULT) ;
	wprintw(wp, "%-7.2f", rp->ru_minflt / etime ) ;
E 11

D 11
	wmove(stdscr, PID_SYSTEM, PID_BLOCK) ;
	wprintw(stdscr, "%-7.2f", rp->ru_oublock / etime ) ;
E 11
I 11
	wmove(wp, PID_SYSTEM, PID_BLOCK) ;
	wprintw(wp, "%-7.2f", rp->ru_oublock / etime ) ;
E 11

D 11
	wmove(stdscr, PID_SYSTEM, PID_MESSAGE) ;
	wprintw(stdscr, "%-7.2f", rp->ru_msgrcv / etime ) ;
E 11
I 11
	wmove(wp, PID_SYSTEM, PID_MESSAGE) ;
	wprintw(wp, "%-7.2f", rp->ru_msgrcv / etime ) ;
E 11

	/*
	 *	The leftovers.
	 */
D 11
	wmove(stdscr, PID_SINGLE + 1, PID_SWAP) ;
	wprintw(stdscr, "%-10d", rp->ru_nswap) ;
E 11
I 11
	wmove(wp, PID_SINGLE + 1, PID_SWAP) ;
	wprintw(wp, "%-10d", rp->ru_nswap) ;
E 11

D 11
	wmove(stdscr, PID_SINGLE + 1, PID_SIG) ;
	wprintw(stdscr, "%-10d", rp->ru_nsignals) ;
E 11
I 11
	wmove(wp, PID_SINGLE + 1, PID_SIG) ;
	wprintw(wp, "%-10d", rp->ru_nsignals) ;
E 11

D 11
	wmove(stdscr, PID_SINGLE + 1, PID_MAXRSS) ;
	wprintw(stdscr, "%-10d", pgtok(rp->ru_maxrss)) ;
E 11
I 11
	wmove(wp, PID_SINGLE + 1, PID_MAXRSS) ;
D 21
	wprintw(wp, "%-10d", pgtok(rp->ru_maxrss)) ;
E 21
I 21
	wprintw(wp, "%-10d", pgtok((int)rp->ru_maxrss)) ;
E 21
E 11

D 11
	wmove(stdscr, PID_SINGLE + 1, PID_CSW) ;
	wprintw(stdscr, "%-10d", rp->ru_nvcsw + rp->ru_nivcsw) ;
E 11
I 11
	wmove(wp, PID_SINGLE + 1, PID_CSW) ;
	wprintw(wp, "%-10d", rp->ru_nvcsw + rp->ru_nivcsw) ;
I 22
}

/*
 *	Dump the contents of the PID structure.
 */
f_pid(p)
struct mon_pid *p ;
{
	if((p->mon_flag & MON$M_VALID) == 0 )
		return ;

D 23
	printf("%s.\n", records[MON$C_PID].rec_string) ;
E 23
I 23
	printf("%s.\n", records[MON$C_PID].string) ;
E 23

	printf("\tpid:       %d\n", p->mon_pid) ;
	printf("\tpgrp:      %d\n", p->mon_pgrp ) ;
	printf("\tpri:       %d\n", p->mon_pri ) ;
	printf("\tnice:      %d\n", p->mon_nice ) ;
	printf("\twchan:     %x\n", p->mon_wchan) ;
	printf("\tttyd:      <%d,%d>\n", major(p->mon_ttyd), minor(p->mon_ttyd)) ;
	printf("\tpflag:     <%s>\n", str_flags(p->mon_pflag)) ;
	printf("\tstat:      %s\n", str_stats(p->mon_stat)) ;
	printf("\tcomm:      %s\n", p->mon_comm) ;
	printf("\trssize:    %d Kb.\n", pgtok(p->mon_rssize)) ;

	printf("\tcpundx:    %x\n", p->mon_cpundx) ;

	printf("\tusername:  %s\n", mon_pid.mon_username) ;
	printf("\trealuser:  %s\n", mon_pid.mon_realuser) ;
	printf("\tgroupname: %s\n", mon_pid.mon_groupname) ;
	printf("\trealgroup: %s\n", mon_pid.mon_realgroup) ;

	printf("\tself:\n") ;
	print_rusage(&p->mon_self, "\t\t") ;

	printf("\tchild:\n") ;
	print_rusage(&p->mon_child, "\t\t") ;

	printf("\tcred:\n") ;
	print_cred(&p->mon_cred, "\t\t") ;
I 25
}

/*
 *	Check the namelist.
 */
check_namelist_pid()
{
	if( pid_nm[PID_NM_PROC].n_value == 0 ) {
		info("There is no process table.\n", module) ;
		return 0 ;
	}

	if( pid_nm[PID_NM_NPROC].n_value == 0 ) {
		info("Can't find out how big the process table is.\n", module) ;
		return 0 ;
	}

	if( pid_nm[PID_NM_USRPTMAP].n_value == 0 ) {
		info("There is no user page table map.\n", module) ;
		return 0 ;
	}

	if( pid_nm[PID_NM_USRPT].n_value == 0 ) {
		info("There is no user page table.\n", module) ;
		return 0 ;
	}

	return 1 ;
E 25
E 22
E 11
E 10
E 7
E 6
E 5
}
E 3
E 2
E 1
