h64900
s 00010/00000/00806
d D 1.71 90/03/29 16:16:36 alan 71 70
c The hack to fix the DECmumble include file problem.
e
s 00005/00000/00801
d D 1.70 89/12/28 15:43:09 alan 70 69
c Changed uses of vmunix to op->opt_kernel and setup opt_kernel correctly.
c 
e
s 00010/00001/00791
d D 1.69 89/12/28 11:25:49 alan 69 68
c added support fractional seconds
e
s 00001/00001/00791
d D 1.68 89/05/18 15:59:35 alan 68 67
c fixed spelling error in error message
e
s 00002/00000/00790
d D 1.67 89/04/18 17:30:44 alan 67 66
c fixed a bug in the debug was handled when not compiled in
e
s 00006/00001/00784
d D 1.66 89/03/11 13:05:07 alan 66 65
c print choices for an ambigious argument and exit if search_options() fails.
e
s 00001/00000/00784
d D 1.65 89/02/13 14:29:25 alan 65 64
c Dust off assorted lint and added KMEM option
c 
e
s 00008/00018/00776
d D 1.64 89/01/18 18:46:28 alan 64 63
c Added "all" option as default and removed some #ifdef's.
c 
e
s 00001/00001/00793
d D 1.63 89/01/16 18:41:56 alan 63 62
c change the option nch to namei
e
s 00006/00002/00788
d D 1.62 89/01/16 16:07:16 alan 62 61
c Added code and data namei and buffer cache.
c 
e
s 00005/00001/00785
d D 1.61 89/01/15 20:24:30 alan 61 60
c turned on SWAP
e
s 00004/00000/00782
d D 1.60 89/01/04 10:43:50 alan 60 59
c V1.1 changes unrelated to MIPS support
e
s 00051/00014/00731
d D 1.59 88/07/04 16:41:45 alan 59 58
c see Mods for July 4, 1988
e
s 00125/00179/00620
d D 1.58 88/06/29 23:31:32 alan 58 57
c See the modification history for 29-June-1988.
c 
e
s 00063/00037/00736
d D 1.57 88/06/28 23:37:54 alan 57 56
c 1.  Moved ..._set flags into bit field.
c 2.  Added security check on -file and -output options.
c 
e
s 00011/00001/00762
d D 1.56 88/06/27 18:15:34 alan 56 55
c changed include of monitor.h and record.h
e
s 00004/00000/00759
d D 1.55 88/04/25 16:30:09 alan 55 54
c made nop unsupported for distribution
e
s 00003/00001/00756
d D 1.54 88/03/16 21:10:40 alan 54 53
c Make reserved data options "not supported" when used with the
c -magnify option.  In this case there no distinction between
c a reserved option and an unrecognized one.
c 
e
s 00003/00000/00754
d D 1.53 87/11/18 16:40:42 alan 53 52
c V0.99 -> T1.0-1
e
s 00010/00010/00744
d D 1.52 87/08/12 15:26:41 alan 52 51
c error message clean up - V0.95
e
s 00002/00001/00752
d D 1.51 87/05/20 17:15:27 alan 51 50
c changed all curses calls to use w... versions
e
s 00001/00001/00752
d D 1.50 87/04/03 14:30:42 alan 50 49
c 1.  Mostly rearranged include files so that the sources would compile
c     using VAXC.
c 2.  Changed an error monitor that pcc let get by.
c 
e
s 00026/00003/00727
d D 1.49 87/03/03 15:41:33 alan 49 48
c see the commentary for V0.83 in version.c
e
s 00000/00006/00730
d D 1.48 87/02/05 16:28:35 alan 48 47
c See comment on V0.81 in version.c.
c 
e
s 00004/00000/00732
d D 1.47 87/01/21 16:36:31 alan 47 46
c This is the first pass at makeing changes to record.h.  The intent of
c this delta is to change record.h and update the files that broke so
c that they will compile and a runnable version is produced.  This
c version may not run correctly.  A few other changes were added at
c same time, which were related to the changes to record.h.  See the
c commentary on V0.68 in version.c.  The next couple of deltas will
c be clean up this one.
c 
e
s 00005/00010/00727
d D 1.46 86/12/30 11:20:22 alan 46 45
c See commentary on V0.64 in version.c
e
s 00036/00006/00701
d D 1.45 86/12/24 23:31:40 alan 45 44
c See commentary on V0.63 in version.c.  Cpu.c may not have changed.
c 
e
s 00005/00000/00702
d D 1.44 86/12/07 22:21:45 alan 44 43
c See V0.57 in version.c
e
s 00033/00017/00669
d D 1.43 86/11/19 09:39:50 alan 43 42
c See commentary on V0.56 in version.c
c 
e
s 00001/00001/00685
d D 1.42 86/11/18 12:42:04 alan 42 41
c See commentary on V0.55 in version.c
c 
e
s 00005/00005/00681
d D 1.41 86/11/17 18:41:51 alan 41 40
c See commentary on V0.54 in version.c
c 
e
s 00030/00008/00656
d D 1.40 86/11/17 17:03:12 alan 40 39
c See V0.53 in version.c.
c 
e
s 00461/00248/00203
d D 1.39 86/11/16 16:56:04 alan 39 38
c See comments on V0.52 in version.c
c 
e
s 00032/00000/00419
d D 1.38 86/11/02 16:16:04 alan 38 37
c See V0.50 in version.c
c 
e
s 00003/00000/00416
d D 1.37 86/09/29 13:34:22 alan 37 36
c added -v (version) option
e
s 00001/00001/00415
d D 1.36 86/08/26 18:03:35 alan 36 35
c modify all SccsId strings
e
s 00005/00000/00411
d D 1.35 86/08/14 16:20:00 alan 35 34
c add '-' support for stdout
e
s 00007/00007/00404
d D 1.34 86/07/31 14:07:19 alan 34 33
c Change many fprintf's to info's and add arguments to assorted warning and
c fatal error messages.
c 
e
s 00028/00000/00383
d D 1.33 86/07/31 13:20:13 alan 33 32
c 1.  Fixed bug that caused "unmagify" to produce a very off the wall error
c message and exit without cleaning up.
c 2.  Fixed bug in magnify that would cause a panic when selecting a non-
c existing function.
c 3.  Enhanced replay and options to remember what the original display
c functions for multi session save files.
c 
e
s 00012/00003/00371
d D 1.32 86/07/28 21:32:58 alan 32 31
c Add a check to force the -s, -f and -p options to have a following
c string, in order to be seriously considered.
c 
e
s 00049/00029/00325
d D 1.31 86/07/23 14:15:21 alan 31 30
c Added abbreviation support for command line options
c 
e
s 00002/00006/00352
d D 1.30 86/07/13 13:52:18 alan 30 29
c added monitor.h to includes
e
s 00008/00008/00350
d D 1.29 86/07/11 19:26:59 alan 29 28
c Dust off LOTS of lint...
c 
e
s 00004/00000/00354
d D 1.28 86/06/30 08:46:45 alan 28 27
c Added general help function for display mode.  Currently there are no
c help functions.
c 
e
s 00012/00001/00342
d D 1.27 86/06/30 08:22:21 alan 27 26
c Added code for a generalized redraw_display function.
c 
e
s 00008/00016/00335
d D 1.26 86/06/29 15:47:38 alan 26 25
c Changed the handleing of "word=value" lists.
c 
e
s 00008/00005/00343
d D 1.25 86/06/23 10:04:37 alan 25 24
c make screen mode the default instead of save
e
s 00003/00000/00345
d D 1.24 86/05/29 13:52:34 alan 24 23
c Added opt_total field to options structure for turning on disk totals.
c 
e
s 00000/00001/00345
d D 1.23 86/05/29 11:16:06 alan 23 22
c Changes to incorporate addition of users.
c 
e
s 00052/00012/00294
d D 1.22 86/05/28 15:57:11 alan 22 21
c First pass of changes in order to get data selection to work.  Data
c selection during the replay function still needs to be written.
c 
c 1.  Due to the heavy use of the code like:
c 
c 	if( nel ) {
c 		p = sprintf(buf, "%s%d", name, unit);
c 
c 		if( !bsearch(&p, base, nel, sizeof(key *), compare))
c 			;
c 	}
c I sould impliment it as a function somewhere.  Probably in the 2nd or
c third pass.
c 
e
s 00001/00002/00305
d D 1.21 86/05/26 15:52:59 alan 21 20
c I combined the mon_state and mon_cpu structures into one (mon_cpu) which
c is supposed to be all the system data that is kept on a per CPU basis.
c See record.h for more info.  Most of the changes that occured in the files
c were a result of removing references to mon_state and opt_state.
c 
c Other changes unrelated to this:
c 1.  Changed NM_PAGE to NM_RATE.  This was in three files, monitor.h and
c     two of the others.
c 2.  I added loop for the collecting the "tape" data to save.c.  This is
c     a very short loop since there is no tape data in the system.
c 
e
s 00005/00005/00302
d D 1.20 86/05/26 14:12:38 alan 20 19
c Turn begin and end_replay into open and close_replay.
c 
e
s 00002/00002/00305
d D 1.19 86/05/25 17:56:49 alan 19 18
c Sigh...  In the interest of Life, Liberty and the Common Kludge, whenevery
c you turn on CPU or STATE it will turn on the other (STATE or CPU).  This
c will go away when I combine the CPU and STATE record.
c 
e
s 00007/00007/00300
d D 1.18 86/05/24 19:53:20 alan 18 17
c Change almost anything that was "gather" to "live" or "collect" depending
c on the context.  Functions changed to "live" and words changed to
c collect.  Begin and end changed to open and close respectively.
c 
e
s 00140/00084/00167
d D 1.17 86/05/24 19:41:34 alan 17 16
c Many changes, still more to come.
c 1.  Got rid of the replay flag.  I have added a display_mode and collect_mode
c which will be set to the approproiate thing.
c 2.  Added flags for eatit (eat the first data record in replay mode),
c display_set, collect_set which are set whenever the display_mode or collect_mode
c are set from an option.   Added data_set to show that data has been turned.
c 3.  Move OPT_ #define's to options.h.  Also rearranged them some.
c 4.  Rearranged the cases in other_option().  The "bad" cases are now on
c at the end of the switch.
c 5.  Changed all fprintf's to printf's.
c 6.  Added OPT_NET.  To be defined at a much later date.
c 7.  Added a verify_options() to make sure that nothing silly can happen.
c 
c What I didn't do:
c 1.  Still no abbreviations.
c 2.  Didn't change *gather() functions to *live().
c 
e
s 00013/00004/00238
d D 1.16 86/05/22 18:56:59 alan 16 15
c Added flags to determine when the -f and -s options were used from the
c command line.
c 
e
s 00012/00012/00230
d D 1.15 86/05/22 10:19:16 alan 15 14
c changed prefix of display functoins to open and close.
c changed prefix of collection functions to begin and end.
c 
e
s 00009/00006/00233
d D 1.14 86/05/21 18:17:48 alan 14 13
c 1.  Added a flag and constant for replay.
c 2.  Took out *_mask.
c 3.  Turned on "tape" as a valid data option.
c 
e
s 00051/00024/00188
d D 1.13 86/05/21 10:35:50 alan 13 12
c 1.  Changed references to function pointers.
c 2.  Added "live" options.
c 3.  Added case for OPT_LIVE and OPT_SAVE, so that it wouldn't use the
c     default case when those were turned on.
c 
e
s 00004/00013/00208
d D 1.12 86/05/18 17:30:27 alan 12 11
c fully initialize opt_data
e
s 00000/00005/00221
d D 1.11 86/05/18 16:27:30 alan 11 10
c moved #define's for grouped data (MON$M_MON and MON$M_IO) from source to
c include file.
c 
e
s 00002/00002/00224
d D 1.10 86/05/12 21:04:35 alan 10 9
c turned on tty in MON$M_MON
c 
e
s 00009/00000/00217
d D 1.9 86/05/12 20:38:01 alan 9 8
c added group options for I/O and 'mon'
e
s 00005/00002/00212
d D 1.8 86/05/12 15:07:05 alan 8 7
c added help options, -h
e
s 00109/00015/00105
d D 1.7 86/05/10 18:27:46 alan 7 6
c added first pass of data selection code
e
s 00004/00001/00116
d D 1.6 86/05/08 18:16:22 alan 6 5
c turned on disks, samples and netif
e
s 00001/00000/00116
d D 1.5 86/05/08 11:54:38 alan 5 4
c added opt_prompt
e
s 00000/00000/00116
d D 1.4 86/05/02 17:55:21 alan 4 3
c changed structure of options
e
s 00003/00003/00113
d D 1.3 86/04/23 17:23:13 alan 3 2
c Changed all occurances of "idle" to "monitor"
c 
e
s 00018/00007/00098
d D 1.2 86/04/23 16:09:49 alan 2 1
c Knows about the screen function.
c 
e
s 00105/00000/00000
d D 1.1 86/04/23 12:32:34 alan 1 0
c date and time created 86/04/23 12:32:34 by alan
e
u
U
t
T
I 1
/*
 *	Author:  Alan Rollow, CSC/CS, Digital Equipment Corp.
 *	File:	 %M%
 *	Date:	 %G%
 *	Version: %I%
 *
D 39
 *	%M% - This file contains functions for processing the command line
 *		to set various available options.
E 39
I 39
 *	%M% - This file contains functions for processing the command 
 *	line to set various available options.
E 39
 */
#ifndef	lint
D 36
static	char	SccsId[] = "%W% %G%" ;
E 36
I 36
D 39
static	char	SccsId[] = "%W%	(monitor)	%G%" ;
E 39
I 39
static	char	SccsId[] = "%W% (monitor) %G%" ;
E 39
E 36
#endif

I 56
/*
 * Modification History
 * 
 * 27-June-1988 -- arr
 *
 *	Change include of monitor.h to include.h.
 *
 *	Change include of record.h to monitor.h.
I 57
 *
D 58
 * 28-June-1988 - arr
E 58
I 58
 * 28-June-1988 -- arr
E 58
 *
 *	Put the various ..._set data structures into one bit
 *	field.
 *
 *	Make a "security" check in the -file and -output options.
 *	This uses a global variable called "secure" that may be
 *	patched with adb(1).
I 58
 *
 * 29-June-1988 -- arr
 *
 *	Compress the switches in display_option() and collect_option()
 *	to use as much common code as possible.
 *
 *	Change the way OPT_READ was handled to use the replay fuctions
 *	instead of it's input functions.
 *
 *	Further compressed display_option() and collect_option() so
 *	that they went away completely.  Changed the handling of
 *	pid collection so that it goes though the OPT_LIVE code.
 *
 *	Remove the references to OPT_RATE.  Replace most of the
 *	switch tables in set_display() and set_collect() with a
 *	loop using the display_table and collect_table arrays.
I 59
 *
 *  4-July-1988 -- arr
 *
 *	Remove the restriction that let monitor only collect data
 *	on processes when the opt_pid option was turned on.
 *
 *	Fixed the error message that says the display was changed
 *	to SCREEN.  It previously said that the COLLECTION mode was
 *	changed to SCREEN.
I 61
 *
 * Jan. 15 1989 -- arr
 *
D 64
 *	Turned on SWAP.
E 64
I 64
 *	Turned on SWAP space data collection.
E 64
I 62
 *
 * Jan. 16, 1989 -- arr
 *
 *	Turn on collection of buffer and namei cache.
I 64
 *
 * Jan. 18, 1989 -- arr
 *
 *	Added "all" option and made it the default for data collection.
 *	Also removed ALLOW_NAMES and PROC_ONLY #ifdef's.
I 69
 *
 * Dec. 28, 1989 -- arr
 *
 *	Added support for fractional seconds.
I 71
 *
 * Mar. 26, 1990 -- arr
 *
 *	Added hack to work-around DECmumble include file problem.
 *
E 71
E 69
E 64
E 62
E 61
E 59
E 58
E 57
 */

E 56
#include <nlist.h>
#include <stdio.h>
I 7
#include <signal.h>
E 7

#include <sys/types.h>
I 47
D 48
#include <sys/devio.h>
E 48
E 47
D 7
#include <sys/vm.h>
E 7
I 7
#include <sys/buf.h>
#include <sys/file.h>
#include <sys/socket.h>
E 7
#include <sys/dk.h>
I 47
#include <sys/param.h>
#include <sys/dir.h>
I 71

#if defined(V4_ULTRIX) && defined(mips)
#	include <mips/cpu.h>
#endif

E 71
#include <sys/user.h>
E 47
I 7
#include <sys/vmsystm.h>
#include <sys/vmmeter.h>
E 7

D 3
#include "idle.h"
E 3
I 3
D 7
#include "monitor.h"
E 7
I 7
#include <net/if.h>
#include <netinet/in.h>

E 7
E 3
#include "options.h"
I 22
D 50
#include "extern.h"
E 50
E 22
D 7
#include "extern.h"
E 7
I 7
D 56
#include "record.h"
E 56
I 30
#include "monitor.h"
I 56
#include "include.h"
E 56
I 50
#include "extern.h"
E 50
E 30
E 7

/*
I 44
 *	Functions that don't return (int).
 */
void	exit() ;

/*
E 44
I 39
 *	Yet another convient macro...
 */
#define	MACRO(s, code, bit, type)	{ s, sizeof(s)-1, code, bit, type, }

/*
 *	Bit encodings used locally.
 */
#define	OPT_NEXTWORD	01

/*
 *	No relationships between the indexs and the fields should be 
 *	assumed.  Gaps have been left in the OPT_ number that aren't
 *	reflected in the size of the table.
 */
static struct tag {
D 59
	char	*opt_string ;
	int	opt_length,
		opt_code,
		opt_bit,
		opt_type ;
E 59
I 59
	char	*opt_string ;		/* the name of the option */
	int	opt_length,		/* the length of the string */
		opt_code,		/* The OPT_... code */
		opt_bit,		/* The MON$M_ bit for the data option */
		opt_type ;		/* The option type */
E 59
} array[] = {
/*
 *	Display modes (0-7).
 */
	MACRO("save",	 OPT_SAVE,	0, OPT_DISPLAY),
	MACRO("screen",	 OPT_SCREEN,	0, OPT_DISPLAY),
	MACRO("window",	 OPT_WINDOW,	0, OPT_RFFU),
D 59
	MACRO("line",	 OPT_LINE,	0, OPT_RFFU),
E 59
I 55
#ifdef	ALLOW_NOP
E 55
	MACRO("nop",	 OPT_NOP,	0, OPT_DISPLAY),
I 55
#else
	MACRO("nop",	 OPT_NOP,	0, OPT_NOSUP),
#endif
E 55
	MACRO("print",	 OPT_PRINT,	0, OPT_RFFU),
	MACRO("read",	 OPT_READ,	0, OPT_DISPLAY),
/*
 *	Collection modes (8-15).
 */
	MACRO("live",	 OPT_LIVE,	0, OPT_COLLECT),
	MACRO("replay",	 OPT_REPLAY,	0, OPT_COLLECT),
I 60
D 64
#ifdef	ALLOW_NAMES
E 64
E 60
D 59
	MACRO("network", OPT_NET,	0, OPT_RFFU),
E 59
	MACRO("names",	 OPT_NAMES,	0, OPT_COLLECT),
I 60
D 64
#else
	MACRO("names",	 OPT_NAMES,	0, OPT_NOSUP),
#endif
E 64
E 60
I 43
D 58
	MACRO("dump",	 OPT_DUMP,	0, OPT_NOSUP),
E 58
E 43
/*
 *	Data selection (16-39).
 */
	MACRO("cpu",	 OPT_CPU,	MON$M_CPU, OPT_DATA),
	MACRO("tty",	 OPT_TTY,	MON$M_TTY, OPT_DATA),
	MACRO("disk",	 OPT_DISK,	MON$M_DISK, OPT_DATA),
	MACRO("free",	 OPT_FREE,	MON$M_FREE, OPT_DATA),
	MACRO("fork",	 OPT_FORK,	MON$M_FORK, OPT_DATA),
	MACRO("page",	 OPT_PAGE,	MON$M_PAGE, OPT_DATA),
	MACRO("process", OPT_PROC,	MON$M_PROC, OPT_DATA),
D 61
	MACRO("swap",	 OPT_SWAP,	MON$M_SWAP, OPT_RFFU),
E 61
I 61
	MACRO("swap",	 OPT_SWAP,	MON$M_SWAP, OPT_DATA),
E 61
D 48
	MACRO("tape",	 OPT_TAPE,	MON$M_TAPE, OPT_DATA),
E 48
	MACRO("users",	 OPT_USER,	MON$M_USER, OPT_DATA),
	MACRO("netif",	 OPT_NETIF,	MON$M_NETIF, OPT_DATA),
	MACRO("memory",	 OPT_MEMORY,	MON$M_MEMORY, OPT_DATA),
	MACRO("loadave", OPT_LOADAVE,	MON$M_LOADAVE, OPT_DATA),
	MACRO("io", 	 OPT_IO,	MON$M_IO, OPT_DATA),
	MACRO("mon", 	 OPT_MON,	MON$M_MON, OPT_DATA),
I 64
	MACRO("all",	 OPT_ALL,	MON$M_ALL, OPT_DATA),
E 64
I 49
	MACRO("pid",	 OPT_PID,	MON$M_PID, OPT_DATA),
I 51
	MACRO("os",	 OPT_OS,	MON$M_OS, OPT_DATA),
I 53
D 62
	MACRO("buf",	 OPT_BUF,	MON$M_BUF, OPT_RFFU),
E 62
I 62
	MACRO("buf",	 OPT_BUF,	MON$M_BUF, OPT_DATA),
E 62
	MACRO("nfs",	 OPT_NFS,	MON$M_NFS, OPT_RFFU),
D 59
	MACRO("namei",	 OPT_NAMEI,	MON$M_NAMEI, OPT_RFFU),
E 59
I 59
D 62
	MACRO("nch",	 OPT_NAMEI,	MON$M_NAMEI, OPT_RFFU),
E 62
I 62
D 63
	MACRO("nch",	 OPT_NAMEI,	MON$M_NAMEI, OPT_DATA),
E 63
I 63
	MACRO("namei",	 OPT_NAMEI,	MON$M_NAMEI, OPT_DATA),
I 65
	MACRO("kmem",	 OPT_KMEM,	MON$M_KMEM, OPT_DATA),
E 65
E 63
E 62
E 59
E 53
E 51
E 49
D 48
	MACRO("all",	 OPT_ALL,	MON$M_ALL, OPT_DATA),
E 48
/*
 *	Command line options (40-...).
 */
	MACRO("-file",	  OPT_FILE,	OPT_NEXTWORD,	OPT_MINUS),
	MACRO("-total",	  OPT_TOTAL,	0,		OPT_MINUS),
	MACRO("-output",  OPT_OUTPUT,	OPT_NEXTWORD,	OPT_MINUS),
	MACRO("-sleep",	  OPT_SLEEP,	OPT_NEXTWORD,	OPT_MINUS),
I 67
#ifdef	DEBUG
E 67
D 46
	MACRO("-eatit",	  OPT_EATIT,	0,		OPT_MINUS),
E 46
	MACRO("-debug",	  OPT_DEBUG,	0,		OPT_MINUS),
I 67
#endif
E 67
	MACRO("-prompt",  OPT_PROMPT,	OPT_NEXTWORD,	OPT_MINUS),
	MACRO("-help",	  OPT_HELP,	0,		OPT_MINUS),
	MACRO("-version", OPT_VERSION,	0,		OPT_MINUS),
I 43
D 45
	MACRO("-magnify", OPT_MAGNIFY,  OPT_NEXTWORD,	OPT_NOSUP),
E 45
I 45
	MACRO("-magnify", OPT_MAGNIFY,  OPT_NEXTWORD,	OPT_MINUS),
D 58
	MACRO("-rate",	  OPT_RATE,	0,		OPT_NOSUP),
E 58
	MACRO("-sample",  OPT_SAMPLE,	0,		OPT_MINUS),
I 70
	MACRO("-kernel",  OPT_KERNEL,   OPT_NEXTWORD,   OPT_MINUS),
E 70
E 45
E 43
};

/*
 *	Conditionally compile in the debugging code.  If the code is
 *	compiled in, debugging messages will be printed if the "-d"
 *	option is used on the command line.
 */
#ifdef	DEBUG
int	debug = 0 ;
#endif

/*
I 40
D 57
 *	This is the module name to be passed to the error
 *	message functions.
E 57
I 57
 *	A flag which can be used to disable the ability to set
 *	the data file and screen dump names from the command line.
I 59
 *
 *	It needs to somewhere that abd can get to it.  In a object
 *	code distribution this would live in a data file that could
 *	be configured as necessary.
E 59
E 57
 */
D 57
static	char	*module = "options" ;
E 57
I 57
int	secure = 1 ;
E 57

/*
E 40
D 57
 *	These replace flags that were carried around in the options
 *	structure but not longer needed.
E 57
I 57
 *	Various local data structures.
 *
 *	module - The module name passed to the error message functions.
 *	set - A bit field used to keep track of what options have been set.
E 57
 */
D 57
static	display_set = 0,	/* a display option has been set */
	collect_set = 0,	/* a collection option has been set */
	file_set = 0,		/* the -f option has been used */
	data_set = 0 ;		/* a data option has been set */
E 57
I 57
static char *module = "options" ;
static struct set_bits set ;
E 57

/*
E 39
I 33
D 59
 *	The "default" display functions.  These will be used in replay.
E 59
I 59
 *	The "default" display functions.  These will be used in replay
 *	to remember what the default display mode was.
E 59
 */
int	(*def_display)(),
	(*def_redraw)(),
	(*def_close)(),
	(*def_open)(),
	(*def_help)() ;

/*
E 33
I 27
D 39
 *	The NULL function.
 */
int	nop()
{
}

/*
E 39
E 27
D 13
 *	Various available functions.
E 13
I 13
D 58
 *	Various available functions.  First the "display"
E 58
I 58
 *	A macro for getting the number of elements in a static
 *	table.
 */
#define	SIZE(x)	(sizeof(x)/sizeof(x[0]))

/*
 *	The various available functions.  First the "display"
E 58
 *	functions.
E 13
 */
D 15
int	screen(), init_screen(), uninit_screen() ;
int	save(), init_save(), uninit_save() ;
E 15
I 15
D 27
int	screen(), open_screen(), close_screen() ;
E 27
I 27
D 46
int	screen(), open_screen(), close_screen(), redraw_screen() ;
E 27
int	save(), open_save(), close_save() ;
E 46
I 46
int	screen(), open_screen(), close_screen(), redraw_screen(), help_screen() ;
E 46
I 38
D 39
int	open_nop(), close_nop(), display_nop(), redraw_nop(), help_nop() ;
E 39
I 39
int	open_read(), close_read(), display_read() ;
I 46
int	save(), open_save(), close_save() ;
E 46
E 39

I 58
struct display_table display_table[] = {
	OPT_SCREEN, 1, 2,
	screen, open_screen, close_screen, redraw_screen, help_screen,

	OPT_READ, 0, 2,
	display_read, open_read, close_read, NULL, NULL,

	OPT_SAVE, 0, 600,
	save, open_save, close_save, NULL, NULL,

	OPT_NOP, 0, 2,
	NULL, NULL, NULL, NULL, NULL,
};

E 58
E 38
E 15
I 13
/*
 *	Next the data collection functions.
 */
D 15
int	gather(), init_gather(), uninit_gather() ;
int	replay(), init_replay(), uninit_replay() ;
E 15
I 15
D 18
int	gather(), begin_gather(), end_gather() ;
E 18
I 18
D 46
int	live(), open_live(), close_live() ;
E 46
I 46
D 58
int	dump_records(), open_dump(), close_dump() ;
E 58
E 46
E 18
D 20
int	replay(), begin_replay(), end_replay() ;
E 20
I 20
int	replay(), open_replay(), close_replay() ;
I 39
int	names(), open_names(), close_names() ;
I 43
D 46
int	dump_records(), open_dump(), close_dump() ;
E 46
I 46
int	live(), open_live(), close_live() ;
I 49
D 58
int	collect_pid(), open_pid(), close_pid() ;
E 58
E 49
E 46
E 43
E 39
E 20
E 15
E 13

I 58
struct collect_table collect_table[] = {
	OPT_LIVE,   live,         open_live,   close_live,
	OPT_REPLAY, replay,       open_replay, close_replay,
	OPT_NAMES,  names,        open_names,  close_names,
};

E 58
/*
I 22
D 30
 *	Function to build a value list.
 */
char	**build_value() ;

/*
E 30
E 22
I 2
D 17
 *	Internal status variables.
 */
int	sleep_changed = 0 ;

/*
E 17
E 2
 *	Look at the argument vector to set the various options.  Default
 *	options will also be set here.
 */
parse(argc, argv, op)
int	argc ;
char	**argv ;
OPTION	*op ;
{
D 39
	int	i ;
E 39
I 39
	int	i, mcc ;
	char	*next_word, *value, *strchr() ;
E 39

I 59
	/*
	 *	Initialize the options structure.
	 */
E 59
D 15
	init_options(op);
E 15
I 15
D 17
	open_options(op);
E 17
I 17
	init_options(op);
E 17
E 15

I 59
	/*
	 *	Do any special command name processing.
	 */
E 59
I 39
	command_name(argv[0], op) ;

I 59
	/*
	 *	Loop through the arguments.
	 */
E 59
E 39
	for(i = 1; i < argc; i++) {
I 59
		/*
		 *	See if the argument has an '=' in it and remember
		 *	the right part of the equal.
		 */
E 59
D 39
		if( argv[i][0] != '-' ) {
			other_option(argv[i], op);
			continue ;
E 39
I 39
		if((value = strchr(argv[i], '=')) != NULL ) {
			*value = '\0' ;
			value++ ;
E 39
		}

I 59
		/*
		 *	Look in the option table to see if the argument
		 *	matches.  Return a "magick cookie code" which is
		 *	index of the table entry.
		 */
E 59
D 39
		switch( argv[i][1] ) {
D 8
		case 's':			/* sleep */
E 8
I 8
		case 's':				/* sleep */
I 32
			if( argv[i][2] == '\0' )
				continue ;
E 39
I 39
		mcc = search_options(argv[i]) ;
E 39

E 32
E 8
D 39
			op->opt_sleep = atoi(&argv[i][2]);
I 2
D 16
			sleep_changed++ ;
E 16
I 16
D 17
			op->opt_sleep_set = 1 ;
E 17
I 17
			op->sleep_set = 1 ;
E 17
E 16
E 2
			break ;
D 2
		case 'n':			/* number of samples */
			op->opt_sample = atoi(&argv[i][2]);
			break ;
E 2
D 8
		case 'f':
E 8
I 8
		case 'f':				/* data file */
I 32
			if( argv[i][2] == '\0' )
				continue ;
E 39
I 39
D 43
#ifdef	DEBUG
		if( debug && mcc != -1 )
			printf("found %s.\n", array[mcc].opt_string) ;
#endif
E 39

E 43
E 32
E 8
D 39
			op->opt_file = &argv[i][2] ;
I 35

			if( strcmp(op->opt_file, "-") == 0 )
				op->opt_standard = 1 ;

E 35
I 16
D 17
			op->opt_file_set = 1 ;
E 17
I 17
			op->file_set = 1 ;
E 39
I 39
		switch( array[mcc].opt_type ) {
		case OPT_DISPLAY:
D 58
			display_option(op, array[mcc].opt_code) ;
E 58
I 58
			op->display_mode = array[mcc].opt_code ;
			set.display = 1 ;
E 58
E 39
E 17
E 16
			break ;
I 8
D 32
		case 'h':				/* help */
			help();
			exit(0);
E 32
I 14
D 17
		case 'p':
E 17
I 17
D 39
		case 'p':				/* prompt */
I 32
			if( argv[i][2] == '\0' )
				continue ;

E 32
E 17
			op->opt_prompt = &argv[i][2] ;
			break ; 
I 32
		case 'h':				/* help */
			help();
			exit(0);
I 37
		case 'v':
			show_version() ;
			exit(0) ;
E 37
E 32
I 17
		case 'e':				/* turn off eatit */
			op->opt_eatit = 0 ;
E 39
I 39
		case OPT_COLLECT:
D 58
			collect_option(op, array[mcc].opt_code) ;
E 58
I 58
			op->collect_mode = array[mcc].opt_code ;
			set.collect = 1 ;
E 58
E 39
			break ;
I 24
D 39
		case 't':			/* turn on disk totals */
			op->opt_total = 1 ;
E 39
I 39
		case OPT_DATA:
			data_option(op, mcc, value) ;
E 39
			break ;
I 39
		case OPT_MINUS:
I 58
			/*
			 *	Get the next argument if one is there.
			 */
E 58
			next_word = (i + 1) == argc ? NULL : argv[i+1] ;
			i += minus_option(op, mcc, next_word) ;
			break ;
		case OPT_RFFU:
D 40
			info("monitor: options: reserved for future use: %s.\n", argv[i]) ;
E 40
I 40
D 52
			info("reserved for future use: %s.\n", module, argv[i]) ;
E 52
I 52
			info("Reserved for future use: %s.\n", module, argv[i]) ;
E 52
E 40
			break ;
		case OPT_NOSUP:
E 39
E 24
E 17
E 14
E 8
		default:
D 3
			fprintf(stderr, "idle: unsupported option: %c (%s).\n",
E 3
I 3
D 17
			fprintf(stderr, "monitor: unsupported option: %c (%s).\n",
E 17
I 17
D 29
			printf("monitor: unsupported option: %c (%s).\n",
E 29
I 29
D 34
			fprintf(stderr, "monitor: options: unsupported option: %c (%s).\n",
E 34
I 34
D 39
			info("monitor: options: unsupported option: %c (%s).\n",
E 34
E 29
E 17
E 3
				argv[i][1], &argv[i][2]);
E 39
I 39
D 40
			info("monitor: options: unsupported option: %s.\n", argv[i]);
E 40
I 40
D 52
			info("unsupported option: %s.\n", module, argv[i]);
E 52
I 52
			info("Unsupported option: %s.\n", module, argv[i]);
I 66
			exit(-1) ;
E 66
E 52
E 40
E 39
			break ;
		}
	}
I 17

I 59
	/*
	 *	verify that the various combinations of options are
	 *	reasonable and change those that aren't.
	 */
E 59
	verify_options(op);
I 33

I 58
	/*
	 *	Setup the functions based on the display and collection
	 *	modes chosen.
	 */
	set_collect(op) ;
	set_display(op) ;

E 58
I 39
#ifdef	DEBUG
	if( debug )
		print_option(op) ;
#endif

E 39
	def_display = op->display ;
	def_redraw = op->redraw_display ;
	def_close = op->close_display ;
	def_open = op->open_display ;
	def_help = op->help_display ;
E 33
E 17
}

D 15
init_options(op)
E 15
I 15
D 17
open_options(op)
E 17
I 17
/*
D 39
 *	Verify that the options are set reasonably.  There are currently
D 22
 *	three cases.
E 22
I 22
 *	four cases.
E 39
I 39
 *	Verify that the options are set reasonably.  The first pass of 
 *	verify_options() will set the options according to the various 
 *	relationships between the display mode and collection mode.
E 39
E 22
D 58
 *
D 39
 *	1.  Data option:
 *
 *		If MEMORY is turned then we don't need really to also
 *		collect FREE.
 *
 *		If a data option isn't selected and the collection option
 *		is LIVE print a message and exit.
 *
 *	2.  Display options:
 *
 *		If SCREEN is selected and a file is selected turn on
 *		REPLAY.
 *
 *	3.  Collection options:
 *
 *		If REPLAY is turned on make sure that SAVE is not the
 *		display mode.  If it is, turn it into SCREEN.
E 39
I 39
 *	The 2nd pass will set the functions according to the mode.
E 58
E 39
 */
verify_options(op)
E 17
E 15
OPTION	*op ;
{
I 39
	/*
D 58
	 *	Anytime NAMES is used as a collection option then
	 *	than that's what the collection will be.  Return
	 *	after setting the functions.
E 58
I 58
	 *	Anytime OPT_NAMES is used as a collection option
	 *	then set the display mode op OPT_NOP and return.
	 *	The set_display() and set_collect() will ensure
	 *	that everything is setup correctly.
E 58
	 */
	if( op->collect_mode == OPT_NAMES ) {
I 58
		op->display_mode = OPT_NOP ;
E 58
D 57
		collect_set = 1 ;
		display_set = 1 ;
E 57
I 57
		set.collect = 1 ;
		set.display = 1 ;
E 57

D 58
		op->collect = names ;
		op->open_collect = open_names ;
		op->close_collect = close_names ;

		op->display_mode = OPT_NOP ;
		op->display = NULL ;
		op->open_display = NULL ;
		op->help_display = NULL ;
		op->close_display = NULL ;
		op->redraw_display = NULL ;

E 58
		return ;
	}

	/*
D 58
	 *	If both MEMORY and FREE are turned on data options turn
	 *	off FREE.
E 58
I 58
	 *	If both the MEMORY and FREE data options are turned on
	 *	turn off FREE.
E 58
	 */
E 39
I 17
	if( op->opt_memory && op->opt_free )
		op->opt_free = 0 ;

D 39
	if( op->display_mode == OPT_SCREEN && op->file_set ) {
		op->collect_mode = OPT_REPLAY ;
		op->collect_set = 1 ;
E 39
I 39
	/*
	 *   If the display mode is SAVE...
	 *
	 *	If the collection mode is not set, then use LIVE.
	 *
D 58
	 *	or if the collection is REPLAY change the display mode
	 *	to SCREEN.
E 58
I 58
	 *	or if the collection mode is REPLAY change the display 
	 *	mode to SCREEN.
E 58
	 */
	if( op->display_mode == OPT_SAVE ) {
D 57
		if( !collect_set ) {
E 57
I 57
		if( set.collect == 0 ) {
E 57
			op->collect_mode = OPT_LIVE ;
D 57
			collect_set = 1 ;
E 57
I 57
			set.collect = 1 ;
E 57
		}
		else if( op->collect_mode == OPT_REPLAY ) {
D 40
			info("monitor: options: collection mode changed to SCREEN.\n") ;
E 40
I 40
D 52
			info("collection mode changed to SCREEN.\n", module) ;
E 52
I 52
D 59
			info("Collection mode changed to SCREEN.\n", module) ;
E 59
I 59
			info("Display mode changed to SCREEN.\n", module) ;
E 59
E 52
E 40
			op->display_mode = OPT_SCREEN ;
D 57
			display_set = 1 ;
E 57
I 57
			set.display = 1 ;
E 57
		}
		else
			;	/* don't care */
	}
E 39

D 39
		op->collect = replay ;
D 20
		op->open_collect = begin_replay ;
		op->close_collect = end_replay ;
E 20
I 20
		op->open_collect = open_replay ;
		op->close_collect = close_replay ;
E 39
I 39
	/*
	 *	If the display mode hasn't been set, use SAVE if the collection
	 *	mode is LIVE and has been set and a data file has been set.
 	 *	Otherwise use SCREEN.
	 *
	 *	Since the default collection mode is LIVE we only want to
	 *	set the display mode to SAVE if a data file has been set AND
	 *	LIVE was selected on the command line.
	 */
D 57
	if( !display_set ) {
		if( op->collect_mode == OPT_LIVE && collect_set && file_set ) {
E 57
I 57
	if( set.display == 0 ) {
		if( op->collect_mode == OPT_LIVE && set.collect && set.file ) {
E 57
			op->display_mode = OPT_SAVE ;
D 57
			display_set = 1 ;
E 57
I 57
			set.display = 1 ;
E 57
		}
		else {
			op->display_mode = OPT_SCREEN ;
D 57
			display_set = 1 ;
E 57
I 57
			set.display = 1 ;
E 57
		}
E 39
E 20
	}

D 39
	if( op->collect_mode == OPT_REPLAY && op->display_mode == OPT_SAVE ) {
		op->display_mode = OPT_SCREEN ;
		op->display_set = 1 ;
		op->opt_inter = 1 ;
E 39
I 39
	/*
	 *	Whenever a collection mode hasn't been set, use REPLAY if
D 58
	 *	a data has been set and LIVE otherwise.
E 58
I 58
	 *	a data file has been specified, otherwise use LIVE as the
	 *	collection mode.
E 58
	 */
D 57
	if( !collect_set ) {
		collect_set = 1 ;
E 57
I 57
	if( set.collect == 0 ) {
		set.collect = 1 ;
E 57
E 39

I 39
D 57
		if( file_set )
E 57
I 57
		if( set.file )
E 57
			op->collect_mode = OPT_REPLAY ;
		else
			op->collect_mode = OPT_LIVE ;
	}

	/*
D 59
	 *	Make sure we've chosen a data option in LIVE mode.
E 59
I 59
	 *	If we haven't chosen a data option turn on a default.
E 59
	 */
D 57
	if( op->collect_mode == OPT_LIVE && !data_set )
E 57
I 57
D 59
	if( op->collect_mode == OPT_LIVE && set.data == 0 )
E 57
D 42
		fatal("monitor: options: No data selected in LIVE mode.\n") ;
E 42
I 42
D 51
		fatal("No data selected in LIVE mode.\n", module) ;
E 51
I 51
		fatal("No data selected in LIVE mode, use -h for help.\n", module) ;
E 59
I 59
	if( op->collect_mode == OPT_LIVE && set.data == 0 ) {
		set.data = 1 ;
D 64
		op->opt_data |= MON$M_MON ;
E 64
I 64
		op->opt_data |= MON$M_ALL ;
E 64
	}
E 59
E 51
E 42
D 58

	/*
	 *	Setup the functions based on the display and collection
	 *	modes chosen.
	 */
	set_functions(op) ;
E 58
}

/*
 *	Based on the collection and display modes set the corresponding
 *	functions.  Panic if we see an unexpected collection or display
 *	mode.
 */
D 58
set_functions(op)
E 58
I 58
set_display(op)
E 58
OPTION	*op ;
{
D 58
	switch( op->display_mode ) {
	case OPT_SCREEN:
E 39
		op->display = screen ;
I 39
D 46
		op->help_display = NULL ;
E 46
I 46
		op->help_display = help_screen ;
E 46
E 39
		op->open_display = open_screen ;
I 28
D 39
		op->help_display = nop ;
E 39
E 28
		op->close_display = close_screen ;
I 27
		op->redraw_display = redraw_screen ;
E 58
I 58
	int	i ;
E 58
I 39

D 58
		op->opt_inter = 1 ;
E 58
I 58
	for(i = 0; i < SIZE(display_table); i++) {
		if( display_table[i].code == op->display_mode ) {
			op->display = display_table[i].display ;
			op->help_display = display_table[i].help ;
			op->open_display = display_table[i].open ;
			op->close_display = display_table[i].close ;
			op->redraw_display = display_table[i].redraw ;
E 58

D 58
		if( !op->sleep_set )
			op->opt_sleep = 2 ;
E 58
I 58
			op->opt_inter = display_table[i].interactive ;
E 58

D 58
		break ;
	case OPT_SAVE:
		op->display = save ;
		op->help_display = NULL ;
		op->open_display = open_save ;
		op->close_display = close_save ;
		op->redraw_display = NULL ;
E 58
I 58
			if( !op->sleep_set )
				op->opt_sleep = display_table[i].sleep ;
E 58

D 58
		if( !op->sleep_set )
			op->opt_sleep = 600 ;

		break ;
	case OPT_READ:
D 43
		op->display = display_read ;
E 43
I 43
		if( op->collect_mode == OPT_REPLAY ) {
D 57
			collect_set = 1 ;
E 57
I 57
			set.collect = 1 ;
E 57
			op->collect_mode = OPT_DUMP ;

			op->display = NULL ;
			op->open_display = NULL ;
			op->close_display = NULL ;
E 58
I 58
			return ;
E 58
		}
D 58
		else {
			op->display = display_read ;
			op->open_display = open_read ;
			op->close_display = close_read ;
		}
E 58
I 58
	}
E 58

E 43
D 58
		op->help_display = NULL ;
D 43
		op->open_display = open_read ;
		op->close_display = close_read ;
E 43
		op->redraw_display = NULL ;
E 58
I 58
	panic("Unexpected display mode!\n", module) ;
}
E 58

D 58
		if( !op->sleep_set )
			op->opt_sleep = 2 ;
E 58
I 58
/*
 *	Based on the collection and display modes set the corresponding
 *	functions.  Panic if we see an unexpected collection or display
 *	mode.
 */
set_collect(op)
OPTION	*op ;
{
	int	i ;
E 58

D 58
		break ;
	case OPT_NOP:
		op->display = NULL ;
		op->help_display = NULL ;
		op->open_display = NULL ;
		op->close_display = NULL ;
		op->redraw_display = NULL ;
E 58
I 58
	for(i = 0; i < SIZE(collect_table); i++) {
		if( collect_table[i].code == op->collect_mode ) {
			op->collect = collect_table[i].collect ;
			op->open_collect = collect_table[i].open ;
			op->close_collect = collect_table[i].close ;
E 58

D 58
		if( !op->sleep_set )
			op->opt_sleep = 2 ;

		break ;
	default:
D 41
		panic("monitor: options: unexpected display mode.\n") ;
E 41
I 41
D 52
		panic("unexpected display mode.\n", module) ;
E 52
I 52
		panic("Unexpected display mode!\n", module) ;
E 58
I 58
			break ;
		}
E 58
E 52
E 41
E 39
E 27
	}

I 58
	/*
	 *	Do some option specific processing.
	 */
E 58
D 39
	if( op->data_set == 0 && op->collect_mode == OPT_LIVE ) {
D 29
		printf("monitor: No data selected in LIVE mode.\n");
E 29
I 29
D 34
		fprintf(stderr, "monitor: options: No data selected in LIVE mode.\n");
E 34
I 34
		info("monitor: options: No data selected in LIVE mode.\n");
E 34
E 29
		exit(0);
E 39
I 39
	switch( op->collect_mode ) {
	case OPT_LIVE:
I 59
D 64
#ifdef PROC_ONLY
E 59
D 49
		op->collect = live ;
		op->open_collect = open_live ;
		op->close_collect = close_live ;
E 49
I 49
D 58
		if( op->opt_pid ) {
			op->collect = collect_pid ;
			op->open_collect = open_pid ;
			op->close_collect = close_pid ;
E 49

I 49
			/*
			 *	If any other data options are set, turn them
			 *	off and print a message saying so.
			 */
			if( op->opt_data & MON$M_MON ) {
				op->opt_data &= ~MON$M_MON ;
D 52
				info("other data options being disabled.\n",
E 52
I 52
				info("Other data options being disabled.\n",
E 52
					module) ;
			}
E 58
I 58
		/*
		 *	If we're collecting data on process and other data 
		 *	options are set, turn them off and print a message 
		 *	saying so.  (This restriction will go away soon).
		 */
		if( op->opt_pid && (op->opt_data & MON$M_MON)) {
			op->opt_data &= ~MON$M_MON ;
			info("Other data options being disabled.\n",
				module) ;
E 58
		}
D 58
		else {
			op->collect = live ;
			op->open_collect = open_live ;
			op->close_collect = close_live ;
		}
E 58
D 59

E 59
I 59
#endif
E 64
E 59
E 49
		break ;
	case OPT_REPLAY:
D 58
		op->collect = replay ;
		op->open_collect = open_replay ;
		op->close_collect = close_replay ;

I 43
		break ;
	case OPT_DUMP:
		op->collect = dump_records ;
		op->open_collect = open_dump ;
		op->close_collect = close_dump ;

E 58
I 58
		/*
		 *	When the display mode is OPT_READ set the
		 *	sleep time to zero (0) unless the user has
		 *	set the time from the command line.
		 */
E 58
E 43
		if( !op->sleep_set && op->display_mode == OPT_READ ) {
			op->opt_sleep = 0 ;
			op->sleep_set = 1 ;
		}

D 43
		break ;
E 43
I 43
		break ; 
I 58
	case OPT_NAMES:
		/*
		 *	Recognize that is a valid collection otherwise
		 *	it would panic.
		 */
		break ;
E 58
E 43
	default:
D 41
		panic("monitor: options: unexpected collection mode.\n") ;
E 41
I 41
D 52
		panic("unexpected collection mode.\n", module) ;
E 52
I 52
		panic("Unexpected collection mode!\n", module) ;
E 52
E 41
E 39
	}
}

/*
 *	Initialize the options structures.
 */
init_options(op)
OPTION	*op ;
{
E 17
I 6
D 12
	op->opt_control = 0 ;
	op->opt_rectype3 = 0 ;
E 12
I 12
	op->opt_data = 0 ;
E 12
	op->opt_sample = 1 ;
E 6
D 12
	op->opt_cpu = 0 ;
	op->opt_tty = 0 ;
	op->opt_fork = 0 ;
D 6
	op->opt_disk = 0 ;
E 6
I 6
D 7
	op->opt_disk = 1 ;
E 7
I 7
	op->opt_disk = 0 ;
E 7
E 6
	op->opt_proc = 0 ;
	op->opt_page = 0 ;
	op->opt_tape = 0 ;
D 7
	op->opt_state = 1 ;
E 7
I 7
	op->opt_state = 0 ;
E 7
	op->opt_netif = 0 ;
D 7
	op->opt_inter = 0 ;
	op->opt_memory = 1 ;
	op->opt_loadave = 1 ;
E 7
I 7
	op->opt_memory = 0 ;
	op->opt_loadave = 0 ;
E 12
E 7

D 7
	op->mask_disk = ~0 ;
	op->mask_tape = ~0 ;
	op->mask_netif = ~0 ;
E 7
I 7
D 14
	op->opt_flag &= ~(MON$M_INTER) ;
E 14
I 14
D 17
	op->opt_inter = 0 ;
	op->opt_replay = 0 ;
I 16
	op->opt_sleep_set = 0 ;
	op->opt_file_set = 0 ;
E 17
I 17
	op->opt_flag = 0 ;
I 25
D 39

I 35
	op->opt_standard = 0 ;
E 35
	op->display_set = 1 ;
E 39
E 25
D 46
	op->opt_eatit = 1 ;
E 46
I 25
D 39
	op->opt_inter = 1 ;
E 39
E 25
E 17
E 16
E 14
E 7

I 7
D 14
	op->mask_disk  = 0xffffffff ;
	op->mask_tape  = 0xffffffff ;
	op->mask_netif = 0xffffffff ;

E 14
E 7
D 2
	op->opt_sleep = 30 ;
	op->opt_sample = 32 ;
E 2
I 2
D 25
	op->opt_sleep = 600 ;		/* 10 minute samples in file mode */
E 25
I 25
D 39
	op->opt_sleep = 2 ;		/* 2 second samples in screen mode */
E 39
E 25
E 2
	op->opt_file = "monitor.dat" ;
I 39
	op->opt_output = "screen.dump" ;
E 39
I 5
	op->opt_prompt = "monitor> " ;
I 70
	op->opt_kernel = "/vmunix" ;
E 70
I 45
	op->opt_magnify = 0 ;
E 45
E 5

D 2
	op->opt_funct = save ;
E 2
I 2
D 13
	op->opt_process = save ;
E 2
	op->opt_begin = init_save ;
	op->opt_finish = uninit_save ;
E 13
I 13
D 17
	op->opt_display = save ;
D 15
	op->opt_open_display = init_save ;
	op->opt_close_display = uninit_save ;
E 15
I 15
	op->opt_open_display = open_save ;
	op->opt_close_display = close_save ;
E 17
I 17
D 25
	op->display = save ;
	op->open_display = open_save ;
	op->close_display = close_save ;
	op->display_mode = OPT_SAVE ;
E 25
I 25
D 39
	op->display = screen ;
	op->open_display = open_screen ;
I 28
	op->help_display = nop ;
E 28
	op->close_display = close_screen ;
I 27
	op->redraw_display = redraw_screen ;
E 39
E 27
	op->display_mode = OPT_SCREEN;
E 25
E 17
E 15
D 39

D 17
	op->opt_gather = gather ;
D 15
	op->opt_end_gather = uninit_gather ;
	op->opt_begin_gather = init_gather ;
E 15
I 15
	op->opt_end_gather = end_gather ;
	op->opt_begin_gather = begin_gather ;
E 17
I 17
D 18
	op->collect = gather ;
	op->open_collect = begin_gather ;
	op->close_collect = end_gather ;
E 18
I 18
	op->collect = live ;
	op->open_collect = open_live ;
	op->close_collect = close_live ;
E 39
E 18
	op->collect_mode = OPT_LIVE ;
I 57

	set.display = 0 ;
	set.collect = 0 ;
	set.file = 0 ;
	set.data = 0 ;
E 57
E 17
E 15
E 13
}

I 13
/*
I 31
D 39
 *	Yet another convient macro...
E 39
I 39
D 45
 *	Process "-" preceded options.
E 45
I 45
 *	Process "-" preceded options.  The value returned by this
 *	function is the number of command line arguments to skip.
E 45
E 39
 */
D 39
#define	MACRO(s, code, bit)	{ s, sizeof(s)-1, code, bit, }

/*
E 31
D 17
 *	"Display" modes.
 */
E 13
I 7
#define	OPT_SCREEN	0
#define	OPT_WINDOW	1
#define	OPT_LINE	2
#define	OPT_SAVE	3
I 13
/*
 *	Collection mode.
 */
E 13
#define OPT_REPLAY	4
D 13
#define	OPT_CPU		5
#define	OPT_TTY		6
#define	OPT_DISK	7
#define	OPT_FREE	8
#define	OPT_FORK	9
#define	OPT_PAGE	10
#define	OPT_PROC	11
#define	OPT_SWAP	12
#define	OPT_TAPE	13
#define	OPT_USER	14
#define	OPT_NETIF	15
#define	OPT_STATE	16
#define	OPT_MEMORY	17
#define	OPT_LOADAVE	18
I 9
#define	OPT_IO		19
#define	OPT_MON		20
E 13
I 13
#define	OPT_LIVE	5
/*
 *	Data selection.
 */
#define	OPT_CPU		6
#define	OPT_TTY		7
#define	OPT_DISK	8
#define	OPT_FREE	9
#define	OPT_FORK	10
#define	OPT_PAGE	11
#define	OPT_PROC	12
#define	OPT_SWAP	13
#define	OPT_TAPE	14
#define	OPT_USER	15
#define	OPT_NETIF	16
#define	OPT_STATE	17
#define	OPT_MEMORY	18
#define	OPT_LOADAVE	19
#define	OPT_IO		20
#define	OPT_MON		21
E 13
E 9

I 9
D 11
#define	MON$M_IO	(MON$M_TTY | MON$M_DISK | MON$M_NETIF)
D 10
#define	MON$M_MON	(MON$M_CPU | MON$M_DISK | MON$M_FORK | MON$M_PAGE| \
			 MON$M_PROC | MON$M_NETIF | MON$M_STATE | \
E 10
I 10
#define	MON$M_MON	(MON$M_CPU | MON$M_TTY | MON$M_DISK | MON$M_FORK | \
			 MON$M_PAGE | MON$M_PROC | MON$M_NETIF | MON$M_STATE | \
E 10
			 MON$M_MEMORY | MON$M_LOADAVE)

E 11
E 9
E 7
/*
E 17
I 7
 *	Please note that "code" and index of the element are expected
 *	to be the same.  No other relationships about indexes and other
 *	fields should be assumed.
 */
D 30
static struct	{
E 30
I 30
static struct tag {
E 30
	char	*opt_string ;
I 31
	int	opt_length ;
E 31
	int	opt_code ;
	int	opt_bit ;
} array[] = {
I 17
/*
 *	Display modes.
 */
D 31
	"save",		OPT_SAVE,	0,
E 17
	"screen",	OPT_SCREEN,	0,
	"window",	OPT_WINDOW,	0,
	"line",		OPT_LINE,	0,
E 31
I 31
	MACRO("save",	OPT_SAVE,	0),
	MACRO("screen",	OPT_SCREEN,	0),
	MACRO("window",	OPT_WINDOW,	0),
	MACRO("line",	OPT_LINE,	0),
I 38
	MACRO("nop",	OPT_NOP,	0),
	MACRO("disp_1",	OPT_DISP_1,	0),
	MACRO("disp_2",	OPT_DISP_2,	0),
	MACRO("disp_3",	OPT_DISP_3,	0),
E 38
E 31
D 17
	"save",		OPT_SAVE,	0,
	"replay",	OPT_REPLAY,	0,
E 17
I 17
/*
 *	Collection modes.
 */
E 17
I 13
D 31
	"live",		OPT_LIVE,	0,
I 17
	"replay",	OPT_REPLAY,	0,
	"net",		OPT_NET,	0,
E 31
I 31
	MACRO("live",	 OPT_LIVE,	0),
	MACRO("replay",	 OPT_REPLAY,	0),
	MACRO("network", OPT_NET,	0),
I 38
	MACRO("coll_3",	 OPT_COLL_3,	0),
	MACRO("coll_3",	 OPT_COLL_3,	0),
	MACRO("coll_3",	 OPT_COLL_3,	0),
E 38
E 31
/*
 *	Data selection.
 */
E 17
E 13
D 19
	"cpu",		OPT_CPU,	MON$M_CPU,
E 19
I 19
D 21
	"cpu",		OPT_CPU,	MON$M_CPU | MON$M_STATE,
E 21
I 21
D 31
	"cpu",		OPT_CPU,	MON$M_CPU,
E 21
E 19
	"tty",		OPT_TTY,	MON$M_TTY,
	"disk",		OPT_DISK,	MON$M_DISK,
	"free",		OPT_FREE,	MON$M_FREE,
	"fork",		OPT_FORK,	MON$M_FORK,
	"page",		OPT_PAGE,	MON$M_PAGE,
	"proc",		OPT_PROC,	MON$M_PROC,
	"swap",		OPT_SWAP,	MON$M_SWAP,
	"tape",		OPT_TAPE,	MON$M_TAPE,
	"user",		OPT_USER,	MON$M_USER,
	"netif",	OPT_NETIF,	MON$M_NETIF,
D 19
	"state",	OPT_STATE,	MON$M_STATE,
E 19
I 19
D 21
	"state",	OPT_STATE,	MON$M_STATE | MON$M_CPU,
E 21
E 19
	"memory",	OPT_MEMORY,	MON$M_MEMORY,
	"loadave",	OPT_LOADAVE,	MON$M_LOADAVE,
I 9
	"io",		OPT_IO,		MON$M_IO,
	"mon",		OPT_MON,	MON$M_MON,
E 31
I 31
	MACRO("cpu",	 OPT_CPU,	MON$M_CPU),
	MACRO("tty",	 OPT_TTY,	MON$M_TTY),
	MACRO("disk",	 OPT_DISK,	MON$M_DISK),
	MACRO("free",	 OPT_FREE,	MON$M_FREE),
	MACRO("fork",	 OPT_FORK,	MON$M_FORK),
	MACRO("page",	 OPT_PAGE,	MON$M_PAGE),
	MACRO("process", OPT_PROC,	MON$M_PROC),
	MACRO("swap",	 OPT_SWAP,	MON$M_SWAP),
	MACRO("tape",	 OPT_TAPE,	MON$M_TAPE),
	MACRO("users",	 OPT_USER,	MON$M_USER),
	MACRO("netif",	 OPT_NETIF,	MON$M_NETIF),
	MACRO("memory",	 OPT_MEMORY,	MON$M_MEMORY),
	MACRO("loadave", OPT_LOADAVE,	MON$M_LOADAVE),
	MACRO("io", 	 OPT_IO,	MON$M_IO),
	MACRO("mon", 	 OPT_MON,	MON$M_MON),
	MACRO("all",	 OPT_ALL,	MON$M_ALL),
E 31
E 9
};

/*
E 7
 *	Process a non-minus preceded option.
 */
D 22
other_option(arg, op)
char	*arg ;
E 22
I 22
other_option(word, op)
char	*word ;
E 39
I 39
minus_option(op, mcc, next_word)
int	mcc ;
char	*next_word ;
E 39
E 22
OPTION	*op ;
{
D 2
	fprintf(stderr, "idle: unsupported option: %s.\n", arg);
E 2
I 2
D 7
	if( strcmp(arg, "screen") == 0 ) {
E 7
I 7
D 22
	int	mcc ;		/* Magick cookie code, i.e. index */
E 22
I 22
D 29
	int	mcc, i ;		/* Magick cookie code, i.e. index */
E 29
I 29
D 39
	int	mcc ;			/* Magick cookie code, i.e. index */
E 29
	char	*index(), *value ;
I 26
	struct list *list = 0 ;
E 39
I 39
D 45
	int	advance = 0 ;
E 45
I 45
	int	skip = 0 ;
	char	*value, *strchr() ;
I 69
	double	atof(), sleep_time ;
E 69
E 45
E 39
E 26
E 22

D 22
	if((mcc = search_options(arg)) == -1 )
D 17
		fprintf(stderr, "monitor: unsupported option: %s.\n", arg);
E 17
I 17
		printf("monitor: unsupported option: %s.\n", arg);
E 22
I 22
D 39
	if((value = index(word, '=')) != NULL ) {
		*value = '\0' ;
		value++ ;
E 39
I 39
	if((array[mcc].opt_bit & OPT_NEXTWORD) && next_word == NULL ) {
D 40
		info("monitor: options: This option requires an additional argument: %s.\n", array[mcc].opt_string) ;
E 40
I 40
		info("This option requires an additional argument: %s.\n",
			module, array[mcc].opt_string) ;
E 40
D 45
		return advance ;
E 45
I 45
		return skip ;
E 45
E 39
	}
E 22
E 17

I 22
D 39
	if((mcc = search_options(word)) == -1 ) {
D 29
		printf("monitor: unsupported option: %s.\n", word);
E 29
I 29
D 34
		fprintf(stderr, "monitor: options: unsupported option: %s.\n", word);
E 34
I 34
		info("monitor: options: unsupported option: %s.\n", word);
E 34
E 29
		return ;
	}
E 39
I 39
	if( array[mcc].opt_bit & OPT_NEXTWORD )
D 45
		advance = 1 ;
E 45
I 45
		skip = 1 ;
E 45
E 39

E 22
D 39
	switch( mcc ) {
I 13
D 17
	case OPT_LIVE:
E 17
	case OPT_SAVE:
I 17
		op->display_mode = OPT_SAVE ;
		op->display_set = 1 ;
E 17
I 14
		op->opt_inter = 0 ;
E 39
I 39
	switch( array[mcc].opt_code ) {
#ifdef	DEBUG
	case OPT_DEBUG:
		debug++ ;
		break ;
#endif
	case OPT_SLEEP:				/* sleep */
D 69
		op->opt_sleep = atoi(next_word) ;
E 69
I 69
		sleep_time = atof(next_word) ;

		op->opt_sleep = (int)sleep_time ;
		op->opt_fract = sleep_time - op->opt_sleep ;
E 69
		op->sleep_set = 1 ;
I 69

E 69
		break ;
	case OPT_FILE:				/* data file */
D 57
		op->opt_file = next_word ;
E 57
I 57
		if( secure ) {
			op->opt_file = next_word ;
E 57
E 39
E 14
D 17
		break ;				/* defaults */
E 13
	case OPT_SCREEN:
E 7
D 13
		op->opt_process = screen ;
		op->opt_begin = init_screen ;
		op->opt_finish = uninit_screen ;
E 13
I 13
		op->opt_display = screen ;
D 15
		op->opt_open_display = init_screen ;
		op->opt_close_display = uninit_screen ;
E 15
I 15
		op->opt_open_display = open_screen ;
		op->opt_close_display = close_screen ;
E 17
E 15
I 14

I 39
D 57
		if( strcmp(next_word, "-") == 0 )
			op->opt_standard = 1 ;
E 57
I 57
			if( strcmp(next_word, "-") == 0 )
				op->opt_standard = 1 ;
E 57
E 39
I 17

D 39
		op->display = save ;
		op->open_display = open_save ;
I 28
		op->help_display = nop ;
E 28
		op->close_display = close_save ;
I 27
		op->redraw_display = nop ;
E 39
I 39
D 57
		file_set = 1 ;
E 57
I 57
			set.file = 1 ;
		}
		else {
			info("This option isn't secure: %s.\n", module, "-file") ;
			info("Using default: %s.\n", module, op->opt_file) ;
		}

E 57
		break ;
	case OPT_OUTPUT:			/* screen/print dump file */
D 57
		op->opt_output = next_word ;
		op->output_set = 1 ;
E 57
I 57
		if( secure )
			op->opt_output = next_word ;
		else {
			info("This option isn't secure: %s.\n", module, "-output") ;
			info("Using default: %s.\n", module, op->opt_output) ;
		}

I 70
		break ;
	case OPT_KERNEL:
		op->opt_kernel = next_word ;
E 70
E 57
		break ;
	case OPT_PROMPT:			/* prompt */
		op->opt_prompt = next_word ;
		break ; 
	case OPT_HELP:				/* help */
		help();
		exit(0);
	case OPT_VERSION:			/* version string */
		show_version() ;
		exit(0) ;
D 46
	case OPT_EATIT:				/* turn off eatit */
		op->opt_eatit = 0 ;
		break ;
E 46
	case OPT_TOTAL:				/* turn on disk totals */
		op->opt_total = 1 ;
		break ;
I 45
	case OPT_SAMPLE:			/* magnify sample record */
		op->opt_mag_sample = 1 ;
		break ;
D 58
	case OPT_RATE:				/* divide by elapsed time */
		op->opt_rate = 1 ;
		break ;
E 58
	case OPT_MAGNIFY:			/* use a magnify function */
		if((value = strchr(next_word, '=')) != NULL ) {
			*value = '\0' ;
			value++ ;
		}

D 54
		if((mcc = search_options(next_word)) == -1 )
E 54
I 54
		mcc = search_options(next_word) ;

		if( mcc == -1 || array[mcc].opt_type == OPT_RFFU )
E 54
			info("Data option not supported.\n", module) ; 
		else {
			op->opt_magnify |= array[mcc].opt_bit ;

			data_option(op, mcc, value) ;
		}

		break ;
E 45
	default:
D 41
		panic("monitor: options: unexpected options.\n") ;
E 41
I 41
D 52
		panic("unexpected options.\n", module) ;
E 52
I 52
		panic("Unexpected option!\n", module) ;
E 52
E 41
		break ;
	}
E 39
E 27

D 39
		if( !op->sleep_set )
			op->opt_sleep = 600 ;
E 39
I 39
D 45
	return advance ;
E 45
I 45
	return skip ;
E 45
}
E 39

I 39
/*
D 58
 *	Display options.
 */
display_option(op, code)
OPTION	*op ;
int	code ;
{
	switch( code ) {
	case OPT_SAVE:
		op->display_mode = OPT_SAVE ;
D 57
		display_set = 1 ;
E 57
I 57
		set.display = 1 ;
E 57
E 39
		break ;
	case OPT_SCREEN:
		op->display_mode = OPT_SCREEN ;
D 39
		op->display_set = 1 ;
E 17
E 14
E 13
		op->opt_inter = 1 ;
D 16
		if( !sleep_changed )
E 16
I 16
D 17
		if( !op->opt_sleep_set )
E 17
I 17

		op->display = screen ;
		op->open_display = open_screen ;
I 28
		op->help_display = nop ;
E 28
		op->close_display = close_screen ;
I 27
		op->redraw_display = redraw_screen ;
E 27

		if( !op->sleep_set )
E 17
E 16
D 7
			op->opt_sleep = 1 ;
E 7
I 7
			op->opt_sleep = 2 ;

E 39
I 39
D 57
		display_set = 1 ;
E 57
I 57
		set.display = 1 ;
E 57
E 39
		break ;
I 39
	case OPT_READ:
		op->display_mode = OPT_READ ;
D 57
		display_set = 1 ;
E 57
I 57
		set.display = 1 ;
E 57
		break ;
E 39
I 38
	case OPT_NOP:
		op->display_mode = OPT_NOP ;
D 39
		op->display_set = 1 ;
		op->opt_inter = 0 ;

		op->display = display_nop ;
		op->open_display = open_nop ;
		op->help_display = help_nop ;
		op->close_display = close_nop ;
		op->redraw_display = redraw_nop ;

		if( !op->sleep_set )
			op->opt_sleep = 2 ;

E 39
I 39
D 57
		display_set = 1 ;
E 57
I 57
		set.display = 1 ;
E 57
E 39
		break ;
I 39
	default:
D 41
		panic("monitor: options: unexpected display option.\n") ;
E 41
I 41
D 52
		panic("unexpected display option.\n", module) ;
E 52
I 52
		panic("Unexpected display option!\n", module) ;
E 52
E 41
		break ;
	}
}

/*
 *	Collection options.
 */
collect_option(op, code)
OPTION	*op ;
int	code ;
{
	switch( code ) {
E 39
E 38
D 17
	case OPT_LINE:
	case OPT_WINDOW:
D 13
	case OPT_REPLAY:
E 13
		fprintf(stderr, "monitor: output option unimplimented: %s.\n",
			arg);
I 13
		break ;
E 17
	case OPT_REPLAY:
I 14
D 17
		op->opt_replay = 1 ;
I 16
		op->opt_begin_gather = begin_replay ;
		op->opt_end_gather = end_replay ;
		op->opt_gather = replay ;
E 17
I 17
		op->collect_mode = OPT_REPLAY ;
D 39
		op->collect_set = 1 ;
E 39
I 39
D 57
		collect_set = 1 ;
E 57
I 57
		set.collect = 1 ;
E 57
E 39
E 17
E 16

E 14
D 16
		fprintf(stderr, 
			"monitor: data collection not implimented: %s.\n", arg);
E 16
I 16
D 17
		op->opt_inter = 1 ;
		op->opt_open_display = open_screen ;
		op->opt_close_display = close_screen ;
		op->opt_display = screen ;
E 17
I 17
D 39
		op->collect = replay ;
D 20
		op->open_collect = begin_replay ;
		op->close_collect = end_replay ;
E 20
I 20
		op->open_collect = open_replay ;
		op->close_collect = close_replay ;
E 20
E 17

E 39
E 16
E 13
		break ;
I 17
	case OPT_LIVE:
		op->collect_mode = OPT_LIVE ;
D 39
		op->collect_set = 1 ;
E 39
I 39
D 57
		collect_set = 1 ;
E 57
I 57
		set.collect = 1 ;
E 57
E 39

D 18
		op->collect = gather ;
		op->open_collect = begin_gather ;
		op->close_collect = end_gather ;
E 18
I 18
D 39
		op->collect = live ;
		op->open_collect = open_live ;
		op->close_collect = close_live ;
E 39
I 39
		break ;
	case OPT_NAMES:
		op->collect_mode = OPT_NAMES ;
D 57
		collect_set = 1 ;
E 57
I 57
		set.collect = 1 ;
E 57
E 39
E 18

		break ;
	default:
I 22
D 39
		switch( mcc ) {
		case OPT_CPU:
D 26
			if( cpu_base )
				free(cpu_base);
				
			cpu_base = build_value(value, &cpu_nel) ;
E 26
I 26
			list = &cpu_list ;
E 26
			break ;
		case OPT_DISK:
D 26
			if( disk_base )
				free(disk_base);

			disk_base = build_value(value, &disk_nel) ;
E 26
I 26
			list = &disk_list ;
E 26
			break ;
		case OPT_TAPE:
D 26
			if( tape_base )
				free(tape_base);

			tape_base = build_value(value, &tape_nel) ;
E 26
I 26
			list = &tape_list ;
E 26
			break ;
		case OPT_NETIF:
D 26
			if( netif_base )
				free(netif_base);

			netif_base = build_value(value, &netif_nel) ;
E 26
I 26
			list = &netif_list ;
E 26
			break ;
		default:
			break ;
		}
I 26

		if( list )
D 29
			build_value(value, list) ;
E 29
I 29
			build_value(value, (struct list *)list) ;
E 29
E 26

E 22
		op->data_set = 1 ;
		op->opt_data |= array[mcc].opt_bit ;
E 39
I 39
D 41
		panic("monitor: options: unexpected collection option.\n") ;
E 41
I 41
D 52
		panic("unexpected collection option.\n", module) ;
E 52
I 52
		panic("Unexpected collection option!\n", module) ;
E 52
E 41
E 39
		break ;
I 39
	}
}

E 39
/*
D 39
 *	Start the "bad" options.
E 39
I 39
 *	Data options.
E 58
I 58
 *	Do any special processing needed for data options.
E 58
E 39
 */
E 17
D 14
	case OPT_TAPE:
E 14
D 23
	case OPT_USER:
E 23
D 39
	case OPT_SWAP:
D 17
		fprintf(stderr, "monitor: data option unimplimented: %s.\n",
			arg);
E 17
I 17
D 22
		printf("monitor: unsupported data option: %s.\n", arg);
E 22
I 22
D 29
		printf("monitor: unsupported data option: %s.\n", word);
E 29
I 29
D 34
		fprintf(stderr, "monitor: options: unsupported data option: %s.\n", word);
E 34
I 34
		info("monitor: options: unsupported data option: %s.\n", word);
E 39
I 39
data_option(op, mcc, value)
OPTION	*op ;
int	mcc ;
char	*value ;
{
	struct list *list = 0 ;

	switch( array[mcc].opt_code ) {
	case OPT_CPU:
		list = &cpu_list ;
E 39
E 34
E 29
E 22
E 17
I 12
		break ;
D 17
	case -1:
		fprintf(stderr, "monitor: Bad option: %s.\n", arg);
E 17
I 17
D 39
	case OPT_LINE:
	case OPT_WINDOW:
D 22
		printf("monitor: unsupported display option: %s.\n", arg);
E 22
I 22
D 29
		printf("monitor: unsupported display option: %s.\n", word);
E 29
I 29
D 34
		fprintf(stderr, "monitor: options: unsupported display option: %s.\n", word);
E 34
I 34
		info("monitor: options: unsupported display option: %s.\n", word);
E 39
I 39
	case OPT_DISK:
		list = &disk_list ;
E 39
E 34
E 29
E 22
E 17
E 12
D 48
		break ;
D 17
	default:
		fprintf(stderr, "turning on %s(%x).\n",
			array[mcc].opt_string, array[mcc].opt_bit);
		op->opt_data |= array[mcc].opt_bit ;
E 17
I 17
D 39
	case OPT_NET:
D 22
		printf("monitor: unsupported collection option: %s.\n", arg);
		break ;
	case -1:
		printf("monitor: Bad option: %s.\n", arg);
E 22
I 22
D 29
		printf("monitor: unsupported collection option: %s.\n", word);
E 29
I 29
D 34
		fprintf(stderr, "monitor: options: unsupported collection option: %s.\n", word);
E 34
I 34
		info("monitor: options: unsupported collection option: %s.\n", word);
E 39
I 39
	case OPT_TAPE:
		list = &tape_list ;
E 48
E 39
I 38
		break ;
D 39
	case OPT_DISP_1:
	case OPT_DISP_2:
	case OPT_DISP_3:
	case OPT_COLL_1:
	case OPT_COLL_2:
	case OPT_COLL_3:
		info("monitor: options: reserved for future use: %s.\n", word) ;
E 39
I 39
	case OPT_NETIF:
		list = &netif_list ;
E 39
E 38
E 34
E 29
E 22
E 17
		break ;
I 49
	case OPT_PID:
		op->opt_proc_id = atoi(value) ;
		break ;
E 49
I 39
	default:
		break ;
E 39
E 7
	}
I 39

	if( list )
		build_value(value, (struct list *)list) ;

D 57
	data_set = 1 ;
E 57
I 57
	set.data = 1 ;
E 57
I 45

E 45
	op->opt_data |= array[mcc].opt_bit ;
E 39
D 7
	else
D 3
		fprintf(stderr, "idle: unsupported option: %s.\n", arg);
E 3
I 3
		fprintf(stderr, "monitor: unsupported option: %s.\n", arg);
E 7
I 7
}

I 39
/*
D 40
 *
E 40
I 40
 *	Search "array" for an option that matches word.  Abbreviations
 *	of option string are recognized.  If there is more than one
 *	one match then "word" is considered ambiguous and a message
 *	is printed.  If "word" is longer than option string the match
 *	will fail.
I 45
 *
 *	This function returns the index of the entry or -1.
E 45
E 40
 */
E 39
D 31
search_options(s)
char	*s ;
E 31
I 31
search_options(word)
char	*word ;
E 31
{
D 31
	register i ;
E 31
I 31
	register i, length, found = -1, n_found = 0 ;
E 31

D 31
	for(i = 0; i < sizeof(array)/sizeof(array[0]); i++)
		if( strcmp(s, array[i].opt_string) == 0 )
			return i ;
E 31
I 31
	length = strlen(word) ;
E 31

D 31
	return -1 ;
E 31
I 31
	for(i = 0; i < sizeof(array)/sizeof(array[0]); i++) {
		if( length > array[i].opt_length )
			continue ;

		if( strncmp(word, array[i].opt_string, length) == 0 ) {
			n_found++ ;
			found = i ;
		}
	}

	if( n_found > 1 ) {
D 34
		fprintf(stderr, "monitor: options: %s is ambigious.\n", word);
E 34
I 34
D 40
		info("monitor: options: %s is ambigious.\n", word);
E 40
I 40
D 52
		info("%s is ambigious.\n", module, word);
E 52
I 52
D 66
		info("The argument \"%s\" is ambigious.\n", module, word);
E 66
I 66
D 68
		info("The argument \"%s\" is ambigious.  Matching options are:\n", module, word);
E 68
I 68
		info("The argument \"%s\" is ambiguous.  Matching options are:\n", module, word);
E 68
		for(i = 0; i < sizeof(array)/sizeof(array[0]); i++)
			if( strncmp(word, array[i].opt_string, length) == 0 )
				fprintf(stderr, "\t%s\n", array[i].opt_string) ;

E 66
E 52
E 40
E 34
		return -1 ;
	}
	else
		return found ;
I 33
}

/*
 *	Restore the display to their defaults.
 */
restore_display(op)
OPTION	*op ;
{
	op->redraw_display = def_redraw ;
	op->close_display = def_close ;
	op->open_display = def_open ;
	op->help_display = def_help ;
	op->display = def_display ;
I 39
}

#ifdef	DEBUG

char	*str_data(),
	*str_opt_flags() ;

I 40
/*
 *	Translate the integer value of a collection or display
 *	mode into the corresponding string.
 */
E 40
char	*search_name(mode)
int	mode ;
{
	register i ;

	for(i = 0; i < sizeof(array)/sizeof(array[0]) ; i++)
		if( mode == array[i].opt_code )
			return array[i].opt_string ;

	return "(null)" ;
}

/*
 *	Print the contents of the option structure for debugging.
 */
print_option(op)
OPTION	*op ;
{
D 43
	printf("data:    <%s>\n", str_data(op->opt_data)) ;
	printf("flags:   <%s>\n", str_opt_flags(op->opt_flag)) ;
	printf("display: %s\n", search_name(op->display_mode));
	printf("collect: %s\n", search_name(op->collect_mode));
	printf("sleep:   %d\n", op->opt_sleep) ;
	printf("file:    %s\n", op->opt_file) ;
	printf("prompt:  %s\n", op->opt_prompt) ;
	printf("output:  %s\n", op->opt_output) ;
E 43
I 43
	fprintf(stderr, "Contents of option structure:\n") ;
	fprintf(stderr, "\tdata:    <%s>\n", str_data(op->opt_data)) ;
	fprintf(stderr, "\tflags:   <%s>\n", str_opt_flags(op->opt_flag)) ;
	fprintf(stderr, "\tdisplay: %s\n", search_name(op->display_mode));
	fprintf(stderr, "\tcollect: %s\n", search_name(op->collect_mode));
I 49
	fprintf(stderr, "\tproc_id: %d\n", op->opt_proc_id) ;
E 49
	fprintf(stderr, "\tsleep:   %d\n", op->opt_sleep) ;
	fprintf(stderr, "\tfile:    %s\n", op->opt_file) ;
	fprintf(stderr, "\tprompt:  %s\n", op->opt_prompt) ;
	fprintf(stderr, "\toutput:  %s\n", op->opt_output) ;
I 45
	fprintf(stderr, "\tmagnify: <%s>\n", str_data(op->opt_magnify)) ;
E 45
E 43
}
#endif

I 40
extern	char	*program_name ;

E 40
/*
D 40
 *	Eventually this will do command name process.  If "monitor" is
 *	invoked as "names" the names option will be selected automatically.
E 40
I 40
 *	Eventually this will do command name processing.  For
 *	example if "monitor" is invoked as "names" the names 
 *	option will be selected automatically. 	Currently this
 *	function only sets the program name for the error messages.
 *
 *	ARGSUSED
E 40
 */
command_name(s, op)
char	*s ;
OPTION	*op ;
{
I 40
	program_name = s ;
E 40
E 39
E 33
E 31
E 7
E 3
E 2
}
E 1
