h14376
s 00010/00000/00248
d D 1.10 90/03/29 16:17:34 alan 10 9
c The hack to fix the DECmumble include file problem.
e
s 00002/00002/00246
d D 1.9 89/03/09 21:08:33 alan 9 8
c reorder local include files to satisify VAXC
e
s 00001/00001/00247
d D 1.8 89/02/25 09:57:26 alan 8 7
c editorial change to rec_ elements
e
s 00009/00000/00239
d D 1.7 89/02/15 19:29:42 alan 7 6
c properly set mon_flag in all records
e
s 00000/00001/00239
d D 1.6 89/01/29 10:03:52 alan 6 5
c dusted off lint
e
s 00020/00000/00220
d D 1.5 89/01/24 17:16:53 alan 5 4
c moved some f_ functions to other files
e
s 00067/00037/00153
d D 1.4 89/01/18 19:03:36 alan 4 3
c reworked display
e
s 00000/00000/00190
d D 1.3 89/01/17 19:09:35 alan 3 2
c first pass at a display function
e
s 00118/00005/00072
d D 1.2 89/01/16 22:13:42 alan 2 1
c first pass at a magnification function
e
s 00077/00000/00000
d D 1.1 89/01/16 11:56:19 alan 1 0
c date and time created 89/01/16 11:56:19 by alan
e
u
U
t
T
I 1
/*
 *	Author:  Alan Rollow, EIS/CXO, Digital Equipment Corp.
 *	File:	 %M%
 *	Date:	 %G%
 *	Version: %I%
 *
 *	%M% - Deal with the namei cache stats.
 */
#ifndef	lint
static	char	SccsId[] = "%W% (monitor) %G%" ;
#endif

I 4
/*
 * Modification history.
 *
 * Jan. 18, 1989 -- arr
 *
 *	Redesigned magnification screen.
I 5
 *
 * Jan. 24, 1989 -- arr
 *
 *	Moved f_namei() from functions.c.
I 7
 *
 * Feb. 15, 1989 -- arr
 *
 *	Fix f_namei() to use mon_flag.
I 10
 *
 * Mar. 26, 1990 -- arr
 *
 *	Added hack to work-around DECmumble include file problem.
 *
E 10
E 7
E 5
 */

E 4
#include <nlist.h>
#include <stdio.h>
#include <signal.h>

#include <sys/types.h>
#include <sys/dk.h>
#include <sys/buf.h>
#include <sys/file.h>
#include <sys/socket.h>
#include <sys/vmsystm.h>
#include <sys/vmmeter.h>

#include <sys/dir.h>
I 10

#if defined(V4_ULTRIX) && defined(mips)
#	include <mips/cpu.h>
#endif

E 10
#include <sys/param.h>
#include <sys/user.h>

#include <net/if.h>
#include <netinet/in.h>

I 9
#include "monitor.h"
E 9
#include "options.h"
D 9
#include "extern.h"
E 9
#include "include.h"
D 9
#include "monitor.h"
E 9
I 9
#include "extern.h"
E 9

/*
D 2
 *	Data declared elsewhere.
E 2
I 2
 *	Data declared elsewhere.  These aren't in extern.h because
 *	they don't need to be known by the whole world.
E 2
 */
I 2
extern	WINDOW	*wp ;
E 2
extern	int	lines ;

/*
 *	Local data.
 */
D 2
static	int	namei_ticks = 0 ;
E 2
D 6
static	char	*module = "buf" ;
E 6
I 2
static	int	namei_ticks = 0,
		prev_goodhits = 0,
		prev_badhits = 0,
		prev_falsehits = 0,
		prev_miss = 0,
		prev_long = 0,
		prev_pass2 = 0,
		prev_2passes = 0 ;
I 5


/*
 *	Function to dump a record for easy reading.
 */
f_namei(p)
struct mon_namei *p ;
{
I 7
	if((p->mon_flag & MON$M_VALID) == 0 )
                return ;

D 8
        printf("%s.\n", records[MON$C_NAMEI].rec_string) ;
E 8
I 8
        printf("%s.\n", records[MON$C_NAMEI].string) ;
E 8

E 7
	printf("\tgoodhits:  %d\n", p->mon_goodhits) ;
	printf("\tbadhits:   %d\n", p->mon_badhits) ;
	printf("\tfalsehits: %d\n", p->mon_falsehits) ;
	printf("\tmiss:      %d\n", p->mon_miss) ;
	printf("\tlong:      %d\n", p->mon_long) ;
	printf("\tpass2:     %d\n", p->mon_pass2) ;
	printf("\t2passes:   %d\n", p->mon_2passes) ;
}
E 5
E 2

/*
 *	Number of lines used by the namei cache screen.
 */
D 2
#define	NAMEI_LINES	(3)
E 2
I 2
D 4
#define	NAMEI_LINES	(11)
E 4
I 4
#define	NAMEI_LINES	(17)
E 4
E 2

I 2
D 4
#define	NAMEI_X		(17)
E 4
I 4
#define	NAMEI_X		(16)
E 4
#define	NAMEI_Y		(3)

E 2
/*
 *      Setup the static screen for displaying namei cache 
 *      information.
 *
 *      ARGSUSED
 */
open_namei(op)
OPTION	*op ;
{
	sample_header() ;

	lines = NAMEI_LINES ;
I 2

D 4
	wprintw(wp, "Good Hits:      %10u\n", 0) ;
	wprintw(wp, "Bad Hits:       %10u\n", 0) ;
	wprintw(wp, "False Hits:     %10u\n", 0) ;
	wprintw(wp, "Misses:         %10u\n", 0) ;
	wprintw(wp, "Long names:     %10u\n", 0) ;
	wprintw(wp, "Two pass names: %10u\n", 0) ;
	wprintw(wp, "Times:          %10u\n\n", 0) ;
E 4
I 4
	wprintw(wp, "Good Hits:      %6.2f %% : %10u\n", 0.0, 0) ;
	wprintw(wp, "Bad Hits:       %6.2f %% : %10u\n", 0.0, 0) ;
	wprintw(wp, "False Hits:     %6.2f %% : %10u\n", 0.0, 0) ;
	wprintw(wp, "Misses:         %6.2f %% : %10u\n", 0.0, 0) ;
	wprintw(wp, "Long names:     %6.2f %% : %10u\n", 0.0, 0) ;
	wprintw(wp, "Two pass names: %6.2f %% : %10u of %10u\n\n", 0.0, 0, 0) ;
E 4

D 4
	wprintw(wp, "Good Hits:      %10u\n", 0) ;
	wprintw(wp, "Bad Hits:       %10u\n", 0) ;
	wprintw(wp, "False Hits:     %10u\n", 0) ;
	wprintw(wp, "Misses:         %10u\n", 0) ;
	wprintw(wp, "Long names:     %10u\n", 0) ;
	wprintw(wp, "Two pass names: %10u\n", 0) ;
	wprintw(wp, "Times:          %10u", 0) ;
E 4
I 4
	wprintw(wp, "Good Hits:      %6.2f %% : %10.2f / sec.\n", 0.0, 0.0) ;
	wprintw(wp, "Bad Hits:       %6.2f %% : %10.2f / sec.\n", 0.0, 0.0) ;
	wprintw(wp, "False Hits:     %6.2f %% : %10.2f / sec.\n", 0.0, 0.0) ;
	wprintw(wp, "Misses:         %6.2f %% : %10.2f / sec.\n", 0.0, 0.0) ;
	wprintw(wp, "Long names:     %6.2f %% : %10.2f / sec.\n", 0.0, 0.0) ;
	wprintw(wp, "Two pass names: %6.2f %% : %10u of %10u", 0.0, 0, 0) ;
E 4
E 2
}

/*
 *      Display the dynamic data of the namei cache information.
 *
 *      ARGSUSED
 */
magnify_namei(op)
OPTION	*op ;
{
D 2
	sample_body((double)(sample.mon_ticks - namei_ticks)/first.mon_hz) ;
        namei_ticks = sample.mon_ticks ;
E 2
I 2
D 4
	double	etime, delta_namei() ;
E 4
I 4
	double	 etime, delta_namei() ;
	register total ;
E 4

I 4
	total = namei.mon_goodhits + namei.mon_badhits + namei.mon_falsehits +
		namei.mon_miss + namei.mon_long ;

	if( total == 0 )
		total = 1 ;

E 4
	wmove(wp, NAMEI_Y, NAMEI_X) ;
D 4
	wprintw(wp, "%10u", namei.mon_goodhits) ;
E 4
I 4
	wprintw(wp, "%6.2f %% : %10u", (100.0 * namei.mon_goodhits)/total,
		namei.mon_goodhits) ;
E 4

	wmove(wp, NAMEI_Y + 1, NAMEI_X) ;
D 4
	wprintw(wp, "%10u", namei.mon_badhits) ;
E 4
I 4
	wprintw(wp, "%6.2f %% : %10u", (100.0 * namei.mon_badhits)/total,
		namei.mon_badhits) ;
E 4

	wmove(wp, NAMEI_Y + 2, NAMEI_X) ;
D 4
	wprintw(wp, "%10u", namei.mon_falsehits) ;
E 4
I 4
	wprintw(wp, "%6.2f %% : %10u", (100.0 * namei.mon_falsehits)/total,
		namei.mon_falsehits) ;
E 4

	wmove(wp, NAMEI_Y + 3, NAMEI_X) ;
D 4
	wprintw(wp, "%10u", namei.mon_miss) ;
E 4
I 4
	wprintw(wp, "%6.2f %% : %10u", (100.0 * namei.mon_miss)/total,
		namei.mon_miss) ;
E 4

	wmove(wp, NAMEI_Y + 4, NAMEI_X) ;
D 4
	wprintw(wp, "%10u", namei.mon_long) ;
E 4
I 4
	wprintw(wp, "%6.2f %% : %10u", (100.0 * namei.mon_long)/total,
		namei.mon_long) ;
E 4

	wmove(wp, NAMEI_Y + 5, NAMEI_X) ;
D 4
	wprintw(wp, "%10u", namei.mon_pass2) ;
E 4
I 4
	wprintw(wp, "%6.2f %% : %10u of %10u", namei.mon_2passes == 0 ? 0.0 :
		(100.0 * namei.mon_pass2)/namei.mon_2passes,
		namei.mon_pass2, namei.mon_2passes) ;
E 4

D 4
	wmove(wp, NAMEI_Y + 6, NAMEI_X) ;
	wprintw(wp, "%10u", namei.mon_2passes) ;

E 4
	etime = delta_namei(sample.mon_ticks) ;

I 4
	if( etime == 0 )
		etime = 1.0 ;

	total = namei.mon_goodhits + namei.mon_badhits + namei.mon_falsehits +
		namei.mon_miss + namei.mon_long ;

	if( total == 0 )
		total = 1 ;

	wmove(wp, NAMEI_Y + 7, NAMEI_X) ;
	wprintw(wp, "%6.2f %% : %10.2f", (100.0 * namei.mon_goodhits)/total,
		namei.mon_goodhits/etime) ;

E 4
	wmove(wp, NAMEI_Y + 8, NAMEI_X) ;
D 4
	wprintw(wp, "%10u", namei.mon_goodhits) ;
E 4
I 4
	wprintw(wp, "%6.2f %% : %10.2f", (100.0 * namei.mon_badhits)/total,
		namei.mon_badhits/etime) ;
E 4

	wmove(wp, NAMEI_Y + 9, NAMEI_X) ;
D 4
	wprintw(wp, "%10u", namei.mon_badhits) ;
E 4
I 4
	wprintw(wp, "%6.2f %% : %10.2f", (100.0 * namei.mon_falsehits)/total,
		namei.mon_falsehits/etime) ;
E 4

	wmove(wp, NAMEI_Y + 10, NAMEI_X) ;
D 4
	wprintw(wp, "%10u", namei.mon_falsehits) ;
E 4
I 4
	wprintw(wp, "%6.2f %% : %10.2f", (100.0 * namei.mon_miss)/total,
		namei.mon_miss/etime) ;
E 4

	wmove(wp, NAMEI_Y + 11, NAMEI_X) ;
D 4
	wprintw(wp, "%10u", namei.mon_miss) ;
E 4
I 4
	wprintw(wp, "%6.2f %% : %10.2f", (100.0 * namei.mon_long)/total,
		namei.mon_long/etime) ;
E 4

	wmove(wp, NAMEI_Y + 12, NAMEI_X) ;
D 4
	wprintw(wp, "%10u", namei.mon_long) ;

	wmove(wp, NAMEI_Y + 13, NAMEI_X) ;
	wprintw(wp, "%10u", namei.mon_pass2) ;

	wmove(wp, NAMEI_Y + 14, NAMEI_X) ;
	wprintw(wp, "%10u", namei.mon_2passes) ;
E 4
I 4
	wprintw(wp, "%6.2f %% : %10u of %10u", namei.mon_2passes == 0 ? 0.0 :
		(100.0 * namei.mon_pass2)/namei.mon_2passes,
		namei.mon_pass2, namei.mon_2passes) ;
E 4

	sample_body(etime) ;
}

double	delta_namei(ticks)
int	ticks ;
{
	register tmp ;
	double   etime ;

	etime = (double)(ticks - namei_ticks) / first.mon_hz ;
	namei_ticks = ticks ;

	tmp = namei.mon_goodhits ;
	      namei.mon_goodhits -= prev_goodhits ;
	      prev_goodhits = tmp ;

	tmp = namei.mon_badhits ;
	      namei.mon_badhits -= prev_badhits ;
	      prev_badhits = tmp ;

	tmp = namei.mon_falsehits ;
	      namei.mon_falsehits -= prev_falsehits ;
	      prev_falsehits = tmp ;

	tmp = namei.mon_miss ;
	      namei.mon_miss -= prev_miss ;
	      prev_miss = tmp ;

	tmp = namei.mon_long ;
	      namei.mon_long -= prev_long ;
	      prev_long = tmp ;

	tmp = namei.mon_pass2 ;
	      namei.mon_pass2 -= prev_pass2 ;
	      prev_pass2 = tmp ;

	tmp = namei.mon_2passes ;
	      namei.mon_2passes -= prev_2passes ;
	      prev_2passes = tmp ;

	return etime ;
E 2
}
E 1
