h53495
s 00012/00000/00221
d D 1.46 90/05/23 21:27:46 alan 46 45
c added pause
e
s 00001/00001/00220
d D 1.45 89/12/28 11:25:52 alan 45 44
c added support fractional seconds
e
s 00001/00001/00220
d D 1.44 89/12/27 21:42:10 alan 44 43
c 
e
s 00009/00003/00212
d D 1.43 89/12/27 21:40:25 alan 43 42
c turn sleep into select()
e
s 00008/00002/00207
d D 1.42 89/12/25 16:55:27 alan 42 41
c 1.  Return predictable value.
c 2.  Remove unneeded #includes.
c 
e
s 00001/00001/00208
d D 1.41 89/02/13 14:29:19 alan 41 40
c Dust off assorted lint and added KMEM option
c 
e
s 00006/00002/00203
d D 1.40 89/01/04 11:00:59 alan 40 39
c Dust off lint acquired in V3.0
e
s 00009/00001/00196
d D 1.39 88/06/27 18:15:08 alan 39 38
c changed include of monitor.h and record.h
e
s 00002/00002/00195
d D 1.38 87/08/12 15:26:35 alan 38 37
c error message clean up - V0.95
e
s 00000/00000/00197
d D 1.37 87/05/20 17:15:49 alan 37 36
c changed all curses calls to use w... versions
e
s 00002/00001/00195
d D 1.36 87/04/03 15:51:09 alan 36 35
c Fix more includes to get rid of VAXC warning.  These were replaceing
c 
c 	#include <sys/vm.h>
c 
c with
c 
c 	#include <sys/vmsystm.h>
c 	#include <sys/vmmeter.h>
c 
c 
e
s 00006/00002/00190
d D 1.35 87/04/03 14:30:55 alan 35 34
c 1.  Mostly rearranged include files so that the sources would compile
c     using VAXC.
c 2.  Changed an error monitor that pcc let get by.
c 
e
s 00024/00008/00168
d D 1.34 86/12/30 11:20:44 alan 34 33
c See commentary on V0.64 in version.c
e
s 00004/00000/00172
d D 1.33 86/12/17 14:25:58 alan 33 32
c see V0.62 in version.c
e
s 00007/00002/00165
d D 1.32 86/12/07 22:22:02 alan 32 31
c See V0.57 in version.c
e
s 00003/00001/00164
d D 1.31 86/11/18 12:40:26 alan 31 30
c fixed bug that caused dump_screen() to be called with a NULL FILE pointer.
c 
e
s 00014/00002/00151
d D 1.30 86/11/17 18:42:02 alan 30 29
c See commentary on V0.54 in version.c
c 
e
s 00000/00000/00153
d D 1.29 86/11/16 17:07:01 alan 29 28
c Changes can be referenced to V0.52 instead of V0.51 in version.c
c 
e
s 00039/00022/00114
d D 1.28 86/11/16 16:31:41 alan 28 27
c See comments for V0.51 in version.c
c 
e
s 00002/00005/00134
d D 1.27 86/09/29 16:37:01 alan 27 26
c added code and mods for makeing the sleep time dependent on the output
c tty speed.
c 
e
s 00010/00023/00129
d D 1.26 86/08/26 17:01:16 alan 26 25
c added code for changeing window size and modified SccsId
c 
e
s 00001/00007/00151
d D 1.25 86/07/13 14:39:49 alan 25 24
c dust off even more lint
e
s 00005/00002/00153
d D 1.24 86/07/11 19:27:08 alan 24 23
c Dust off LOTS of lint...
c 
e
s 00004/00006/00151
d D 1.23 86/06/30 10:12:58 alan 23 22
c added delay to warning message
e
s 00001/00001/00156
d D 1.22 86/06/30 08:22:33 alan 22 21
c Added code for a generalized redraw_display function.
c 
e
s 00009/00003/00148
d D 1.21 86/06/27 17:02:14 alan 21 20
c added entries into magnify and unmagnify commands
e
s 00006/00003/00145
d D 1.20 86/05/30 16:28:10 alan 20 19
c Added checks and return to do the "right" thing with MON_NORMAL, MON_EXIT
c and MON_CONTINUE.
c 
e
s 00011/00016/00137
d D 1.19 86/05/24 19:53:26 alan 19 18
c Change almost anything that was "gather" to "live" or "collect" depending
c on the context.  Functions changed to "live" and words changed to
c collect.  Begin and end changed to open and close respectively.
c 
e
s 00002/00001/00151
d D 1.18 86/05/23 19:53:56 alan 18 17
c check return code from gather function
e
s 00003/00003/00149
d D 1.17 86/05/23 12:13:52 alan 17 16
c bug fixes
e
s 00002/00002/00150
d D 1.16 86/05/22 18:50:31 alan 16 15
c Moved call to display before going to sleep.
c 
e
s 00046/00051/00106
d D 1.15 86/05/21 16:23:34 alan 15 14
c Move nlist() and /dev/kmem open and close into gather.  Then I got rid
c of the call to monitor(), by moving all the other code up into the mail.
c I moved the command execution switch into its own function.
c 
e
s 00005/00005/00152
d D 1.14 86/05/21 10:31:27 alan 14 13
c 1.  initial changes caused by changes to option structure.
c 2.  Need to move "gather()" specific code to "gather" functions.
c 
e
s 00002/00002/00155
d D 1.13 86/05/19 12:17:22 alan 13 12
c 1.  An even better fix to the profiling name problem.  I make monitor()
c     a static function.
c 
e
s 00005/00002/00152
d D 1.12 86/05/18 16:59:48 alan 12 11
c renamed monitor() to monit() because the profiling function is also
c called monitor().  When compiled with profiling turned on I got a
c "multiply defined" error.
c 
e
s 00012/00002/00142
d D 1.11 86/05/18 14:15:38 alan 11 10
c 1.  Added call to dumpit() in monitor.c
c 2.  Added disk, netif and pageing data to screen function.
c 
e
s 00000/00013/00144
d D 1.10 86/05/12 20:39:46 alan 10 9
c moved help() code to its own file.
c 
e
s 00021/00014/00136
d D 1.9 86/05/12 16:15:15 alan 9 8
c 1.  Rearranged calling order of ..._gather(), (*opt_begin)() and (*opt_finish)()
c 2.  Added help function.
c 3.  Updated comment at beginning.
c 
e
s 00005/00005/00145
d D 1.8 86/05/12 12:33:52 alan 8 7
c 1.  Run the _gather functions before running the opt_begin and opt_finish functions.
c 
e
s 00003/00003/00147
d D 1.7 86/05/07 09:59:36 alan 7 6
c added a word to make context of comment clear
e
s 00004/00000/00146
d D 1.6 86/05/04 14:43:38 alan 6 5
c added {uninit,init}_gather()
e
s 00011/00003/00135
d D 1.5 86/04/24 17:36:58 alan 5 4
c added signals
e
s 00004/00004/00134
d D 1.4 86/04/23 17:23:17 alan 4 3
c Changed all occurances of "idle" to "monitor"
c 
e
s 00023/00015/00115
d D 1.3 86/04/23 16:06:36 alan 3 2
c cleaned up monitor code, opt_funct became opt_process
c 
e
s 00063/00000/00067
d D 1.2 86/04/22 17:07:30 alan 2 1
c First working version
e
s 00067/00000/00000
d D 1.1 86/04/22 10:15:53 alan 1 0
c date and time created 86/04/22 10:15:53 by alan
e
u
U
t
T
I 1
/*
 *	Author:  Alan Rollow, CSC/CS, Digital Equipment Corp.
 *	File:	 %M%
 *	Date:	 %G%
 *	Version: %I%
 *
 *	%M% - This file contains the main program and other functions
D 21
 *	needed to drive the "gather", "save" and "screen" functions.
E 21
I 21
 *	needed to drive the "collect" and "display" functions.
E 21
 *
D 9
 *	The current implimentation of the program will collect CPU state
 *	info and free memory stats and save them in a file.
 *
E 9
 *	This program is based on the various programs that collect and
 *	display system data.  Among them are:
 *
 *		MONITOR - VMS Utility.
 *		mon     - 4.2BSD UNIX* utility to visually monitor
D 32
 *				system activity, by Phillip Dykstra.
E 32
I 32
 *			  system activity, by Phillip Dykstra.
E 32
 *		vmstat  - 4.2BSD UNIX* utility to monitor virtual memory
D 32
 *				stats.
E 32
I 32
 *			  stats.
E 32
 *		iostat  - 4.2BSD UNIX* utility to monitor I/O stats.
 *		netstat - 4.2BSD UNIX* utility to monitor network stats.
 *
 *	*UNIX is a trademark of AT&T Labs.
D 26
 *
 *	Future plans:
 *
D 9
 *	This program is the groundwork for a more extensive system monitoring
 *	facility.  The program is divided into a number of major functional
 *	sections:
E 9
I 9
 *	The program is divided into a number of major functional sections:
E 9
 *
D 3
 *		gather - Collect system information.  Eventually it will
 *			 be possible to specify options to the program that
 *			 will cause it to gather selected info from what is
 *			 available.
E 3
I 3
D 9
 *		gather - Collect system information.  In the interest of ease
 *			 of programming gather() will gather all available data
 *			 It will be the responsability of the processing funct-
 *			 ion to decide what to use.
E 9
I 9
D 19
 *		gather - Collect system information.  Based on the options
 *			 provided on the command line, gather will only
 *			 read the desired data from the kernel.
E 19
I 19
D 21
 *		collect - 
 *		display - 
E 21
I 21
 *		collect - gather the data from a running system or save file.
 *		display - format the for the screen or write it to a file.
E 21
 *		admin   - 
 *		device  - 
 *		utility - 
E 19
E 9
E 3
 *
D 19
 *		screen - Provides a mon like display using curses (or whatever
 *			 else might be approiate).
 *
D 7
 *		save   - Save the collected to a file for later use.  Like the
 *			 VMS monitor program it might be possible to replay the
 *			 contents of this(these) file(s).
E 7
I 7
 *		save   - Save the collected data to a file for later use.  
 *			 Like the VMS monitor program it might be possible 
 *			 to replay the contents of this(these) file(s).
E 7
 *
E 19
D 9
 *		admin  - The main program and other functions needed to get
 *			 the program started and cleaned up when done.
E 9
I 9
 *	Please refer to the file monitor.hlp for a more detail description
 *	of the program.
E 9
 *
 *	Advanced Development:
 *
 *	It might be possible to turn this program into a network server for
 *	an "rmon" type program.  The server will collect data about its local
 *	CPU(s) and provide it to client program which will display or save
 *	data.
E 26
 */
#ifndef	lint
D 26
static	char	SccsId[] = "%W% %G%" ;
E 26
I 26
D 28
static	char	SccsId[] = "%W%	(monitor)	%G%" ;
E 28
I 28
static	char	SccsId[] = "%W% (monitor) %G%" ;
E 28
E 26
#endif

I 39
/*
 * Modification History
 * 
 * 27-June-1988 -- arr
 *
 *	Change include of monitor.h to include.h.
I 40
 *
 * 28-December-1988 -- arr
 *
 *	Dust off V3.0 lint.
I 42
 *
 * Dec. 25, 1989 -- arr
 *
 *	Return a predicatable value and clean up unneeded #includes.
 *
D 43
 *	TODO: Replace sleep with select().
E 43
I 43
 * Dec. 27, 1989 -- arr
 *
 *	Turn the sleep into a select().
I 46
 *
 * May 23, 1990 -- arr
 *
 *	Added 'p'ause.
E 46
E 43
E 42
E 40
 */

E 39
I 2
#include <nlist.h>
#include <stdio.h>
I 5
#include <signal.h>
I 43
#include <errno.h>
E 43
E 5

E 2
#include <sys/types.h>
I 2
D 36
#include <sys/vm.h>
E 36
#include <sys/dk.h>
#include <sys/file.h>
#include <sys/time.h>
#include <sys/resource.h>
I 36
D 42
#include <sys/vmsystm.h>
#include <sys/vmmeter.h>
E 42
E 36
E 2

D 4
#include "idle.h"
E 4
I 4
D 39
#include "monitor.h"
E 39
I 39
#include "include.h"
E 39
E 4
D 35
#include "extern.h"
E 35
I 2
#include "options.h"
I 32

/*
I 35
 *	Data objects define elsewhere.
 */
extern	int	killed ;

/*
E 35
 *	Functions that don't return (int).
 */
D 40
void	sleep() ;
E 40
I 40
D 44
unsigned sleep() ;
E 44
I 44
void	exit() ;
E 44
E 40
E 32
E 2

I 30
/*
 *	Module name for error functions.
 */
static	char	*module = "monitor" ;

E 30
I 26
OPTION	option ;	/* option structure; available to catch_sigwinch() */

E 26
main(argc, argv)
int	argc ;
char	**argv ;
{
I 20
D 28
	int	rc ;			/* return code of collect */
E 20
I 17
	int	found ;			/* number of fd's with input */
E 28
I 28
	int	rc ;				/* return code of collect */
	int	found ;				/* number of fd's with input */
	int	read_fds ;			/* mask of input fd's */
	int	command = '\0' ;		/* interactive command */
E 28
E 17
I 2
D 15
	OPTION	option ;
E 15
I 15
D 26
	int	catch() ;		/* function to catch signals */
E 26
I 26
D 40
	int	catch(), catch_sigwinch() ;	/* functions to catch signals */
E 40
I 40
	void	catch(), catch_sigwinch() ;	/* functions to catch signals */
E 40
E 26
I 17
D 28
	int	read_fds ;		/* mask of input fd's */
E 17
	int	command = '\0' ;	/* interactive command */
D 26
	OPTION	option, *op ;		/* option structure and address */
E 26
I 26
	OPTION	*op ;			/* option structure and address */
E 26
	struct	timeval intv ;		/* interval timer */
E 28
I 28
	struct	timeval intv ;			/* interval timer */
E 28
E 15

	parse(argc, argv, &option);		/* parse arguments */

D 15
	nlist("/vmunix", namelist);		/* no error returned */
E 15
I 15
D 28
	op = &option ;
E 28
I 28
	if( option.open_collect )
		(*option.open_collect)(&option) ;
E 28
E 15

D 15
	if((kmem = open("/dev/kmem", O_RDONLY, 0)) == -1 )
D 4
		fatal("idle: can't open /dev/kmem: %s.\n");
E 4
I 4
		fatal("monitor: can't open /dev/kmem: %s.\n");
E 4

D 8
	(*option.opt_begin)(&option) ;

E 8
D 12
	monitor(&option) ;
E 12
I 12
D 13
	monit(&option) ;
E 13
I 13
	monitor(&option) ;
E 13
E 12

D 8
	(*option.opt_finish)(&option) ;

E 8
	if( close(kmem) == -1 )
D 4
		fatal("idle: can't close /dev/kmem: %s.\n");
E 4
I 4
		fatal("monitor: can't close /dev/kmem: %s.\n");
E 4
}

D 12
monitor(op)
E 12
I 12
/*
 *	Do the actual work.
 */
D 13
monit(op)
E 13
I 13
static	monitor(op)
E 13
E 12
OPTION	*op ;
{
	struct timeval intv ;
D 5
	int	read_fds = 0, found = 0;
D 3
	int	pass = 0, c ;
E 3
I 3
	int	command ;
E 5
I 5
D 9
	int	read_fds = 0, found = 0, command ;
E 9
I 9
	int	read_fds = 0, found = 0, command = '\0' ;
E 9
	int	catch();
I 11
	FILE	*fp, *fopen() ;
E 11
E 5
E 3

E 15
I 8
D 9
	init_gather() ;
E 9
I 9
D 14
	init_gather(op) ;
E 14
I 14
D 19
	(*op->opt_begin_gather)(op) ;
E 19
I 19
D 28
	(*op->open_collect)(op) ;
E 19
E 14
E 9

E 28
E 8
I 3
	/*
D 15
	 *	Ought to do some signal processing here.
E 15
I 15
	 *	Die gracefully on interrupt, hangup, quit and terminate.
E 15
	 */
I 5
	(void)signal(SIGINT, catch);
	(void)signal(SIGHUP, catch);
	(void)signal(SIGQUIT, catch);
	(void)signal(SIGTERM, catch);
I 34
	/*
	 *	Ignore (by default) SIGALRM's.  This should fix
	 *	the alarm clock problem.
	 */
	(void)signal(SIGALRM, SIG_IGN) ;
E 34
I 26

	/*
	 *	Perform magick on a SIGWINCH.
	 */
	(void)signal(SIGWINCH, catch_sigwinch);
E 26
E 5

I 27
D 28
	(*op->open_display)(op);
E 28
I 28
	if( option.open_display )
		(*option.open_display)(&option);
E 28

E 27
E 3
D 28
	intv.tv_sec = op->opt_sleep ;
E 28
I 28
	intv.tv_sec = option.opt_sleep ;
E 28
D 45
	intv.tv_usec = 0 ;
E 45
I 45
	intv.tv_usec = option.opt_fract * 1000000 ;
E 45

I 30
	/*
	 *    Until we are "killed" or see an exit command:
	 *
	 *	  Execute the collection function execute the
	 *	  the display function if everything is NORMAL
	 *	  and wait for the next sample.
	 */
E 30
I 6
D 8
	init_gather(op);
E 8
I 8
D 14
	(*op->opt_begin)(op);
E 14
I 14
D 19
	(*op->opt_open_display)(op);
E 19
I 19
D 27
	(*op->open_display)(op);
E 19
E 14
E 8

E 27
E 6
D 3
	for( ; ; ) {
		gather(pass++);
E 3
I 3
D 5
	while( command != 'q' && command != 'e' ) {
E 5
I 5
	while( command != 'q' && command != 'e' && !killed ) {
E 5
D 15
		gather(op);
E 15
I 15
D 17
		int	read_fds, found ;
E 15
E 3

E 17
I 15
D 18
		(op->opt_gather)(op);
E 18
I 18
D 19
		if( (op->opt_gather)(op) == -1 )
E 19
I 19
D 20
		if( (op->collect)(op) == -1 )
E 20
I 20
D 28
		if((rc = (op->collect)(op)) == MON_EXIT )
E 28
I 28
		if( option.collect )
			rc = (*option.collect)(&option) ;

		if( rc == MON_EXIT )
E 28
E 20
E 19
			break ;
E 18
D 20

I 16
D 19
		(op->opt_display)(op);
E 19
I 19
		(op->display)(op);
E 20
I 20
		else if( rc == MON_CONTINUE )
			continue ;
D 28
		else
			(op->display)(op);
E 28
I 28
		else {
			if( option.display )
				(*option.display)(&option);
		}
E 28
E 20
E 19

E 16
E 15
D 28
		if( op->opt_inter ) {
I 17
			screen_prompt(op);
E 28
I 28
		if( option.opt_inter ) {
			screen_prompt(&option);
E 28
E 17
			read_fds = 1 << fileno(stdin) ;
			found = select(1, &read_fds, (int *)0, (int *)0, &intv);
I 3
D 17
			screen_prompt(op);
E 17
I 15

			if( found && read_fds )
D 28
				command = exec_command(op) ;
E 28
I 28
				command = exec_command(&option) ;
E 28
E 15
E 3
		}
I 28
D 43
		else if( option.opt_sleep )
D 41
			sleep((unsigned)option.opt_sleep);
E 41
I 41
			(void)sleep((unsigned)option.opt_sleep);
E 43
I 43
		else if( option.opt_sleep ) {
			if( select(0, (int *)0, (int *)0, (int *)0, &intv) == -1 )
				if( errno != EINTR )
					fatal("Sleep failed: %s.\n", module) ;
		}
E 43
E 41
E 28
		else
D 24
			sleep(op->opt_sleep);
E 24
I 24
D 27
/*
 *	Need a fix here?
 */
E 27
D 28
			sleep((unsigned)op->opt_sleep);
E 28
I 28
			;			/* don't delay */
E 28
E 24
D 16

D 15
		if( found && read_fds ) {
			if( !op->opt_inter )
D 4
				panic("idle: this should never happen.\n");
E 4
I 4
				panic("monitor: this should never happen.\n");
E 15
I 15
		(*op->opt_display)(op) ;
E 16
	}
E 15
E 4

D 3
			c = getchar() ;
			/*
			 * input available...
			 */
E 3
I 3
D 15
			switch( command = getchar()) {
I 11
			case 'r':			/* redraw */
E 11
			case 12:			/* ^L */
				screen_redraw(op);
				break ;
D 11
			case 'q':
			case 'e':
E 11
I 11
			case 'q':			/* quit */
			case 'e':			/* exit */
				break ;
			case 'd':			/* screen dump */
				if((fp = fopen("screen.dump", "a")) == NULL )
					warning("monitor: can't dump screen: %s.\n");
E 15
I 15
D 19
	(*op->opt_close_display)(op);
E 19
I 19
D 28
	(*op->close_display)(op);
E 28
I 28
	if( option.close_display )
		(*option.close_display)(&option);
E 28
E 19
E 15

D 15
				dumpit(fp);
E 15
I 15
D 19
	(*op->opt_end_gather)(op);
E 19
I 19
D 28
	(*op->close_collect)(op);
E 28
I 28
	if( option.close_collect )
		(*option.close_collect)(&option);
I 42

	return 0 ;
E 42
E 28
E 19
}
E 15

D 15
				fclose(fp);
E 11
				break ;
			default:
				break ;
			}
E 15
I 15
/*
 *	Input has become available on our standard input.  Read it and
 *	execute the approproiate command.
 */
exec_command(op)
OPTION	*op ;
{
	register command ;
I 28
	FILE	 *fp, *fopen() ;
E 28
D 25
	FILE	 *fp, *fopen() ;
E 25

	switch( command = getchar()) {
I 21
D 34
	case 'u':
E 34
I 34
	case 'h':				/* Help */
	case '?':
		if( op->help_display )
			(*op->help_display)(op) ;
I 46

		if( op->redraw_display )
			(*op->redraw_display)(op) ;

		break ;
	case 'p':				/* pause */
		if( op->opt_curses )
			curses_pause() ;
E 46

		if( op->redraw_display )
			(*op->redraw_display)(op) ;

		break ;
	case 'u':				/* Unmagnify */
E 34
		unmagnify(op);
		break ;
D 34
	case 'm':
E 34
I 34
	case 'm':				/* Magnify */
E 34
		magnify(op) ;
I 33

		if( op->redraw_display )
D 35
			(op->redraw_display)(op) ;
E 35
I 35
			(*op->redraw_display)(op) ;
E 35

E 33
		break ;
E 21
D 34
	case 'r':			/* redraw */
	case 12:			/* ^L */
D 22
		screen_redraw(op);
E 22
I 22
		(*op->redraw_display)(op);
E 34
I 34
	case 'r':				/* redraw */
	case 12:				/* ^L */
		if( op->redraw_display )
			(*op->redraw_display)(op);

E 34
E 22
		break ;
D 34
	case 'q':			/* quit */
	case 'e':			/* exit */
E 34
I 34
	case 'q':				/* quit */
	case 'e':				/* exit */
E 34
		break ;
D 34
	case 'd':			/* screen dump */
E 34
I 34
	case 'd':				/* screen dump */
E 34
D 23
		if((fp = fopen("screen.dump", "a")) == NULL ) {
E 23
I 23
D 25
		if((fp = fopen("screen.dump", "a")) == NULL )
E 23
D 24
			warning("monitor: can't dump screen: %s.\n");
E 24
I 24
			warning("monitor: monitor: can't dump screen: %s.\n");
E 24
D 23
			return 'd' ;
E 23
I 23
		else {
			dumpit(fp);
			fclose(fp);
E 23
E 15
E 3
		}
E 25
I 25
D 28
		dump_screen("screen.dump");
E 28
I 28
D 31
		if((fp = fopen(op->opt_output, "a")) == NULL )
E 31
I 31
		if((fp = fopen(op->opt_output, "a")) == NULL ) {
E 31
D 30
			warning( "monitor: monitor: can't open output file: %s (%s).\n",
E 30
I 30
D 38
			warning("can't open output file: %s (%s).\n", module,
E 38
I 38
			warning("Can't open output file: %s (%s).\n", module,
E 38
E 30
				op->opt_output) ;
I 31
			return command ;
		}
E 31

		dump_screen(fp);

		if( fclose(fp) == EOF )
D 30
			warning("monitor: monitor: can't close dump file: %s.\n") ;
E 30
I 30
D 38
			warning("can't close dump file: %s.\n", module) ;
E 38
I 38
			warning("Can't close dump file: %s.\n", module) ;
E 38
E 30

E 28
E 25
D 23

D 3
		if( pass == op->opt_sample ) {
			(*op->opt_funct)(op) ;
			pass = 0 ;
		}
E 3
I 3
D 14
		(*op->opt_process)(op) ;
E 14
I 14
D 15
		(*op->opt_display)(op) ;
E 15
I 15
		dumpit(fp);

		fclose(fp);
E 23
		break ;
	default:
		break ;
E 15
E 14
E 3
	}
I 5

D 15
	if( killed )
		printf("Killed.\n");
I 8

D 14
	(*op->opt_finish)(op);
E 14
I 14
	(*op->opt_close_display)(op);
E 14
E 8
I 6

D 14
	uninit_gather(op);
E 14
I 14
	(*op->opt_end_gather)(op);
E 15
I 15
	return command ;
E 15
E 14
I 9
}
D 10

help()
{
	printf("usage: monitor -s# -ffile -h [ mode and data selection ]\n\n");
	printf("\t-s#    - Sleep for # seconds.\n");
	printf("\t-ffile - Save output in file.\n");
	printf("\t-h     - This help listing.\n\n");
	printf("\tMode options:\n");
	printf("\t\t{ screen save replay }\n\n");
	printf("\tData options:\n");
	printf("\t\t{ cpu tty disk free fork proc page tape netif state \n");
	printf("\t\t  memory loadave }\n");
E 9
E 6
E 5
E 2
}
E 10
E 1
