h40767
s 00013/00004/00118
d D 1.18 89/01/04 10:45:32 alan 18 17
c V1.1 changes for MIPS support.  This is a check-point of the current
c support.
c 
e
s 00011/00001/00111
d D 1.17 88/06/27 18:15:03 alan 17 16
c changed include of monitor.h and record.h
e
s 00001/00001/00111
d D 1.16 87/11/18 16:40:35 alan 16 15
c V0.99 -> T1.0-1
e
s 00002/00011/00110
d D 1.15 87/08/12 15:26:30 alan 15 14
c error message clean up - V0.95
e
s 00001/00001/00120
d D 1.14 87/04/03 14:31:07 alan 14 13
c 1.  Mostly rearranged include files so that the sources would compile
c     using VAXC.
c 2.  Changed an error monitor that pcc let get by.
c 
e
s 00000/00069/00121
d D 1.13 87/02/05 16:28:14 alan 13 12
c See comment on V0.81 in version.c.
c 
e
s 00028/00026/00162
d D 1.12 87/01/21 16:36:04 alan 12 11
c This is the first pass at makeing changes to record.h.  The intent of
c this delta is to change record.h and update the files that broke so
c that they will compile and a runnable version is produced.  This
c version may not run correctly.  A few other changes were added at
c same time, which were related to the changes to record.h.  See the
c commentary on V0.68 in version.c.  The next couple of deltas will
c be clean up this one.
c 
e
s 00064/00004/00124
d D 1.11 86/11/17 17:03:29 alan 11 10
c See V0.53 in version.c.
c 
e
s 00001/00001/00127
d D 1.10 86/08/26 18:03:56 alan 10 9
c modify all SccsId strings
e
s 00002/00000/00126
d D 1.9 86/08/01 14:17:51 alan 9 8
c 1.  Remove some lint caused by the addition of extra arguments on 
c     error function.  It has been reduced to a  mininium but is still
c     there.
c 2.  Make totals for disk and tapes static instead of dynamic.
c 3.  Merged stack.c code into uba.c and mba.c.  There were some pointers
c     that needed to be changed.
c 
c TODO: There is still a bug in multiple session replay that causes the
c first disk I/O data to be negitive numbers.  Wierd...
c 
e
s 00033/00008/00093
d D 1.8 86/07/31 15:41:08 alan 8 7
c merge in add_tape and add_disk code from stack.c
e
s 00009/00009/00092
d D 1.7 86/07/11 19:27:25 alan 7 6
c Dust off LOTS of lint...
c 
e
s 00006/00016/00095
d D 1.6 86/06/29 15:47:50 alan 6 5
c Changed the handleing of "word=value" lists.
c 
e
s 00022/00006/00089
d D 1.5 86/05/28 15:57:32 alan 5 4
c First pass of changes in order to get data selection to work.  Data
c selection during the replay function still needs to be written.
c 
c 1.  Due to the heavy use of the code like:
c 
c 	if( nel ) {
c 		p = sprintf(buf, "%s%d", name, unit);
c 
c 		if( !bsearch(&p, base, nel, sizeof(key *), compare))
c 			;
c 	}
c I sould impliment it as a function somewhere.  Probably in the 2nd or
c third pass.
c 
e
s 00006/00012/00089
d D 1.4 86/05/07 09:46:58 alan 4 3
c changed lseek/read to readk
e
s 00037/00073/00064
d D 1.3 86/05/06 17:56:23 alan 3 2
c cleaned up for real use.  Added code to netif.c for link listing interfaces
e
s 00000/00000/00137
d D 1.2 86/05/05 12:45:07 alan 2 1
c taken from ../names V1.1
e
s 00137/00000/00000
d D 1.1 86/05/05 12:44:03 alan 1 0
c date and time created 86/05/05 12:44:03 by alan
e
u
U
t
T
I 1
/*
 *	Author:  Alan Rollow, CSC/CS, Digital Equipment Corp.
 *	File:	 %M%
 *	Date:	 %G%
 *	Version: %I%
 *
D 11
 *	%M% - Read device names from kernal.
E 11
I 11
 *	%M% - Read MASSBUS device names from kernel.
E 11
 */
#ifndef	lint
D 10
static	char	SccsId[] = "%W% %G%" ;
E 10
I 10
D 11
static	char	SccsId[] = "%W%	(monitor)	%G%" ;
E 11
I 11
static	char	SccsId[] = "%W% (monitor) %G%" ;
E 11
E 10
#endif

I 17
/*
 * Modification History
 * 
 * 27-June-1988 -- arr
 *
 *	Change include of monitor.h to include.h.
 *
D 18
 *	Change include of record.h to monitor.h.
E 18
I 18
 *	Change include of record.h to monitor.h. 
 *
 * 29-November-1988 -- arr
 *
 *	#ifdef out the world for the MIPS port.
E 18
 */

E 17
#include <nlist.h>
#include <stdio.h>
I 3
#include <signal.h>
E 3

#include <sys/types.h>
I 12
D 13
#include <sys/devio.h>
E 13
E 12
#include <sys/buf.h>
#include <sys/file.h>
I 3
#include <sys/socket.h>
#include <sys/dk.h>
I 12
#include <sys/param.h>
#include <sys/dir.h>
#include <sys/user.h>
E 12
#include <sys/vmsystm.h>
#include <sys/vmmeter.h>
E 3

D 18
#include <vax/pte.h>
#include <vaxmba/mbavar.h>
#include <vaxmba/mbareg.h>
E 18
I 18
#include <machine/pte.h>
E 18

I 3
#include <net/if.h>
#include <netinet/in.h>

I 18
#ifdef	vax
#	include <vaxmba/mbavar.h>
#	include <vaxmba/mbareg.h>
#endif

E 18
I 17
#include "include.h"
E 17
E 3
D 14
#include "extern.h"
E 14
D 3
#include "names.h"
E 3
I 3
#include "monitor.h"
D 17
#include "record.h"
E 17
I 14
#include "extern.h"
E 14
E 3

I 11
D 15
/*
 *	Module name for the error functions.
 */
static	char	*module = "mba" ;

E 15
E 11
I 9
char	*strcpy() ;

I 11
/*
 *	Walk down the MASSBUS device list.
 */
E 11
E 9
I 5
D 6
int	cmp() ;		/* comparision function for the search */

E 6
E 5
mba_devices()
{
I 18
#ifdef	vax
E 18
D 8
	struct	mba_device	mba_device, *mp ;
	struct	mba_driver	driver ;
E 8
I 8
D 12
	register struct	mon_disk *dp ;
E 12
	struct	mba_device mba_device, *mp ;
	struct	mba_driver driver ;
E 8
D 3
	char	device[32], *mba_type() ;
E 3
I 3
D 5
	char	device[32] ;
E 5
I 5
D 6
	char	device[32], buf[BUFSIZ], *p, *sprintf() ;
E 6
I 6
D 12
	char	device[32] ;
E 12
I 12
	char	device[DEV_SIZE+1] ;
E 12
E 6
E 5
E 3

I 11
	/*
	 *	Make sure the beginning of the list is a reasonable
	 *	place to start.
	 */
E 11
D 3
	if( mp = (struct mba_device *)namelist[NM_MBDINIT].n_value )
		printf("#\n#	MASSBUS devices and formatters\n#\n");
E 3
I 3
	if((mp = (struct mba_device *)namelist[NM_MBDINIT].n_value) == NULL )
		return ;
E 3

D 5
	if( mp ) for ( ; ; ) {
E 5
I 5
	for( ; ; ) {
I 11
		/*
		 *	Read the next mba_device structure.
		 */
E 11
E 5
D 3
		lseek(kmem, (long)mp++, 0);
E 3
I 3
D 4
		lseek(kmem, (long)mp++, L_SET);
E 3
		read(kmem, &mba_device, sizeof(mba_device));
E 4
I 4
D 7
		readk((long)mp++, &mba_device, sizeof(mba_device));
E 7
I 7
		readk((long)mp++, (char *)&mba_device, sizeof(mba_device));
E 7
E 4

I 11
		/*
		 *	If the driver entry is 0 then we're done.
		 */
E 11
		if( mba_device.mi_driver == 0 )
			break ;

I 11
		/*
		 *	The only type of interesting MASSBUS "device" are
		 *	disks, so skip the device if it's dk number is -1.
		 */
E 11
D 3
		lseek(kmem, (long)mba_device.mi_driver, 0);
E 3
I 3
		if( mba_device.mi_dk == -1 )
			continue ;

I 11
		/*
		 *	Read the driver structure and device name.
		 */
E 11
D 4
		lseek(kmem, (long)mba_device.mi_driver, L_SET);
E 3
		read(kmem, &driver, sizeof(driver));
E 4
I 4
D 7
		readk((long)mba_device.mi_driver, &driver, sizeof(driver));
E 7
I 7
		readk((long)mba_device.mi_driver, (char *)&driver, sizeof(driver));
E 7
E 4

D 3
		lseek(kmem, (long)driver.md_dname, 0);
E 3
I 3
D 4
		lseek(kmem, (long)driver.md_dname, L_SET);
E 3
		read(kmem, device, sizeof(device));
E 4
I 4
D 7
		readk((long)driver.md_dname, device, sizeof(device));
E 7
I 7
D 12
		readk((long)driver.md_dname, (char *)device, sizeof(device));
E 12
I 12
		readk((long)driver.md_dname, (char *)device, DEV_SIZE);
E 12
E 7
E 4

I 11
		/*
D 15
		 *	If the device isn't alive print a warning message
		 *	and skip it.
E 15
I 15
		 *	If the device isn't alive skip it.
E 15
		 */
E 11
D 3
		printf("%s%d (%s) on mba%d drive %d %s alive.\n",
			device, mba_device.mi_unit, 
			mba_type(mba_device.mi_drv),
			mba_device.mi_mbanum,
			mba_device.mi_drive,
			mba_device.mi_alive ? "is" : "is not");
E 3
I 3
D 15
		if( !mba_device.mi_alive ) {
D 7
			fprintf(stderr, "monitor: %s%d is not alive.\n",
E 7
I 7
D 8
			fprintf(stderr, "monitor: mba: %s%d is not alive.\n",
E 7
				device, mba_device.mi_unit);
E 8
I 8
D 11
			info("monitor: mba: %s%d is not alive.\n", device, 
E 11
I 11
			info("%s%d is not alive.\n", module, device,
E 11
				mba_device.mi_unit);
E 15
I 15
		if( !mba_device.mi_alive )
E 15
E 8
			continue ;
D 15
		}
E 15

I 11
		/*
		 *	Check to see if this is an interesting device.
		 */
E 11
I 5
D 6
		if( disk_nel ) {
			p = sprintf(buf, "%s%d", device, mba_device.mi_unit) ;
E 6
I 6
		if( find_value(&disk_list, device, mba_device.mi_unit) == 0 )
			continue ;
E 6

I 11
		/*
		 *	Save the static device information.
		 */
E 11
D 6
			if( !bsearch(&p, disk_base, disk_nel, KEY_SIZE, cmp))
				continue ;
		}

E 6
E 5
D 7
		push_device(device, &mba_device, MBA, DISK);
E 7
I 7
D 8
		push_device(device, (char *)&mba_device, MBA, DISK);
E 8
I 8
D 12
		dp = disk + n_disk ;
E 12
I 12
		disk[n_disk].mon_length = MON$S_DISK ;
		disk[n_disk].mon_index = n_disk ;
D 16
		disk[n_disk].mon_type = MON$K_DISK ;
E 16
I 16
		disk[n_disk].mon_type = MON$C_DISK ;
E 16
		disk[n_disk].mon_flag = 1 ;
E 12

D 12
		dp->mon_length = MON$S_DISK ;
		dp->mon_index = n_disk++ ;
		dp->mon_type = MON$K_DISK ;
		dp->mon_flag = 1 ;
E 12
I 12
		disk[n_disk].mon_name[DEV_SIZE] = '\0' ;
E 12

D 12
		(void)strcpy(dp->mon_name, device);
E 12
I 12
		(void)strcpy(disk[n_disk].mon_name, device);
E 12
	
D 12
		dp->mon_dk = mba_device.mi_dk ;
		dp->mon_bus = mba_device.mi_mbanum ;
		dp->mon_unit = mba_device.mi_unit ;
		dp->mon_controller = mba_device.mi_drive ;
E 12
I 12
		disk[n_disk].mon_dk = mba_device.mi_dk ;
		disk[n_disk].mon_unit = mba_device.mi_unit ;

		n_disk++ ;
E 12
E 8
E 7
E 3
D 13
	}
}

I 11
/*
D 12
 *	Walk down the MASSBUS slice list.
E 12
I 12
 *	Walk down the MASSBUS slave list.
E 12
 */
E 11
mba_slaves()
{
I 8
D 12
	register struct mon_tape *tp ;
E 12
E 8
D 5
	struct mba_slave mba_slave, *mp ;
	struct mba_driver driver ;
	char	device[32], slave[32] ;
E 5
I 5
	struct	mba_slave mba_slave, *mp ;
	struct	mba_driver driver ;
D 6
	char	slave[32], buf[BUFSIZ], *p, *sprintf() ;
E 6
I 6
D 12
	char	slave[32] ;
E 12
I 12
	char	slave[DEV_SIZE+1] ;
E 12
E 6
E 5

I 11
	/*
	 *	Make sure this is a reasonable place to start.
	 */
E 11
D 3
	if( mp = (struct mba_slave *)namelist[NM_MBSINIT].n_value )
		printf("#\n#	MASSBUS slaves\n#\n");
E 3
I 3
	if((mp = (struct mba_slave *)namelist[NM_MBSINIT].n_value) == NULL )
		return ;
E 3

D 5
	if( mp ) for( ; ; ) {
E 5
I 5
	for( ; ; ) {
I 11
		/*
		 *	Read the mba_slave structure.
		 */
E 11
E 5
D 3
		lseek(kmem, (long)mp++, 0);
E 3
I 3
D 4
		lseek(kmem, (long)mp++, L_SET);
E 3
		read(kmem, &mba_slave, sizeof(mba_slave));
E 4
I 4
D 7
		readk((long)mp++, &mba_slave, sizeof(mba_slave));
E 7
I 7
		readk((long)mp++, (char *)&mba_slave, sizeof(mba_slave));
E 7
E 4

I 11
		/*
		 *	If the driver entry is 0, we're done.
		 */
E 11
		if( mba_slave.ms_driver == 0 )
			break ;

I 11
		/*
		 *	Read the driver structure and slave name.
		 */
E 11
D 3
		lseek(kmem, (long)mba_slave.ms_driver, 0);
E 3
I 3
D 4
		lseek(kmem, (long)mba_slave.ms_driver, L_SET);
E 3
		read(kmem, &driver, sizeof(driver));
E 4
I 4
D 7
		readk((long)mba_slave.ms_driver, &driver, sizeof(driver));
E 7
I 7
		readk((long)mba_slave.ms_driver, (char *)&driver, sizeof(driver));
E 7
E 4

D 3
		lseek(kmem, (long)driver.md_dname, 0);
		read(kmem, device, sizeof(device));

		lseek(kmem, (long)driver.md_sname, 0);
E 3
I 3
D 4
		lseek(kmem, (long)driver.md_sname, L_SET);
E 3
		read(kmem, slave, sizeof(slave));
E 4
I 4
D 12
		readk((long)driver.md_sname, slave, sizeof(slave));
E 12
I 12
		readk((long)driver.md_sname, slave, DEV_SIZE);
E 12
E 4

I 11
		/*
		 *	If the slave isn't alive, print a warning message
		 *	and skip it.
		 */
E 11
D 3
		printf("%s%d at %s%d %s alive.\n",
			slave, mba_slave.ms_slave,
			device, mba_slave.ms_ctlr,
			mba_slave.ms_alive ? "is" : "is not");
	}
}
E 3
I 3
		if( !mba_slave.ms_alive ) {
D 7
			fprintf(stderr, "monitor: %s%d is not alive.\n",
E 7
I 7
D 8
			fprintf(stderr, "monitor: mba: %s%d is not alive.\n",
E 7
				slave, mba_slave.ms_unit);
E 8
I 8
D 11
			info("monitor: mba: %s%d is not alive.\n", slave, 
E 11
I 11
			info("%s%d is not alive.\n", module, slave, 
E 11
				mba_slave.ms_unit);
E 8
			continue ;
I 5
		}

I 11
		/*
		 *	See if this is an interesting slave.
		 */
E 11
D 6
		if( tape_nel ) {
			p = sprintf(buf, "%s%d", slave, mba_slave.ms_unit) ;

			if( !bsearch(&p, tape_base, tape_nel, KEY_SIZE, cmp))
				continue ;
E 5
		}
E 6
I 6
		if( find_value(&tape_list, slave, mba_slave.ms_unit) == 0 )
			continue ;
E 6
E 3

I 11
		/*
		 *	Save the static slave information.
		 */
E 11
D 3
char	*mba_type(mdp, drive)
struct mba_drv *mdp ;
int	drive ;
{	
	struct mba_drv mba_drv ;
	static char	buf[BUFSIZ] ;

	if( mdp == NULL )
		return NULL ;

	lseek(kmem, (long)mdp, 0);
	read(kmem, &mba_drv, sizeof(mba_drv));

	switch( mba_drv.mbd_dt & MBDT_TYPE ) {
	case MBDT_RP04:
		return "rp04" ;
	case MBDT_RP05:
		return "rp05" ;
	case MBDT_RP06:
		return "rp06" ;
	case MBDT_RP07:
		return "rp07" ;
	case MBDT_RM02:
		return "rm02" ;
	case MBDT_RM03:
		return "rm03" ;
	case MBDT_RM05:
		return "rm05" ;
	case MBDT_RM80:
		return "rm80" ;
	case MBDT_ML11A:
		return "ml11a" ;
	case MBDT_ML11B:
		return "ml11b" ;
	case MBDT_TM03:
		return "tm03" ;
	case MBDT_TE16:
		return "te16" ;
	case MBDT_TU45:
		return "tu45" ;
	case MBDT_TU77:
		return "tu77" ;
	case MBDT_TU78:
		return "tu78" ;
	default:
		return sprintf(buf, "0%o", mba_drv.mbd_dt & MBDT_TYPE );
E 3
I 3
D 7
		push_device(slave, &mba_slave, MBA, TAPE);
E 7
I 7
D 8
		push_device(slave, (char *)&mba_slave, MBA, TAPE);
E 8
I 8
D 12
		tp = tape + n_tape ;
E 12
I 12
		tape[n_tape].mon_length = MON$S_TAPE ;
		tape[n_tape].mon_index = tape[n_tape].mon_tp = n_tape ;
		tape[n_tape].mon_type = MON$K_TAPE ;
		tape[n_tape].mon_flag = 1 ;
E 12

D 12
		tp->mon_length = MON$S_TAPE ;
		tp->mon_index = tp->mon_tp = n_tape++ ;
		tp->mon_type = MON$K_TAPE ;
		tp->mon_flag = 1 ;
E 12
I 12
		tape[n_tape].mon_name[DEV_SIZE] = '\0' ;
E 12

D 12
		(void)strcpy(tp->mon_name, slave);
E 12
I 12
		(void)strcpy(tape[n_tape].mon_name, slave);
E 12

D 12
		tp->mon_bus = -1 ;
		tp->mon_unit = mba_slave.ms_slave ;
		tp->mon_controller = mba_slave.ms_ctlr ;
E 12
I 12
		tape[n_tape].mon_unit = mba_slave.ms_slave ;

		n_tape++ ;
E 13
E 12
E 8
E 7
E 3
	}
I 18
#endif
E 18
}
E 1
