h01947
s 00003/00003/00120
d D 1.15 90/08/21 22:43:35 alan 15 14
c dust off lint
e
s 00011/00001/00112
d D 1.14 90/03/29 16:17:30 alan 14 13
c The hack to fix the DECmumble include file problem.
e
s 00002/00002/00111
d D 1.13 89/02/25 09:56:42 alan 13 12
c editorial change to rec_ elements
e
s 00001/00001/00112
d D 1.12 89/02/15 20:44:14 alan 12 11
c dust off some lint
e
s 00008/00001/00105
d D 1.11 89/02/15 20:19:17 alan 11 10
c Fixed bug in setting mon_flag from input data.
c 
e
s 00011/00001/00095
d D 1.10 88/06/27 18:14:32 alan 10 9
c changed include of monitor.h and record.h
e
s 00004/00004/00092
d D 1.9 87/08/12 15:25:32 alan 9 8
c error message clean up - V0.95
e
s 00001/00001/00095
d D 1.8 87/04/03 14:32:24 alan 8 7
c 1.  Mostly rearranged include files so that the sources would compile
c     using VAXC.
c 2.  Changed an error monitor that pcc let get by.
c 
e
s 00000/00001/00096
d D 1.7 87/02/05 16:27:40 alan 7 6
c See comment on V0.81 in version.c.
c 
e
s 00004/00000/00093
d D 1.6 87/01/21 16:35:28 alan 6 5
c This is the first pass at makeing changes to record.h.  The intent of
c this delta is to change record.h and update the files that broke so
c that they will compile and a runnable version is produced.  This
c version may not run correctly.  A few other changes were added at
c same time, which were related to the changes to record.h.  See the
c commentary on V0.68 in version.c.  The next couple of deltas will
c be clean up this one.
c 
e
s 00012/00005/00081
d D 1.5 86/11/18 12:41:38 alan 5 4
c See commentary on V0.55 in version.c
c 
e
s 00001/00002/00085
d D 1.4 86/11/16 16:32:12 alan 4 3
c See comments for V0.51 in version.c
c 
e
s 00004/00004/00083
d D 1.3 86/09/29 13:34:41 alan 3 2
c cleaned up error messages
e
s 00017/00000/00070
d D 1.2 86/09/28 14:55:52 alan 2 1
c new code
e
s 00070/00000/00000
d D 1.1 86/09/28 10:53:55 alan 1 0
c date and time created 86/09/28 10:53:55 by alan
e
u
U
t
T
I 1
/*
 *	Author:  Alan Rollow, CSC/CS, Digital Equipment Corp.
 *	File:	 %M%
 *	Date:	 %G%
 *	Version: %I%
 *
 *	%M% - Functions to get data records.
 */
#ifndef	lint
D 4
static	char	SccsId[] = "%W%	(monitor)	%G%" ;
E 4
I 4
static	char	SccsId[] = "%W% (monitor) %G%" ;
E 4
#endif

I 10
/*
 * Modification History
 * 
 * 27-June-1988 -- arr
 *
 *	Change include of monitor.h to include.h.
 *
 *	Change include of record.h to monitor.h.
I 11
 *
 * Feb. 15, 1989 -- arr
 *
 *	Set the mon_flag field from the header after it has been
D 14
 *	read.
E 14
I 14
 *	read. 
 *
 * Mar. 26, 1990 -- arr
 *
 *	Added hack to work-around DECmumble include file problem.
 *
E 14
E 11
 */

E 10
#include <nlist.h>
#include <stdio.h>
#include <signal.h>
#include <curses.h>

#include <sys/types.h>
#include <sys/buf.h>
I 6
D 7
#include <sys/devio.h>
E 7
E 6
#include <sys/uio.h>
#include <sys/file.h>
#include <sys/socket.h>
#include <sys/dk.h>
I 6
#include <sys/param.h>
#include <sys/dir.h>
I 14

#if defined(V4_ULTRIX) && defined(mips)
#	include <mips/cpu.h>
#endif

E 14
#include <sys/user.h>
E 6
#include <sys/vmsystm.h>
#include <sys/vmmeter.h>

#include <net/if.h>
#include <netinet/in.h>

I 10
#include "include.h"
E 10
D 8
#include "extern.h"
E 8
#include "monitor.h"
D 4
#include "options.h"
E 4
D 10
#include "record.h"
E 10
I 8
#include "extern.h"
E 8

/*
I 5
 *	Module name for error functions.
 */
static	char	*module = "get_records" ;

/*
E 5
 *	Read the next record of the file.  It will probably be a FIRST,
 *	LAST or SAMPLE record.  The record type will be returned.  If
 *	an error occurs, the function will exit with a fatal error or
 *	return a -1.  The only non-fatal error condition is EOF.
 */
get_record(fd)
int	fd ;
{
D 11
	struct 	mon_header header ;
E 11
I 11
D 12
	struct 	mon_header header, *p ;
E 12
I 12
	struct 	mon_header header ;
E 12
E 11
	register rc, type, size ;

/*
 *	Read the header of the next record in the file.
 *
 *	If an error occurs (rc == -1) exit with a fatal error.
 *
 *	Otherwise if EOF is reached (rc == 0) and return -1.
 */
	if((rc = read(fd, (char *)&header, MON$S_HEADER)) == -1 )
D 3
		fatal("monitor: get_record: can't read record: %s.\n");
E 3
I 3
D 5
		fatal("monitor: get_records: can't read record header: %s.\n");
E 5
I 5
D 9
		fatal("can't read record header: %s.\n", module);
E 9
I 9
		fatal("Can't read record header: %s.\n", module);
E 9
E 5
E 3
	else if( rc == 0 )
		return -1 ;

/*
 *	Save the record type and the (remainder of the) record size.
 *	Then read in the rest of that record.
 */
	type = header.mon_type ;
	size = header.mon_length - MON$S_HEADER ;
I 11

D 13
	((struct mon_header *)records[type].rec_addr)->mon_flag = header.mon_flag ;
E 13
I 13
	((struct mon_header *)records[type].addr)->mon_flag = header.mon_flag ;
E 13
E 11

D 13
	if( read(fd, records[type].rec_addr + MON$S_HEADER, size) <= 0 )
E 13
I 13
	if( read(fd, records[type].addr + MON$S_HEADER, size) <= 0 )
E 13
D 3
		fatal("monitor: get_record: can't read rest of record: %s.\n");
E 3
I 3
D 5
		fatal("monitor: get_records: can't read rest of record: %s.\n");
E 5
I 5
D 9
		fatal("can't read rest of record: %s.\n", module);
E 9
I 9
		fatal("Can't read rest of record: %s.\n", module);
E 9
E 5
E 3

	return type ;
}
I 2

/*
D 5
 *	Read a sample.  Return only if successful.
E 5
I 5
 *	Read a sample.  Return only if successful.  This
 *	requires that an I/O vector usable with readv(2)
 *	already be setup.
E 5
 */
D 15
void	get_sample(fd, iov, n)
E 15
I 15
void	get_sample(fd, mon_iov, n)
E 15
int	fd, n ;
D 15
struct iovec *iov ;
E 15
I 15
struct iovec *mon_iov ;
E 15
{
	register rc ;

D 15
	if((rc = readv(fd, iov, n)) < 0 )
E 15
I 15
	if((rc = readv(fd, mon_iov, n)) < 0 )
E 15
D 3
		fatal("monitor: get_sample: can't read record: %s.\n") ;
E 3
I 3
D 5
		fatal("monitor: get_records: can't read sample data: %s.\n") ;
E 5
I 5
D 9
		fatal("can't read data sample: %s.\n", module) ;
E 9
I 9
		fatal("Can't read data sample: %s.\n", module) ;
E 9
E 5
E 3
	else if( rc == 0 )
D 3
		fatal("monitor: get_sample: unexpected EOF.\n");
E 3
I 3
D 5
		fatal("monitor: get_records: unexpected EOF.\n");
E 5
I 5
D 9
		fatal("unexpected EOF.\n", module);
E 9
I 9
		fatal("Unexpected EOF.\n", module);
E 9
E 5
E 3
	else
		return ;
}
E 2
E 1
