h41033
s 00002/00002/00525
d D 1.17 86/05/24 19:35:45 alan 17 16
c I made some big changes to options.h and how options where being handled.
c The changes to these files reflect those.  Most of the changes were caused
c by changing the names of things.
c 
c Added note: this is probably the last version of gather.c because it
c is going to become live.c very soon.
c 
e
s 00028/00021/00499
d D 1.16 86/05/24 16:49:19 alan 16 15
c The dk_mspw[] (milli-seconds per word?) disk data appears to be static.  Rathe
c than collect it at every iteration, I know collect it once in gather_static().
c This required moving it's namelist array element and #define in the "static"
c namelist part of the ararray.
c 
e
s 00011/00002/00509
d D 1.15 86/05/23 21:00:34 alan 15 14
c If the display function is save() open_gather() returns.  If not it calls
c gather and runs the delta_ functions that need to be run.
c 
e
s 00080/00056/00431
d D 1.14 86/05/23 20:43:20 alan 14 13
c General code cleanup.  I took out some of the namelist checking.  If
c I believed that a given namelist entry would actually not be there
c I left the check in.  Whenever an option got turned off because it
c wasn't there, I now print a message.  I removed the messages from
c check_options().  I still need to the turn the dk_mspw[] data into
c 'static' data, but that will require changes many other places.
c 
e
s 00014/00001/00473
d D 1.13 86/05/23 19:58:42 alan 13 12
c add references to allocate and free _totals
e
s 00002/00002/00472
d D 1.12 86/05/22 10:18:27 alan 12 11
c changed init_ to begin_ and uninit_ to end_
e
s 00013/00000/00461
d D 1.11 86/05/21 16:21:02 alan 11 10
c Moved nlist() call and /dev/kmem open and close into gather.
c 
e
s 00024/00031/00437
d D 1.10 86/05/19 16:49:19 alan 10 9
c update some comments
e
s 00010/00003/00458
d D 1.9 86/05/12 19:11:58 alan 9 8
c Moved the sample timestamp assignment from save() to gather().
c 
e
s 00053/00018/00408
d D 1.8 86/05/11 16:38:25 alan 8 7
c 1.  Fixed the mspw values that were going to the disk file.  I had a type
c     mismatch.
c 2.  Added #ifdef's for what I think is the sun stuff.
c 3.  Turned on the network interface data.  Due to a change in record.h
c     I now save the if_flags.
c 4.  Turned on the "Time in CPU states data" and changed the comment to
c     say that I only save the first CPU.  If cpus() sets the linked list
c     up correctly I'll get all the CPU's.
c 5.  If disk or tty I/O are turned on, I get a copy for the "_cp_time"
c     data for them though the dynamic[] data collection.  This is seperate
c     from the mon_state data.
c 6.  Removed a few debugging prints and fixed some size bugs.
c 
e
s 00237/00028/00189
d D 1.7 86/05/10 19:21:03 alan 7 6
c 1.  Added code to init_gather() to check for availability of data.
c 2.  Added code gather() to actually collect most data, that had to
c     be collected by hand (CPU, disk, netif)
c 3.  Added code in gather() to move collected into the right places.
c     These only so if the option is turned on.
c 
e
s 00096/00058/00121
d D 1.6 86/05/07 11:59:30 alan 6 5
c Added cpus() to figure out how many cpus there are and allocate space for
c mon_state structures.
c Rearranged array of "dynamic" info.  I added a "where" field which is
c initialized in init_gather().  It replaces a reference to:
c 
c 	namelist[dynamic[i].gt_nm].n_value
c 
c Took out device printfs.
c Moved device gathering functions into a function called gather_static()
c which gathers all the static info.  The device functions are only run
c if we are interested in that type of device.
c 
e
s 00145/00012/00034
d D 1.5 86/05/07 10:08:12 alan 5 4
c intermediate 'sort-of' working version
e
s 00001/00001/00045
d D 1.4 86/04/23 17:22:55 alan 4 3
c Changed all occurances of "idle" to "monitor"
c 
e
s 00007/00014/00039
d D 1.3 86/04/23 16:05:58 alan 3 2
c Changes for "data" not being pointer.
c 
e
s 00034/00000/00019
d D 1.2 86/04/22 17:07:27 alan 2 1
c First working version
e
s 00019/00000/00000
d D 1.1 86/04/22 10:15:50 alan 1 0
c date and time created 86/04/22 10:15:50 by alan
e
u
U
t
T
I 1
/*
 *	Author:  Alan Rollow, CSC/CS, Digital Equipment Corp.
 *	File:	 %M%
 *	Date:	 %G%
 *	Version: %I%
 *
 *	%M% - This file contains code for gathering system data.  It will
 *	fill the structure (or structures) provided based on the "options"
 *	argument.
 */
#ifndef	lint
static	char	SccsId[] = "%W% %G%" ;
#endif

I 2
#include <nlist.h>
I 5
#include <stdio.h>
#include <signal.h>

E 5
E 2
#include <sys/types.h>
I 2
D 5
#include <sys/vm.h>
E 5
#include <sys/dk.h>
I 5
#include <sys/buf.h>
#include <sys/file.h>
#include <sys/socket.h>
#include <sys/vmsystm.h>
#include <sys/vmmeter.h>
E 5
E 2

I 5
#include <net/if.h>
#include <netinet/in.h>

E 5
D 4
#include "idle.h"
E 4
I 4
#include "monitor.h"
E 4
#include "extern.h"
I 2
#include "options.h"
I 5
#include "record.h"
E 5
E 2

I 5
/*
 *	Most of the kernel data will be read directly into the
 *	mon_... structures.  However some of it needs to shuffled
 *	off to a variety of places.  These are the objects for that
 *	info.
 */
struct vmtotal	Total ;
struct vmmeter	Rate ;
I 8
long		current[CPUSTATES] ;
E 8
int		dk_busy ;
long		dk_time[DK_NDRIVE] ;
long		dk_seek[DK_NDRIVE] ;
long		dk_xfer[DK_NDRIVE] ;
long		dk_wds[DK_NDRIVE] ;
D 16
#ifdef	sun
D 8
long		dk_bps[DK_NDRIVE] ;
E 8
I 8
float		dk_bps[DK_NDRIVE] ;
E 8
#else
D 8
long		dk_mspw[DK_NDRIVE] ;
E 8
I 8
float		dk_mspw[DK_NDRIVE] ;
E 8
#endif
E 16

/*
I 7
 *	Other local data and declarations.
 */
D 8
double	etime, cpu_time() ;
E 8
I 8
static	double	elapsed_time = 0.0 ;
static	long	prev_time[CPUSTATES] ;
static	int	passno = 0 ;
E 8

I 8

E 8
/*
E 7
 *	Table of stuff to read.  The "flag" can be used to determine
 *	if the data is available.  There are will probably be more than
 *	version of this table.  One for "static" data and the other for
D 7
 *	"dynamic" data.  This is the "dynamic" data table.
E 7
I 7
 *	"dynamic" data.  This is the "dynamic" data table.  The NM_
 *	#define's can be used as indexes into the dynamic data table
 *	because all the dynamic data appears at the beginning and is
 *	in the correct order.  If any dynamic data is added all the
 *	indexs will need to change accordingly.
E 7
 */
I 7

/*
 *	These are macro's to make the table below more readable.
 *
 *	I hope.
 */
D 10
#define	NORMAL(name, where, flag, string) \
	{ (char *)&(name), sizeof((name)), (where), (flag), (string) }
E 10
I 10
#define	NORMAL(name, where, flag) \
	{ (char *)&(name), sizeof((name)), (where), (flag), }
E 10

D 10
#define	ARRAY(name, where, flag, string) \
	{ (char *)(name), sizeof((name)), (where), (flag), (string) }
E 10
I 10
#define	ARRAY(name, where, flag) \
	{ (char *)(name), sizeof((name)), (where), (flag), }
E 10

E 7
struct	gather_table {
D 6
	int	nm ;			/* namelist index */
E 6
	char	*addr ;		/* address of target */
	int	len ;		/* length of data */
I 6
	long	where ;		/* value of namelist entry */
E 6
	int	flag ;		/* misc */
I 6
D 7
	int	nm ;
E 7
I 7
D 10
	char	*string ;	/* name of the thing */
E 10
E 7
E 6
} dynamic[] = {
D 6
	NM_FREE,	(char *)&freemem.mon_freemem, 
	sizeof(freemem.mon_freemem), 1,
E 6
I 6
D 7
	(char *)&freemem.mon_freemem, sizeof(freemem.mon_freemem),
	0, 1, NM_FREE,
E 7
I 7
D 10
	NORMAL(freemem.mon_freemem, 0, 1, "Free memory"),
	NORMAL(Total, 		    0, 1, "Total"),
E 10
I 10
	NORMAL(freemem.mon_freemem, 0, 1),
	NORMAL(Total, 		    0, 1),
E 10
E 7
E 6

D 6
	NM_TOTAL,	(char *)&Total,		sizeof(Total), 1,
E 6
I 6
D 7
	(char *)&Total,	sizeof(Total), 0, 1, NM_TOTAL,
E 7
I 7
D 8
	0, 0, 0, 0, "Time in CPU states",
E 8
I 8
D 10
	ARRAY(current,		   0, 1, "Time in CPU states for I/O"),
E 8
	ARRAY(loadave.mon_loadave, 0, 1, "Load average"),
	NORMAL(Rate, 		   0, 1, "Rate"),
	NORMAL(page.mon_deficit,   0, 1, "Deficit"),
	NORMAL(fork.mon_fork,      0, 1, "Fork"),
E 10
I 10
	ARRAY(current,		   0, 1),
	ARRAY(loadave.mon_loadave, 0, 1),
	NORMAL(Rate, 		   0, 1),
	NORMAL(page.mon_deficit,   0, 1),
	NORMAL(fork.mon_fork,      0, 1),
E 10
E 7
E 6

D 6
	NM_LOADAVE,	(char *)loadave.mon_loadave, 
	sizeof(loadave.mon_loadave), 1,
E 6
I 6
D 7
	(char *)loadave.mon_loadave, sizeof(loadave.mon_loadave),
	0, 1, NM_LOADAVE,
E 6

D 6
	NM_PAGE,	(char *)&Rate,		sizeof(Rate), 1,
E 6
I 6
	(char *)&Rate, sizeof(Rate), 0, 1, NM_PAGE,
	(char *)&page.mon_deficit, sizeof(page.mon_deficit), 0, 1, NM_DEFICIT,
	(char *)&fork.mon_fork, sizeof(fork.mon_fork), 0, 1, NM_FORK,
E 6

D 6
	NM_DEFICIT,	(char *)&page.mon_deficit, 
	sizeof(page.mon_deficit), 1,

	NM_FORK,	(char *)&fork.mon_fork, sizeof(fork.mon_fork), 1,

	NM_DK_BUSY,	(char *)&dk_busy,	sizeof(dk_busy), 1,
	NM_DK_TIME,	(char *)dk_time,	sizeof(dk_time), 1,
	NM_DK_SEEK,	(char *)dk_seek,	sizeof(dk_seek), 1,
	NM_DK_XFER,	(char *)dk_xfer,	sizeof(dk_xfer), 1,
	NM_DK_WDS,	(char *)dk_wds,		sizeof(dk_wds), 1,
E 6
I 6
	(char *)&dk_busy,	sizeof(dk_busy), 0, 1, NM_DK_BUSY,
	(char *)dk_time,	sizeof(dk_time), 0, 1, NM_DK_TIME,
	(char *)dk_seek,	sizeof(dk_seek), 0, 1, NM_DK_SEEK,
	(char *)dk_xfer,	sizeof(dk_xfer), 0, 1, NM_DK_XFER,
	(char *)dk_wds,		sizeof(dk_wds), 0, 1, NM_DK_WDS,
E 7
I 7
D 10
	(char *)&dk_busy,	sizeof(dk_busy), 0, 1, "DK_busy",
	(char *)dk_time,	sizeof(dk_time), 0, 1, "DK_time",
	(char *)dk_seek,	sizeof(dk_seek), 0, 1, "DK_seek",
	(char *)dk_xfer,	sizeof(dk_xfer), 0, 1, "DK_xfer",
	(char *)dk_wds,		sizeof(dk_wds), 0, 1, "DK_wds",
E 10
I 10
	(char *)&dk_busy,	sizeof(dk_busy), 0, 1, 
	(char *)dk_time,	sizeof(dk_time), 0, 1,
	(char *)dk_seek,	sizeof(dk_seek), 0, 1,
	(char *)dk_xfer,	sizeof(dk_xfer), 0, 1,
	(char *)dk_wds,		sizeof(dk_wds),  0, 1, 
E 10
E 7
E 6
D 16
#ifdef	sun
D 6
	NM_DK_BPS,	(char *)dk_bps,		sizeof(dk_bps), 1,
E 6
I 6
D 7
	(char *)dk_bps,		sizeof(dk_bps), 0, 1, NM_DK_BPS,
E 7
I 7
D 10
	(char *)dk_bps,		sizeof(dk_bps), 0, 1, "DK_bps",
E 10
I 10
	(char *)dk_bps,		sizeof(dk_bps),  0, 1,
E 10
E 7
E 6
#else
D 6
	NM_DK_MSPW,	(char *)dk_mspw,	sizeof(dk_mspw), 1,
E 6
I 6
D 7
	(char *)dk_mspw,	sizeof(dk_mspw), 0, 1, NM_DK_MSPW,
E 7
I 7
D 10
	(char *)dk_mspw,	sizeof(dk_mspw), 0, 1, "DK_mspw",
E 10
I 10
	(char *)dk_mspw,	sizeof(dk_mspw), 0, 1,
E 10
E 7
E 6
#endif
E 16
I 16

E 16
D 6
	NM_TTY_IN,	(char *)&tty.mon_ttyin, sizeof(tty.mon_ttyin), 1,
	NM_TTY_OUT,	(char *)&tty.mon_ttyout, sizeof(tty.mon_ttyout), 1,
E 6
I 6
D 7
	(char *)&tty.mon_ttyin,  sizeof(tty.mon_ttyin), 0, 1, NM_TTY_IN,
	(char *)&tty.mon_ttyout, sizeof(tty.mon_ttyout), 0, 1, NM_TTY_OUT,
E 7
I 7
D 10
	(char *)&tty.mon_ttyin,  sizeof(tty.mon_ttyin), 0, 1, "TTY Input",
	(char *)&tty.mon_ttyout, sizeof(tty.mon_ttyout), 0, 1, "TTY Output",
E 10
I 10
	(char *)&tty.mon_ttyin,  sizeof(tty.mon_ttyin),  0, 1,
	(char *)&tty.mon_ttyout, sizeof(tty.mon_ttyout), 0, 1,
E 10
E 7
E 6
};

/*
 *	Initialize static data, verify options vs. namelist to see what
D 14
 *	can really be gathered.
E 14
I 14
 *	can really be gathered.  We also make one pass on the kernel and
 *	run the delta functions for disks, netif, forks and ttys.  Tapes
 *	will be added once they are needed.
E 14
 */
D 12
init_gather(op)
E 12
I 12
begin_gather(op)
E 12
OPTION	*op ;
{
D 6
	struct mon_tape *tp ;
	struct mon_disk *dp ;
	struct mon_netif *ip ;
E 6
I 6
D 13
	int	i ;
E 13
I 13
	int	i, save() ;
E 13
I 7

E 7
/*
I 11
 *	Initialize the namelist.
 */
	nlist("/vmunix", namelist);		/* no error returned */

/*
 *	Open /dev/kmem.
 */
	if((kmem = open("/dev/kmem", O_RDONLY, 0)) == -1 )
		fatal("monitor: can't open /dev/kmem: %s.\n");

/*
E 11
I 7
 *	Check the contents of the namelist and turn off the options
 *	that we can't access information for.
 */
	check_namelist(op) ;

/*
E 7
 *	Initialize the dynamic array namelist info.
 */
	for(i = 0; i < sizeof(dynamic)/sizeof(dynamic[0]); i++)
D 7
		dynamic[i].where = (long)namelist[dynamic[i].nm].n_value ;
E 7
I 7
		dynamic[i].where = (long)namelist[i].n_value ;
E 7
E 6

D 6
	uba_devices();		/* Unibus/Qbus disks and tapes */
E 6
I 6
/*
 *	Collect the static info.
 */
	gather_static(op);
E 6

D 6
	mba_devices();		/* MASSBUS disks */
	mba_slaves();		/* MASSBUS tapes */

	net_devices();		/* network interfaces */

	tp = tape ;
	while( tp ) {
		printf("%s%d at %d bus %d - %d\n", tp->mon_name, tp->mon_unit,
			tp->mon_controller, tp->mon_bus, tp->mon_tp) ;
		tp = tp->mon_next ;
	}

	dp = disk ;
	while( dp ) {
		printf("%s%d at %d bus %d - %d\n", dp->mon_name, dp->mon_unit,
			dp->mon_controller, dp->mon_bus, dp->mon_dk) ;
		dp = dp->mon_next ;
	}

	ip = netif ;
	while( ip ) {
		printf("%s%d with %d collisions.\n", ip->mon_name, ip->mon_unit,
			ip->mon_collisions);
		ip = ip->mon_next ;
	}

	printf("There are %d disks, %d tapes and %d network interfaces.\n",
		n_disk, n_tape, n_netif);
E 6
I 6
/*
D 7
 *	Process the options and figure out what data we need to collect.
E 7
I 7
 *	This is where we look at the data options and figure out what
 *	items from the name list we can turn off.
E 7
 */
I 7
	check_options(op) ;
I 13

/*
 *	By now we know how many total structures we need.  We only
 *	need these for some display functions.  We don't need the
D 15
 *	data for save().
E 15
I 15
 *	data for save() and will return.
E 15
 */
D 17
	if( op->opt_display != save )
E 17
I 17
	if( op->display_mode != OPT_SAVE )
E 17
		allocate_totals(op) ;
I 15
	else
		return ;
E 15
I 14

/*
 *	Like the replay() function we need to make pass of the data
 *	and initialize some of the differences.
 */
D 15

E 15
	gather(op);

	if( op->opt_fork )
		delta_fork(&fork);

	if( op->opt_tty )
		delta_tty(&tty);

	if( op->opt_disk ) {
		struct mon_disk *dp = disk ;

		while( dp ) {
			delta_disk(dp);
			dp = dp->mon_next ;
		}
	}

	if( op->opt_netif ) {
		struct mon_netif *np = netif ;

		while( np ) {
			delta_netif(np);
			np = np->mon_next ;
		}
	}
E 14
E 13
E 7
E 6
}

I 15
/*
 *	Collect data out of the running kernel.
 */
E 15
E 5
I 2
D 3
#define	pgtok(a)	((a)*NBPG/1024)

DATA	prev ; 

gather(pass, op)
int	pass ;
E 3
I 3
gather(op)
E 3
OPTION	*op ;
{
D 5
	VMTOTAL	Memory ;
E 5
D 3
	long	tmp, total_time ;
E 3
D 8
	int	i ;
E 8
I 8
D 9
	register	i, etime ;
E 8
I 6
	struct mon_state *sp = state ;
E 9
I 9
	time_t		 time() ;
	register	 i, etime ;
	struct mon_disk  *dp = disk ;
E 9
	struct mon_netif *ip = netif ;
D 9
	struct mon_disk *dp = disk ;
E 9
I 9
	struct mon_state *sp = state ;

/*
 *	Collect the timestamp here so that the screen function will have
 *	it.
 */
	sample.mon_timestamp = time(0) ;
E 9
E 6

D 3
	/* CPU time */
E 3
I 3
D 5
/* CPU time (an array of CPUSTATES longwords) */
E 5
I 5
/*
 *	This loop will gather the common dynamic data.
 */
	for(i = 0; i < sizeof(dynamic)/sizeof(dynamic[0]); i++) {
D 7
		if( !dynamic[i].flag )
E 7
I 7
		if( dynamic[i].flag == 0 )
E 7
			continue ;
E 5
E 3

D 5
	lseek(kmem, (long)namelist[CPU_TIME].n_value, 0);
D 3
	read(kmem, data[pass].cpu_time, sizeof(long) * CPUSTATES);
E 3
I 3
	read(kmem, data.cpu_time, sizeof(long) * CPUSTATES);
E 5
I 5
D 6
		readk((long)namelist[dynamic[i].nm].n_value,
			dynamic[i].addr, dynamic[i].len);
E 6
I 6
		readk(dynamic[i].where, dynamic[i].addr, dynamic[i].len);
E 6
	}
E 5
E 3

D 3
	/* free memory */
E 3
I 3
D 5
/* free memory (a longword in struct vmtotal) */
E 5
I 5
/*
D 8
 *	The loop here will gather the CPU state data.  Since I don't
 *	know how the multiple CPU is going to be arranged for the
 *	VAX 8300 and VAX 8800, for now I'll just read data for one
 *	CPU.
E 8
I 8
 *	The loop here will gather the CPU state data.  Another
 *	function sets up the linked list of CPU's.  It will have
 *	worry about the true implimentation of multiple CPU machines
E 8
 */
E 5
E 3

I 6
	while( sp ) {
D 7
		printf("cpu #%d\n", sp->mon_cpu);
E 7
I 7
D 8
		printf("cpu #%d at %x\n", sp->mon_cpu, sp->mon_where);

E 8
		readk(sp->mon_where, (char *)sp->mon_time,
			sizeof(sp->mon_time));

D 8
		if( sp->mon_cpu == 1 )
			etime = cpu_time();		/* calculate etime */

E 8
E 7
		sp = sp->mon_next ;
	}

E 6
D 5
	lseek(kmem, (long)namelist[X_TOTAL].n_value, 0);
	read(kmem, &Memory, sizeof(VMTOTAL));
E 5
I 5
/*
I 8
 *	The disk and tty data need to know the number of clock ticks
 *	which have elapsed since the last sample.  Since the CPU data
 *	may not be turned we will gather what we need here.  There is
 *	a little extra overhead if the state data is turned on, but
 *	the code to do it most effienciely doesn't seem worth the
 *	trouble right now.
 */
	if( op->opt_disk || op->opt_tty ) {
		register tmp ;

		for(i = 0, etime = 0; i < CPUSTATES; i++) {
			tmp = current[i] ;
			current[i] -= prev_time[i] ;
			prev_time[i] = tmp ;
			etime += current[i] ;
		}

		if( etime == 0 )
			etime = 1 ;

		elapsed_time = (double)etime / first.mon_hz ;
	}

	if( op->opt_tty )
		tty.mon_etime = elapsed_time ;

/*
E 8
 *	The loop here will gather the network interface dynamic data.
 */
I 6
	while( ip ) {
D 7
		printf("%s%d - %d\n", ip->mon_name, ip->mon_unit,
			ip->mon_collisions);
E 7
I 7
D 8
		printf("%s%d\n", ip->mon_name, ip->mon_unit);
E 8
I 8
		struct ifnet ifnet ;

		readk((long)ip->mon_ifnet, (char *)&ifnet, sizeof(ifnet));

		ip->mon_flags	   = ifnet.if_flags ;
		ip->mon_ipackets   = ifnet.if_ipackets ;
		ip->mon_ierrors    = ifnet.if_ierrors ;
		ip->mon_opackets   = ifnet.if_opackets ;
		ip->mon_oerrors    = ifnet.if_oerrors ;
		ip->mon_collisions = ifnet.if_collisions ;

E 8
E 7
		ip = ip->mon_next ;
	}
E 6
E 5

D 3
	data[pass].free = Memory.t_free ;
E 3
I 3
D 5
	data.free = Memory.t_free ;
E 5
I 5
/*
I 7
 *	Collect the disk data from the approiate places.
 */
	while( dp ) {
		int	dk = dp->mon_dk ;

I 8
		dp->mon_etime = elapsed_time ;	/* elapsed time in seconds */
E 8
		dp->mon_time = dk_time[dk] ;
		dp->mon_seek = dk_seek[dk] ;
		dp->mon_xfer = dk_xfer[dk] ;
		dp->mon_wds = dk_wds[dk] ;
D 16
#ifdef	sun
		dp->mon_bps = dk_bps[dk] ;
#else
D 8
		dp->mon_mspw = dk_mspw[dk] ;
E 8
I 8
		dp->mon_mspw = dk_mspw[dk] ;	/* static? */
E 8
#endif
E 16
I 16

E 16
D 8
		printf("%s%d\n", dp->mon_name, dp->mon_unit);
E 8
		dp = dp->mon_next ;
	}

/*
E 7
 *	This will be where we move the collected data into the appropriate place
D 7
 *	if it wasn't read directly.
E 7
I 7
 *	if it wasn't read directly.  
E 7
 */
I 7
	if( op->opt_cpu ) {
		cpu.mon_swtch   = Rate.v_swtch ;
		cpu.mon_trap    = Rate.v_trap ;
		cpu.mon_syscall = Rate.v_syscall ;
		cpu.mon_intr    = Rate.v_intr ;
		cpu.mon_pdma    = Rate.v_pdma ;
	}

	if( op->opt_memory ) {
		memory.mon_vm     = Total.t_vm ;
		memory.mon_avm    = Total.t_avm ;
		memory.mon_rm     = Total.t_rm ;
		memory.mon_arm    = Total.t_arm ;
		memory.mon_vmtxt  = Total.t_vmtxt ;
		memory.mon_avmtxt = Total.t_avmtxt ;
		memory.mon_rmtxt  = Total.t_rmtxt ;
		memory.mon_armtxt = Total.t_armtxt ;
		memory.mon_free   = Total.t_free ;
	}

	if( op->opt_proc ) {
		proc.mon_rq = Total.t_rq ;
		proc.mon_dw = Total.t_dw ;
		proc.mon_pw = Total.t_pw ;
		proc.mon_sl = Total.t_sl ;
		proc.mon_sw = Total.t_sw ;
	}

	if( op->opt_page )
		page.mon_meter = Rate ;
I 15

	/*
 	 *	-1 is an error condition for opt_gather functions.
	 */
	return 1 ;
E 15
E 7
I 6
}
E 6
E 5
E 3

D 3
	/* load average */
E 3
I 3
D 5
/* load average (an array of 4 doubles) */
E 5
I 5
/*
D 6
 *	Last and for now least count the number of users and collect
 *	swap space data.
E 6
I 6
 *	Free all the space allocated by init_ and generally clean up.
E 6
 */
I 6
D 12
uninit_gather(op)
E 12
I 12
end_gather(op)
E 12
OPTION	*op ;
{
I 13
	int	save() ;

D 14
	if( op->opt_display != sava )
E 14
I 14
D 17
	if( op->opt_display != save )
E 17
I 17
	if( op->display_mode != OPT_SAVE )
E 17
E 14
		free_totals(op);

E 13
I 11
	if( close(kmem) == -1 )
		fatal("monitor: can't close /dev/kmem: %s.\n");
E 11
E 6
}
E 5
E 3

D 5
	lseek(kmem, (long)namelist[LOADAVE].n_value, 0);
D 3
	read(kmem, data[pass].loadave, sizeof(double) * 4);

E 3
I 3
	read(kmem, data.loadave, sizeof(double) * 4);
E 5
I 5
D 6
uninit_gather(op)
E 6
I 6
/*
 *	Gather the static data (names of devices, physmem, etc).
I 14
 *
 *	Eventually the functions which collect names will be
 *	responseable for doing the handling the command line
 *	options like "disk=ra0,hp1,ra2".
E 14
 */
gather_static(op)
E 6
OPTION	*op ;
{
I 16
#ifdef	sun
	float		dk_bps[DK_NDRIVE] ;
#else
	float		dk_mspw[DK_NDRIVE] ;
#endif
E 16
I 6
/*
 *	Determine from options what sort of device information
 *	we are interested in.
 */
	if( op->opt_disk || op->opt_tape )
D 14
		uba_devices();		/* Unibus/Qbus disks and tapes */
E 14
I 14
		uba_devices(op);	/* Unibus/Qbus disks and tapes */
E 14

	if( op->opt_disk )
D 14
		mba_devices();		/* MASSBUS disks */
E 14
I 14
		mba_devices(op);	/* MASSBUS disks */
E 14

	if( op->opt_tape )
D 14
		mba_slaves();		/* MASSBUS tapes */
E 14
I 14
		mba_slaves(op);		/* MASSBUS tapes */
E 14

	if( op->opt_netif )
D 14
		net_devices();		/* network interfaces */
E 14
I 14
		net_devices(op);	/* network interfaces */
E 14

	if( op->opt_state )
D 14
		cpus() ;		/* CPU's for state info */
E 14
I 14
		cpus(op) ;		/* CPU's for state info */
E 14
/*
 *	Read in the version string.
 */
	readk(namelist[NM_VERSION].n_value, (char *)first.mon_version,
		MON$S_VERSION);

/*
 *	Read in "_hz".
 */
	readk(namelist[NM_HZ].n_value, (char *)&first.mon_hz,
		sizeof(first.mon_hz));

/*
 *	Read in the amount of physical memory.
 */
	readk(namelist[NM_PHYSMEM].n_value, (char *)&first.mon_physmem,
		sizeof(first.mon_physmem));

/*
 *	Get the hostname.  We are going to use a normal system call here...
 */
	if( gethostname(first.mon_hostname, MON$S_HOSTNAME) == -1 )
		strcpy(first.mon_hostname, "Who am I?");
I 14

/*
D 16
 *	I have reason to believe that the dk_mspw[] data is static.
 *	I will eventually add code here to read this data once and
 *	initialize the disk records.
E 16
I 16
 *	Collect more static disk data.
E 16
 */
I 16
	if( op->opt_disk ) {
		register struct mon_disk *dp = disk ;
#ifdef	sun
		readk(namelist[NM_DK_BPS].n_value, (char *)dk_bps,
			sizeof(dk_bps));
#else
		readk(namelist[NM_DK_MSPW].n_value, (char *)dk_mspw,
			sizeof(dk_mspw));
#endif

		while( dp ) {
#ifdef	sun
			dp->mon_bps = dk_bps[dp->mon_unit] ;
#else
			dp->mon_mspw = dk_mspw[dp->mon_dk] ;
#endif
			dp = dp->mon_next ;
		}
	}
E 16
E 14
E 6
E 5
E 3
}
I 7

/*
 *	This is where we check the namelist values to determine what
 *	is available.  If a needed namelist entry is 0, they we
 *	turn off the approiate option.
 *
I 10
 *	The real question is when and why a namelist entry might be
 *	zero.  Under what circumstances is this to be expected and
 *	and if unexpected should we panic()?
 *
E 10
D 16
 *	TODO: We should print messages whenever this happens.
I 14
 *
E 16
 *	The current version of this code check for things which
 *	I believe might not be there.
E 14
 */
check_namelist(op)
OPTION	*op ;
{
D 14
	if( namelist[NM_FREE].n_value == 0 )
		op->opt_free = 0 ;

	if( namelist[NM_TOTAL].n_value == 0 )
		op->opt_proc = op->opt_memory = 0 ;

E 14
	/*
	 *	If the CPU states aren't available then we can't
	 *	use them directory or indirectly for the calculation
	 *	of disk and tty I/O (etime).
	 */
D 14
	if( namelist[NM_STATES].n_value == 0 )
E 14
I 14
	if( namelist[NM_STATES].n_value == 0 ) {
		printf("Time in CPU states is not available.\n");
E 14
		op->opt_state = op->opt_disk = op->opt_tty = 0 ;
I 14
	}
E 14

D 14
	if( namelist[NM_LOADAVE].n_value == 0 )
		op->opt_loadave = 0 ;

	if( namelist[NM_FORK].n_value == 0 )
		op->opt_fork = 0 ;

E 14
	/*
	 *	We'll used dk_busy to determine if the disk I/O info
	 *	is available.
	 */
D 14
	if( namelist[NM_DK_BUSY].n_value == 0 )
E 14
I 14
	if( namelist[NM_DK_BUSY].n_value == 0 ) {
		printf("Disk I/O data is not available.\n");
E 14
		op->opt_disk = 0 ;
I 14
	}
E 14

D 14
	if( !namelist[NM_TTY_IN].n_value || !namelist[NM_TTY_OUT].n_value )
E 14
I 14
	if( !namelist[NM_TTY_IN].n_value || !namelist[NM_TTY_OUT].n_value ) {
		printf("TTY I/O data is not available.\n");
E 14
		op->opt_tty = 0 ;
I 14
	}
E 14

	/*
	 *	Check some of the static namelist elements to determine
	 *	what options need to be turned off.
	 */
D 14
	if( !namelist[NM_UBDINIT].n_value && !namelist[NM_MBDINIT].n_value )
E 14
I 14
	if( !namelist[NM_UBDINIT].n_value && !namelist[NM_MBDINIT].n_value ) {
		printf("Disk I/O data is not available.\n");
E 14
		op->opt_disk = 0 ;
I 14
	}
E 14

D 14
	if( !namelist[NM_UBDINIT].n_value && !namelist[NM_MBSINIT].n_value )
E 14
I 14
	if( !namelist[NM_UBDINIT].n_value && !namelist[NM_MBSINIT].n_value ) {
		printf("Tape I/O data is not available.\n");
E 14
		op->opt_tape = 0 ;
I 14
	}
E 14

D 14
	if( namelist[NM_IFNET].n_value == 0 )
E 14
I 14
	if( namelist[NM_IFNET].n_value == 0 ) {
		printf("Network interface data is not available.\n");
E 14
		op->opt_netif = 0 ;
D 14

	if( namelist[NM_HZ].n_value == 0 )
		op->opt_cpu = op->opt_tty = op->opt_disk = 0 ;	
E 14
I 14
	}
E 14
}

/*
 *	This is where we check opt_... to turn off data that we don't
 *	need.
 */
check_options(op)
OPTION	*op ;
{
D 14
	if( op->opt_loadave == 0 ) {
		printf("monitor: Turning off %s.\n", "LOADAVE");
E 14
I 14
	if( op->opt_loadave == 0 )
E 14
		dynamic[NM_LOADAVE].flag = 0 ;
D 14
	}
E 14

D 14
	if( op->opt_netif == 0 ) {
		printf("monitor: Turning off %s.\n", "IFNET");
E 14
I 14
	if( op->opt_netif == 0 )
E 14
		dynamic[NM_IFNET].flag = 0 ;
D 14
	}
E 14

D 14
	if( op->opt_free == 0 ) {
		printf("monitor: Turning off %s.\n", "FREE");
E 14
I 14
	if( op->opt_free == 0 )
E 14
		dynamic[NM_FREE].flag = 0 ;
D 14
	}
E 14

D 14
	if( op->opt_proc == 0 && op->opt_memory == 0 ) {
		printf("monitor: Turning off %s.\n", "TOTAL");
E 14
I 14
	if( op->opt_proc == 0 && op->opt_memory == 0 )
E 14
		dynamic[NM_TOTAL].flag = 0 ;
D 14
	}
E 14

D 8
	if( op->opt_disk == 0 && op->opt_tty == 0 && op->opt_state == 0 ) {
E 8
I 8
D 14
	if( op->opt_disk == 0 && op->opt_tty == 0 ) {
E 8
		printf("monitor: Turning off %s.\n", "STATES");
E 14
I 14
	if( op->opt_disk == 0 && op->opt_tty == 0 )
E 14
		dynamic[NM_STATES].flag = 0 ;
D 14
	}
E 14

D 14
	if( op->opt_page == 0 && op->opt_cpu == 0 ) {
		printf("monitor: Turning off %s.\n", "PAGE");
E 14
I 14
	if( op->opt_page == 0 && op->opt_cpu == 0 )
E 14
		dynamic[NM_PAGE].flag = 0 ;
D 14
	}
E 14

D 14
	if( op->opt_page == 0 ) {
		printf("monitor: Turning off %s.\n", "DEFICIT");
E 14
I 14
	if( op->opt_page == 0 )
E 14
		dynamic[NM_DEFICIT].flag = 0 ;
D 14
	}
E 14

	if( op->opt_disk == 0 ) {
D 14
		printf("monitor: Turning off %s.\n", "DK*");
E 14
		dynamic[NM_DK_BUSY].flag = dynamic[NM_DK_TIME].flag = 0 ;
		dynamic[NM_DK_SEEK].flag = dynamic[NM_DK_XFER].flag = 0 ;
D 16
		dynamic[NM_DK_WDS].flag = dynamic[NM_DK_MSPW].flag = 0 ;
E 16
I 16
		dynamic[NM_DK_WDS].flag = 0 ;
E 16
	}

D 14
	if( op->opt_tty == 0 ) {
		printf("monitor: Turning off %s.\n", "TTY*");
E 14
I 14
	if( op->opt_tty == 0 )
E 14
		dynamic[NM_TTY_IN].flag = dynamic[NM_TTY_OUT].flag = 0 ;
D 14
	}
E 14

D 14
	if( op->opt_fork == 0 ) {
		printf("monitor: Turning off %s.\n", "FORK");
E 14
I 14
	if( op->opt_fork == 0 )
E 14
		dynamic[NM_FORK].flag = 0 ;
D 14
	}
E 14
}
D 10
/*
 *	The purpose of the previous two functions is to perform a large
 *	consistancy check.
 *
 *	There are many ways to look at the previous two functions.
 *
 *	One the one hand if a particular kernel address isn't there
 *	it may indicate greater problems.  Some kernel data structures
 *	may be "dynamically" configured.
 */
E 10
E 7
E 2
E 1
