h62625
s 00010/00000/00252
d D 1.7 90/03/29 16:17:15 alan 7 6
c The hack to fix the DECmumble include file problem.
e
s 00010/00010/00242
d D 1.6 89/04/19 11:24:07 alan 6 5
c remove ()'s from display
e
s 00002/00002/00250
d D 1.5 89/03/11 17:27:18 alan 5 4
c another editorial change
e
s 00002/00002/00250
d D 1.4 89/03/11 17:23:43 alan 4 3
c editorial change
e
s 00044/00043/00208
d D 1.3 89/03/11 16:00:31 alan 3 2
c changed the structure of mon_fork and the other changes that required
e
s 00082/00039/00169
d D 1.2 89/03/07 17:50:45 alan 2 1
c bug fixes
e
s 00208/00000/00000
d D 1.1 89/02/26 13:53:09 alan 1 0
c date and time created 89/02/26 13:53:09 by alan
e
u
U
t
T
I 1
/*
 *	Author:  Alan Rollow, CSC/CS, Digital Equipment Corp.
 *	File:	 %M%
 *	Date:	 %G%
 *	Version: %I%
 *
 *	%M% - Functions to handle the fork data.
 */
#ifndef	lint
static	char	SccsId[] = "%W% (monitor) %G%" ;
#endif

/*
 * Modification history.
I 2
 *
 * Mar. 6, 1989 -- arr
 *
 *	Redesign magnification screen.
I 3
 *
 * March 11, 1989 -- arr
 *
 *	Changes needed for change to mon_fork structure in monitor.h.
I 7
 *
 * Mar. 26, 1990 -- arr
 *
 *	Added hack to work-around DECmumble include file problem.
 *
E 7
E 3
E 2
 */

#include <nlist.h>
#include <stdio.h>
#include <signal.h>
#include <curses.h>

#include <sys/types.h>
#include <sys/dk.h>
#include <sys/param.h>
#include <sys/dir.h>
I 7

#if defined(V4_ULTRIX) && defined(mips)
#	include <mips/cpu.h>
#endif

E 7
#include <sys/user.h>
#include <sys/buf.h>
#include <sys/file.h>
#include <sys/socket.h>
#include <sys/vmsystm.h>
#include <sys/vmmeter.h>

#include <net/if.h>
#include <netinet/in.h>

#include "include.h"
#include "options.h"
#include "monitor.h"
#include "extern.h"

/*
 *	Each magnify function has to remember when it was last run
 *	so that it can maintain the correct elapsed time.
 *
 *	These will need to be external and have to be reset for
 *	session being replayed.
 */
int	fork_ticks = 0 ;
D 3
struct  forkstat old_fork = {
		0, 0, 0, 0
};
E 3
I 3
struct  mon_fork old_fork ;
E 3

D 3

E 3
/*
 *	Default display.
 */
extern	int	lines ;		/* length of the screen being used. */
extern	WINDOW	*wp ;

/*
 *	Calculate the change in the interesting fork stats.
 */
double	delta_fork(ticks)
int	ticks ;
{
	register t ;
D 3
	register struct forkstat *p = &mon_fork.mon_fork ;
E 3
	double	 etime ;

	etime = (double)(ticks - fork_ticks)/first.mon_hz ;

D 3
	t = p->cntfork ; 
	    p->cntfork -= old_fork.cntfork ;
	    old_fork.cntfork = t ;
E 3
I 3
	t = mon_fork.mon_fork ;
	    mon_fork.mon_fork -= old_fork.mon_fork ;
	    old_fork.mon_fork = t ;
E 3

D 3
	t = p->cntvfork ; 
	    p->cntvfork -= old_fork.cntvfork ;
	    old_fork.cntvfork = t ;
E 3
I 3
	t = mon_fork.mon_vfork ; 
	    mon_fork.mon_vfork -= old_fork.mon_vfork ;
	    old_fork.mon_vfork = t ;
E 3

D 3
	t = p->sizfork ;
	    p->sizfork -= old_fork.sizfork ;
	    old_fork.sizfork = t ;
E 3
I 3
	t = mon_fork.mon_fork_size ;
	    mon_fork.mon_fork_size -= old_fork.mon_fork_size ;
	    old_fork.mon_fork_size = t ;
E 3

D 3
	t = p->sizvfork ;
	    p->sizvfork -= old_fork.sizvfork ;
	    old_fork.sizvfork = t ;
E 3
I 3
	t = mon_fork.mon_vfork_size ;
	    mon_fork.mon_vfork_size -= old_fork.mon_vfork_size ;
	    old_fork.mon_vfork_size = t ;
E 3

	fork_ticks = ticks ;

	return etime ;
}
/*
 *	Constants for the placement of the FORK data.
 */
D 2
#define	FORK_OFFSET	(29)
#define	FORK_TOTAL	(3)
#define	FORK_AVERAGE	(8)
#define	FORK_DELTA	(11)
E 2
I 2
D 6
#define	FORK_OFFSET	 (22)
#define	FORK_OFFSET_RATE (38)
E 6
I 6
#define	FORK_OFFSET	 (20)
#define	FORK_OFFSET_RATE (36)
E 6
#define	FORK_BOOT	 (5)
#define	FORK_SAMPLE	 (13)
E 2

D 2
#define	FORK_LINES	(16)
E 2
I 2
#define	FORK_LINES	(19)
E 2

/*
 *	Functions for doing fork stats.
 *
 *	ARGSUSED
 */
open_fork(op)
OPTION	*op ;
{
	sample_header() ;

	lines = FORK_LINES ;

D 2
	wprintw(wp, "Total fork()'s:\n");
	wprintw(wp, "Total vfork()'s:\n");
	wprintw(wp, "Total size of fork()'s:      %10d Kb.\n", 0);
	wprintw(wp, "Total size of vfork()'s:     %10d Kb.\n\n", 0);
E 2
I 2
D 3
	wprintw(wp, "Fork statistics since system booted.\n\n") ;
E 3
I 3
D 4
	wprintw(wp, "mon_fork statistics since system booted.\n\n") ;
E 4
I 4
	wprintw(wp, "Fork statistics since the system booted.\n\n") ;
E 4
E 3
E 2

D 2
	wprintw(wp, "Average size of fork():      %10.2f Kb.\n", 0);
	wprintw(wp, "Average size of vfork():     %10.2f Kb.\n\n", 0);
E 2
I 2
D 6
	wprintw(wp, "Number of fork()'s:   %10d      %10.3f / second\n", 0, 0);
	wprintw(wp, "Size of fork()'s:     %10d Kb.  %10.3f Kb. / fork\n\n", 0, 0);
E 6
I 6
	wprintw(wp, "Number of fork's:   %10d      %10.3f / second\n", 0, 0);
	wprintw(wp, "Size of fork's:     %10d Kb.  %10.3f Kb. / fork\n\n", 0, 0);
E 6
E 2

D 2
	wprintw(wp, "Change in fork()'s:\n");
	wprintw(wp, "Change in vfork()'s:\n");
	wprintw(wp, "Change in size of fork()'s:  %10d Kb.\n", 0);
	wprintw(wp, "Change in size of vfork()'s: %10d Kb.", 0);
E 2
I 2
D 6
	wprintw(wp, "Number of vfork()'s:  %10d      %10.3f / second\n", 0, 0);
	wprintw(wp, "Size of vfork()'s:    %10d Kb.  %10.3f Kb. / vfork\n\n", 0, 0);
E 6
I 6
	wprintw(wp, "Number of vfork's:  %10d      %10.3f / second\n", 0, 0);
	wprintw(wp, "Size of vfork's:    %10d Kb.  %10.3f Kb. / vfork\n\n", 0, 0);
E 6

D 3
	wprintw(wp, "Fork statistics for this sample.\n\n") ;
E 3
I 3
D 4
	wprintw(wp, "mon_fork statistics for this sample.\n\n") ;
E 4
I 4
	wprintw(wp, "Fork statistics for this sample.\n\n") ;
E 4
E 3

D 6
	wprintw(wp, "Number of fork()'s:   %10d      %10.3f / second\n", 0, 0);
	wprintw(wp, "Size of fork()'s:     %10d Kb.  %10.3f Kb. / fork\n\n", 0, 0);
E 6
I 6
	wprintw(wp, "Number of fork's:   %10d      %10.3f / second\n", 0, 0);
	wprintw(wp, "Size of fork's:     %10d Kb.  %10.3f Kb. / fork\n\n", 0, 0);
E 6

D 6
	wprintw(wp, "Number of vfork()'s:  %10d      %10.3f / second\n", 0, 0);
	wprintw(wp, "Size of vfork()'s:    %10d Kb.  %10.3f Kb. / vfork\n\n", 0, 0);
E 6
I 6
	wprintw(wp, "Number of vfork's:  %10d      %10.3f / second\n", 0, 0);
	wprintw(wp, "Size of vfork's:    %10d Kb.  %10.3f Kb. / vfork\n\n", 0, 0);
E 6

E 2
}

/*
 *	ARGSUSED
 */
magnify_fork(op)
OPTION	*op ;
{
D 2
	double	etime ;
E 2
I 2
	double	etime = sample.mon_ticks / first.mon_hz ;
	double	fork_size, vfork_size ;
E 2

	/*
D 2
	 *	The fork totals.
E 2
I 2
	 *	Guard against division by zero.
E 2
	 */
D 2
	wmove(wp, FORK_TOTAL, FORK_OFFSET) ;
	wprintw(wp, "%10d", Fork.cntfork);
E 2
I 2
D 3
	if( Fork.cntfork == 0 )
E 3
I 3
	if( mon_fork.mon_fork == 0 )
E 3
		fork_size = 0.0 ;
	else
D 3
		fork_size = pgtok(Fork.sizfork) / Fork.cntfork ;
E 3
I 3
		fork_size = pgtok(mon_fork.mon_fork_size) / mon_fork.mon_fork ;
E 3
E 2

D 2
	wmove(wp, FORK_TOTAL + 1, FORK_OFFSET) ;
	wprintw(wp, "%10d", Fork.cntvfork);
E 2
I 2
D 3
	if( Fork.cntvfork == 0 )
E 3
I 3
	if( mon_fork.mon_vfork == 0 )
E 3
		vfork_size = 0.0 ;
	else
D 3
		vfork_size = pgtok(Fork.sizvfork) / Fork.cntvfork ;
E 3
I 3
		vfork_size = pgtok(mon_fork.mon_vfork_size) / mon_fork.mon_vfork ;
E 3
E 2

D 2
	wmove(wp, FORK_TOTAL + 2, FORK_OFFSET) ;
	wprintw(wp, "%10d", pgtok(Fork.sizfork));
E 2
I 2
	if( etime == 0.0 )
		etime = 1.0 ;
E 2

D 2
	wmove(wp, FORK_TOTAL + 3, FORK_OFFSET) ;
	wprintw(wp, "%10d", pgtok(Fork.sizvfork));

E 2
	/*
D 2
	 *	The running average.
E 2
I 2
	 *	The fork totals.
E 2
	 */
D 2
	wmove(wp, FORK_AVERAGE, FORK_OFFSET) ;
	wprintw(wp, "%10.2f", (double)pgtok(Fork.sizfork) / Fork.cntfork);
E 2
I 2
	wmove(wp, FORK_BOOT, FORK_OFFSET) ;
	wprintw(wp, "%10d      %10.3f / second\n",
D 3
		Fork.cntfork, (double)Fork.cntfork / etime);
E 3
I 3
		mon_fork.mon_fork, (double)mon_fork.mon_fork / etime);
E 3
E 2

D 2
	wmove(wp, FORK_AVERAGE + 1, FORK_OFFSET) ;
	wprintw(wp, "%10.2f", (double)pgtok(Fork.sizvfork) / Fork.cntvfork);
E 2
I 2
	wmove(wp, FORK_BOOT + 1, FORK_OFFSET) ;
	wprintw(wp, "%10d Kb.  %10.3f Kb. / fork\n\n",
D 3
		pgtok(Fork.sizfork), fork_size);
E 3
I 3
		pgtok(mon_fork.mon_fork_size), fork_size);
E 3
E 2

I 2
	wmove(wp, FORK_BOOT + 3, FORK_OFFSET) ;
	wprintw(wp, "%10d      %10.3f / second\n",
D 3
		Fork.cntvfork, (double)Fork.cntvfork / etime);
E 3
I 3
		mon_fork.mon_vfork, (double)mon_fork.mon_vfork / etime);
E 3

	wmove(wp, FORK_BOOT + 4, FORK_OFFSET) ;
	wprintw(wp, "%10d Kb.  %10.3f Kb. / vfork\n\n",
D 3
		pgtok(Fork.sizvfork), vfork_size);
E 3
I 3
		pgtok(mon_fork.mon_vfork_size), vfork_size);
E 3

E 2
	/*
	 *	The amount of change since the last sample.
	 */
	etime = delta_fork(sample.mon_ticks) ;

D 2
	wmove(wp, FORK_DELTA, FORK_OFFSET) ;
	wprintw(wp, "%10d", Fork.cntfork);
E 2
I 2
	/*
	 *	Guard against division by zero.
	 */
D 3
	if( Fork.cntfork == 0 )
E 3
I 3
	if( mon_fork.mon_fork == 0 )
E 3
		fork_size = 0.0 ;
	else
D 3
		fork_size = pgtok(Fork.sizfork) / Fork.cntfork ;
E 3
I 3
		fork_size = pgtok(mon_fork.mon_fork_size) / mon_fork.mon_fork ;
E 3
E 2

D 2
	wmove(wp, FORK_DELTA + 1, FORK_OFFSET) ;
	wprintw(wp, "%10d", Fork.cntvfork);
E 2
I 2
D 3
	if( Fork.cntvfork == 0 )
E 3
I 3
	if( mon_fork.mon_vfork == 0 )
E 3
		vfork_size = 0.0 ;
	else
D 3
		vfork_size = pgtok(Fork.sizvfork) / Fork.cntvfork ;
E 3
I 3
		vfork_size = pgtok(mon_fork.mon_vfork_size) / mon_fork.mon_vfork ;
E 3
E 2

D 2
	wmove(wp, FORK_DELTA + 2, FORK_OFFSET) ;
	wprintw(wp, "%10d", pgtok(Fork.sizfork));
E 2
I 2
	if( etime == 0.0 )
		etime = 1.0 ;
E 2

D 2
	wmove(wp, FORK_DELTA + 3, FORK_OFFSET) ;
	wprintw(wp, "%10d", pgtok(Fork.sizvfork));
E 2
I 2
	/*
	 *	The fork totals.
	 */
	wmove(wp, FORK_SAMPLE, FORK_OFFSET) ;
	wprintw(wp, "%10d      %10.3f / second\n",
D 3
		Fork.cntfork, (double)Fork.cntfork / etime);
E 3
I 3
		mon_fork.mon_fork, (double)mon_fork.mon_fork / etime);
E 3

	wmove(wp, FORK_SAMPLE + 1, FORK_OFFSET) ;
	wprintw(wp, "%10d Kb.  %10.3f Kb. / fork\n\n",
D 3
		pgtok(Fork.sizfork), fork_size);
E 3
I 3
		pgtok(mon_fork.mon_fork_size), fork_size);
E 3

	wmove(wp, FORK_SAMPLE + 3, FORK_OFFSET) ;
	wprintw(wp, "%10d      %10.3f / second\n",
D 3
		Fork.cntvfork, (double)Fork.cntvfork / etime);
E 3
I 3
		mon_fork.mon_vfork, (double)mon_fork.mon_vfork / etime);
E 3

	wmove(wp, FORK_SAMPLE + 4, FORK_OFFSET) ;
	wprintw(wp, "%10d Kb.  %10.3f Kb. / vfork\n\n",
D 3
		pgtok(Fork.sizvfork), vfork_size);
E 3
I 3
		pgtok(mon_fork.mon_vfork_size), vfork_size);
E 3
E 2

	sample_body(etime) ;
}


/*
 *	Initialize whatever static counters need to be initialized.
 */
setup_fork()
{
D 3
	old_fork.cntfork = 0 ;
	old_fork.cntvfork = 0 ;
	old_fork.sizfork = 0 ;
	old_fork.sizvfork = 0 ;
E 3
I 3
	old_fork.mon_fork = 0 ;
	old_fork.mon_vfork = 0 ;
	old_fork.mon_fork_size = 0 ;
	old_fork.mon_vfork_size = 0 ;

E 3
	fork_ticks = 0 ;
}

/*
 *	Function to dump the contents of the FORK record.
 */
f_fork(p)
struct mon_fork *p ;
{
	if((p->mon_flag & MON$M_VALID) == 0 )
		return ;

	printf("%s.\n", records[MON$C_FORK].string) ;

D 3
	printf("\tcntfork:  %d\n", p->mon_fork.cntfork);
	printf("\tcntvfork: %d\n", p->mon_fork.cntvfork);
	printf("\tsizfork:  %d Kb.\n", pgtok(p->mon_fork.sizfork));
	printf("\tsizvfork: %d Kb.\n", pgtok(p->mon_fork.sizvfork));
E 3
I 3
D 5
	printf("\tmon_fork:  %d\n", p->mon_fork);
	printf("\tmon_vfork: %d\n", p->mon_vfork);
E 5
I 5
	printf("\tmon_fork:       %d\n", p->mon_fork);
	printf("\tmon_vfork:      %d\n", p->mon_vfork);
E 5
	printf("\tmon_fork_size:  %d Kb.\n", pgtok(p->mon_fork_size));
	printf("\tmon_vfork_size: %d Kb.\n", pgtok(p->mon_vfork_size));
E 3
}
E 1
