h48366
s 00010/00000/00093
d D 1.6 90/03/29 16:17:13 alan 6 5
c The hack to fix the DECmumble include file problem.
e
s 00045/00009/00048
d D 1.5 89/05/09 18:56:47 alan 5 4
c added code to FP conversion
e
s 00011/00000/00046
d D 1.4 89/04/19 12:55:32 alan 4 3
c convert load averages to less reasonable values
e
s 00002/00001/00044
d D 1.3 89/03/09 21:08:38 alan 3 2
c reorder local include files to satisify VAXC
e
s 00003/00000/00042
d D 1.2 89/01/29 10:04:03 alan 2 1
c dusted off lint
e
s 00042/00000/00000
d D 1.1 89/01/17 22:35:02 alan 1 0
c date and time created 89/01/17 22:35:02 by alan
e
u
U
t
T
I 1
/*
 *	Author:  Alan Rollow, EIS/CXO, Digital Equipment Corp.
 *	File:	 %M%
 *	Date:	 %G%
 *	Version: %I%
 *
 *	%M% - Handle floating point conversions.
 */
#ifndef	lint
static	char	SccsId[] = "%W% (monitor) %G%" ;
#endif

I 5
/*
 * Modification history.
 *
 * May 9, 1989 -- arr
 *
 *	Added code to use VAX/IEEE floating point conversion functions.
I 6
 *
 * Mar. 26, 1990 -- arr
 *
 *	Added hack to work-around DECmumble include file problem.
 *
E 6
 */

E 5
#include <nlist.h>
#include <stdio.h>
#include <signal.h>

#include <sys/types.h>
#include <sys/dk.h>
#include <sys/buf.h>
#include <sys/file.h>
#include <sys/socket.h>
#include <sys/vmsystm.h>
#include <sys/vmmeter.h>

#include <sys/dir.h>
I 6

#if defined(V4_ULTRIX) && defined(mips)
#	include <mips/cpu.h>
#endif

E 6
#include <sys/param.h>
#include <sys/user.h>

#include <net/if.h>
#include <netinet/in.h>

#include "monitor.h"
D 3
#include "extern.h"
E 3
#include "options.h"
I 3
#include "include.h"
#include "extern.h"
E 3

/*
I 2
D 5
 *	To be filled in when I see the documentation on the
 *	floating point conversion routines.
E 2
 *
I 2
 *	ARGSUSED
E 5
I 5
 *	Local data used by the panic function.
E 5
E 2
 */
I 5
static	char	*module = "float" ;

/*
 *	Depending on the architecture of the data a pair of floating
 *	point conversion functions are chosen, one for D float/IEEE
 *	double (LOADAVE) and one for F float/IEEE single (DISK).
 */
E 5
convert_fp(op)
OPTION	*op ;
{
I 4
	register i ;
I 5
	double	 dtoi(), itod(), ftoi(), itof() ;
	double	 (*disk_filter)(), (*load_filter)() ;
E 5

	/*
D 5
	 *	This isn't the right thing to do, but the VAX
	 *	load average gives an excessive number on the
	 *	MIPS.  By using a loadave of -1 it's clear that
	 *	this isn't a normal value.
E 5
I 5
	 *	Choose the right function to do the data conversion.
E 5
	 */
I 5
	if( first.mon_arch == MON$C_VAX ) {	/* convert D/F Float to IEEE */
		load_filter = dtoi ;
		disk_filter = ftoi ;
	}
	else if( first.mon_arch == MON$C_MIPS ) { /* convert IEEE to D/F float */
		load_filter = itod ;
		disk_filter = itof ;
	}
	else
		panic("Unknown architecture!\n", module) ;
		
	/*
	 *	Convert the load averages.  If the number can't be
	 *	converted for some reason, use -1.
	 */
E 5
	if( op->opt_loadave )
		for(i = 0; i < MON$N_LOADAVE; i++)
D 5
			loadave.mon_loadave[i] = -1.0 ;
E 5
I 5
			if((*load_filter)(&loadave.mon_loadave[i]) == -1 )
				loadave.mon_loadave[i] = -1.0 ;

	/*
	 *	Convert the disk data.  If the value can't be converted
	 *	use 0.0.
	 */
	if( op->opt_disk )
		for(i = 0; i < first.mon_disk; i++)
			if((*disk_filter)(&disk[i].mon_mspw) == -1 )
				disk[i].mon_mspw = 0.0 ;
E 5
E 4
}
E 1
