h36146
s 00004/00033/00094
d D 1.2 87/11/26 15:23:04 alan 2 1
c remove monitor specific code from error.c
e
s 00127/00000/00000
d D 1.1 87/11/26 15:20:58 alan 1 0
c date and time created 87/11/26 15:20:58 by alan
e
u
U
t
T
I 1
/*
 *	Author:  Alan Rollow, CSC/CS, Digital Equipment Corp.
 *	File:	 %M%
 *	Date:	 %G%
 *	Version: %I%
 *
 *	%M% - Print error messages.
 *
 *	All error messages will have the form:
 *
 *		program_name: module: text.
 *
 *	"Program_name" will be set at the beginning of the options
 *	processing.  "Module" will be the 2nd argument passed.
 */
#ifndef	lint
static	char	SccsId[] = "%W% (monitor) %G%" ;
#endif

#include <stdio.h>
D 2
#include <curses.h>
E 2

D 2
#include "options.h"

E 2
/*
 *	Functions that don't return an (int).
 */
void	exit(),
	abort(),
	sleep() ;

/*
 *	Value of argv[0] to be printed with error messages.
 */
char	*program_name ;

/*
 *	Magick to keep lk(1) happy.
 */
#ifdef	vaxc
globalref readonly char *sys_errlist[] ;
#else
extern	char	*sys_errlist[] ;
#endif

extern	int	errno ;
D 2
extern	OPTION	option ;
extern	WINDOW	*wp ;			/* display options */
E 2

/*
 *	Fatal error messages are expected to have a system 
 *	error message associated with them and cause monitor 
 *	to exit.
 *
 * 	VARARGS
 */
fatal(format, module, arg)
char	*format, *module, *arg ;
{
	fprintf(stderr, "%s: %s: ", program_name, module) ;
	fprintf(stderr, format, sys_errlist[errno], arg);

D 2
	if( option.opt_curses )
		cleanup_screen() ;

E 2
	exit(errno);
}

/*
 *	Warning error messages are expected to have a system
 *	error message associated with them.  They do not cause
 *	monitor to exit.
 *
 * 	VARARGS
 */
warning(format, module, arg)
char	*format, *module, *arg ;
{
D 2
	if( option.opt_curses ) {
		wmove(wp, LINES - 1, 0) ;
		wprintw(wp, "%s: %s: ", program_name, module) ;
		wprintw(wp, format, sys_errlist[errno], arg);
		wrefresh(wp) ;
		sleep(1);
	}
	else {
		fprintf(stderr, "%s: %s: ", program_name, module) ;
		fprintf(stderr, format, sys_errlist[errno], arg);
	}
E 2
I 2
	fprintf(stderr, "%s: %s: ", program_name, module) ;
	fprintf(stderr, format, sys_errlist[errno], arg);
E 2
}

/*
 *	Info is like warning except it doesn't print system
 *	error messages.
 *
 *	VARARGS
 */
info(format, module, arg1, arg2, arg3)
char	*format, *module, *arg1 ;
{
D 2
	if( option.opt_curses ) {
		wmove(wp, LINES - 1, 0) ;
		wprintw(wp, "%s: %s: ", program_name, module) ;
		wprintw(wp, format, arg1, arg2, arg3);
		wrefresh(wp) ;
		sleep(1);
	}
	else {
		fprintf(stderr, "%s: %s: ", program_name, module) ;
		fprintf(stderr, format, arg1, arg2, arg3);
	}
E 2
I 2
	fprintf(stderr, "%s: %s: ", program_name, module) ;
	fprintf(stderr, format, arg1, arg2, arg3);
E 2
}

/*
 *	A panic occurs when some impossible condition occurs.
 */
panic(message, module)
char	*message, *module ;
{
	fprintf(stderr, "%s: %s: ", program_name, module) ;
	fprintf(stderr, message);
D 2

	if( option.opt_curses )
		cleanup_screen() ;
E 2

	abort();
}
E 1
