h46358
s 00010/00000/00190
d D 1.26 90/03/29 16:16:21 alan 26 25
c The hack to fix the DECmumble include file problem.
e
s 00011/00001/00179
d D 1.25 88/06/27 18:14:18 alan 25 24
c changed include of monitor.h and record.h
e
s 00001/00001/00179
d D 1.24 87/09/14 18:55:49 alan 24 23
c see V0.96 in version.c for details
e
s 00006/00000/00174
d D 1.23 87/08/10 21:27:07 alan 23 22
c See commentary on V0.92 in version.c
e
s 00013/00008/00161
d D 1.22 87/05/20 17:14:43 alan 22 21
c changed all curses calls to use w... versions
e
s 00015/00006/00154
d D 1.21 87/04/17 15:47:08 alan 21 20
c Changed all calls to curses to use the 'w' version of the function.  Currently
c all of these write to the 'stdscr'.  This will changed in the next delta.
c 
e
s 00007/00006/00153
d D 1.20 87/04/03 14:31:41 alan 20 19
c 1.  Mostly rearranged include files so that the sources would compile
c     using VAXC.
c 2.  Changed an error monitor that pcc let get by.
c 
e
s 00000/00004/00159
d D 1.19 87/02/05 16:27:22 alan 19 18
c See comment on V0.81 in version.c.
c 
e
s 00013/00010/00150
d D 1.18 87/01/30 20:49:21 alan 18 17
c see commentary for V0.77 in version.c
c 
e
s 00007/00005/00153
d D 1.17 87/01/30 16:09:17 alan 17 16
c See commenary on V0.76 in version.c
e
s 00022/00026/00136
d D 1.16 87/01/30 10:16:36 alan 16 15
c fixes to delta_disk()
e
s 00004/00000/00158
d D 1.15 87/01/21 16:35:11 alan 15 14
c This is the first pass at makeing changes to record.h.  The intent of
c this delta is to change record.h and update the files that broke so
c that they will compile and a runnable version is produced.  This
c version may not run correctly.  A few other changes were added at
c same time, which were related to the changes to record.h.  See the
c commentary on V0.68 in version.c.  The next couple of deltas will
c be clean up this one.
c 
e
s 00007/00001/00151
d D 1.14 87/01/14 12:35:06 alan 14 13
c see comment on V0.66 in version.c
e
s 00038/00019/00114
d D 1.13 86/12/07 22:23:06 alan 13 12
c See V0.57 in version.c
e
s 00001/00001/00132
d D 1.12 86/09/24 19:33:10 alan 12 11
c comment change
e
s 00001/00001/00132
d D 1.11 86/08/26 18:04:37 alan 11 10
c modify all SccsId strings
e
s 00008/00024/00125
d D 1.10 86/07/29 13:51:49 alan 10 9
c turn cpu, disk and tape into arrays
e
s 00009/00001/00140
d D 1.9 86/07/25 14:51:32 alan 9 8
c Fixed bug that was causeing magnify function to walk off the end of the
c arrays in replay-mode.
c 
c This is bug is another example of why I should rewrite the disk, tape, netif
c and cpu lists to be array's everywhere.  For disk and tape I can statically
c allocate space for the data structures, for cpu's I can dynamically allocate
c based on the size of _cpudata and for netif's I can make two passes on the
c internal list, one quick pass to size the list and the other to fill the
c static info.
c 
e
s 00002/00000/00139
d D 1.8 86/07/11 19:32:31 alan 8 7
c Dust off LOTS of lint...
c 
e
s 00055/00000/00084
d D 1.7 86/07/03 09:31:25 alan 7 6
c flesh out code for magnify_disk
e
s 00020/00000/00064
d D 1.6 86/07/01 17:10:57 alan 6 5
c add prototype function for doing magnifyy and open
e
s 00005/00003/00059
d D 1.5 86/06/24 08:35:01 alan 5 4
c Move the various version of mon_etime into the sample record.
c 
e
s 00001/00001/00061
d D 1.4 86/05/29 17:41:13 alan 4 3
c Fix bug that was causeing seek time to appear as zero
c 
e
s 00020/00016/00042
d D 1.3 86/05/29 13:12:50 alan 3 2
c Changed arguments being passed and what it actually does.
c calculate_disk(), now calculates kbps, tps and msps.  These are passwd
c back and forth by reference.
c 
e
s 00019/00002/00039
d D 1.2 86/05/26 13:39:20 alan 2 1
c Move to code that actually calculates interesting disk from screen.c to disk.c
c 
e
s 00041/00000/00000
d D 1.1 86/05/26 13:27:54 alan 1 0
c date and time created 86/05/26 13:27:54 by alan
e
u
U
t
T
I 1
/*
 *	Author:  Alan Rollow, CSC/CS, Digital Equipment Corp.
 *	File:	 %M%
 *	Date:	 %G%
 *	Version: %I%
 *
D 13
 *	%M% - Based the information in the mon_disk structure calculate
D 12
 *	      The things of interest.
E 12
I 12
 *	the things of interest.
E 13
I 13
 *	%M% - Based the information in the mon_disk structure
 *	calculate the things of interest.
E 13
E 12
 *
D 3
 *	calculate_disk(p, hz, words, idle_time)
E 3
I 3
D 18
 *	calculate_disk(p, kbps, tps, msps)
E 3
 *	struct mon_disk *p ;
D 3
 *	int	hz ;
 *	double	*words, *idle_time ;
E 3
I 3
 *	double	*kbps, *tps, *msps ;
E 18
I 18
 *	calculate_disk(index, kbps, tps, msps)
 *	int	index ;
 *	double	*kbps, *tps ;
 *	int	*msps ;
E 18
I 13
 *
 *	kbps - Kilobytes transfered per second.
 *	tps  - Transfers per second.
D 18
 *	msps - Milli/micro seconds per seek.
E 18
I 18
 *	msps - Milli/micro seconds per seek (or transfer on DSA disks).
E 18
E 13
E 3
 */
#ifndef	lint
D 11
static	char	SccsId[] = "%W% %G%" ;
E 11
I 11
D 13
static	char	SccsId[] = "%W%	(monitor)	%G%" ;
E 13
I 13
static	char	SccsId[] = "%W%	(monitor) %G%" ;
E 13
E 11
#endif

I 25
/*
 * Modification History
 * 
 * 27-June-1988 -- arr
 *
 *	Change include of monitor.h to include.h.
 *
 *	Change include of record.h to monitor.h.
I 26
 *
 * Mar. 26, 1990 -- arr
 *
 *	Added hack to work-around DECmumble include file problem.
 *
E 26
 */

E 25
#include <stdio.h>
#include <signal.h>
I 6
#include <curses.h>
I 20
#include <nlist.h>
E 20
E 6

#include <sys/types.h>
#include <sys/dk.h>
I 15
#include <sys/param.h>
#include <sys/dir.h>
I 26

#if defined(V4_ULTRIX) && defined(mips)
#	include <mips/cpu.h>
#endif

E 26
#include <sys/user.h>
D 16
#include <sys/devio.h>
E 16
E 15
#include <sys/buf.h>
D 2
#include <sys/file.h>
E 2
#include <sys/socket.h>
#include <sys/vmsystm.h>
#include <sys/vmmeter.h>

#include <net/if.h>
#include <netinet/in.h>

I 16
D 19
#ifdef	V20
#	include <sys/devio.h>
#endif

E 19
E 16
D 2
#include "extern.h"
E 2
D 25
#include "record.h"
E 25
I 3
#include "monitor.h"
I 25
#include "include.h"
E 25
D 20
#include "extern.h"
E 20
I 6
#include "options.h"
I 20
#include "extern.h"
E 20
E 6
E 3

I 8
D 13
char	*ctime() ;

E 13
I 13
/*
I 22
 *	Default display.
 */
I 23
extern	int	lines ;		/* length of screen being used */
E 23
extern	WINDOW	*wp ;

/*
E 22
 *	Given an address to a mon_disk structure calculate:
 *
 *		kbps - Kilobytes per second.
 *		tps  - Transfers per second.
 *		msps - Milliseconds per seek.
 */
E 13
E 8
D 3
calculate_disk(p, hz, words, idle_time)
struct mon_disk *p ;
int	hz ;
double	*words, *idle_time ;
E 3
I 3
D 16
calculate_disk(p, kbps, tps, msps)
register struct mon_disk *p ;
E 16
I 16
D 17
calculate_disk(index, kbps, tps, msps)
E 17
I 17
double	calculate_disk(index, kbps, tps, msps)
E 17
register index ;
E 16
D 18
double	*kbps, *tps, *msps ;
E 18
I 18
double	*kbps, *tps ;
int	*msps ;
E 18
E 3
{
I 2
D 3
	double	xfer_time ;
E 3
I 3
D 5
	double	xfer_time, idle_time, words ;
E 5
I 5
D 16
	double	xfer_time, idle_time, words, etime ;
E 16
I 16
	double	xfer_time, idle_time, words, etime, delta_disk() ;
E 16
E 5
E 3

I 5
D 16
	etime = sample.mon_etime ;
E 16
I 16
	etime = delta_disk(index, sample.mon_ticks) ;
E 16

I 13
	/*
	 *	The algorithm for these calculations was derived
	 *	the iostat(1) and vmstat(1) programs.  It wasn't
	 *	commented there either.
	 *
	 *	Someday, I promise...
	 */
E 13
E 5
D 3
	*words = p->mon_wds * 32.0 ;
E 3
I 3
D 16
	words = p->mon_wds * 32.0 ;
E 3
D 13
#ifdef	sun
D 3
	xfer_time = *words * 2 / p->mon_bps ;
E 3
I 3
	xfer_time = words * 2 / p->mon_bps ;
E 3
#else
E 13
D 3
	xfer_time = p->mon_mspw * *words ;
E 3
I 3
	xfer_time = p->mon_mspw * words ;
E 3
D 13
#endif
E 13
D 3
	*idle_time = (p->mon_time / hz) - xfer_time ;
E 3
I 3
D 4
	idle_time = (p->mon_time / first.mon_hz) - xfer_time ;
E 4
I 4
	idle_time = (p->mon_time/(double)first.mon_hz) - xfer_time ;
E 16
I 16
D 24
	words = disk[index].mon_wds * 32.0 ;
E 24
I 24
	words = (unsigned)disk[index].mon_wds * 32.0 ;
E 24
	xfer_time = disk[index].mon_mspw * words ;
	idle_time = (disk[index].mon_time/(double)first.mon_hz) - xfer_time ;
E 16
E 4
E 3

	if( xfer_time < 0 ) {
D 3
		*idle_time += xfer_time ;
E 3
I 3
		idle_time += xfer_time ;
E 3
		xfer_time = 0 ;
	}

D 3
	if( *idle_time < 0 ) {
		xfer_time += *idle_time ;
		*idle_time = 0 ;
E 3
I 3
	if( idle_time < 0 ) {
		xfer_time += idle_time ;
		idle_time = 0 ;
E 3
	}
I 3

D 5
	*kbps = words / 512.0 / p->mon_etime ;
	*tps  = p->mon_xfer / p->mon_etime ;
E 5
I 5
	*kbps = words / 512.0 / etime ;
D 16
	*tps  = p->mon_xfer / etime ;
E 16
I 16
	*tps  = disk[index].mon_xfer / etime ;
E 16
E 5
D 14
	*msps = p->mon_seek ? ((idle_time * 1000.0)/p->mon_seek) : 0.0 ;
E 14
I 14

D 16
	if( p->mon_seek )
		*msps = (idle_time * 1000.0) / p->mon_seek ;
	else if( p->mon_xfer )
		*msps = (idle_time * 1000.0) / p->mon_xfer ;
E 16
I 16
	if( disk[index].mon_seek )
D 18
		*msps = (idle_time * 1000.0) / disk[index].mon_seek ;
E 18
I 18
		*msps = (idle_time * 1000) / disk[index].mon_seek ;
E 18
	else if( disk[index].mon_xfer )
D 18
		*msps = (idle_time * 1000.0) / disk[index].mon_xfer ;
E 18
I 18
		*msps = (idle_time * 1000) / disk[index].mon_xfer ;
E 18
E 16
	else
D 18
		*msps = 0.0 ;
E 18
I 18
		*msps = 0 ;
E 18
I 17

	return etime ;
E 17
E 14
I 6
}

I 21
#define	DISK_TITLE	(3)
#define	DISK_OFFSET	(6)
#define	DISK_WIDTH	(0)

I 23
#define	DISK_BASE_LINES	(5)

E 23
E 21
I 10
D 13
/* ARGSUSED */
E 13
I 13
/*
 *	Print the header for disk I/O data.
 *
 *	ARGSUSED
 */
E 13
E 10
open_disk(op)
OPTION	*op ;
{
I 7
D 10
	register struct mon_disk *dp = disk ;
E 10
I 10
D 16
	register struct mon_disk *dp, *lastp ;
E 10
	register entry = 0, x, y = 3 ;
E 16
I 16
D 20
	register entry = 0, x, y = 3, i ;
E 20
I 20
	register disk_entry = 0, x, y = 3, i ;
E 20
E 16
	char	 *heading = "Disk:   kbps   tps   msps" ;

I 23
	lines = DISK_BASE_LINES ;

E 23
E 7
D 13
	clear() ;
E 13
I 13
	sample_header() ;
E 13

D 13
	move(0, 0);

	printw("Elapsed Time:\n");
	printw("Timestamp:\n\n");
I 7

E 13
	/*
 	 *	Print the headings side-by-side.
	 */
D 21
	mvprintw(y, 0, "%s", heading);
	mvprintw(y, COLS / 2, "%s", heading);
E 21
I 21
D 22
	wmove(stdscr, DISK_TITLE, 0) ;
	wprintw(stdscr, "%s", heading);
E 22
I 22
	wmove(wp, DISK_TITLE, 0) ;
	wprintw(wp, "%s", heading);
E 22
E 21

I 21
D 22
	wmove(stdscr, DISK_TITLE, COLS / 2) ;
	wprintw(stdscr, "%s", heading);
E 22
I 22
	wmove(wp, DISK_TITLE, COLS / 2) ;
	wprintw(wp, "%s", heading);
E 22

E 21
D 10
	if( dp == NULL )
		return ;
E 10
I 10
D 16
	lastp = disk + n_disk ;
E 10

D 10
	while( dp ) {
D 9
		if( entry++ % 2 )
E 9
I 9
		if( entry == first.mon_disk )
			break ;

E 10
I 10
	for(dp = disk; dp < lastp; dp++ ) {
E 16
I 16
	for(i = 0; i < n_disk; i++) {
E 16
E 10
D 20
		if( entry % 2 )
E 20
I 20
		if( disk_entry % 2 )
E 20
E 9
			x = COLS / 2 ;
		else {
			x = 0 ;
			y++ ;
I 23
			lines++ ;
E 23
		}

I 9
D 20
		entry++ ;
E 20
I 20
		disk_entry++ ;
E 20

E 9
D 16
		mvprintw(y, x, "%s%d", dp->mon_name, dp->mon_unit);
E 16
I 16
D 21
		mvprintw(y, x, "%s%d", disk[i].mon_name, disk[i].mon_unit);
E 21
I 21
D 22
		wmove(stdscr, y, x) ;
		wprintw(stdscr, "%s%d", disk[i].mon_name, disk[i].mon_unit);
E 22
I 22
		wmove(wp, y, x) ;
		wprintw(wp, "%s%d", disk[i].mon_name, disk[i].mon_unit);
E 22
E 21
E 16
D 10

		if( op->collect_mode == OPT_REPLAY )
			dp++ ;
		else
			dp = dp->mon_next ;
E 10
	}
E 7
}

I 10
D 13
/* ARGSUSED */
E 13
I 13
/*
 *	"magnify" the disk I/O information.  The only really
 *	interesting thing to do with the disk I/O data is
 *	to make sure that all of it can be seen.  If the screen
 *	is 24 lines long, then it is long enough.  I also added
 *	one decimal place to the floating point numbers to make
 *	them look different from the main screen.
 *
 *	ARGSUSED
 */
E 13
E 10
magnify_disk(op)
OPTION	*op ;
{
I 7
D 10
	register struct mon_disk *dp = disk ;
E 10
I 10
D 16
	register struct mon_disk *dp, *lastp ;
E 10
	register entry = 0, y = 3, x = 0 ;
E 16
I 16
D 20
	register entry = 0, y = 3, x = 0, i ;
E 20
I 20
	register disk_entry = 0, y = 3, x = 0, i ;
E 20
E 16
D 17
	double	 kbps, tps, msps ;
E 17
I 17
D 18
	double	 kbps, tps, msps, etime, calculate_disk() ;
E 18
I 18
	double	 kbps, tps, etime, calculate_disk() ;
	int	 msps ;
E 18
E 17

E 7
D 13
	mvprintw(0, 14, "%.2f", sample.mon_etime);
	mvprintw(1, 14, "%24.24s", ctime(&sample.mon_timestamp));
E 13
I 13
D 17
	sample_body(14) ;
E 13
I 7

E 17
D 10
	if( dp == NULL )
		return ;
E 10
I 10
D 16
	lastp = disk + first.mon_disk ;
E 10

D 10
	while( dp ) {
I 9
		if( entry == first.mon_disk )
			break ;

E 10
I 10
	for(dp = disk; dp < lastp; dp++) {
E 16
I 16
	for(i = 0; i < n_disk; i++) {
E 16
E 10
E 9
D 20
		if( entry++ % 2 )
E 20
I 20
		if( disk_entry++ % 2 )
E 20
D 21
			x = (COLS / 2) + 6 ;
E 21
I 21
			x = (COLS / 2) + DISK_OFFSET ;
E 21
		else {
D 21
			x = 6 ;
E 21
I 21
			x = DISK_OFFSET ;
E 21
			y++ ;
		}

D 16
		delta_disk(dp) ;
		calculate_disk(dp, &kbps, &tps, &msps);
E 16
I 16
D 17
		calculate_disk(i, &kbps, &tps, &msps);
E 17
I 17
		etime = calculate_disk(i, &kbps, &tps, &msps);
E 17
E 16

D 18
		mvprintw(y, x, "%6.1f %5.1f  %5.1f", kbps, tps, msps);
E 18
I 18
D 21
		mvprintw(y, x, "%6.1f %5.1f  %5d", kbps, tps, msps);
E 21
I 21
D 22
		wmove(stdscr, y, x) ;
		wprintw(stdscr, "%6.1f %5.1f  %5d", kbps, tps, msps);
E 22
I 22
		wmove(wp, y, x) ;
		wprintw(wp, "%6.1f %5.1f  %5d", kbps, tps, msps);
E 22
E 21
E 18
D 10

		if( op->collect_mode == OPT_REPLAY )
			dp++ ;
		else
			dp = dp->mon_next ;
E 10
	}
I 17

	sample_body(etime) ;
E 17
E 7
E 6
E 3
E 2
}
E 1
