/*
 * timer - time tcp header compression code.
 *
 * Copyright (c) 1989 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 *	Van Jacobson (van@helios.ee.lbl.gov), Dec 31, 1989:
 *	- Initial distribution.
 */
#ifndef lint
static char rcsid[] = "$Header: timer.c,v 1.5 89/12/31 08:53:10 van Exp $";
#endif

#include <sys/types.h>
#include <sys/param.h>
#include <sys/file.h>
#include <sys/mbuf.h>
#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <netinet/tcp.h>
#include <stdio.h>
#include <sys/timeb.h>
#include <ctype.h>
#include <netdb.h>
#include "slcompress.h"

static char *ip_proto_name();
static char buf1[2048 + sizeof(struct mbuf)];
static char buf2[2048 + sizeof(struct mbuf)];

struct tcpip {
	struct ip ip;
	struct tcphdr tcp;
};


char *usage = "usage: %s file\n";

main (argc, argv)
	int argc;
	char **argv;
{
	int i, s, cc, fd;
	u_int type;
	int npack;
	u_long iaddr;
	register struct ip *ip;
	struct mbuf *m1;
	struct slcompress slc;
	struct timeb strt_time, end_time;
	double dtread, dtcomp, dtucomp;
	double junk;
	u_char *bufp;

	if (argc <= 1) {
		fprintf(stderr, usage, *argv);
		exit(1);
	}
	setlinebuf(stdout);
	if ((fd = open(argv[1], O_RDONLY, 0777)) < 0) {
		perror(argv[1]);
		exit(2);
	}
	sl_compress_init(&slc);

	/* run the read loop (to load buffer cache & fault in prog) */

	npack = 0;
	while (read(fd, &cc, sizeof(cc)) == sizeof(cc)) {

		cc = ntohl(cc);
		m1 = (struct mbuf *) buf1;
		bzero(buf1, sizeof(buf1));
		m1->m_off = MMINOFF;
		m1->m_len = cc;
		if (read(fd, mtod(m1, char *), cc) < cc) {
			perror( "read 2" );
			exit(1);
		}
		ip = mtod(m1, struct ip *);
		type = sl_compress_tcp(m1, mtod(m1, struct ip *), &slc, 1);
		bufp = mtod(m1, u_char *);
		(void) sl_uncompress_tcp(&bufp, m1->m_len, type, &slc);
		++npack;
	}

	/* time just the read loop (with no compression) */

	npack = 0;
	(void)lseek(fd, 0L, 0);
	ftime( &strt_time );
	while (read(fd, &cc, sizeof(cc)) == sizeof(cc)) {
		cc = ntohl(cc);
		m1 = (struct mbuf *) buf1;
		bzero(buf1, sizeof(buf1));
		m1->m_off = MMINOFF;
		m1->m_len = cc;
		if (read(fd, mtod(m1, char *), cc) < cc) {
			perror( "read 2" );
			exit(1);
		}
		ip = mtod(m1, struct ip *);
		++npack;
	}
	ftime( &end_time );
	i = end_time.time - strt_time.time;
	dtread = i;
	i = end_time.millitm - strt_time.millitm;
	junk = i;
        dtread = dtread*1000 + junk;

	/* time the read loop with compression */

	npack = 0;
	(void)lseek(fd, 0L, 0);
	ftime( &strt_time );
	while (read(fd, &cc, sizeof(cc)) == sizeof(cc)) {
		cc = ntohl(cc);
		m1 = (struct mbuf *) buf1;
		bzero(buf1, sizeof(buf1));
		m1->m_off = MMINOFF;
		m1->m_len = cc;
		if (read(fd, mtod(m1, char *), cc) < cc) {
			perror( "read 2" );
			exit(1);
		}
		ip = mtod(m1, struct ip *);
		type = sl_compress_tcp(m1, mtod(m1, struct ip *), &slc, 1);
		++npack;
	}
	ftime( &end_time );
	i = end_time.time - strt_time.time;
	dtcomp = i;
	i = end_time.millitm - strt_time.millitm;
	junk = i;
        dtcomp = dtcomp*1000 + junk;

	/* time the read loop with compression and uncompression */

	npack = 0;
	(void)lseek(fd, 0L, 0);
	ftime( &strt_time );
	while (read(fd, &cc, sizeof(cc)) == sizeof(cc)) {
		cc = ntohl(cc);
		m1 = (struct mbuf *) buf1;
		bzero(buf1, sizeof(buf1));
		m1->m_off = MMINOFF;
		m1->m_len = cc;
		if (read(fd, mtod(m1, char *), cc) < cc) {
			perror( "read 2" );
			exit(1);
		}
		ip = mtod(m1, struct ip *);
		type = sl_compress_tcp(m1, mtod(m1, struct ip *), &slc, 1);
		bufp = mtod(m1, u_char *);
		(void) sl_uncompress_tcp(&bufp, m1->m_len, type, &slc);
		++npack;
	}
	ftime( &end_time );
	i = end_time.time - strt_time.time;
	dtucomp = i;
	i = end_time.millitm - strt_time.millitm;
	junk = i;
        dtucomp = dtucomp*1000 + junk;

	junk = npack;
	printf("%d pack  %g read-ms  %g comp-ms  %g ucomp-ms	%g us/pack-comp  %g us/pack-ucomp\n",
		npack, dtread, dtcomp, dtucomp,
		(dtcomp - dtread)/junk*1000,
		(dtucomp - dtcomp)/junk*1000);
	close(fd);
	exit(0);
}
