/*****************************************************************************
Copyright 1988, 1989 by Digital Equipment Corporation, Maynard, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the name of Digital not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************************/

#include "x11perf.h"
#include "bitmaps.h"

static XRectangle   *rects;
static XPoint *points;
static GC	    pgc;

static XPoint *make_recttriangles();

extern Bool doTriangles;
extern int nAggregate;

int InitRectangles(xp, p, reps)
    XParms  xp;
    Parms   p;
    int     reps;
{
    int i;
    int size = p->special;
    int step;
    int x, y;
    int rows;

    pgc = xp->fggc;

    rects = (XRectangle *)malloc(p->objects * sizeof(XRectangle));
    x = 0;
    y = 0;
    rows = 0;
    if (xp->pack) {
	/* Pack rectangles as close as possible, mainly for debugging faster
	   tiling, stippling routines in a server */
	step = size;
    } else {
	/* Try to exercise all alignments...any odd number is okay */
	step = size + 1 + (size % 2);
    }

    for (i = 0; i != p->objects; i++) {
	rects[i].x = x;
        rects[i].y = y;
	rects[i].width = rects[i].height = size;

	y += step;
	rows++;
	if (y + size > Height || rows == MAXROWS) {
	    rows = 0;
	    y = 0;
	    x += step;
	    if (x + size > Width) {
		x = 0;
	    }
	}
    }

    SetFillStyle(xp, p);

    if (doTriangles) points = make_recttriangles(rects,p->objects);

    return reps;
}

/*
 generate two triangles for each rectangle
*/
static XPoint *make_recttriangles(rects,nobjects)
    XRectangle *rects;
    int nobjects;
{
    XPoint *pt,*pts;
    XRectangle *r,*endr = rects + nobjects;

    pt = pts = (XPoint *)malloc(6 * nobjects * sizeof(XPoint));

    for (r = rects; r != endr; r++) {

	int x = r->x,y = r->y,width = r->width,height = r->height;

	pt->x = x;		/* 1st triangle -counterclockwise */
	pt->y = y;
	pt++;
	pt->x = x;
	pt->y = y + height;
	pt++;
	pt->x = x + width;
	pt->y = y + height;
	pt++;

	pt->x = x + width;	/* 2nd triangle - clockwise */
	pt->y = y + height;
	pt++;
	pt->x = x;
	pt->y = y;
	pt++;
	pt->x = x + width;
	pt->y = y;
	pt++;

    }
    return pts;
}

void DoRectangles(xp, p, reps)
    XParms  xp;
    Parms   p;
    int     reps;
{
    int i;

    if (doTriangles) {		/* draw as triangles */
	for (i = 0; i != reps; i++) {
	    XPoint *pt,*endp = points + 6 * p->objects;
	    for  (pt = points; pt < endp; pt += 3) {
		XFillPolygon(xp->d, xp->w, pgc, pt, 3, Convex, CoordModeOrigin);
	    }
	    pgc = (pgc == xp->bggc) ? xp->fggc : xp->bggc;
	}
    }
    else if (nAggregate > 0) { /* aggregate rectangles */
	for (i = 0; i != reps; i++) {
	    XFillRectangles(xp->d, xp->w, pgc, rects, p->objects);
	    pgc = (pgc == xp->bggc) ? xp->fggc : xp->bggc;
	}
    }
    else {			/* individual rectangles */
	for (i = 0; i != reps; i++) {
	    XRectangle *r,*endr = rects + p->objects;
	    for  (r = rects; r != endr; r++) {
		XFillRectangle(xp->d, xp->w, pgc,r->x,r->y,r->width,r->height);
	    }
	    pgc = (pgc == xp->bggc) ? xp->fggc : xp->bggc;
	}
    }
}

void EndRectangles(xp, p)
    XParms  xp;
    Parms p;
{
    if (doTriangles) free(points);
    free(rects);
}

