/*****************************************************************************
Copyright 1988, 1989 by Digital Equipment Corporation, Maynard, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the name of Digital not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************************/

/*
 rectangle test - 2.2.10.4
*/

#include "x11perf.h"

static XRectangle *rects;
extern XRectangle Rect_;
extern Bool doFill;
static GC pgc;

/*
 initialize single rectangle
*/
int InitRect(xp, p, reps)
    XParms  xp;
    Parms   p;
    int     reps;
{
    int i;

    pgc = xp->fggc;

    rects = (XRectangle *)malloc(p->objects * sizeof(XRectangle));

    for (i = 0; i < p->objects; i++) {
	rects[i] = Rect_;
    }
    return reps;
}

void DoRect(xp, p, reps)
    XParms  xp;
    Parms   p;
    int     reps;
{
    int i;

    for (i = 0; i < reps; i++) {
	if (doFill)
	    XFillRectangles(xp->d, xp->w, pgc, rects, p->objects);
	else
	    XDrawRectangles(xp->d, xp->w, pgc, rects, p->objects);
	pgc = (pgc == xp->bggc) ? xp->fggc : xp->bggc;
    }
}

void EndRect(xp, p)
    XParms  xp;
    Parms p;
{
    free(rects);
}
