/*****************************************************************************
Copyright 1988, 1989 by Digital Equipment Corporation, Maynard, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the name of Digital not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************************/

#include <stdio.h>
#include "x11perf.h"

static int    npolypts,polytype;
static XPoint *points;
static GC pgc;

extern int xOrg,yOrg;
extern int errno;
extern char *sys_errlist[],*Polyfile;

int InitPolygon(xp, p, reps)
    XParms  xp;
    Parms   p;
    int     reps;
{
    int pass;
    float xx,yy,hwidth,hheight;
    FILE *fp;
    XPoint *pt;
    char *file,*q,s[80];

/*
 read file
*/
    file = Polyfile;
    if ((fp = fopen(file,"r")) == NULL) {
	fprintf(stderr,"InitPolygon: %s: %s\n",file,sys_errlist[errno]);
	return 0;
    }
/*
 1) determine no. of points in file on the first pass
 2) read points into XPoint array on the second pass
 NOTES: points in file are normalized in range (-1.0,1.0)
	 -1.0 corresponds to left/bottom of full screen window
 	 0.0  corresponds to center of full screen window
	 1.0  corresponds to top/rightof full screen window
*/
    polytype = Complex;
    hwidth = DisplayWidth(xp->d,DefaultScreen(xp->d)) * .5;
    hheight = DisplayHeight(xp->d,DefaultScreen(xp->d)) * .5;
    pgc = xp->fggc;

    for (pass = 1; pass <= 2; pass++) {
	npolypts = 0;
	while (fgets(s,sizeof(s),fp) != NULL) {
	    for (q = s; *q != '\n'; q++) {
		if (*q == '#') break;		/* kill comments '#' */
	    }
	    *q = '\000';
	    if (strcmp(s,"convex") == 0) polytype = Convex;
	    else if (strcmp(s,"nonconvex") == 0) polytype = Nonconvex;
	    else if (strcmp(s,"complex") == 0) polytype = Complex;
	    else if (sscanf(s,"%f %f",&xx,&yy) == 2) {
		npolypts++;
		if (pass == 2) {
		    pt->x = hwidth * (xx + 1.0) - xOrg;
		    pt->y = hheight * (1.0 - yy) - yOrg;
		    pt++;
		}
	    }
	}
	if (pass == 1) {	/* done with pass1 - allocate pts, rewind */
	    pt = points = (XPoint *)malloc(npolypts * sizeof(XPoint));
	    rewind(fp);
	}
    }
    fclose(fp);
    SetFillStyle(xp,p);
    return reps;
}

void DoPolygon(xp, p, reps)
    XParms  xp;
    Parms   p;
    int     reps;
{
    int     i;

    for (i = 0; i != reps; i++) {
	XFillPolygon(xp->d, xp->w, pgc, points, npolypts, polytype, 
			 CoordModeOrigin);
	pgc = (pgc == xp->bggc) ? xp->fggc : xp->bggc;
    }
}

void EndPolygon(xp, p)
    XParms  xp;
    Parms   p;
{
    free(points);
}

