/*****************************************************************************
Copyright 1988, 1989 by Digital Equipment Corporation, Maynard, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the name of Digital not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************************/

/*
 orientation tests - 2.2.3
*/

#include <math.h>
#include "x11perf.h"

#define NUM_POINTS 4    /* 4 points to an arrowhead */
#define NUM_ANGLES 3    /* But mostly it looks like a triangle */
#define PI  3.14159265357989

static XPoint   *points,*endpoints;
static GC       pgc;

extern int startAngle;

int InitOrient(xp, p, reps)
    XParms  xp;
    Parms   p;
    int     reps;
{
    int     i, npts, size, iradius;
    double  x,y,phi, radius, delta, phi2;
    XPoint  *pt;

    pgc = xp->fggc;

    size = p->special;
    phi = startAngle * PI / 180.0;
    radius = ((double) size) * sqrt(3.0)/2.0;
    iradius = (int) radius + 1;
    delta = 2.0 * PI / ((double) NUM_ANGLES);

    npts = p->objects * NUM_POINTS;  
    pt = points = (XPoint *)malloc(npts * sizeof(XPoint));
    endpoints = points + npts;

    x = iradius;
    y = iradius;
    for (pt = points; pt < endpoints; ) {
	for (i = 0; i < NUM_ANGLES; i++) {
	    phi2 = phi + i * delta;
	    pt->x = x + radius * cos(phi2) + 0.5;
	    pt->y = y + radius * sin(phi2) + 0.5;
	    pt++;
	}
	pt->x = x;
	pt->y = y;
	pt++;
	y += 2 * iradius;
	if (y + iradius >= Height) {
	    y = iradius;
	    x += 2 * iradius;
	    if (x + iradius >= Width) {
		x = iradius;
	    }
	}
    }
    return reps;
}

void DoOrient(xp, p, reps)
    XParms  xp;
    Parms   p;
    int     reps;
{
    int     i;
    XPoint  *pt;

    for (i = 0; i != reps; i++) {
	for (pt = points; pt < endpoints; pt += NUM_POINTS) {
            XFillPolygon(xp->d, xp->w, pgc, pt, NUM_POINTS,
			  Nonconvex, CoordModeOrigin);
	}
        pgc = (pgc == xp->bggc) ? xp->fggc : xp->bggc;
    }
}

void EndOrient(xp, p)
    XParms  xp;
    Parms   p;
{
    free(points);
}
